/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.osgiutilities.service;

import com.thinkbuzan.chaos.osgiutilities.service.IService;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceNotAvailableException;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OSGiService<SERVICECLASS>
implements IService<SERVICECLASS> {
    private final transient ServiceTracker tracker;
    private final transient Class<SERVICECLASS> clazz;
    private transient List<IServiceListener<SERVICECLASS>> listeners;

    public OSGiService(BundleContext context, Class<SERVICECLASS> clazzIn) {
        this.validateOSGiService(context, clazzIn);
        this.clazz = clazzIn;
        this.tracker = new ServiceTracker(context, this.clazz.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object service = super.addingService(reference);
                OSGiService.this.fireServiceAdded(OSGiService.this.clazz.cast(service));
                return service;
            }

            public void removedService(ServiceReference reference, Object service) {
                OSGiService.this.fireServiceRemoved(OSGiService.this.clazz.cast(service));
                super.removedService(reference, service);
            }
        };
        this.tracker.open();
    }

    private void validateOSGiService(BundleContext context, Class<SERVICECLASS> clazzIn) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (clazzIn == null) {
            throw new IllegalArgumentException("clazzIn must not be null");
        }
    }

    @Override
    public SERVICECLASS get() {
        Object service = this.tracker.getService();
        if (service == null) {
            String message = "The \"%s\" OSGi service is not available";
            throw new ServiceNotAvailableException(String.format("The \"%s\" OSGi service is not available", this.clazz.getName()));
        }
        return this.clazz.cast(service);
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IServiceListener<SERVICECLASS> listener) {
        Object[] services;
        OSGiService oSGiService = this;
        synchronized (oSGiService) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<IServiceListener<SERVICECLASS>>();
            }
            this.listeners.add(listener);
            services = this.tracker.getServices();
        }
        if (services == null) {
            return;
        }
        for (Object service : services) {
            listener.serviceAdded(this.clazz.cast(service));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IServiceListener<SERVICECLASS> listener) {
        OSGiService oSGiService = this;
        synchronized (oSGiService) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServiceAdded(SERVICECLASS service) {
        ArrayList<IServiceListener<SERVICECLASS>> listenersCopy;
        OSGiService oSGiService = this;
        synchronized (oSGiService) {
            if (this.listeners == null) {
                return;
            }
            listenersCopy = new ArrayList<IServiceListener<SERVICECLASS>>(this.listeners);
        }
        for (IServiceListener iServiceListener : listenersCopy) {
            iServiceListener.serviceAdded(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServiceRemoved(SERVICECLASS service) {
        ArrayList<IServiceListener<SERVICECLASS>> listenersCopy;
        OSGiService oSGiService = this;
        synchronized (oSGiService) {
            if (this.listeners == null) {
                return;
            }
            listenersCopy = new ArrayList<IServiceListener<SERVICECLASS>>(this.listeners);
        }
        for (IServiceListener iServiceListener : listenersCopy) {
            iServiceListener.serviceRemoved(service);
        }
    }
}

