/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.osgiutilities.service;

import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingServiceManager<T> {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient List<IServiceListener<T>> listeners = new ArrayList<IServiceListener<T>>();
    private final transient OSGiService<T> osgiService;
    private transient T service;

    public PendingServiceManager(OSGiService<T> osgiServiceIn) {
        this.validateParams(osgiServiceIn);
        this.osgiService = osgiServiceIn;
        this.osgiService.addListener(new ServiceAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serviceAdded(T serviceIn) {
                PendingServiceManager.this.lock.lock();
                try {
                    super.serviceAdded(serviceIn);
                    PendingServiceManager.this.service = serviceIn;
                    this.notifyListeners();
                    PendingServiceManager.this.listeners.clear();
                }
                finally {
                    PendingServiceManager.this.lock.unlock();
                }
            }

            private void notifyListeners() {
                for (IServiceListener listener : PendingServiceManager.this.listeners) {
                    listener.serviceAdded(PendingServiceManager.this.service);
                }
            }
        });
    }

    private void validateParams(OSGiService<T> osgiServiceIn) {
        if (osgiServiceIn == null) {
            throw new IllegalArgumentException("osgiServiceIn cannot be null!");
        }
    }

    public final void close() {
        this.osgiService.close();
    }

    public final T getService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(IServiceListener<T> listener) {
        if (listener != null) {
            this.lock.lock();
            try {
                if (this.service == null) {
                    this.listeners.add(listener);
                } else {
                    listener.serviceAdded(this.service);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

