/*
 * Decompiled with CFR 0.152.
 */
package prefuse;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import prefuse.Visualization;
import prefuse.a;
import prefuse.activity.Activity;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.b;
import prefuse.c;
import prefuse.controls.Control;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.AndPredicate;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.listeners.ScaleChangedListener;
import prefuse.render.Renderer;
import prefuse.util.ColorLib;
import prefuse.util.StringLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.display.BackgroundPainter;
import prefuse.util.display.Clip;
import prefuse.util.display.ExportDisplayAction;
import prefuse.util.display.ItemBoundsListener;
import prefuse.util.display.PaintListener;
import prefuse.util.display.RenderingQueue;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.VisiblePredicate;
import prefuse.visual.sort.ItemSorter;

public class Display
extends JComponent {
    private static final Logger a;
    protected Visualization m_vis;
    protected AndPredicate m_predicate;
    protected CopyOnWriteArrayList m_controls;
    protected CopyOnWriteArrayList m_painters;
    protected CopyOnWriteArrayList m_bounders;
    protected BufferedImage m_offscreen;
    protected Clip m_clip;
    protected Clip m_screen;
    protected Clip m_bounds;
    protected Rectangle2D m_rclip;
    protected boolean m_damageRedraw;
    protected boolean m_highQuality;
    protected BackgroundPainter m_bgpainter;
    protected RenderingQueue m_queue;
    protected int m_visibleCount;
    protected AffineTransform m_transform;
    protected AffineTransform m_itransform;
    protected TransformActivity m_transact;
    protected Point2D m_tmpPoint;
    protected double frameRate;
    protected int nframes;
    private int b;
    private long c;
    protected JToolTip m_customToolTip;
    private JTextComponent d;
    private boolean e;
    private VisualItem f;
    private String g;
    private final transient ArrayList<ScaleChangedListener> h;
    public static boolean i;
    private static final String[] z;

    public Display() {
        this(null);
    }

    public Display(Visualization visualization) {
        this(visualization, (Predicate)null);
    }

    public Display(Visualization visualization, String string) {
        this(visualization, (Predicate)ExpressionParser.parse(string, true));
    }

    public Display(Visualization visualization, Predicate predicate) {
        boolean bl = i;
        this.m_predicate = new AndPredicate();
        this.m_controls = new CopyOnWriteArrayList();
        this.m_clip = new Clip();
        this.m_screen = new Clip();
        this.m_bounds = new Clip();
        this.m_rclip = new Rectangle2D.Double();
        this.m_damageRedraw = true;
        this.m_highQuality = false;
        this.m_bgpainter = null;
        this.m_queue = new RenderingQueue();
        this.m_visibleCount = 0;
        this.m_transform = new AffineTransform();
        this.m_itransform = new AffineTransform();
        this.m_transact = new TransformActivity();
        this.m_tmpPoint = new Point2D.Double();
        this.nframes = 0;
        this.b = 10;
        this.c = -1L;
        this.m_customToolTip = null;
        this.h = new ArrayList();
        this.setDoubleBuffered(false);
        this.setBackground(Color.WHITE);
        this.e = false;
        this.d = new JTextField();
        this.d.setBorder(null);
        this.d.setVisible(false);
        this.add(this.d);
        InputEventCapturer inputEventCapturer = new InputEventCapturer();
        this.addMouseListener(inputEventCapturer);
        this.addMouseMotionListener(inputEventCapturer);
        this.addMouseWheelListener(inputEventCapturer);
        this.addKeyListener(inputEventCapturer);
        this.registerDefaultCommands();
        this.m_predicate.addExpressionListener(new c(this));
        this.setVisualization(visualization);
        this.setPredicate(predicate);
        this.setSize(400, 400);
        if (bl) {
            AbstractExpression.b = !AbstractExpression.b;
        }
    }

    public void reset() {
        this.m_offscreen = null;
        this.m_queue.clean();
    }

    protected void registerDefaultCommands() {
        this.registerKeyboardAction(new a(this), z[2], KeyStroke.getKeyStroke(z[4]), 0);
        this.registerKeyboardAction(new b(this), z[3], KeyStroke.getKeyStroke(z[6]), 0);
        try {
            this.registerKeyboardAction(new ExportDisplayAction(this), z[1], KeyStroke.getKeyStroke(z[5]), 0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void setSize(int n2, int n3) {
        this.m_offscreen = null;
        this.setPreferredSize(new Dimension(n2, n3));
        super.setSize(n2, n3);
    }

    @Override
    public void setSize(Dimension dimension) {
        this.m_offscreen = null;
        this.setPreferredSize(dimension);
        super.setSize(dimension);
    }

    @Override
    public void invalidate() {
        this.damageReport();
        super.invalidate();
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        this.m_offscreen = null;
        super.setBounds(n2, n3, n4, n5);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.d.setFont(font);
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setHighQuality(boolean bl) {
        if (this.m_highQuality != bl) {
            this.damageReport();
        }
        this.m_highQuality = bl;
    }

    public boolean isHighQuality() {
        return this.m_highQuality;
    }

    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void setVisualization(Visualization visualization) {
        if (this.m_vis == visualization) {
            return;
        }
        if (this.m_vis != null) {
            this.m_vis.b(this);
        }
        this.m_vis = visualization;
        if (this.m_vis != null) {
            this.m_vis.a(this);
        }
    }

    public Predicate getPredicate() {
        if (this.m_predicate.size() == 1) {
            return BooleanLiteral.TRUE;
        }
        return this.m_predicate.get(0);
    }

    public void setPredicate(String string) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string, true);
        this.setPredicate(predicate);
    }

    public synchronized void setPredicate(Predicate predicate) {
        block3: {
            block2: {
                if (predicate != null) break block2;
                this.m_predicate.set(VisiblePredicate.TRUE);
                if (!i) break block3;
            }
            this.m_predicate.set(new Predicate[]{predicate, VisiblePredicate.TRUE});
        }
    }

    public int getVisibleItemCount() {
        return this.m_visibleCount;
    }

    public ItemSorter getItemSorter() {
        return this.m_queue.sort;
    }

    public synchronized void setItemSorter(ItemSorter itemSorter) {
        this.damageReport();
        this.m_queue.sort = itemSorter;
    }

    public synchronized void setBackgroundImage(Image image, boolean bl, boolean bl2) {
        BackgroundPainter backgroundPainter = null;
        if (image != null) {
            backgroundPainter = new BackgroundPainter(image, bl, bl2);
        }
        this.a(backgroundPainter);
    }

    public synchronized void setBackgroundImage(String string, boolean bl, boolean bl2) {
        BackgroundPainter backgroundPainter = null;
        if (string != null) {
            backgroundPainter = new BackgroundPainter(string, bl, bl2);
        }
        this.a(backgroundPainter);
    }

    private void a(BackgroundPainter backgroundPainter) {
        if (this.m_bgpainter != null) {
            this.removePaintListener(this.m_bgpainter);
        }
        this.m_bgpainter = backgroundPainter;
        if (backgroundPainter != null) {
            this.addPaintListener(backgroundPainter);
        }
    }

    @Override
    public JToolTip createToolTip() {
        if (this.m_customToolTip == null) {
            return super.createToolTip();
        }
        return this.m_customToolTip;
    }

    public void setCustomToolTip(JToolTip jToolTip) {
        this.m_customToolTip = jToolTip;
    }

    public JToolTip getCustomToolTip() {
        return this.m_customToolTip;
    }

    public synchronized boolean isDamageRedraw() {
        return this.m_damageRedraw;
    }

    public synchronized void setDamageRedraw(boolean bl) {
        this.m_damageRedraw = bl;
        this.m_clip.invalidate();
    }

    public synchronized void damageReport(Rectangle2D rectangle2D) {
        if (this.m_damageRedraw) {
            this.m_clip.union(rectangle2D);
        }
    }

    public synchronized void damageReport() {
        this.m_clip.invalidate();
    }

    public synchronized void clearDamage() {
        if (this.m_damageRedraw) {
            this.m_clip.reset();
        }
    }

    public synchronized Rectangle2D getItemBounds() {
        return this.getItemBounds(new Rectangle2D.Double());
    }

    public synchronized Rectangle2D getItemBounds(Rectangle2D rectangle2D) {
        rectangle2D.setFrameFromDiagonal(this.m_bounds.getMinX(), this.m_bounds.getMinY(), this.m_bounds.getMaxX(), this.m_bounds.getMaxY());
        return rectangle2D;
    }

    public BufferedImage getOffscreenBuffer() {
        return this.m_offscreen;
    }

    protected BufferedImage getNewOffscreenBuffer(int n2, int n3) {
        BufferedImage bufferedImage = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                bufferedImage = (BufferedImage)this.createImage(n2, n3);
            }
            catch (Exception exception) {
                bufferedImage = null;
            }
        }
        if (bufferedImage == null) {
            return new BufferedImage(n2, n3, 1);
        }
        return bufferedImage;
    }

    public boolean saveImage(OutputStream outputStream, String string, double d2) {
        try {
            Dimension dimension = new Dimension((int)(d2 * (double)this.getWidth()), (int)(d2 * (double)this.getHeight()));
            BufferedImage bufferedImage = this.getNewOffscreenBuffer(dimension.width, dimension.height);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            this.zoom(double_, d2);
            boolean bl = this.isHighQuality();
            this.setHighQuality(true);
            this.paintDisplay(graphics2D, dimension);
            this.setHighQuality(bl);
            this.zoom(double_, 1.0 / d2);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBufferToScreen(Graphics graphics) {
        Display display = this;
        synchronized (display) {
            graphics.drawImage(this.m_offscreen, 0, 0, null);
        }
    }

    public void repaintImmediate() {
        Graphics graphics = this.getGraphics();
        if (graphics != null && this.m_offscreen != null) {
            this.paintBufferToScreen(graphics);
        }
    }

    protected void prepareGraphics(Graphics2D graphics2D) {
        if (this.m_transform != null) {
            graphics2D.transform(this.m_transform);
        }
        this.setRenderingHints(graphics2D);
    }

    protected void setRenderingHints(Graphics2D graphics2D) {
        block3: {
            block2: {
                if (!this.m_highQuality) break block2;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (!i) break block3;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        block6: {
            block5: {
                if (this.m_offscreen == null) {
                    this.m_offscreen = this.getNewOffscreenBuffer(this.getWidth(), this.getHeight());
                    this.damageReport();
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                Graphics2D graphics2D2 = (Graphics2D)this.m_offscreen.getGraphics();
                this.paintDisplay(graphics2D2, this.getSize());
                this.paintBufferToScreen(graphics2D);
                this.firePostPaint(graphics2D);
                graphics2D2.dispose();
                ++this.nframes;
                if (this.c >= 0L) break block5;
                this.c = System.currentTimeMillis();
                this.nframes = 0;
                if (!i) break block6;
            }
            if (this.nframes == this.b) {
                long l2 = System.currentTimeMillis();
                this.frameRate = 1000.0 * (double)this.nframes / (double)(l2 - this.c);
                this.c = l2;
                this.nframes = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDisplay(Graphics2D graphics2D, Dimension dimension) {
        boolean bl = i;
        Visualization visualization = this.m_vis;
        synchronized (visualization) {
            Display display = this;
            synchronized (display) {
                double d2;
                block21: {
                    block18: {
                        block20: {
                            block19: {
                                if (this.m_clip.isEmpty()) {
                                    return;
                                }
                                this.m_screen.setClip(0.0, 0.0, dimension.width + 1, dimension.height + 1);
                                this.m_screen.transform(this.m_itransform);
                                d2 = 1.0 + 1.0 / this.getScale();
                                if (!this.m_damageRedraw) break block18;
                                if (!this.m_clip.isInvalid()) break block19;
                                this.m_clip.setClip(this.m_screen);
                                if (!bl) break block20;
                            }
                            this.m_clip.intersection(this.m_screen);
                        }
                        this.m_clip.expand(d2);
                        this.prepareGraphics(graphics2D);
                        this.m_rclip.setFrameFromDiagonal(this.m_clip.getMinX(), this.m_clip.getMinY(), this.m_clip.getMaxX(), this.m_clip.getMaxY());
                        graphics2D.setClip(this.m_rclip);
                        this.m_rclip.setFrameFromDiagonal(this.m_clip.getMinX() - d2, this.m_clip.getMinY() - d2, this.m_clip.getMaxX() + d2, this.m_clip.getMaxY() + d2);
                        if (!bl) break block21;
                    }
                    this.m_rclip.setFrame(this.m_screen.getMinX(), this.m_screen.getMinY(), this.m_screen.getWidth(), this.m_screen.getHeight());
                    this.m_clip.setClip(this.m_screen);
                    this.prepareGraphics(graphics2D);
                }
                this.clearRegion(graphics2D, this.m_rclip);
                this.getItemBounds(this.m_rclip);
                this.m_bounds.reset();
                this.m_queue.clear();
                Iterator iterator = this.m_vis.items(this.m_predicate);
                this.m_visibleCount = 0;
                while (iterator.hasNext()) {
                    VisualItem visualItem = (VisualItem)iterator.next();
                    Rectangle2D rectangle2D = visualItem.getBounds();
                    this.m_bounds.union(rectangle2D);
                    if (this.m_clip.intersects(rectangle2D, d2)) {
                        this.m_queue.addToRenderQueue(visualItem);
                    }
                    if (visualItem.isInteractive()) {
                        this.m_queue.addToPickingQueue(visualItem);
                    }
                    ++this.m_visibleCount;
                    if (!bl) continue;
                }
                this.m_queue.sortRenderQueue();
                for (int i2 = 0; i2 < this.m_queue.rsize; ++i2) {
                    this.m_queue.ritems[i2].render(graphics2D);
                    if (!bl) continue;
                }
                if (this.m_damageRedraw) {
                    this.m_clip.reset();
                }
                this.checkItemBoundsChanged(this.m_rclip);
            }
        }
    }

    public void renderImmediate(VisualItem visualItem) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        this.prepareGraphics(graphics2D);
        visualItem.render(graphics2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void printComponent(Graphics graphics) {
        boolean bl = this.m_highQuality;
        try {
            this.m_highQuality = true;
            this.paintDisplay((Graphics2D)graphics, this.getSize());
        }
        finally {
            this.m_highQuality = bl;
        }
    }

    protected void clearRegion(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fill(rectangle2D);
        this.firePrePaint(graphics2D);
    }

    public synchronized void setTransform(AffineTransform affineTransform) throws NoninvertibleTransformException {
        this.damageReport();
        this.m_transform = affineTransform;
        this.m_itransform = this.m_transform.createInverse();
    }

    public AffineTransform getTransform() {
        return this.m_transform;
    }

    public AffineTransform getInverseTransform() {
        return this.m_itransform;
    }

    public Point2D getAbsoluteCoordinate(Point2D point2D, Point2D point2D2) {
        return this.m_itransform.transform(point2D, point2D2);
    }

    public double getScale() {
        return this.m_transform.getScaleX();
    }

    public double getDisplayX() {
        return -this.m_transform.getTranslateX();
    }

    public double getDisplayY() {
        return -this.m_transform.getTranslateY();
    }

    public synchronized void pan(double d2, double d3) {
        this.m_tmpPoint.setLocation(d2, d3);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        double d4 = this.m_tmpPoint.getX();
        double d5 = this.m_tmpPoint.getY();
        this.m_tmpPoint.setLocation(0.0, 0.0);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        this.panAbs(d4 -= this.m_tmpPoint.getX(), d5 -= this.m_tmpPoint.getY());
    }

    public synchronized void panAbs(double d2, double d3) {
        this.damageReport();
        this.m_transform.translate(d2, d3);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void panTo(Point2D point2D) {
        this.m_itransform.transform(point2D, this.m_tmpPoint);
        this.panToAbs(this.m_tmpPoint);
    }

    public synchronized void panToAbs(Point2D point2D) {
        double d2 = this.m_transform.getScaleX();
        double d3 = this.m_transform.getScaleY();
        double d4 = point2D.getX();
        d4 = Double.isNaN(d4) ? 0.0 : d4;
        double d5 = point2D.getY();
        d5 = Double.isNaN(d5) ? 0.0 : d5;
        d4 = (double)this.getWidth() / (2.0 * d2) - d4;
        d5 = (double)this.getHeight() / (2.0 * d3) - d5;
        double d6 = d4 - this.m_transform.getTranslateX() / d2;
        double d7 = d5 - this.m_transform.getTranslateY() / d3;
        this.damageReport();
        this.m_transform.translate(d6, d7);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void zoom(Point2D point2D, double d2) {
        this.m_itransform.transform(point2D, this.m_tmpPoint);
        this.zoomAbs(this.m_tmpPoint, d2);
    }

    public synchronized void zoomAbs(Point2D point2D, double d2) {
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        this.damageReport();
        this.m_transform.translate(d3, d4);
        this.m_transform.scale(d2, d2);
        this.m_transform.translate(-d3, -d4);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireScaleChangedListeners();
    }

    public void addScaleChangedListener(ScaleChangedListener scaleChangedListener) {
        if (!this.h.contains(scaleChangedListener)) {
            this.h.add(scaleChangedListener);
        }
    }

    public void removeScaleChangedListener(ScaleChangedListener scaleChangedListener) {
        this.h.remove(scaleChangedListener);
    }

    public void fireScaleChangedListeners() {
        boolean bl = i;
        double d2 = this.m_transform.getScaleX();
        for (ScaleChangedListener scaleChangedListener : this.h) {
            scaleChangedListener.scaleChanged(d2);
            if (!bl) continue;
        }
    }

    public synchronized void rotate(Point2D point2D, double d2) {
        this.m_itransform.transform(point2D, this.m_tmpPoint);
        this.rotateAbs(this.m_tmpPoint, d2);
    }

    public synchronized void rotateAbs(Point2D point2D, double d2) {
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        this.damageReport();
        this.m_transform.translate(d3, d4);
        this.m_transform.rotate(d2);
        this.m_transform.translate(-d3, -d4);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void animatePan(double d2, double d3, long l2) {
        double d4 = d2 / this.m_transform.getScaleX();
        double d5 = d3 / this.m_transform.getScaleY();
        this.animatePanAbs(d4, d5, l2);
    }

    public synchronized void animatePanAbs(double d2, double d3, long l2) {
        this.m_transact.pan(d2, d3, l2);
    }

    public synchronized void animatePanTo(Point2D point2D, long l2) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animatePanToAbs(double_, l2);
    }

    public synchronized void animatePanToAbs(Point2D point2D, long l2) {
        this.m_tmpPoint.setLocation(0.0, 0.0);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        double d2 = point2D.getX();
        d2 = Double.isNaN(d2) ? 0.0 : d2;
        double d3 = point2D.getY();
        d3 = Double.isNaN(d3) ? 0.0 : d3;
        double d4 = (double)this.getWidth() / (2.0 * this.m_transform.getScaleX());
        double d5 = (double)this.getHeight() / (2.0 * this.m_transform.getScaleY());
        double d6 = d4 - d2 + this.m_tmpPoint.getX();
        double d7 = d5 - d3 + this.m_tmpPoint.getY();
        this.animatePanAbs(d6, d7, l2);
    }

    public synchronized void animateZoom(Point2D point2D, double d2, long l2) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animateZoomAbs(double_, d2, l2);
    }

    public synchronized void animateZoomAbs(Point2D point2D, double d2, long l2) {
        this.m_transact.zoom(point2D, d2, l2);
    }

    public synchronized void animatePanAndZoomTo(Point2D point2D, double d2, long l2) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animatePanAndZoomToAbs(double_, d2, l2);
    }

    public synchronized void animatePanAndZoomToAbs(Point2D point2D, double d2, long l2) {
        this.m_transact.panAndZoom(point2D, d2, l2);
    }

    public boolean isTranformInProgress() {
        return this.m_transact.isRunning();
    }

    public void stopTransform() {
        this.m_transact.cancel();
    }

    public void addPaintListener(PaintListener paintListener) {
        if (this.m_painters == null) {
            this.m_painters = new CopyOnWriteArrayList();
        }
        this.m_painters.add(paintListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.m_painters.remove(paintListener);
    }

    protected void firePrePaint(Graphics2D graphics2D) {
        boolean bl = i;
        if (this.m_painters != null && this.m_painters.size() > 0) {
            Object[] objectArray = this.m_painters.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    ((PaintListener)objectArray[i2]).prePaint(this, graphics2D);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z[0] + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }
    }

    protected void firePostPaint(Graphics2D graphics2D) {
        boolean bl = i;
        if (this.m_painters != null && this.m_painters.size() > 0) {
            Object[] objectArray = this.m_painters.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    ((PaintListener)objectArray[i2]).postPaint(this, graphics2D);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z[0] + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }
    }

    public void addItemBoundsListener(ItemBoundsListener itemBoundsListener) {
        if (this.m_bounders == null) {
            this.m_bounders = new CopyOnWriteArrayList();
        }
        this.m_bounders.add(itemBoundsListener);
    }

    public void removeItemBoundsListener(ItemBoundsListener itemBoundsListener) {
        this.m_bounders.remove(itemBoundsListener);
    }

    protected void checkItemBoundsChanged(Rectangle2D rectangle2D) {
        boolean bl = i;
        if (this.m_bounds.equals(rectangle2D)) {
            return;
        }
        if (this.m_bounders != null && this.m_bounders.size() > 0) {
            Object[] objectArray = this.m_bounders.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    ((ItemBoundsListener)objectArray[i2]).itemBoundsChanged(this);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z[7] + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }
    }

    public void addControlListener(Control control) {
        this.m_controls.add(control);
    }

    public void removeControlListener(Control control) {
        this.m_controls.remove(control);
    }

    public synchronized VisualItem findItem(Point point) {
        Point point2;
        boolean bl = i;
        Point2D point2D = point2 = this.m_itransform == null ? point : this.m_itransform.transform(point, this.m_tmpPoint);
        if (!this.m_queue.psorted) {
            this.m_queue.sortPickingQueue();
        }
        int n2 = this.m_queue.psize;
        while (--n2 >= 0) {
            VisualItem visualItem = this.m_queue.pitems[n2];
            if (!visualItem.isValid()) continue;
            Renderer renderer = visualItem.getRenderer();
            if (renderer != null && visualItem.isInteractive() && renderer.locatePoint(point2, visualItem)) {
                return visualItem;
            }
            if (!bl) continue;
        }
        return null;
    }

    public JTextComponent getTextEditor() {
        return this.d;
    }

    public void setTextEditor(JTextComponent jTextComponent) {
        this.remove(this.d);
        this.d = jTextComponent;
        this.add((Component)this.d, 1);
    }

    public void editText(VisualItem visualItem, String string) {
        Rectangle rectangle;
        block5: {
            block4: {
                if (this.e) {
                    this.stopEditing();
                }
                Rectangle2D rectangle2D = visualItem.getBounds();
                rectangle = this.m_transform.createTransformedShape(rectangle2D).getBounds();
                if (!(this.d instanceof JTextArea)) break block4;
                rectangle.y -= 2;
                rectangle.width += 22;
                rectangle.height += 2;
                if (!i) break block5;
            }
            rectangle.x += 3;
            ++rectangle.y;
            rectangle.width -= 5;
            rectangle.height -= 2;
        }
        Font font = this.getFont();
        int n2 = (int)Math.round((double)font.getSize() * this.m_transform.getScaleX());
        Font font2 = new Font(font.getFontName(), font.getStyle(), n2);
        this.d.setFont(font2);
        this.editText(visualItem, string, rectangle);
    }

    public void editText(VisualItem visualItem, String string, Rectangle rectangle) {
        if (this.e) {
            this.stopEditing();
        }
        String string2 = visualItem.getString(string);
        this.f = visualItem;
        this.g = string;
        Color color = ColorLib.getColor(visualItem.getTextColor());
        Color color2 = ColorLib.getColor(visualItem.getFillColor());
        this.d.setForeground(color);
        this.d.setBackground(color2);
        this.editText(string2, rectangle);
    }

    public void editText(String string, Rectangle rectangle) {
        if (this.e) {
            this.stopEditing();
        }
        this.e = true;
        this.d.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.d.setText(string);
        this.d.setVisible(true);
        this.d.setCaretPosition(string.length());
        this.d.requestFocus();
    }

    public void stopEditing() {
        this.d.setVisible(false);
        if (this.f != null) {
            String string = this.d.getText();
            this.f.set(this.g, (Object)string);
            this.f = null;
            this.g = null;
            this.d.setBackground(null);
            this.d.setForeground(null);
        }
        this.e = false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "r0\u007f5!C!s>qC n?&Yh~)qg)u>%{!o$4Y-njq";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block19;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 55;
                                break;
                            }
                            case 1: {
                                n9 = 72;
                                break;
                            }
                            case 2: {
                                n9 = 28;
                                break;
                            }
                            case 3: {
                                n9 = 80;
                                break;
                            }
                            default: {
                                n9 = 81;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "R0l?#Chx9\"G$})";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "S-~%6\u0017!r6>";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "C'{7=Rht96_em%0[!h)qS:}'8Y/";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "T<n<qs";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "T<n<qr";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "T<n<q\u007f";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "r0\u007f5!C!s>qC n?&Yh~)q~<y=\u0013X=r4\"{!o$4Y-njq";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        a = Logger.getLogger(Display.class.getName());
    }

    public class InputEventCapturer
    implements MouseMotionListener,
    MouseWheelListener,
    MouseListener,
    KeyListener {
        private VisualItem a = null;
        private boolean b = false;
        private static final String z;

        private boolean a() {
            if (this.a.isValid()) {
                return true;
            }
            this.a = null;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            block6: {
                Visualization visualization = Display.this.m_vis;
                synchronized (visualization) {
                    block5: {
                        if (this.a == null) break block5;
                        if (!this.a()) break block6;
                        this.a(this.a, mouseEvent);
                        if (!i) break block6;
                    }
                    this.g(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                boolean bl = false;
                VisualItem visualItem = Display.this.findItem(mouseEvent.getPoint());
                if (this.a != null && this.a != visualItem) {
                    if (this.a()) {
                        this.g(this.a, mouseEvent);
                    }
                    bl = true;
                }
                if (visualItem != null && visualItem != this.a) {
                    this.f(visualItem, mouseEvent);
                    bl = true;
                }
                this.a = visualItem;
                if (bl) {
                    return;
                }
                if (visualItem != null && visualItem == this.a) {
                    this.b(visualItem, mouseEvent);
                }
                if (visualItem == null) {
                    this.h(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            block6: {
                Visualization visualization = Display.this.m_vis;
                synchronized (visualization) {
                    block5: {
                        if (this.a == null) break block5;
                        if (!this.a()) break block6;
                        this.a(this.a, mouseWheelEvent);
                        if (!i) break block6;
                    }
                    this.a(mouseWheelEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            block6: {
                Visualization visualization = Display.this.m_vis;
                synchronized (visualization) {
                    block5: {
                        if (this.a == null) break block5;
                        if (!this.a()) break block6;
                        this.c(this.a, mouseEvent);
                        if (!i) break block6;
                    }
                    this.f(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            block6: {
                Visualization visualization = Display.this.m_vis;
                synchronized (visualization) {
                    block5: {
                        this.b = true;
                        if (this.a == null) break block5;
                        if (!this.a()) break block6;
                        this.d(this.a, mouseEvent);
                        if (!i) break block6;
                    }
                    this.d(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                block8: {
                    block7: {
                        if (this.a == null) break block7;
                        if (!this.a()) break block8;
                        this.e(this.a, mouseEvent);
                        if (!i) break block8;
                    }
                    this.e(mouseEvent);
                }
                if (this.a != null && this.b && this.a(mouseEvent)) {
                    this.g(this.a, mouseEvent);
                    this.a = null;
                }
                this.b = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                this.b(mouseEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (!this.b && this.a != null) {
                    this.g(this.a, mouseEvent);
                    this.a = null;
                }
                this.c(mouseEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            block6: {
                Visualization visualization = Display.this.m_vis;
                synchronized (visualization) {
                    block5: {
                        if (this.a == null) break block5;
                        if (!this.a()) break block6;
                        this.a(this.a, keyEvent);
                        if (!i) break block6;
                    }
                    this.a(keyEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyReleased(KeyEvent keyEvent) {
            block6: {
                Visualization visualization = Display.this.m_vis;
                synchronized (visualization) {
                    block5: {
                        if (this.a == null) break block5;
                        if (!this.a()) break block6;
                        this.b(this.a, keyEvent);
                        if (!i) break block6;
                    }
                    this.b(keyEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyTyped(KeyEvent keyEvent) {
            block6: {
                Visualization visualization = Display.this.m_vis;
                synchronized (visualization) {
                    block5: {
                        if (this.a == null) break block5;
                        if (!this.a()) break block6;
                        this.c(this.a, keyEvent);
                        if (!i) break block6;
                    }
                    this.c(keyEvent);
                }
            }
        }

        private boolean a(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            return n2 < 0 || n2 > Display.this.getWidth() || n3 < 0 || n3 > Display.this.getHeight();
        }

        private void a(VisualItem visualItem, MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemDragged(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void b(VisualItem visualItem, MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemMoved(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void a(VisualItem visualItem, MouseWheelEvent mouseWheelEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemWheelMoved(visualItem, mouseWheelEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void c(VisualItem visualItem, MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemClicked(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void d(VisualItem visualItem, MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemPressed(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void e(VisualItem visualItem, MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemReleased(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void f(VisualItem visualItem, MouseEvent mouseEvent) {
            boolean bl = i;
            visualItem.setHover(true);
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemEntered(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void g(VisualItem visualItem, MouseEvent mouseEvent) {
            boolean bl = i;
            if (visualItem.isValid()) {
                visualItem.setHover(false);
            }
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemExited(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void a(VisualItem visualItem, KeyEvent keyEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            if (objectArray.length == 0) {
                return;
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyPressed(visualItem, keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void b(VisualItem visualItem, KeyEvent keyEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyReleased(visualItem, keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void c(VisualItem visualItem, KeyEvent keyEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyTyped(visualItem, keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void b(MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseEntered(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void c(MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseExited(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void d(MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.mousePressed(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void e(MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseReleased(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void f(MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseClicked(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void g(MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseDragged(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void h(MouseEvent mouseEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseMoved(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void a(MouseWheelEvent mouseWheelEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseWheelMoved(mouseWheelEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void a(KeyEvent keyEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.keyPressed(keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void b(KeyEvent keyEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.keyReleased(keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        private void c(KeyEvent keyEvent) {
            boolean bl = i;
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Control control = (Control)objectArray[i2];
                if (!control.isEnabled()) continue;
                try {
                    control.keyTyped(keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    a.warning(z + exception + "\n" + StringLib.getStackTrace(exception));
                }
                if (!bl) continue;
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "\u0013\u0018vl.\"\tzg~\"\bgf)8@wp~\u0015\u000f{},9\f/)".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 86;
                                break;
                            }
                            case 1: {
                                n7 = 96;
                                break;
                            }
                            case 2: {
                                n7 = 21;
                                break;
                            }
                            case 3: {
                                n7 = 9;
                                break;
                            }
                            default: {
                                n7 = 94;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }

    protected class TransformActivity
    extends Activity {
        private double[] k;
        private double[] l;
        private AffineTransform m;

        public TransformActivity() {
            super(2000L, 20L, 0L);
            this.k = new double[6];
            this.l = new double[6];
            this.m = new AffineTransform();
            this.setPacingFunction(new SlowInSlowOutPacer());
        }

        private AffineTransform a() {
            block3: {
                block2: {
                    if (!this.isScheduled()) break block2;
                    this.m.setTransform(this.l[0], this.l[1], this.l[2], this.l[3], this.l[4], this.l[5]);
                    if (!i) break block3;
                }
                this.m.setTransform(Display.this.m_transform);
            }
            return this.m;
        }

        public void panAndZoom(Point2D point2D, double d2, long l2) {
            boolean bl = i;
            AffineTransform affineTransform = this.a();
            this.cancel();
            this.setDuration(l2);
            Display.this.m_tmpPoint.setLocation(0.0, 0.0);
            Display.this.m_itransform.transform(Display.this.m_tmpPoint, Display.this.m_tmpPoint);
            double d3 = point2D.getX();
            d3 = Double.isNaN(d3) ? 0.0 : d3;
            double d4 = point2D.getY();
            d4 = Double.isNaN(d4) ? 0.0 : d4;
            double d5 = (double)Display.this.getWidth() / (2.0 * Display.this.m_transform.getScaleX());
            double d6 = (double)Display.this.getHeight() / (2.0 * Display.this.m_transform.getScaleY());
            double d7 = d5 - d3 + Display.this.m_tmpPoint.getX();
            double d8 = d6 - d4 + Display.this.m_tmpPoint.getY();
            affineTransform.translate(d7, d8);
            affineTransform.translate(point2D.getX(), point2D.getY());
            affineTransform.scale(d2, d2);
            affineTransform.translate(-point2D.getX(), -point2D.getY());
            affineTransform.getMatrix(this.l);
            Display.this.m_transform.getMatrix(this.k);
            this.run();
            if (AbstractExpression.b) {
                i = !bl;
            }
        }

        public void pan(double d2, double d3, long l2) {
            AffineTransform affineTransform = this.a();
            this.cancel();
            this.setDuration(l2);
            affineTransform.translate(d2, d3);
            affineTransform.getMatrix(this.l);
            Display.this.m_transform.getMatrix(this.k);
            this.run();
        }

        public void zoom(Point2D point2D, double d2, long l2) {
            AffineTransform affineTransform = this.a();
            this.cancel();
            this.setDuration(l2);
            double d3 = point2D.getX();
            double d4 = point2D.getY();
            affineTransform.translate(d3, d4);
            affineTransform.scale(d2, d2);
            affineTransform.translate(-d3, -d4);
            affineTransform.getMatrix(this.l);
            Display.this.m_transform.getMatrix(this.k);
            this.run();
        }

        @Override
        protected void run(long l2) {
            double d2 = this.getPace(l2);
            Display.this.damageReport();
            Display.this.m_transform.setTransform(this.k[0] + d2 * (this.l[0] - this.k[0]), this.k[1] + d2 * (this.l[1] - this.k[1]), this.k[2] + d2 * (this.l[2] - this.k[2]), this.k[3] + d2 * (this.l[3] - this.k[3]), this.k[4] + d2 * (this.l[4] - this.k[4]), this.k[5] + d2 * (this.l[5] - this.k[5]));
            try {
                Display.this.m_itransform = Display.this.m_transform.createInverse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Display.this.fireScaleChangedListeners();
            Display.this.repaint();
        }
    }
}

