/*
 * Decompiled with CFR 0.152.
 */
package prefuse;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import prefuse.Display;
import prefuse.action.Action;
import prefuse.activity.Activity;
import prefuse.activity.ActivityMap;
import prefuse.data.CascadedTable;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.CompositeTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleManager;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.PrefuseConfig;
import prefuse.util.PrefuseLib;
import prefuse.util.collections.CompositeIterator;
import prefuse.visual.AggregateTable;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.VisualTree;
import prefuse.visual.VisualTupleSet;
import prefuse.visual.expression.ValidatedPredicate;
import prefuse.visual.expression.VisiblePredicate;
import prefuse.visual.tuple.TableDecoratorItem;
import prefuse.visual.tuple.TableEdgeItem;
import prefuse.visual.tuple.TableNodeItem;

public class Visualization {
    public static final String ALL_ITEMS;
    public static final String FOCUS_ITEMS;
    public static final String SELECTED_ITEMS;
    public static final String SEARCH_ITEMS;
    private Map a;
    private Map b;
    private Map c;
    private ActivityMap d = new ActivityMap();
    private RendererFactory e = new DefaultRendererFactory();
    private ArrayList f;
    private static final String[] z;

    public Visualization() {
        this.a = new LinkedHashMap();
        this.b = new HashMap();
        this.c = new HashMap();
        this.f = new ArrayList();
        this.addFocusGroup(FOCUS_ITEMS, new DefaultTupleSet());
        this.addFocusGroup(SELECTED_ITEMS, new DefaultTupleSet());
    }

    public synchronized VisualTupleSet add(String string, TupleSet tupleSet) {
        return this.add(string, tupleSet, null);
    }

    public synchronized VisualTupleSet add(String string, TupleSet tupleSet, Predicate predicate) {
        if (tupleSet instanceof Table) {
            return this.addTable(string, (Table)tupleSet, predicate);
        }
        if (tupleSet instanceof Tree) {
            return this.addTree(string, (Tree)tupleSet, predicate);
        }
        if (tupleSet instanceof Graph) {
            return this.addGraph(string, (Graph)tupleSet, predicate);
        }
        throw new IllegalArgumentException(z[1]);
    }

    protected void checkGroupExists(String string) {
        if (this.a.containsKey(string) || this.c.containsKey(string)) {
            throw new IllegalArgumentException(z[3] + string + z[2]);
        }
    }

    protected void addDataGroup(String string, VisualTupleSet visualTupleSet, TupleSet tupleSet) {
        this.checkGroupExists(string);
        this.a.put(string, visualTupleSet);
        if (tupleSet != null) {
            this.b.put(string, tupleSet);
        }
    }

    public synchronized VisualTable addTable(String string) {
        VisualTable visualTable = new VisualTable(this, string);
        this.addDataGroup(string, visualTable, null);
        return visualTable;
    }

    public synchronized VisualTable addTable(String string, Schema schema) {
        VisualTable visualTable = new VisualTable(this, string, schema);
        this.addDataGroup(string, visualTable, null);
        return visualTable;
    }

    public synchronized VisualTable addTable(String string, Table table) {
        return this.addTable(string, table, (Predicate)null);
    }

    public synchronized VisualTable addTable(String string, Table table, Predicate predicate) {
        VisualTable visualTable = new VisualTable(table, this, string, predicate);
        this.addDataGroup(string, visualTable, table);
        return visualTable;
    }

    public synchronized VisualTable addTable(String string, Table table, Schema schema) {
        return this.addTable(string, table, null, schema);
    }

    public synchronized VisualTable addTable(String string, Table table, Predicate predicate, Schema schema) {
        VisualTable visualTable = new VisualTable(table, this, string, predicate, schema);
        this.addDataGroup(string, visualTable, table);
        return visualTable;
    }

    public synchronized VisualTable addTable(VisualTable visualTable) {
        this.addDataGroup(visualTable.getGroup(), visualTable, visualTable.getParentTable());
        visualTable.setVisualization(this);
        return visualTable;
    }

    public synchronized VisualGraph addGraph(String string, Graph graph) {
        return this.addGraph(string, graph, null);
    }

    public synchronized VisualGraph addGraph(String string, Graph graph, Predicate predicate) {
        return this.addGraph(string, graph, predicate, VisualItem.SCHEMA, VisualItem.SCHEMA);
    }

    public synchronized VisualGraph addGraph(String string, Graph graph, Predicate predicate, Schema schema, Schema schema2) {
        this.checkGroupExists(string);
        String string2 = PrefuseLib.getGroupName(string, Graph.NODES);
        String string3 = PrefuseLib.getGroupName(string, Graph.EDGES);
        VisualTable visualTable = this.addTable(string2, graph.getNodeTable(), predicate, schema);
        VisualTable visualTable2 = this.addTable(string3, graph.getEdgeTable(), predicate, schema2);
        VisualGraph visualGraph = new VisualGraph(visualTable, visualTable2, graph.isDirected(), graph.getNodeKeyField(), graph.getEdgeSourceField(), graph.getEdgeTargetField());
        visualGraph.setVisualization(this);
        visualGraph.setGroup(string);
        this.addDataGroup(string, visualGraph, graph);
        TupleManager tupleManager = new TupleManager(visualTable, visualGraph, TableNodeItem.class);
        TupleManager tupleManager2 = new TupleManager(visualTable2, visualGraph, TableEdgeItem.class);
        visualTable.setTupleManager(tupleManager);
        visualTable2.setTupleManager(tupleManager2);
        visualGraph.setTupleManagers(tupleManager, tupleManager2);
        return visualGraph;
    }

    public synchronized VisualTree addTree(String string, Tree tree) {
        return this.addTree(string, tree, null);
    }

    public synchronized VisualTree addTree(String string, Tree tree, Predicate predicate) {
        return this.addTree(string, tree, predicate, VisualItem.SCHEMA, VisualItem.SCHEMA);
    }

    public synchronized VisualTree addTree(String string, Tree tree, Predicate predicate, Schema schema, Schema schema2) {
        this.checkGroupExists(string);
        String string2 = PrefuseLib.getGroupName(string, Graph.NODES);
        String string3 = PrefuseLib.getGroupName(string, Graph.EDGES);
        VisualTable visualTable = this.addTable(string2, tree.getNodeTable(), predicate, schema);
        VisualTable visualTable2 = this.addTable(string3, tree.getEdgeTable(), predicate, schema2);
        VisualTree visualTree = new VisualTree(visualTable, visualTable2, tree.getNodeKeyField(), tree.getEdgeSourceField(), tree.getEdgeTargetField());
        visualTree.setVisualization(this);
        visualTree.setGroup(string);
        this.addDataGroup(string, visualTree, tree);
        TupleManager tupleManager = new TupleManager(visualTable, visualTree, TableNodeItem.class);
        TupleManager tupleManager2 = new TupleManager(visualTable2, visualTree, TableEdgeItem.class);
        visualTable.setTupleManager(tupleManager);
        visualTable2.setTupleManager(tupleManager2);
        visualTree.setTupleManagers(tupleManager, tupleManager2);
        return visualTree;
    }

    public synchronized AggregateTable addAggregates(String string) {
        return this.addAggregates(string, VisualItem.SCHEMA);
    }

    public synchronized AggregateTable addAggregates(String string, Schema schema) {
        AggregateTable aggregateTable = new AggregateTable(this, string, schema);
        this.addDataGroup(string, aggregateTable, null);
        return aggregateTable;
    }

    public synchronized VisualTable addDerivedTable(String string, String string2, Predicate predicate, Schema schema) {
        VisualTable visualTable = (VisualTable)this.getGroup(string2);
        VisualTable visualTable2 = new VisualTable(visualTable, this, string, predicate, schema);
        this.addDataGroup(string, visualTable2, this.getSourceData(string2));
        return visualTable2;
    }

    public synchronized VisualTable addDecorators(String string, String string2) {
        return this.addDecorators(string, string2, (Predicate)null);
    }

    public synchronized VisualTable addDecorators(String string, String string2, Schema schema) {
        return this.addDecorators(string, string2, null, schema);
    }

    public synchronized VisualTable addDecorators(String string, String string2, Predicate predicate) {
        VisualTable visualTable = this.addDerivedTable(string, string2, predicate, VisualItem.SCHEMA);
        visualTable.setTupleManager(new TupleManager(visualTable, null, TableDecoratorItem.class));
        return visualTable;
    }

    public synchronized VisualTable addDecorators(String string, String string2, Predicate predicate, Schema schema) {
        VisualTable visualTable = this.addDerivedTable(string, string2, predicate, schema);
        visualTable.setTupleManager(new TupleManager(visualTable, null, TableDecoratorItem.class));
        return visualTable;
    }

    public synchronized boolean removeGroup(String string) {
        Object object;
        boolean bl = Display.i;
        TupleSet tupleSet = this.getFocusGroup(string);
        if (tupleSet != null) {
            Iterator iterator = tupleSet.tuples(ValidatedPredicate.TRUE);
            while (iterator.hasNext()) {
                ((VisualItem)iterator.next()).setValidated(false);
                if (!bl) continue;
            }
            tupleSet.clear();
            this.c.remove(string);
            return true;
        }
        tupleSet = this.getVisualGroup(string);
        if (tupleSet == null) {
            return false;
        }
        TupleSet[] tupleSetArray = new TupleSet[this.c.size()];
        this.c.values().toArray(tupleSetArray);
        Object object2 = tupleSet.tuples();
        while (object2.hasNext()) {
            object = (VisualItem)object2.next();
            for (int i2 = 0; i2 < tupleSetArray.length; ++i2) {
                tupleSetArray[i2].removeTuple((Tuple)object);
                if (!bl) continue;
            }
            object.setValidated(false);
            if (!bl) continue;
        }
        if (tupleSet instanceof CompositeTupleSet) {
            object2 = (CompositeTupleSet)tupleSet;
            object = ((CompositeTupleSet)object2).setNames();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                String string3 = PrefuseLib.getGroupName(string, string2);
                this.a.remove(string3);
                this.b.remove(string3);
                if (!bl) continue;
            }
        }
        this.a.remove(string);
        this.b.remove(string);
        return true;
    }

    public synchronized void reset() {
        boolean bl = Display.i;
        for (Map.Entry entry : this.c.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            tupleSet.clear();
            if (!bl) continue;
        }
        this.a.clear();
        this.b.clear();
    }

    public TupleSet getSourceData(String string) {
        return (TupleSet)this.b.get(string);
    }

    public TupleSet getSourceData(VisualTupleSet visualTupleSet) {
        return (TupleSet)this.b.get(visualTupleSet.getGroup());
    }

    public Tuple getSourceTuple(VisualItem visualItem) {
        Object object;
        boolean bl = Display.i;
        String string = visualItem.getGroup();
        TupleSet tupleSet = this.getSourceData(string);
        if (tupleSet == null) {
            return null;
        }
        int n2 = visualItem.getRow();
        Table table = visualItem.getTable();
        while (table instanceof VisualTable) {
            object = (VisualTable)table;
            n2 = ((CascadedTable)object).getParentRow(n2);
            table = ((CascadedTable)object).getParentTable();
            if (!bl) continue;
        }
        if ((object = PrefuseLib.getChildGroup(string)) != null) {
            String string2 = PrefuseLib.getParentGroup(string);
            Graph graph = (Graph)this.getSourceData(string2);
            if (table == graph.getNodeTable()) {
                return graph.getNode(n2);
            }
            return graph.getEdge(n2);
        }
        return table.getTuple(n2);
    }

    public VisualItem getVisualItem(String string, Tuple tuple) {
        int n2;
        int n3;
        VisualTable visualTable;
        block3: {
            block4: {
                TupleSet tupleSet;
                boolean bl;
                block2: {
                    bl = Display.i;
                    tupleSet = this.getVisualGroup(string);
                    if (!(tupleSet instanceof VisualTable)) break block2;
                    visualTable = (VisualTable)tupleSet;
                    if (!bl) break block3;
                }
                if (!(tupleSet instanceof Graph)) break block4;
                Graph graph = (Graph)tupleSet;
                visualTable = (VisualTable)(tuple instanceof Node ? graph.getNodeTable() : graph.getEdgeTable());
                if (!bl) break block3;
            }
            return null;
        }
        return (n3 = visualTable.getChildRow(n2 = tuple.getRow())) < 0 ? null : visualTable.getItem(n3);
    }

    public TupleSet getGroup(String string) {
        TupleSet tupleSet = this.getVisualGroup(string);
        if (tupleSet == null) {
            tupleSet = this.getFocusGroup(string);
        }
        return tupleSet;
    }

    public boolean isInGroup(VisualItem visualItem, String string) {
        if (ALL_ITEMS.equals(string)) {
            return true;
        }
        if (visualItem.getGroup() == string) {
            return true;
        }
        TupleSet tupleSet = this.getGroup(string);
        return tupleSet == null ? false : tupleSet.containsTuple(visualItem);
    }

    public void addFocusGroup(String string) {
        this.checkGroupExists(string);
        this.c.put(string, new DefaultTupleSet());
    }

    public void addFocusGroup(String string, TupleSet tupleSet) {
        this.checkGroupExists(string);
        this.c.put(string, tupleSet);
    }

    public int size(String string) {
        TupleSet tupleSet = this.getGroup(string);
        return tupleSet == null ? 0 : tupleSet.getTupleCount();
    }

    public TupleSet getVisualGroup(String string) {
        return (TupleSet)this.a.get(string);
    }

    public TupleSet getFocusGroup(String string) {
        return (TupleSet)this.c.get(string);
    }

    public void invalidate(String string) {
        boolean bl = Display.i;
        Iterator iterator = this.items(string, ValidatedPredicate.TRUE);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            visualItem.setValidated(false);
            if (!bl) continue;
        }
    }

    public void invalidateAll() {
        this.invalidate(ALL_ITEMS);
    }

    public Iterator visibleItems() {
        return this.items(VisiblePredicate.TRUE);
    }

    public Iterator visibleItems(String string) {
        return this.items(string, VisiblePredicate.TRUE);
    }

    public Iterator items() {
        return this.items((Predicate)null);
    }

    public Iterator items(Predicate predicate) {
        boolean bl = Display.i;
        int n2 = this.a.size();
        if (n2 == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (n2 == 1) {
            Iterator iterator = this.a.keySet().iterator();
            return this.items((String)iterator.next(), predicate);
        }
        CompositeIterator compositeIterator = new CompositeIterator(this.a.size());
        Iterator iterator = this.a.keySet().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!PrefuseLib.isChildGroup(string)) {
                compositeIterator.setIterator(n3++, this.items(string, predicate));
            }
            if (!bl) continue;
        }
        return compositeIterator;
    }

    public Iterator items(String string) {
        return this.items(string, (Predicate)null);
    }

    public Iterator items(String string, String string2) {
        Expression expression = ExpressionParser.parse(string2);
        if (!(expression instanceof Predicate) || ExpressionParser.getError() != null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.items(string, (Predicate)expression);
    }

    public Iterator items(String string, Predicate predicate) {
        if (ALL_ITEMS.equals(string)) {
            return this.items(predicate);
        }
        TupleSet tupleSet = this.getGroup(string);
        return tupleSet == null ? Collections.EMPTY_LIST.iterator() : tupleSet.tuples(predicate);
    }

    public void setValue(String string, Predicate predicate, String string2, Object object) {
        boolean bl = Display.i;
        Iterator iterator = this.items(string, predicate);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            visualItem.set(string2, object);
            if (!bl) continue;
        }
    }

    public void setVisible(String string, Predicate predicate, boolean bl) {
        boolean bl2 = Display.i;
        Iterator iterator = this.items(string, predicate);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            visualItem.setVisible(bl);
            if (!bl2) continue;
        }
    }

    public void setInteractive(String string, Predicate predicate, boolean bl) {
        boolean bl2 = Display.i;
        Iterator iterator = this.items(string, predicate);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            visualItem.setInteractive(bl);
            if (!bl2) continue;
        }
    }

    public Action putAction(String string, Action action) {
        action.setVisualization(this);
        this.d.put(string, action);
        return action;
    }

    public Action getAction(String string) {
        return (Action)this.d.get(string);
    }

    public Action removeAction(String string) {
        Action action = this.getAction(string);
        if (action != null) {
            action.cancel();
            this.d.remove(string);
            action.setVisualization(null);
        }
        return action;
    }

    public Activity run(String string) {
        return this.d.run(string);
    }

    public Activity runAfter(String string, long l2) {
        return this.d.runAt(string, System.currentTimeMillis() + l2);
    }

    public Activity runAt(String string, long l2) {
        return this.d.runAt(string, l2);
    }

    public Activity runAfter(String string, String string2) {
        return this.d.runAfter(string, string2);
    }

    public Activity alwaysRunAfter(String string, String string2) {
        return this.d.alwaysRunAfter(string, string2);
    }

    public Activity cancel(String string) {
        return this.d.cancel(string);
    }

    public void setRendererFactory(RendererFactory rendererFactory) {
        this.invalidateAll();
        this.e = rendererFactory;
    }

    public RendererFactory getRendererFactory() {
        return this.e;
    }

    public Renderer getRenderer(VisualItem visualItem) {
        if (visualItem.getVisualization() != this) {
            throw new IllegalArgumentException(z[0]);
        }
        return this.e.getRenderer(visualItem);
    }

    public synchronized void repaint() {
        boolean bl = Display.i;
        Iterator iterator = this.items(ValidatedPredicate.FALSE);
        while (iterator.hasNext()) {
            ((VisualItem)iterator.next()).validateBounds();
            if (!bl) continue;
        }
        for (int i2 = 0; i2 < this.f.size(); ++i2) {
            this.getDisplay(i2).repaint();
            if (!bl) continue;
        }
    }

    public Rectangle2D getBounds(String string) {
        return this.getBounds(string, new Rectangle2D.Double());
    }

    public Rectangle2D getBounds(String string, Rectangle2D rectangle2D) {
        VisualItem visualItem;
        boolean bl = Display.i;
        Iterator iterator = this.visibleItems(string);
        if (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            rectangle2D.setRect(visualItem.getBounds());
        }
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            Rectangle2D.union(visualItem.getBounds(), rectangle2D, rectangle2D);
            if (!bl) continue;
        }
        return rectangle2D;
    }

    public int getDisplayCount() {
        return this.f.size();
    }

    void a(Display display) {
        this.f.add(display);
    }

    public Display getDisplay(int n2) {
        return (Display)this.f.get(n2);
    }

    boolean b(Display display) {
        return this.f.remove(display);
    }

    public void damageReport(VisualItem visualItem, Rectangle2D rectangle2D) {
        boolean bl = Display.i;
        for (int i2 = 0; i2 < this.f.size(); ++i2) {
            Display display = this.getDisplay(i2);
            if (!display.getPredicate().getBoolean(visualItem)) continue;
            display.damageReport(rectangle2D);
            if (!bl) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "P?>%%98:5<9?!$qxq#5<{4<p>\u007fq:88jq89\"l0\"9+x%'??7";
        int n3 = -1;
        block10: while (true) {
            switch (n3) {
                default: {
                    stringArray2[n2] = Visualization.z(Visualization.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "L?=%!i><$4}q\u001a%!u4\u001d5%9%7 47";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = Visualization.z(Visualization.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ">q/<#|0*)qp?n%\"|";
                    n3 = 1;
                    continue block10;
                }
                case 1: {
                    stringArray2[n2] = Visualization.z(Visualization.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "^#!%!9?/=49v";
                    n3 = 2;
                    continue block10;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = Visualization.z(Visualization.z(string2));
        z = stringArray3;
        String string3 = "o8=%0u841%p> ~0u=\u0007$4t\"";
        int n4 = -1;
        block11: while (true) {
            string = Visualization.z(Visualization.z(string3));
            switch (n4) {
                default: {
                    ALL_ITEMS = PrefuseConfig.get(string);
                    string3 = "o8=%0u841%p> ~7v2;#\u0018m4##";
                    n4 = 0;
                    continue block11;
                }
                case 0: {
                    FOCUS_ITEMS = PrefuseConfig.get(string);
                    string3 = "o8=%0u841%p> ~\"|=+3%|5\u0007$4t\"";
                    n4 = 1;
                    continue block11;
                }
                case 1: {
                    SELECTED_ITEMS = PrefuseConfig.get(string);
                    string3 = "o8=%0u841%p> ~\"|0<39P%+=\"";
                    n4 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        SEARCH_ITEMS = PrefuseConfig.get(string);
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x51);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 25;
                            break;
                        }
                        case 1: {
                            n7 = 81;
                            break;
                        }
                        case 2: {
                            n7 = 78;
                            break;
                        }
                        case 3: {
                            n7 = 80;
                            break;
                        }
                        default: {
                            n7 = 81;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

