/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.Map;
import prefuse.action.assignment.ShapeAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.visual.VisualItem;

public class DataShapeAction
extends ShapeAction {
    protected static final int NO_SHAPE = Integer.MIN_VALUE;
    protected String m_dataField;
    protected int[] m_palette;
    protected Map m_ordinalMap;

    public DataShapeAction(String string, String string2) {
        super(string, Integer.MIN_VALUE);
        this.m_dataField = string2;
    }

    public DataShapeAction(String string, String string2, int[] nArray) {
        super(string, Integer.MIN_VALUE);
        this.m_dataField = string2;
        this.m_palette = nArray;
    }

    public String getDataField() {
        return this.m_dataField;
    }

    public void setDataField(String string) {
        this.m_dataField = string;
    }

    @Override
    public void setDefaultShape(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setup() {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        this.m_ordinalMap = DataLib.ordinalMap(tupleSet, this.m_dataField);
    }

    @Override
    public int getShape(VisualItem visualItem) {
        int n2 = super.getShape(visualItem);
        if (n2 != Integer.MIN_VALUE) {
            return n2;
        }
        Object object = visualItem.get(this.m_dataField);
        int n3 = (Integer)this.m_ordinalMap.get(object);
        if (this.m_palette == null) {
            return n3 % 10;
        }
        return this.m_palette[n3 % this.m_palette.length];
    }
}

