/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.SizeAction;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public class DataSizeAction
extends SizeAction {
    protected static final double NO_SIZE = Double.NaN;
    protected String m_dataField;
    protected double m_minSize;
    protected double m_sizeRange;
    protected int m_scale;
    protected int m_bins;
    protected boolean m_inferBounds;
    protected boolean m_inferRange;
    protected boolean m_is2DArea;
    protected double[] m_dist;
    protected int m_tempScale;
    private static final String[] z;

    public DataSizeAction(String string, String string2) {
        super(string, Double.NaN);
        this.m_minSize = 1.0;
        this.m_scale = 0;
        this.m_bins = -1;
        this.m_inferBounds = true;
        this.m_inferRange = true;
        this.m_is2DArea = true;
        this.m_dataField = string2;
    }

    public DataSizeAction(String string, String string2, int n2) {
        this(string, string2, n2, 0);
    }

    public DataSizeAction(String string, String string2, int n2, int n3) {
        boolean bl = ColorAction.n;
        super(string, Double.NaN);
        this.m_minSize = 1.0;
        this.m_scale = 0;
        this.m_bins = -1;
        this.m_inferBounds = true;
        this.m_inferRange = true;
        this.m_is2DArea = true;
        this.m_dataField = string2;
        this.setScale(n3);
        this.setBinCount(n2);
        if (bl) {
            AbstractExpression.b = !AbstractExpression.b;
        }
    }

    public String getDataField() {
        return this.m_dataField;
    }

    public void setDataField(String string) {
        this.m_dataField = string;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException(z[2] + n2);
        }
        this.m_scale = n2;
    }

    public int getBinCount() {
        return this.m_bins;
    }

    public void setBinCount(int n2) {
        if (this.m_scale == 3 && n2 <= 0) {
            throw new IllegalArgumentException(z[1]);
        }
        this.m_bins = n2;
    }

    public boolean is2DArea() {
        return this.m_is2DArea;
    }

    public void setIs2DArea(boolean bl) {
        this.m_is2DArea = bl;
    }

    public double getMinimumSize() {
        return this.m_minSize;
    }

    public void setMinimumSize(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 <= 0.0) {
            throw new IllegalArgumentException(z[3]);
        }
        if (this.m_inferRange) {
            this.m_sizeRange += this.m_minSize - d2;
        }
        this.m_minSize = d2;
    }

    public double getMaximumSize() {
        return this.m_minSize + this.m_sizeRange;
    }

    public void setMaximumSize(double d2) {
        block3: {
            block2: {
                if (!Double.isInfinite(d2) && !Double.isNaN(d2) && !(d2 <= 0.0)) break block2;
                this.m_inferRange = true;
                if (!ColorAction.n) break block3;
            }
            this.m_inferRange = false;
            this.m_sizeRange = d2 - this.m_minSize;
        }
    }

    @Override
    public void setDefaultSize(double d2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setup() {
        block7: {
            block10: {
                boolean bl;
                block9: {
                    TupleSet tupleSet;
                    block8: {
                        bl = ColorAction.n;
                        tupleSet = this.m_vis.getGroup(this.m_group);
                        this.m_tempScale = this.m_scale;
                        if (!this.m_inferBounds) break block7;
                        if (this.m_scale != 3 || this.m_bins <= 0) break block8;
                        double[] dArray = DataLib.toDoubleArray(tupleSet.tuples(), this.m_dataField);
                        this.m_dist = MathLib.quantiles(this.m_bins, dArray);
                        if (!bl) break block9;
                    }
                    if (this.m_scale == 3) {
                        Logger.getLogger(this.getClass().getName()).warning(z[0]);
                        this.m_scale = 0;
                    }
                    this.m_dist = new double[2];
                    this.m_dist[0] = DataLib.min(tupleSet, this.m_dataField).getDouble(this.m_dataField);
                    this.m_dist[1] = DataLib.max(tupleSet, this.m_dataField).getDouble(this.m_dataField);
                }
                if (!this.m_inferRange) break block7;
                if (this.m_dist[0] != 0.0) break block10;
                this.m_sizeRange = this.m_dist[this.m_dist.length - 1] - this.m_minSize;
                if (!bl) break block7;
            }
            this.m_sizeRange = this.m_dist[this.m_dist.length - 1] / this.m_dist[0] - this.m_minSize;
        }
    }

    @Override
    protected void finish() {
        this.m_scale = this.m_tempScale;
    }

    @Override
    public double getSize(VisualItem visualItem) {
        double d2;
        block5: {
            double d3;
            block4: {
                double d4 = super.getSize(visualItem);
                if (!Double.isNaN(d4)) {
                    return d4;
                }
                d2 = visualItem.getDouble(this.m_dataField);
                d3 = MathLib.interp(this.m_scale, d2, this.m_dist);
                if (this.m_bins >= 1) break block4;
                d2 = this.m_minSize + d3 * this.m_sizeRange;
                if (!ColorAction.n) break block5;
            }
            int n2 = d3 < 1.0 ? (int)(d3 * (double)this.m_bins) : this.m_bins - 1;
            d2 = this.m_minSize + (double)n2 * (this.m_sizeRange / (double)(this.m_bins - 1));
        }
        return this.m_is2DArea ? PrefuseLib.getSize2D(d2) : d2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "hm\u001f\r{\u000by\u0002O/Zy\u0010D{B`\u0014\n|Hm\u001dO/\\e\u0005B/EcQHfEb\u0018Dh\u0005,5OiJy\u001d^fEkQ^`\u000b`\u0018DjJ~QYlJ`\u0014\u0004/xi\u0005\n{CiQHfE,\u0007Kc^iQM}Nm\u0005O}\u000bx\u0019Ka\u000bv\u0014X`\u000bx\u001e\nzXiQK/Zy\u0010D{B`\u0014\n|Hm\u001dO!";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 43;
                                break;
                            }
                            case 1: {
                                n9 = 12;
                                break;
                            }
                            case 2: {
                                n9 = 113;
                                break;
                            }
                            case 3: {
                                n9 = 42;
                                break;
                            }
                            default: {
                                n9 = 15;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u007fd\u0014\n~^m\u001f^fGiQYlJ`\u0014\nlJbQD`_,\u0013O/^\u007f\u0014N/\\e\u0005B`^xQHfEb\u0018Dh\u0005,$Yj\u000bmQHfE,\u0007Kc^iQM}Nm\u0005O}\u000bx\u0019Ka\u000bv\u0014X`\u0005";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "~b\u0003OlDk\u001fCuNhQYlJ`\u0014\nyJ`\u0004O5\u000b";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "fe\u001fCb^aQYfQiQ\\nGy\u0014\nb^\u007f\u0005\nmN,\u0010\niBb\u0018^j\u000bb\u0004GmN~QM}Nm\u0005O}\u000bx\u0019Ka\u000bv\u0014X`\u0005";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

