/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.distortion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.action.distortion.Distortion;
import prefuse.data.expression.AbstractExpression;

public class BifocalDistortion
extends Distortion {
    private double p;
    private double q;
    private double r;
    private double s;

    public BifocalDistortion() {
        this(0.1, 3.0);
    }

    public BifocalDistortion(double d2, double d3) {
        this(d2, d3, d2, d3);
    }

    public BifocalDistortion(double d2, double d3, double d4, double d5) {
        boolean bl = Distortion.o;
        this.p = d2;
        this.r = d3;
        this.q = d4;
        this.s = d5;
        this.m_distortX = this.p != 0.0 && this.r != 1.0;
        boolean bl2 = this.m_distortY = this.q != 0.0 && this.s != 1.0;
        if (bl) {
            AbstractExpression.b = !AbstractExpression.b;
        }
    }

    @Override
    protected double distortX(double d2, Point2D point2D, Rectangle2D rectangle2D) {
        return this.a(d2, point2D.getX(), this.p, this.r, rectangle2D.getMinX(), rectangle2D.getMaxX());
    }

    @Override
    protected double distortY(double d2, Point2D point2D, Rectangle2D rectangle2D) {
        return this.a(d2, point2D.getY(), this.q, this.s, rectangle2D.getMinY(), rectangle2D.getMaxY());
    }

    @Override
    protected double distortSize(Rectangle2D rectangle2D, double d2, double d3, Point2D point2D, Rectangle2D rectangle2D2) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_distortX) {
            d8 = rectangle2D.getCenterX();
            d7 = point2D.getX();
            d6 = rectangle2D2.getMinX();
            d5 = rectangle2D2.getMaxX();
            double d9 = d4 = d8 < d7 ? d7 - d6 : d5 - d7;
            if (d4 == 0.0) {
                d4 = d5 - d6;
            }
            if (Math.abs(d8 - d7) <= this.p * d4) {
                bl = true;
            }
        }
        if (this.m_distortY) {
            d8 = rectangle2D.getCenterY();
            d7 = point2D.getY();
            d6 = rectangle2D2.getMinY();
            d5 = rectangle2D2.getMaxY();
            double d10 = d4 = d8 < d7 ? d7 - d6 : d5 - d7;
            if (d4 == 0.0) {
                d4 = d5 - d6;
            }
            if (Math.abs(d8 - d7) <= this.q * d4) {
                bl2 = true;
            }
        }
        if (bl && !this.m_distortY) {
            return this.r;
        }
        if (bl2 && !this.m_distortX) {
            return this.s;
        }
        if (bl && bl2) {
            return Math.min(this.r, this.s);
        }
        return Math.min((1.0 - this.p * this.r) / (1.0 - this.p), (1.0 - this.q * this.s) / (1.0 - this.q));
    }

    private double a(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = d8 = d2 < d3 ? d3 - d6 : d7 - d3;
        if (d8 == 0.0) {
            d8 = d7 - d6;
        }
        double d10 = d2 - d3;
        double d11 = d8 * d4;
        if (Math.abs(d10) <= d11) {
            d2 = d10 * d5 + d3;
            return d2;
        }
        double d12 = d4 * d5;
        d2 = (Math.abs(d10) - d11) / d8 * ((1.0 - d12) / (1.0 - d4));
        return (double)(d10 < 0.0 ? -1 : 1) * d8 * (d2 + d12) + d3;
    }

    public double getXMagnification() {
        return this.r;
    }

    public void setXMagnification(double d2) {
        this.r = d2;
    }

    public double getYMagnification() {
        return this.s;
    }

    public void setYMagnification(double d2) {
        this.s = d2;
    }

    public double getXRange() {
        return this.p;
    }

    public void setXRange(double d2) {
        this.p = d2;
    }

    public double getYRange() {
        return this.q;
    }

    public void setYRange(double d2) {
        this.q = d2;
    }
}

