/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.distortion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.visual.VisualItem;

public abstract class Distortion
extends Layout {
    private Point2D n = new Point2D.Double();
    protected boolean m_distortSize = true;
    protected boolean m_distortX = true;
    protected boolean m_distortY = true;
    public static boolean o;

    public Distortion() {
    }

    public Distortion(String string) {
        super(string);
    }

    public void setSizeDistorted(boolean bl) {
        this.m_distortSize = bl;
    }

    public boolean isSizeDistorted() {
        return this.m_distortSize;
    }

    @Override
    public void run(double d2) {
        boolean bl = o;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        Point2D point2D = this.correct(this.m_anchor, rectangle2D);
        Iterator iterator = this.getVisualization().visibleItems(this.m_group);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            if (visualItem.isFixed()) continue;
            visualItem.setX(visualItem.getEndX());
            visualItem.setY(visualItem.getEndY());
            visualItem.setSize(visualItem.getEndSize());
            if (point2D != null) {
                Rectangle2D rectangle2D2 = visualItem.getBounds();
                double d3 = visualItem.getX();
                double d4 = visualItem.getY();
                if (this.m_distortX) {
                    d3 = this.distortX(d3, point2D, rectangle2D);
                    visualItem.setX(d3);
                }
                if (this.m_distortY) {
                    d4 = this.distortY(d4, point2D, rectangle2D);
                    visualItem.setY(d4);
                }
                if (this.m_distortSize) {
                    double d5 = this.distortSize(rectangle2D2, d3, d4, point2D, rectangle2D);
                    visualItem.setSize(d5 * visualItem.getSize());
                }
            }
            if (!bl) continue;
        }
    }

    protected Point2D correct(Point2D point2D, Rectangle2D rectangle2D) {
        if (point2D == null) {
            return point2D;
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = rectangle2D.getMinX();
        double d5 = rectangle2D.getMinY();
        double d6 = rectangle2D.getMaxX();
        double d7 = rectangle2D.getMaxY();
        double d8 = d2 < d4 ? d4 : (d2 = d2 > d6 ? d6 : d2);
        d3 = d3 < d5 ? d5 : (d3 > d7 ? d7 : d3);
        this.n.setLocation(d2, d3);
        return this.n;
    }

    protected abstract double distortX(double var1, Point2D var3, Rectangle2D var4);

    protected abstract double distortY(double var1, Point2D var3, Rectangle2D var4);

    protected abstract double distortSize(Rectangle2D var1, double var2, double var4, Point2D var6, Rectangle2D var7);
}

