/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.filter;

import java.util.Iterator;
import prefuse.Visualization;
import prefuse.action.GroupAction;
import prefuse.action.filter.VisibilityFilter;
import prefuse.data.Graph;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Predicate;
import prefuse.data.util.BreadthFirstIterator;
import prefuse.data.util.FilterIterator;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class GraphDistanceFilter
extends GroupAction {
    protected int m_distance;
    protected String m_sources;
    protected Predicate m_groupP;
    protected BreadthFirstIterator m_bfs;

    public GraphDistanceFilter(String string) {
        this(string, 1);
    }

    public GraphDistanceFilter(String string, int n2) {
        this(string, Visualization.FOCUS_ITEMS, n2);
    }

    public GraphDistanceFilter(String string, String string2, int n2) {
        super(string);
        this.m_sources = string2;
        this.m_distance = n2;
        this.m_groupP = new InGroupPredicate(PrefuseLib.getGroupName(string, Graph.NODES));
        this.m_bfs = new BreadthFirstIterator();
    }

    public int getDistance() {
        return this.m_distance;
    }

    public void setDistance(int n2) {
        this.m_distance = n2;
    }

    public String getSources() {
        return this.m_sources;
    }

    public void setSources(String string) {
        this.m_sources = string;
    }

    @Override
    public void run(double d2) {
        VisualItem visualItem;
        Object object;
        boolean bl = VisibilityFilter.o;
        Iterator iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            object.setDOI(-1.7976931348623157E308);
            if (!bl) continue;
        }
        object = this.m_vis.getGroup(this.m_sources);
        FilterIterator filterIterator = new FilterIterator(object.tuples(), this.m_groupP);
        this.m_bfs.init(filterIterator, this.m_distance, 2);
        while (this.m_bfs.hasNext()) {
            visualItem = (VisualItem)this.m_bfs.next();
            int n2 = this.m_bfs.getDepth(visualItem);
            PrefuseLib.updateVisible(visualItem, true);
            visualItem.setDOI(-n2);
            visualItem.setExpanded(n2 < this.m_distance);
            if (!bl) continue;
        }
        iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            if (visualItem.getDOI() == -1.7976931348623157E308) {
                PrefuseLib.updateVisible(visualItem, false);
                visualItem.setExpanded(false);
            }
            if (!bl) continue;
        }
        if (AbstractExpression.b) {
            VisibilityFilter.o = !bl;
        }
    }

    public void reset() {
        this.m_bfs = new BreadthFirstIterator();
    }
}

