/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.logging.Logger;
import prefuse.action.layout.AxisLayout;
import prefuse.action.layout.Layout;
import prefuse.data.Schema;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.query.ObjectRangeModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;

public class AxisLabelLayout
extends Layout {
    public static final String FRAC;
    public static final String LABEL;
    public static final String VALUE;
    private AxisLayout n;
    private ValuedRangeModel o;
    private double p;
    private double q;
    private double r;
    private double s;
    private NumberFormat t = NumberFormat.getInstance();
    private int u;
    private boolean v = true;
    private int w = 0;
    private double x;
    private static final String[] z;

    public AxisLabelLayout(String string, int n2, ValuedRangeModel valuedRangeModel) {
        this(string, n2, valuedRangeModel, null);
    }

    public AxisLabelLayout(String string, int n2, ValuedRangeModel valuedRangeModel, Rectangle2D rectangle2D) {
        super(string);
        if (rectangle2D != null) {
            this.setLayoutBounds(rectangle2D);
        }
        this.o = valuedRangeModel;
        this.u = n2;
        this.x = 50.0;
    }

    public AxisLabelLayout(String string, AxisLayout axisLayout) {
        this(string, axisLayout, null, 50.0);
    }

    public AxisLabelLayout(String string, AxisLayout axisLayout, Rectangle2D rectangle2D) {
        this(string, axisLayout, rectangle2D, 50.0);
    }

    public AxisLabelLayout(String string, AxisLayout axisLayout, Rectangle2D rectangle2D, double d2) {
        super(string);
        if (rectangle2D != null) {
            this.setLayoutBounds(rectangle2D);
        }
        this.n = axisLayout;
        this.o = axisLayout.getRangeModel();
        this.u = axisLayout.getAxis();
        this.w = axisLayout.getScale();
        this.x = d2;
    }

    public NumberFormat getNumberFormat() {
        return this.t;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.t = numberFormat;
    }

    public double getSpacing() {
        return this.x;
    }

    public void setSpacing(double d2) {
        this.x = d2;
    }

    public int getScale() {
        return this.w;
    }

    public void setScale(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException(z[0] + n2);
        }
        this.w = n2;
    }

    public boolean isAscending() {
        return this.v;
    }

    public void setAscending(boolean bl) {
        this.v = bl;
    }

    public void setRangeModel(ValuedRangeModel valuedRangeModel) {
        this.o = valuedRangeModel;
    }

    @Override
    public void run(double d2) {
        VisualTable visualTable;
        block10: {
            int n2;
            block9: {
                n2 = Layout.m;
                if (this.o == null && this.n != null) {
                    this.o = this.n.getRangeModel();
                }
                if (this.o == null) {
                    Logger.getLogger(this.getClass().getName()).warning(z[1]);
                    return;
                }
                visualTable = this.getTable();
                Double d3 = (Double)visualTable.getClientProperty(FRAC);
                double d4 = d3 == null ? 1.0 : d3;
                this.r += d4 * (this.p - this.r);
                this.s += d4 * (this.q - this.s);
                if (!(this.o instanceof ObjectRangeModel)) break block9;
                this.p = this.o.getValue();
                this.q = this.p + (double)this.o.getExtent();
                this.ordinalLayout(visualTable);
                if (n2 == 0) break block10;
            }
            this.p = ((Number)this.o.getLowValue()).doubleValue();
            this.q = ((Number)this.o.getHighValue()).doubleValue();
            switch (this.w) {
                case 1: {
                    this.logLayout(visualTable);
                    if (n2 == 0) break;
                }
                case 2: {
                    this.sqrtLayout(visualTable);
                    if (n2 == 0) break;
                }
                default: {
                    this.linearLayout(visualTable);
                }
            }
        }
        this.garbageCollect(visualTable);
    }

    protected void linearLayout(VisualTable visualTable) {
        double d2;
        Object object;
        double d3;
        double d4;
        double d5;
        Rectangle2D rectangle2D;
        int n2;
        block9: {
            double d6;
            block8: {
                n2 = Layout.m;
                rectangle2D = this.getLayoutBounds();
                d5 = this.getBreadth(rectangle2D);
                d4 = this.q - this.p;
                d3 = this.s - this.r;
                d6 = 0.0;
                if (!(this.p >= 0.0)) break block8;
                d6 = Math.pow(10.0, Math.floor(MathLib.log10(this.p)));
                if (n2 == 0) break block9;
            }
            d6 = -Math.pow(10.0, 1.0 + Math.floor(MathLib.log10(-this.p)));
        }
        Iterator iterator = visualTable.tuples();
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            this.reset((VisualItem)object);
            d2 = object.getDouble(VALUE);
            double d7 = d4 == 0.0 ? 0.0 : (d2 - this.p) / d4 * d5;
            this.set((VisualItem)object, d7, rectangle2D);
            if (n2 == 0) continue;
        }
        object = visualTable.index(VALUE);
        d2 = this.getLinearStep(d4, d4 == 0.0 ? 0.0 : d5 / d4);
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        for (double d8 = d6; d8 <= this.q; d8 += d2) {
            double d9;
            VisualItem visualItem;
            double d10 = (d8 - this.p) / d4 * d5;
            if (d10 < -0.5 && n2 == 0) continue;
            int n3 = object.get(d8);
            if (n3 >= 0) {
                visualItem = visualTable.getItem(n3);
                visualItem.setVisible(true);
                visualItem.setEndVisible(true);
                if (n2 == 0) continue;
            }
            visualItem = visualTable.addItem();
            visualItem.set(LABEL, (Object)this.t.format(d8));
            visualItem.setDouble(VALUE, d8);
            double d11 = d9 = d3 == 0.0 ? 0.0 : (d8 - this.r) / d3;
            if (d9 <= 0.0 || d9 >= 1.0) {
                visualItem.setStartVisible(true);
            }
            this.set(visualItem, d9 * d5, rectangle2D);
            this.set(visualItem, d10, rectangle2D);
            if (n2 == 0) continue;
        }
    }

    protected void sqrtLayout(VisualTable visualTable) {
        double d2;
        Object object;
        int n2 = Layout.m;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d3 = this.getBreadth(rectangle2D);
        double d4 = this.q - this.p;
        double d5 = MathLib.safeSqrt(this.r);
        double d6 = MathLib.safeSqrt(this.s) - d5;
        double d7 = Math.pow(10.0, Math.floor(MathLib.safeLog10(this.p)));
        double d8 = MathLib.safeSqrt(this.p);
        double d9 = MathLib.safeSqrt(this.q) - d8;
        Iterator iterator = visualTable.tuples();
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            this.reset((VisualItem)object);
            d2 = object.getDouble(VALUE);
            double d10 = d4 == 0.0 ? 0.0 : (MathLib.safeSqrt(d2) - d8) / d9 * d3;
            this.set((VisualItem)object, d10, rectangle2D);
            if (n2 == 0) continue;
        }
        object = visualTable.index(VALUE);
        d2 = this.getLinearStep(d4, d3 / d4);
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        for (double d11 = d7; d11 <= this.q; d11 += d2) {
            double d12;
            VisualItem visualItem;
            double d13 = (MathLib.safeSqrt(d11) - d8) / d9 * d3;
            if (d13 < -0.5 && n2 == 0) continue;
            int n3 = object.get(d11);
            if (n3 >= 0) {
                visualItem = visualTable.getItem(n3);
                visualItem.setVisible(true);
                visualItem.setEndVisible(true);
                if (n2 == 0) continue;
            }
            visualItem = visualTable.addItem();
            visualItem.set(LABEL, (Object)this.t.format(d11));
            visualItem.setDouble(VALUE, d11);
            double d14 = d12 = d6 == 0.0 ? 0.0 : (MathLib.safeSqrt(d11) - d5) / d6;
            if (d12 <= 0.0 || d12 >= 1.0) {
                visualItem.setStartVisible(true);
            }
            this.set(visualItem, d12 * d3, rectangle2D);
            this.set(visualItem, d13, rectangle2D);
            if (n2 == 0) continue;
        }
        if (AbstractExpression.b) {
            Layout.m = ++n2;
        }
    }

    protected void logLayout(VisualTable visualTable) {
        int n2 = Layout.m;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d2 = this.getBreadth(rectangle2D);
        visualTable.clear();
        double d3 = MathLib.safeLog10(this.p);
        double d4 = MathLib.safeLog10(this.q);
        double d5 = d4 - d3;
        double d6 = MathLib.log10(d4 - d3);
        int n3 = (int)Math.floor(d6);
        int n4 = (int)Math.floor(d3);
        int n5 = (int)Math.ceil(d4);
        double d7 = Math.pow(10.0, n4);
        double d8 = Math.pow(10.0, n5);
        double d9 = d7 * Math.pow(10.0, n3);
        double d10 = d7;
        double d11 = 0.0;
        while (d10 <= d8) {
            double d12 = MathLib.safeLog10(d10);
            if (d11 != 0.0 && Math.abs(d12 - (double)Math.round(d12)) < 1.0E-4) {
                d11 = 0.0;
                d9 = 10.0 * d9;
            }
            if (!((d12 = (d12 - d3) / d5 * d2) < -0.5)) {
                VisualItem visualItem = visualTable.addItem();
                this.set(visualItem, d12, rectangle2D);
                String string = d11 == 0.0 ? this.t.format(d10) : null;
                visualItem.set(LABEL, (Object)string);
                visualItem.setDouble(VALUE, d10);
            }
            d10 += d9;
            d11 += 1.0;
            if (n2 == 0) continue;
        }
    }

    protected double getBreadth(Rectangle2D rectangle2D) {
        switch (this.u) {
            case 0: {
                return rectangle2D.getWidth();
            }
        }
        return rectangle2D.getHeight();
    }

    protected double adjust(double d2) {
        switch (this.w) {
            case 1: {
                return Math.pow(10.0, d2);
            }
            case 2: {
                return d2 * d2;
            }
        }
        return d2;
    }

    protected double getLinearStep(double d2, double d3) {
        double d4;
        block5: {
            double d5;
            block9: {
                int n2;
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                n2 = Layout.m;
                                double d6 = Math.log(d2) / Math.log(10.0);
                                d4 = Math.pow(10.0, Math.floor(d6));
                                d5 = d4 * d3 / this.x;
                                if (!(d5 > 20.0)) break block4;
                                d4 /= 20.0;
                                if (n2 == 0) break block5;
                            }
                            if (!(d5 > 10.0)) break block6;
                            d4 /= 10.0;
                            if (n2 == 0) break block5;
                        }
                        if (!(d5 > 5.0)) break block7;
                        d4 /= 5.0;
                        if (n2 == 0) break block5;
                    }
                    if (!(d5 > 4.0)) break block8;
                    d4 /= 4.0;
                    if (n2 == 0) break block5;
                }
                if (!(d5 > 2.0)) break block9;
                d4 /= 2.0;
                if (n2 == 0) break block5;
            }
            if (d5 < 1.0) {
                d4 *= 2.0;
            }
        }
        return d4;
    }

    protected void ordinalLayout(VisualTable visualTable) {
        Object object;
        int n2 = Layout.m;
        ObjectRangeModel objectRangeModel = (ObjectRangeModel)this.o;
        double d2 = this.q - this.p;
        double d3 = this.s - this.r;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d4 = this.getBreadth(rectangle2D);
        double d5 = d4 / d2;
        int n3 = this.getOrdinalStep(d2, d5);
        if (n3 <= 0) {
            n3 = 1;
        }
        Iterator iterator = visualTable.tuples();
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            this.reset((VisualItem)object);
            double d6 = object.getDouble(VALUE);
            double d7 = d2 == 0.0 ? 0.5 * d4 : (d6 - this.p) / d2 * d4;
            this.set((VisualItem)object, d7, rectangle2D);
            if (n2 == 0) continue;
        }
        object = visualTable.index(VALUE);
        int n4 = (int)this.p;
        while ((double)n4 <= this.q) {
            block8: {
                double d8;
                VisualItem visualItem;
                block7: {
                    int n5 = object.get((double)n4);
                    if (n5 < 0) break block7;
                    visualItem = visualTable.getItem(n5);
                    visualItem.set(VisualItem.LABEL, (Object)objectRangeModel.getObject(n4).toString());
                    visualItem.setVisible(true);
                    visualItem.setEndVisible(true);
                    if (n2 == 0) break block8;
                }
                visualItem = visualTable.addItem();
                visualItem.set(VisualItem.LABEL, (Object)objectRangeModel.getObject(n4).toString());
                visualItem.setDouble(VisualItem.VALUE, (double)n4);
                double d9 = d8 = d3 == 0.0 ? 0.5 : ((double)n4 - this.r) / d3;
                if (d8 <= 0.0 || d8 >= 1.0) {
                    visualItem.setStartVisible(true);
                }
                this.set(visualItem, d8 * d4, rectangle2D);
                this.set(visualItem, ((double)n4 - this.p) * d4 / d2, rectangle2D);
            }
            n4 += n3;
            if (n2 == 0) continue;
        }
    }

    protected int getOrdinalStep(double d2, double d3) {
        return d3 >= this.x ? 1 : (int)Math.ceil(this.x / d3);
    }

    protected void set(VisualItem visualItem, double d2, Rectangle2D rectangle2D) {
        switch (this.u) {
            case 0: {
                d2 = this.v ? d2 + rectangle2D.getMinX() : rectangle2D.getMaxX() - d2;
                PrefuseLib.updateDouble(visualItem, VisualItem.X, d2);
                PrefuseLib.updateDouble(visualItem, VisualItem.Y, rectangle2D.getMinY());
                PrefuseLib.updateDouble(visualItem, VisualItem.X2, d2);
                PrefuseLib.updateDouble(visualItem, VisualItem.Y2, rectangle2D.getMaxY());
                if (Layout.m == 0) break;
            }
            case 1: {
                d2 = this.v ? rectangle2D.getMaxY() - d2 - 1.0 : d2 + rectangle2D.getMinY();
                PrefuseLib.updateDouble(visualItem, VisualItem.X, rectangle2D.getMinX());
                PrefuseLib.updateDouble(visualItem, VisualItem.Y, d2);
                PrefuseLib.updateDouble(visualItem, VisualItem.X2, rectangle2D.getMaxX());
                PrefuseLib.updateDouble(visualItem, VisualItem.Y2, d2);
            }
        }
    }

    protected void reset(VisualItem visualItem) {
        visualItem.setVisible(false);
        visualItem.setEndVisible(false);
        visualItem.setStartStrokeColor(visualItem.getStrokeColor());
        visualItem.revertToDefault(VisualItem.STROKECOLOR);
        visualItem.revertToDefault(VisualItem.ENDSTROKECOLOR);
        visualItem.setStartTextColor(visualItem.getTextColor());
        visualItem.revertToDefault(VisualItem.TEXTCOLOR);
        visualItem.revertToDefault(VisualItem.ENDTEXTCOLOR);
        visualItem.setStartFillColor(visualItem.getFillColor());
        visualItem.revertToDefault(VisualItem.FILLCOLOR);
        visualItem.revertToDefault(VisualItem.ENDFILLCOLOR);
    }

    protected void garbageCollect(VisualTable visualTable) {
        int n2 = Layout.m;
        Iterator iterator = visualTable.tuples();
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            if (!visualItem.isStartVisible() && !visualItem.isEndVisible()) {
                visualTable.removeTuple(visualItem);
            }
            if (n2 == 0) continue;
        }
    }

    protected VisualTable getTable() {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        if (tupleSet == null) {
            Schema schema = PrefuseLib.getAxisLabelSchema();
            VisualTable visualTable = this.m_vis.addTable(this.m_group, schema);
            visualTable.index(VALUE);
            return visualTable;
        }
        if (tupleSet instanceof VisualTable) {
            return (VisualTable)tupleSet;
        }
        throw new IllegalStateException(z[2]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0013\u007f_t";
        int n3 = 2;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 117;
                                break;
                            }
                            case 1: {
                                n9 = 13;
                                break;
                            }
                            case 2: {
                                n9 = 62;
                                break;
                            }
                            case 3: {
                                n9 = 23;
                                break;
                            }
                            default: {
                                n9 = 82;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 2: {
                    FRAC = string.intern();
                    string2 = "*a_u7\u0019";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    LABEL = string.intern();
                    string2 = "*{_{'\u0010";
                    n3 = 4;
                    continue block13;
                }
                case 4: {
                    VALUE = string.intern();
                    string2 = " cLr1\u001ajP~(\u0010i\u001ed1\u0014a[7&\f}[-r";
                    n3 = -1;
                    continue block13;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "4uWdr\u0019l\\r>\u0006-S~!\u0006dPpr\u0014-Lv<\u0012h\u001ez=\u0011hR9";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "2\u007fQb\"UlRe7\u0014iG77\rdMc!Y-Px&Uo[~<\u0012-Kd7\u0011-Xx Ua_u7\u0019~";
                    n3 = 1;
                    continue block13;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

