/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;
import prefuse.data.query.NumberRangeModel;
import prefuse.data.query.ObjectRangeModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.MathLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;

public class AxisLayout
extends Layout {
    private String n;
    private int o = 0;
    private int p = 0;
    private int q = -1;
    private boolean r = false;
    private ValuedRangeModel s = null;
    private Predicate t = null;
    private double u;
    private double v;
    private double[] w = new double[2];
    private static final String[] z;

    public AxisLayout(String string, String string2) {
        super(string);
        this.n = string2;
    }

    public AxisLayout(String string, String string2, int n2) {
        this(string, string2);
        this.setAxis(n2);
    }

    public AxisLayout(String string, String string2, int n2, Predicate predicate) {
        this(string, string2, n2);
        this.setFilter(predicate);
    }

    public void setDataField(String string) {
        this.n = string;
        if (!this.r) {
            this.s = null;
        }
    }

    public String getDataField() {
        return this.n;
    }

    public void setRangeModel(ValuedRangeModel valuedRangeModel) {
        this.s = valuedRangeModel;
        this.r = valuedRangeModel != null;
    }

    public ValuedRangeModel getRangeModel() {
        return this.s;
    }

    public void setFilter(Predicate predicate) {
        this.t = predicate;
    }

    public Predicate getFilter() {
        return this.t;
    }

    public int getScale() {
        return this.o;
    }

    public void setScale(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException(z[1] + n2);
        }
        this.o = n2;
    }

    public int getAxis() {
        return this.p;
    }

    public void setAxis(int n2) {
        if (n2 < 0 || n2 >= 2) {
            throw new IllegalArgumentException(z[2] + n2);
        }
        this.p = n2;
    }

    public int getDataType() {
        return this.q;
    }

    public void setDataType(int n2) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException(z[0] + n2);
        }
        this.q = n2;
    }

    @Override
    public void run(double d2) {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        this.a();
        switch (this.getDataType(tupleSet)) {
            case 2: {
                this.numericalLayout(tupleSet);
                if (Layout.m == 0) break;
            }
            default: {
                this.ordinalLayout(tupleSet);
            }
        }
    }

    protected int getDataType(TupleSet tupleSet) {
        block5: {
            boolean bl;
            block7: {
                block6: {
                    int n2 = Layout.m;
                    if (this.q != -1) break block5;
                    bl = true;
                    if (!(tupleSet instanceof Table)) break block6;
                    bl = ((Table)tupleSet).canGetDouble(this.n);
                    if (n2 == 0) break block7;
                }
                Iterator iterator = tupleSet.tuples();
                while (iterator.hasNext()) {
                    if (((Tuple)iterator.next()).canGetDouble(this.n)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                return 2;
            }
            return 1;
        }
        return this.q;
    }

    private void a() {
        block3: {
            Rectangle2D rectangle2D;
            block2: {
                rectangle2D = this.getLayoutBounds();
                if (this.p != 0) break block2;
                this.u = rectangle2D.getMinX();
                this.v = rectangle2D.getMaxX() - this.u;
                if (Layout.m == 0) break block3;
            }
            this.u = rectangle2D.getMaxY();
            this.v = rectangle2D.getMinY() - this.u;
        }
    }

    protected void set(VisualItem visualItem, double d2) {
        block3: {
            double d3;
            block2: {
                d3 = this.u + d2 * this.v;
                if (this.p != 0) break block2;
                this.setX(visualItem, null, d3);
                if (Layout.m == 0) break block3;
            }
            this.setY(visualItem, null, d3);
        }
    }

    protected void numericalLayout(TupleSet tupleSet) {
        double d2;
        int n2;
        block8: {
            block5: {
                block7: {
                    double d3;
                    block6: {
                        n2 = Layout.m;
                        if (this.r) break block5;
                        this.w[0] = DataLib.min(tupleSet, this.n).getDouble(this.n);
                        this.w[1] = DataLib.max(tupleSet, this.n).getDouble(this.n);
                        d3 = this.w[0];
                        d2 = this.w[1];
                        if (this.s != null) break block6;
                        this.s = new NumberRangeModel(d3, d2, d3, d2);
                        if (n2 == 0) break block7;
                    }
                    ((NumberRangeModel)this.s).setValueRange(d3, d2, d3, d2);
                }
                if (n2 == 0) break block8;
            }
            this.w[0] = ((Number)this.s.getLowValue()).doubleValue();
            this.w[1] = ((Number)this.s.getHighValue()).doubleValue();
        }
        Iterator iterator = this.m_vis.items(this.m_group, this.t);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            d2 = visualItem.getDouble(this.n);
            double d4 = MathLib.interp(this.o, d2, this.w);
            this.set(visualItem, d4);
            if (n2 == 0) continue;
        }
    }

    protected void ordinalLayout(TupleSet tupleSet) {
        Object[] objectArray;
        int n2;
        block3: {
            block4: {
                n2 = Layout.m;
                if (this.r) break block3;
                objectArray = DataLib.ordinalArray(tupleSet, this.n);
                if (this.s != null) break block4;
                this.s = new ObjectRangeModel(objectArray);
                if (n2 == 0) break block3;
            }
            ((ObjectRangeModel)this.s).setValueRange(objectArray);
        }
        objectArray = (Object[])this.s;
        int n3 = objectArray.getValue();
        int n4 = n3 + objectArray.getExtent();
        double d2 = n4 - n3;
        Iterator iterator = this.m_vis.items(this.m_group, this.t);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            int n5 = objectArray.getIndex(visualItem.get(this.n)) - n3;
            this.set(visualItem, d2 > 0.0 ? (double)n5 / d2 : 0.5);
            if (n2 == 0) continue;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "S2<\u001e\u0007i; \u0012\u001ec8n\u001f\u0005r=n\u000f\u001dv9n\r\u0005j)+AD";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 6;
                                break;
                            }
                            case 1: {
                                n9 = 92;
                                break;
                            }
                            case 2: {
                                n9 = 78;
                                break;
                            }
                            case 3: {
                                n9 = 123;
                                break;
                            }
                            default: {
                                n9 = 100;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "S2<\u001e\u0007i; \u0012\u001ec8n\b\u0007g0+[\u0012g0;\u001e^&";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "S2<\u001e\u0007i; \u0012\u001ec8n\u001a\u001co/n\r\u0005j)+AD";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

