/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Node;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.VisualItem;

public class GridLayout
extends Layout {
    protected int rows;
    protected int cols;
    protected boolean analyze = false;

    public GridLayout(String string) {
        super(string);
        this.analyze = true;
    }

    public GridLayout(String string, int n2, int n3) {
        super(string);
        this.rows = n2;
        this.cols = n3;
        this.analyze = false;
    }

    @Override
    public void run(double d2) {
        Object object;
        int n2 = Layout.m;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d3 = rectangle2D.getMinX();
        double d4 = rectangle2D.getMinY();
        double d5 = rectangle2D.getWidth();
        double d6 = rectangle2D.getHeight();
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        int n3 = this.rows;
        Object object2 = this.cols;
        if (this.analyze) {
            object = GridLayout.analyzeGraphGrid(tupleSet);
            n3 = object[0];
            object2 = object[1];
        }
        object = tupleSet.tuples();
        for (int i2 = 0; object.hasNext() && i2 < n3 * object2; ++i2) {
            VisualItem visualItem = (VisualItem)object.next();
            visualItem.setVisible(true);
            double d7 = d3 + d5 * ((double)(i2 % object2) / (double)(object2 - 1));
            double d8 = d4 + d6 * ((double)(i2 / object2) / (double)(n3 - 1));
            this.setX(visualItem, null, d7);
            this.setY(visualItem, null, d8);
            if (n2 == 0) continue;
        }
        while (object.hasNext()) {
            VisualItem visualItem = (VisualItem)object.next();
            visualItem.setVisible(false);
            if (n2 == 0) continue;
        }
    }

    public static int[] analyzeGraphGrid(TupleSet tupleSet) {
        Node node;
        int n2 = Layout.m;
        Iterator iterator = tupleSet.tuples();
        iterator.next();
        int n3 = 2;
        while (iterator.hasNext() && ((node = (Node)iterator.next()).getDegree() != 2 || n2 != 0)) {
            ++n3;
            if (n2 == 0) continue;
        }
        int n4 = tupleSet.getTupleCount() / n3;
        return new int[]{n4, n3};
    }

    public int getNumCols() {
        return this.cols;
    }

    public void setNumCols(int n2) {
        this.cols = n2;
    }

    public int getNumRows() {
        return this.rows;
    }

    public void setNumRows(int n2) {
        this.rows = n2;
    }
}

