/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.PrefuseLib;
import prefuse.util.force.DragForce;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.NBodyForce;
import prefuse.util.force.SpringForce;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class ForceDirectedLayout
extends Layout {
    private ForceSimulator n;
    private long o = -1L;
    private long p = 50L;
    private boolean q;
    private int r = 100;
    private boolean s;
    protected transient VisualItem referrer;
    protected String m_nodeGroup;
    protected String m_edgeGroup;
    public static final String FORCEITEM;
    public static final Schema FORCEITEM_SCHEMA;
    private static final String z;

    public ForceDirectedLayout(String string) {
        this(string, false, false);
    }

    public ForceDirectedLayout(String string, boolean bl) {
        this(string, bl, false);
    }

    public ForceDirectedLayout(String string, boolean bl, boolean bl2) {
        super(string);
        this.m_nodeGroup = PrefuseLib.getGroupName(string, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(string, Graph.EDGES);
        this.s = bl;
        this.q = bl2;
        this.n = new ForceSimulator();
        this.n.addForce(new NBodyForce());
        this.n.addForce(new SpringForce());
        this.n.addForce(new DragForce());
    }

    public ForceDirectedLayout(String string, ForceSimulator forceSimulator, boolean bl) {
        this(string, forceSimulator, bl, false);
    }

    public ForceDirectedLayout(String string, ForceSimulator forceSimulator, boolean bl, boolean bl2) {
        super(string);
        this.m_nodeGroup = PrefuseLib.getGroupName(string, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(string, Graph.EDGES);
        this.s = bl;
        this.q = bl2;
        this.n = forceSimulator;
    }

    public long getMaxTimeStep() {
        return this.p;
    }

    public void setMaxTimeStep(long l2) {
        this.p = l2;
    }

    public ForceSimulator getForceSimulator() {
        return this.n;
    }

    public void setForceSimulator(ForceSimulator forceSimulator) {
        this.n = forceSimulator;
    }

    public int getIterations() {
        return this.r;
    }

    public void setIterations(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException(z);
        }
        this.r = n2;
    }

    public void setDataGroups(String string, String string2) {
        this.m_nodeGroup = string;
        this.m_edgeGroup = string2;
    }

    @Override
    public void run(double d2) {
        block8: {
            long l2;
            block7: {
                int n2 = TreeLayout.n;
                if (!this.q) break block7;
                Point2D point2D = this.getLayoutAnchor();
                Iterator iterator = this.m_vis.visibleItems(this.m_nodeGroup);
                while (iterator.hasNext()) {
                    NodeItem nodeItem = (NodeItem)iterator.next();
                    nodeItem.setX(point2D.getX());
                    nodeItem.setY(point2D.getY());
                    if (n2 == 0) continue;
                }
                this.n.clear();
                l2 = 1000L;
                this.initSimulator(this.n);
                for (int i2 = 0; i2 < this.r; ++i2) {
                    l2 = (long)((double)l2 * (1.0 - (double)i2 / (double)this.r));
                    long l3 = l2 + 50L;
                    this.n.runSimulator(l3);
                    if (n2 == 0) continue;
                }
                this.a();
                if (n2 == 0) break block8;
            }
            if (this.o == -1L) {
                this.o = System.currentTimeMillis() - 20L;
            }
            long l4 = System.currentTimeMillis();
            l2 = Math.min(this.p, l4 - this.o);
            this.o = l4;
            this.n.clear();
            this.initSimulator(this.n);
            this.n.runSimulator(l2);
            this.a();
        }
        if (d2 == 1.0) {
            this.reset();
        }
    }

    private void a() {
        int n2 = TreeLayout.n;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (rectangle2D != null) {
            d2 = rectangle2D.getMinX();
            d4 = rectangle2D.getMinY();
            d3 = rectangle2D.getMaxX();
            d5 = rectangle2D.getMaxY();
        }
        Iterator iterator = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            ForceItem forceItem = (ForceItem)visualItem.get(FORCEITEM);
            if (visualItem.isFixed()) {
                forceItem.force[0] = 0.0f;
                forceItem.force[1] = 0.0f;
                forceItem.velocity[0] = 0.0f;
                forceItem.velocity[1] = 0.0f;
                if (!Double.isNaN(visualItem.getX())) continue;
                this.setX(visualItem, this.referrer, 0.0);
                this.setY(visualItem, this.referrer, 0.0);
                if (n2 == 0) continue;
            }
            double d6 = forceItem.location[0];
            double d7 = forceItem.location[1];
            if (this.s && rectangle2D != null) {
                Rectangle2D rectangle2D2 = visualItem.getBounds();
                double d8 = rectangle2D2.getWidth() / 2.0;
                double d9 = rectangle2D2.getHeight() / 2.0;
                if (d6 + d8 > d3) {
                    d6 = d3 - d8;
                }
                if (d6 - d8 < d2) {
                    d6 = d2 + d8;
                }
                if (d7 + d9 > d5) {
                    d7 = d5 - d9;
                }
                if (d7 - d9 < d4) {
                    d7 = d4 + d9;
                }
            }
            this.setX(visualItem, this.referrer, d6);
            this.setY(visualItem, this.referrer, d7);
            if (n2 == 0) continue;
        }
    }

    public void reset() {
        int n2 = TreeLayout.n;
        Iterator iterator = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            ForceItem forceItem = (ForceItem)visualItem.get(FORCEITEM);
            if (forceItem != null) {
                forceItem.location[0] = (float)visualItem.getEndX();
                forceItem.location[1] = (float)visualItem.getEndY();
                forceItem.force[1] = 0.0f;
                forceItem.force[0] = 0.0f;
                forceItem.velocity[1] = 0.0f;
                forceItem.velocity[0] = 0.0f;
            }
            if (n2 == 0) continue;
        }
        this.o = -1L;
    }

    protected void initSimulator(ForceSimulator forceSimulator) {
        Object object;
        VisualItem visualItem;
        int n2 = TreeLayout.n;
        TupleSet tupleSet = this.m_vis.getGroup(this.m_nodeGroup);
        if (tupleSet == null) {
            return;
        }
        try {
            tupleSet.addColumns(FORCEITEM_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        float f2 = this.referrer == null ? 0.0f : (float)this.referrer.getX();
        float f3 = this.referrer == null ? 0.0f : (float)this.referrer.getY();
        f2 = Float.isNaN(f2) ? 0.0f : f2;
        f3 = Float.isNaN(f3) ? 0.0f : f3;
        Iterator iterator = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            object = (ForceItem)visualItem.get(FORCEITEM);
            ((ForceItem)object).mass = this.getMassValue(visualItem);
            double d2 = visualItem.getEndX();
            double d3 = visualItem.getEndY();
            ((ForceItem)object).location[0] = Double.isNaN(d2) ? f2 : (float)d2;
            ((ForceItem)object).location[1] = Double.isNaN(d3) ? f3 : (float)d3;
            forceSimulator.addItem((ForceItem)object);
            if (n2 == 0) continue;
        }
        if (this.m_edgeGroup != null) {
            iterator = this.m_vis.visibleItems(this.m_edgeGroup);
            while (iterator.hasNext()) {
                visualItem = (EdgeItem)iterator.next();
                object = visualItem.getSourceItem();
                ForceItem forceItem = (ForceItem)object.get(FORCEITEM);
                NodeItem nodeItem = visualItem.getTargetItem();
                ForceItem forceItem2 = (ForceItem)nodeItem.get(FORCEITEM);
                float f4 = this.getSpringCoefficient((EdgeItem)visualItem);
                float f5 = this.getSpringLength((EdgeItem)visualItem);
                forceSimulator.addSpring(forceItem, forceItem2, f4 >= 0.0f ? f4 : -1.0f, f5 >= 0.0f ? f5 : -1.0f);
                if (n2 == 0) continue;
            }
        }
    }

    protected float getMassValue(VisualItem visualItem) {
        return 1.0f;
    }

    protected float getSpringLength(EdgeItem edgeItem) {
        return -1.0f;
    }

    protected float getSpringCoefficient(EdgeItem edgeItem) {
        return -1.0f;
    }

    public VisualItem getReferrer() {
        return this.referrer;
    }

    public void setReferrer(VisualItem visualItem) {
        this.referrer = visualItem;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2 = ".'DlK\u0013:NpYG>Tm^G1D>KG#NmC\u0013:W{\n\t&L|O\u0015r";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 103;
                                break;
                            }
                            case 1: {
                                n8 = 83;
                                break;
                            }
                            case 2: {
                                n8 = 33;
                                break;
                            }
                            case 3: {
                                n8 = 30;
                                break;
                            }
                            default: {
                                n8 = 42;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    z = string.intern();
                    string2 = "85NlI\u0002\u001aU{G";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        FORCEITEM = string.intern();
        FORCEITEM_SCHEMA = new Schema();
        FORCEITEM_SCHEMA.addColumn(FORCEITEM, ForceItem.class, new ForceItem());
    }
}

