/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Random;
import prefuse.action.layout.Layout;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.tuple.TupleSet;
import prefuse.util.PrefuseLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class FruchtermanReingoldLayout
extends Layout {
    private double n;
    private double o;
    private int p = 700;
    protected String m_nodeGroup;
    protected String m_edgeGroup;
    protected int m_fidx;
    public static final String PARAMS;
    public static final Schema PARAMS_SCHEMA;
    private static final String[] z;

    public FruchtermanReingoldLayout(String string) {
        this(string, 700);
    }

    public FruchtermanReingoldLayout(String string, int n2) {
        super(string);
        this.m_nodeGroup = PrefuseLib.getGroupName(string, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(string, Graph.EDGES);
        this.p = n2;
    }

    public int getMaxIterations() {
        return this.p;
    }

    public void setMaxIterations(int n2) {
        this.p = n2;
    }

    @Override
    public void run(double d2) {
        int n2 = TreeLayout.n;
        Graph graph = (Graph)this.m_vis.getGroup(this.m_group);
        Rectangle2D rectangle2D = super.getLayoutBounds();
        this.a(graph, rectangle2D);
        for (int i2 = 0; i2 < this.p; ++i2) {
            VisualItem visualItem;
            Iterator iterator = graph.nodes();
            while (iterator.hasNext()) {
                visualItem = (NodeItem)iterator.next();
                if (visualItem.isFixed()) continue;
                this.calcRepulsion(graph, (NodeItem)visualItem);
                if (n2 == 0) continue;
            }
            iterator = graph.edges();
            while (iterator.hasNext()) {
                visualItem = (EdgeItem)iterator.next();
                this.calcAttraction((EdgeItem)visualItem);
                if (n2 == 0) continue;
            }
            iterator = graph.nodes();
            while (iterator.hasNext()) {
                visualItem = (NodeItem)iterator.next();
                if (visualItem.isFixed()) continue;
                this.calcPositions((NodeItem)visualItem, rectangle2D);
                if (n2 == 0) continue;
            }
            this.a(i2);
            if (n2 == 0) continue;
        }
        this.a(graph);
    }

    private void a(Graph graph, Rectangle2D rectangle2D) {
        int n2 = TreeLayout.n;
        this.initSchema(graph.getNodes());
        this.o = rectangle2D.getWidth() / 10.0;
        this.n = 0.75 * Math.sqrt(rectangle2D.getHeight() * rectangle2D.getWidth() / (double)graph.getNodeCount());
        Iterator iterator = graph.nodes();
        Random random = new Random(42L);
        double d2 = 0.1 * rectangle2D.getWidth() / 2.0;
        double d3 = 0.1 * rectangle2D.getHeight() / 2.0;
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            Params params = this.a(nodeItem);
            params.a[0] = rectangle2D.getCenterX() + random.nextDouble() * d2;
            params.a[1] = rectangle2D.getCenterY() + random.nextDouble() * d3;
            if (n2 == 0) continue;
        }
    }

    private void a(Graph graph) {
        int n2 = TreeLayout.n;
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            Params params = this.a(nodeItem);
            this.setX(nodeItem, null, params.a[0]);
            this.setY(nodeItem, null, params.a[1]);
            if (n2 == 0) continue;
        }
    }

    public void calcPositions(NodeItem nodeItem, Rectangle2D rectangle2D) {
        double d2;
        double d3;
        block12: {
            double d4;
            block11: {
                Params params;
                int n2;
                block10: {
                    block9: {
                        n2 = TreeLayout.n;
                        params = this.a(nodeItem);
                        double d5 = Math.max(1.0E-6, Math.sqrt(params.b[0] * params.b[0] + params.b[1] * params.b[1]));
                        double d6 = params.b[0] / d5 * Math.min(d5, this.o);
                        if (Double.isNaN(d6)) {
                            System.err.println(z[1]);
                        }
                        double d7 = params.b[1] / d5 * Math.min(d5, this.o);
                        params.a[0] = params.a[0] + d6;
                        params.a[1] = params.a[1] + d7;
                        d4 = rectangle2D.getWidth() / 50.0;
                        d3 = params.a[0];
                        if (!(d3 < rectangle2D.getMinX() + d4)) break block9;
                        d3 = rectangle2D.getMinX() + d4 + Math.random() * d4 * 2.0;
                        if (n2 == 0) break block10;
                        boolean bl = AbstractExpression.b = !AbstractExpression.b;
                    }
                    if (d3 > rectangle2D.getMaxX() - d4) {
                        d3 = rectangle2D.getMaxX() - d4 - Math.random() * d4 * 2.0;
                    }
                }
                if (!((d2 = params.a[1]) < rectangle2D.getMinY() + d4)) break block11;
                d2 = rectangle2D.getMinY() + d4 + Math.random() * d4 * 2.0;
                if (n2 == 0) break block12;
            }
            if (d2 > rectangle2D.getMaxY() - d4) {
                d2 = rectangle2D.getMaxY() - d4 - Math.random() * d4 * 2.0;
            }
        }
        params.a[0] = d3;
        params.a[1] = d2;
    }

    public void calcAttraction(EdgeItem edgeItem) {
        int n2 = TreeLayout.n;
        NodeItem nodeItem = edgeItem.getSourceItem();
        Params params = this.a(nodeItem);
        NodeItem nodeItem2 = edgeItem.getTargetItem();
        Params params2 = this.a(nodeItem2);
        double d2 = params.a[0] - params2.a[0];
        double d3 = params.a[1] - params2.a[1];
        double d4 = Math.max(1.0E-6, Math.sqrt(d2 * d2 + d3 * d3));
        double d5 = d4 * d4 / this.n;
        if (Double.isNaN(d5)) {
            System.err.println(z[0]);
        }
        double d6 = d2 / d4 * d5;
        double d7 = d3 / d4 * d5;
        params.b[0] = params.b[0] - d6;
        params.b[1] = params.b[1] - d7;
        params2.b[0] = params2.b[0] + d6;
        params2.b[1] = params2.b[1] + d7;
        if (AbstractExpression.b) {
            TreeLayout.n = ++n2;
        }
    }

    public void calcRepulsion(Graph graph, NodeItem nodeItem) {
        int n2 = TreeLayout.n;
        Params params = this.a(nodeItem);
        params.b[0] = 0.0;
        params.b[1] = 0.0;
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            Params params2 = this.a(nodeItem2);
            if (nodeItem2.isFixed()) continue;
            if (nodeItem != nodeItem2) {
                double d2 = params.a[0] - params2.a[0];
                double d3 = params.a[1] - params2.a[1];
                double d4 = Math.max(1.0E-6, Math.sqrt(d2 * d2 + d3 * d3));
                double d5 = this.n * this.n / d4;
                if (Double.isNaN(d5)) {
                    System.err.println(z[0]);
                }
                params.b[0] = params.b[0] + d2 / d4 * d5;
                params.b[1] = params.b[1] + d3 / d4 * d5;
            }
            if (n2 == 0) continue;
        }
    }

    private void a(int n2) {
        this.o *= 1.0 - (double)n2 / (double)this.p;
    }

    protected void initSchema(TupleSet tupleSet) {
        try {
            tupleSet.addColumns(PARAMS_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Params a(VisualItem visualItem) {
        Params params = (Params)visualItem.get(PARAMS);
        if (params == null) {
            params = new Params();
            visualItem.set(PARAMS, (Object)params);
        }
        return params;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u001bd7$Z,v #T%l\u00174P*e*=]\u0014c70T7";
        int n3 = 1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 68;
                                break;
                            }
                            case 1: {
                                n9 = 2;
                                break;
                            }
                            case 2: {
                                n9 = 69;
                                break;
                            }
                            case 3: {
                                n9 = 81;
                                break;
                            }
                            default: {
                                n9 = 57;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 1: {
                    PARAMS = string.intern();
                    string2 = "\tc19\\)c18Z%ne4K6m7\u007f\u0017j";
                    n3 = -1;
                    continue block10;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\tc19\\)c18Z%ne4K6m7\u007f\u0017j\"m2X(a\u0015>J-v,>W78=\u0015P7rl";
                    n3 = 0;
                    continue block10;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        PARAMS_SCHEMA = new Schema();
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class);
    }

    public static class Params
    implements Cloneable {
        double[] a = new double[2];
        double[] b = new double[2];
    }
}

