/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.action.layout.graph.a;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ArrayLib;
import prefuse.visual.NodeItem;

public class RadialTreeLayout
extends TreeLayout {
    public static final int DEFAULT_RADIUS = 50;
    protected int m_maxDepth = 0;
    protected double m_radiusInc = 50.0;
    protected double m_theta1 = 0.0;
    protected double m_theta2 = this.m_theta1 + Math.PI * 2;
    protected boolean m_setTheta = false;
    protected boolean m_autoScale = true;
    protected Point2D m_origin;
    protected NodeItem m_prevRoot = null;
    public static final String PARAMS;
    public static final Schema PARAMS_SCHEMA;

    public RadialTreeLayout(String string) {
        super(string);
    }

    public RadialTreeLayout(String string, int n2) {
        this(string);
        this.m_radiusInc = n2;
        this.m_autoScale = false;
    }

    public double getRadiusIncrement() {
        return this.m_radiusInc;
    }

    public void setRadiusIncrement(double d2) {
        this.m_radiusInc = d2;
    }

    public boolean getAutoScale() {
        return this.m_autoScale;
    }

    public void setAutoScale(boolean bl) {
        this.m_autoScale = bl;
    }

    public void setAngularBounds(double d2, double d3) {
        this.m_theta1 = d2;
        this.m_theta2 = d2 + d3;
        this.m_setTheta = true;
    }

    @Override
    public void run(double d2) {
        Graph graph = (Graph)this.m_vis.getGroup(this.m_group);
        this.initSchema(graph.getNodes());
        this.m_origin = this.getLayoutAnchor();
        NodeItem nodeItem = this.getLayoutRoot();
        Params params = (Params)nodeItem.get(PARAMS);
        graph.getSpanningTree(nodeItem);
        this.m_maxDepth = 0;
        this.a(nodeItem, 0);
        if (this.m_autoScale) {
            this.setScale(this.getLayoutBounds());
        }
        if (!this.m_setTheta) {
            this.a(nodeItem);
        }
        if (this.m_maxDepth > 0) {
            this.layout(nodeItem, this.m_radiusInc, this.m_theta1, this.m_theta2);
        }
        this.setX(nodeItem, null, this.m_origin.getX());
        this.setY(nodeItem, null, this.m_origin.getY());
        params.b = this.m_theta2 - this.m_theta1;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_prevRoot = null;
    }

    protected void setScale(Rectangle2D rectangle2D) {
        double d2 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
        if (this.m_maxDepth > 0) {
            this.m_radiusInc = (d2 - 30.0) / (double)this.m_maxDepth;
        }
    }

    private void a(NodeItem nodeItem) {
        Node node;
        NodeItem nodeItem2;
        int n2 = TreeLayout.n;
        if (this.m_prevRoot == null || !this.m_prevRoot.isValid() || nodeItem == this.m_prevRoot) {
            this.m_prevRoot = nodeItem;
            return;
        }
        NodeItem nodeItem3 = this.m_prevRoot;
        while ((nodeItem2 = (NodeItem)nodeItem3.getParent()) != nodeItem || n2 != 0) {
            if (nodeItem2 == null) {
                this.m_prevRoot = nodeItem;
                return;
            }
            nodeItem3 = nodeItem2;
            if (n2 == 0) continue;
        }
        double d2 = 0.0;
        Iterator iterator = this.b(nodeItem);
        while (iterator.hasNext() && (node = (Node)iterator.next()) != nodeItem3) {
            d2 += ((Params)node.get((String)RadialTreeLayout.PARAMS)).a;
            if (n2 == 0) continue;
        }
        double d3 = ((Params)nodeItem.get((String)RadialTreeLayout.PARAMS)).a;
        double d4 = ((Params)nodeItem3.get((String)RadialTreeLayout.PARAMS)).a;
        d2 = Math.PI * -2 * (d2 + d4 / 2.0) / d3;
        this.m_theta1 = d2 + Math.atan2(nodeItem3.getY() - nodeItem.getY(), nodeItem3.getX() - nodeItem.getX());
        this.m_theta2 = this.m_theta1 + Math.PI * 2;
        this.m_prevRoot = nodeItem;
    }

    private double a(NodeItem nodeItem, int n2) {
        double d2;
        block6: {
            double d3;
            block5: {
                int n3 = TreeLayout.n;
                if (n2 > this.m_maxDepth) {
                    this.m_maxDepth = n2;
                }
                d2 = 0.0;
                Rectangle2D rectangle2D = nodeItem.getBounds();
                double d4 = rectangle2D.getWidth();
                double d5 = rectangle2D.getHeight();
                double d6 = d3 = n2 == 0 ? 0.0 : Math.sqrt(d4 * d4 + d5 * d5) / (double)n2;
                if (!nodeItem.isExpanded() || nodeItem.getChildCount() <= 0) break block5;
                Iterator iterator = nodeItem.children();
                while (iterator.hasNext()) {
                    NodeItem nodeItem2 = (NodeItem)iterator.next();
                    d2 += this.a(nodeItem2, n2 + 1);
                    if (n3 == 0) continue;
                }
                d2 = Math.max(d3, d2);
                if (n3 == 0) break block6;
            }
            d2 = d3;
        }
        ((Params)nodeItem.get((String)RadialTreeLayout.PARAMS)).a = d2;
        return d2;
    }

    private static final double a(double d2) {
        int n2 = TreeLayout.n;
        while (d2 > Math.PI * 2) {
            d2 -= Math.PI * 2;
            if (n2 == 0) continue;
        }
        while (d2 < 0.0) {
            d2 += Math.PI * 2;
            if (n2 == 0) continue;
        }
        return d2;
    }

    private Iterator b(NodeItem nodeItem) {
        int n2;
        int n3 = TreeLayout.n;
        double d2 = 0.0;
        NodeItem nodeItem2 = (NodeItem)nodeItem.getParent();
        if (nodeItem2 != null) {
            d2 = RadialTreeLayout.a(Math.atan2(nodeItem2.getY() - nodeItem.getY(), nodeItem2.getX() - nodeItem.getX()));
        }
        if ((n2 = nodeItem.getChildCount()) == 0) {
            return null;
        }
        NodeItem nodeItem3 = (NodeItem)nodeItem.getFirstChild();
        if (!nodeItem3.isStartVisible()) {
            return nodeItem.children();
        }
        double[] dArray = new double[n2];
        int[] nArray = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = n4;
            dArray[n4] = RadialTreeLayout.a(-d2 + Math.atan2(nodeItem3.getY() - nodeItem.getY(), nodeItem3.getX() - nodeItem.getX()));
            ++n4;
            nodeItem3 = (NodeItem)nodeItem3.getNextSibling();
            if (n3 == 0) continue;
        }
        ArrayLib.sort(dArray, nArray);
        return new a(this, nodeItem, nArray);
    }

    protected void layout(NodeItem nodeItem, double d2, double d3, double d4) {
        int n2 = TreeLayout.n;
        double d5 = d4 - d3;
        double d6 = d5 / 2.0;
        double d7 = ((Params)nodeItem.get((String)RadialTreeLayout.PARAMS)).a;
        double d8 = 0.0;
        Iterator iterator = this.b(nodeItem);
        while (iterator != null && iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            Params params = (Params)nodeItem2.get(PARAMS);
            double d9 = params.a / d7;
            if (nodeItem2.isExpanded() && nodeItem2.getChildCount() > 0) {
                this.layout(nodeItem2, d2 + this.m_radiusInc, d3 + d8 * d5, d3 + (d8 + d9) * d5);
            }
            this.setPolarLocation(nodeItem2, nodeItem, d2, d3 + d8 * d5 + d9 * d6);
            params.b = d9 * d5;
            d8 += d9;
            if (n2 == 0) continue;
        }
    }

    protected void setPolarLocation(NodeItem nodeItem, NodeItem nodeItem2, double d2, double d3) {
        this.setX(nodeItem, nodeItem2, this.m_origin.getX() + d2 * Math.cos(d3));
        this.setY(nodeItem, nodeItem2, this.m_origin.getY() + d2 * Math.sin(d3));
    }

    protected void initSchema(TupleSet tupleSet) {
        tupleSet.addColumns(PARAMS_SCHEMA);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\u0004YF^?:GsH3>gFC9._w[$:FT".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 91;
                            break;
                        }
                        case 1: {
                            n7 = 43;
                            break;
                        }
                        case 2: {
                            n7 = 39;
                            break;
                        }
                        case 3: {
                            n7 = 58;
                            break;
                        }
                        default: {
                            n7 = 86;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        PARAMS = new String(cArray).intern();
        PARAMS_SCHEMA = new Schema();
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class, new Params());
    }

    public static class Params
    implements Cloneable {
        double a;
        double b;

        public Object clone() {
            Params params = new Params();
            params.a = this.a;
            params.b = this.b;
            return params;
        }
    }
}

