/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.util.StringLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class FocusControl
extends ControlAdapter {
    private String c = Visualization.FOCUS_ITEMS;
    protected String activity;
    protected VisualItem curFocus;
    protected int ccount;
    protected int button = 0;
    protected Predicate filter = null;
    private final transient ArrayList<FocusChangedListener> d = new ArrayList();
    private final transient ArrayList<ItemClickedListener> e = new ArrayList();

    public FocusControl() {
        this(1);
    }

    public FocusControl(String string) {
        this(1);
        this.c = string;
    }

    public FocusControl(int n2) {
        this.ccount = n2;
    }

    public FocusControl(String string, int n2) {
        this.ccount = n2;
        this.c = string;
    }

    public FocusControl(int n2, String string) {
        this.ccount = n2;
        this.activity = string;
    }

    public FocusControl(String string, int n2, String string2) {
        this.ccount = n2;
        this.activity = string2;
        this.c = string;
    }

    public void setFilter(Predicate predicate) {
        this.filter = predicate;
    }

    public Predicate getFilter() {
        return this.filter;
    }

    protected boolean filterCheck(VisualItem visualItem) {
        if (this.filter == null) {
            return true;
        }
        try {
            return this.filter.getBoolean(visualItem);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).warning(exception.getMessage() + "\n" + StringLib.getStackTrace(exception));
            return false;
        }
    }

    @Override
    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!this.filterCheck(visualItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getPredefinedCursor(12));
        if (this.ccount == 0) {
            Visualization visualization = visualItem.getVisualization();
            TupleSet tupleSet = visualization.getFocusGroup(this.c);
            tupleSet.setTuple(visualItem);
            this.curFocus = visualItem;
            this.a(visualization);
        }
    }

    @Override
    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!this.filterCheck(visualItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getDefaultCursor());
        if (this.ccount == 0) {
            this.curFocus = null;
            Visualization visualization = visualItem.getVisualization();
            TupleSet tupleSet = visualization.getFocusGroup(this.c);
            tupleSet.removeTuple(visualItem);
            this.a(visualization);
        }
    }

    @Override
    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!this.filterCheck(visualItem)) {
            return;
        }
        if (UILib.isButtonPressed(mouseEvent, this.button) && (mouseEvent.getClickCount() == this.ccount || mouseEvent.getClickCount() == this.ccount + 1)) {
            this.a(visualItem, mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (visualItem != this.curFocus) {
                Visualization visualization = visualItem.getVisualization();
                TupleSet tupleSet = visualization.getFocusGroup(this.c);
                this.curFocus = visualItem;
                tupleSet.setTuple(visualItem);
                this.a(visualization);
                this.a();
            }
            this.a(visualItem, mouseEvent);
        }
    }

    private void a(Visualization visualization) {
        if (this.activity != null) {
            visualization.run(this.activity);
        }
    }

    public void setCurrentFocus(VisualItem visualItem) {
        this.curFocus = visualItem;
    }

    private void a() {
        int n2 = ControlAdapter.b;
        for (FocusChangedListener focusChangedListener : this.d) {
            focusChangedListener.focusChanged(this.curFocus);
            if (n2 == 0) continue;
        }
    }

    public void addFocusChangedListener(FocusChangedListener focusChangedListener) {
        if (focusChangedListener != null && !this.d.contains(focusChangedListener)) {
            this.d.add(focusChangedListener);
        }
    }

    public void removeFocusChangedListener(FocusChangedListener focusChangedListener) {
        this.d.remove(focusChangedListener);
    }

    public void addItemClickedListener(ItemClickedListener itemClickedListener) {
        if (itemClickedListener != null && !this.e.contains(itemClickedListener)) {
            this.e.add(itemClickedListener);
        }
    }

    public void removeItemClickedListener(ItemClickedListener itemClickedListener) {
        this.e.remove(itemClickedListener);
    }

    private void a(VisualItem visualItem, MouseEvent mouseEvent) {
        int n2 = ControlAdapter.b;
        if (mouseEvent.isConsumed()) {
            return;
        }
        for (ItemClickedListener itemClickedListener : this.e) {
            itemClickedListener.itemClicked(visualItem, mouseEvent);
            if (n2 == 0) continue;
        }
        mouseEvent.consume();
    }

    public static interface ItemClickedListener {
        public void itemClicked(VisualItem var1, MouseEvent var2);
    }

    public static interface FocusChangedListener {
        public void focusChanged(VisualItem var1);
    }
}

