/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import java.util.Iterator;
import prefuse.controls.ControlAdapter;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class NeighborHighlightControl
extends ControlAdapter {
    private String c = null;
    private boolean d = false;

    public NeighborHighlightControl() {
        this(null);
    }

    public NeighborHighlightControl(String string) {
        this.c = string;
    }

    @Override
    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (visualItem instanceof NodeItem) {
            this.setNeighborHighlight((NodeItem)visualItem, true);
        }
    }

    @Override
    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (visualItem instanceof NodeItem) {
            this.setNeighborHighlight((NodeItem)visualItem, false);
        }
    }

    protected void setNeighborHighlight(NodeItem nodeItem, boolean bl) {
        int n2 = ControlAdapter.b;
        Iterator iterator = nodeItem.edges();
        while (iterator.hasNext()) {
            EdgeItem edgeItem = (EdgeItem)iterator.next();
            NodeItem nodeItem2 = edgeItem.getAdjacentItem(nodeItem);
            if (edgeItem.isVisible() || this.d) {
                edgeItem.setHighlighted(bl);
                nodeItem2.setHighlighted(bl);
            }
            if (n2 == 0) continue;
        }
        if (this.c != null) {
            nodeItem.getVisualization().run(this.c);
        }
    }

    public boolean isHighlightWithInvisibleEdge() {
        return this.d;
    }

    public void setHighlightWithInvisibleEdge(boolean bl) {
        this.d = bl;
    }
}

