/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.util.ui.UILib;

public class RotationControl
extends ControlAdapter {
    private Point c = new Point();
    private double d = 0.0;
    private int e;

    public RotationControl() {
        this(16);
    }

    public RotationControl(int n2) {
        this.e = n2;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.e)) {
            Display display = (Display)mouseEvent.getComponent();
            display.setCursor(Cursor.getPredefinedCursor(11));
            this.c.setLocation(mouseEvent.getPoint());
            this.d = Double.NaN;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.e)) {
            int n2 = mouseEvent.getY() - this.c.y;
            int n3 = mouseEvent.getX() - this.c.x;
            double d2 = Math.atan2(n2, n3);
            if (!Double.isNaN(this.d)) {
                Display display = (Display)mouseEvent.getComponent();
                display.rotate(this.c, d2 - this.d);
            }
            this.d = d2;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.e)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

