/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class SubtreeDragControl
extends ControlAdapter {
    private Point2D c = new Point2D.Double();
    private Point2D d = new Point2D.Double();
    private boolean e;

    @Override
    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getComponent();
        this.c = display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.c);
        this.e = visualItem.isFixed();
        visualItem.setFixed(true);
    }

    @Override
    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        visualItem.setFixed(this.e);
    }

    @Override
    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getComponent();
        this.d = display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.d);
        double d2 = this.d.getX() - this.c.getX();
        double d3 = this.d.getY() - this.c.getY();
        this.a((NodeItem)visualItem, d2, d3);
        this.c.setLocation(this.d);
        visualItem.getVisualization().repaint();
    }

    private void a(NodeItem nodeItem, double d2, double d3) {
        int n2 = ControlAdapter.b;
        double d4 = nodeItem.getX();
        double d5 = nodeItem.getY();
        nodeItem.setStartX(d4);
        nodeItem.setStartY(d5);
        nodeItem.setX(d4 += d2);
        nodeItem.setY(d5 += d3);
        nodeItem.setEndX(d4);
        nodeItem.setEndY(d5);
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            this.a((NodeItem)iterator.next(), d2, d3);
            if (n2 == 0) continue;
        }
    }
}

