/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class ZoomToFitControl
extends ControlAdapter {
    private long c = 2000L;
    private int d = 50;
    private int e = 4;
    private boolean f = true;
    private String g = Visualization.ALL_ITEMS;

    public ZoomToFitControl() {
    }

    public ZoomToFitControl(String string) {
        this.g = string;
    }

    public ZoomToFitControl(int n2) {
        this.e = n2;
    }

    public ZoomToFitControl(String string, int n2) {
        this.g = string;
        this.e = n2;
    }

    public ZoomToFitControl(String string, int n2, long l2, int n3) {
        this.g = string;
        this.d = n2;
        this.c = l2;
        this.e = n3;
    }

    @Override
    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.f) {
            this.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Display display = (Display)mouseEvent.getComponent();
        if (!display.isTranformInProgress() && UILib.isButtonPressed(mouseEvent, this.e)) {
            this.doFit(display);
        }
    }

    public void doFit(Display display) {
        Visualization visualization = display.getVisualization();
        Rectangle2D rectangle2D = visualization.getBounds(this.g);
        GraphicsLib.expand(rectangle2D, this.d + (int)(1.0 / display.getScale()));
        DisplayLib.fitViewToBounds(display, rectangle2D, this.c);
    }

    public boolean isZoomOverItem() {
        return this.f;
    }

    public void setZoomOverItem(boolean bl) {
        this.f = bl;
    }

    public int getMargin() {
        return this.d;
    }

    public void setMargin(int n2) {
        this.d = n2;
    }
}

