/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.SpanningTree;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.GraphListener;
import prefuse.data.event.TableListener;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.CompositeTupleSet;
import prefuse.data.tuple.TableEdge;
import prefuse.data.tuple.TableNode;
import prefuse.data.tuple.TupleManager;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.Index;
import prefuse.data.util.NeighborIterator;
import prefuse.util.PrefuseConfig;
import prefuse.util.TypeLib;
import prefuse.util.collections.CompositeIntIterator;
import prefuse.util.collections.CompositeIterator;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IntArrayIterator;
import prefuse.util.collections.IntIterator;

public class Graph
extends CompositeTupleSet {
    public static final int INEDGES = 0;
    public static final int OUTEDGES = 1;
    public static final int UNDIRECTED = 2;
    public static final String DEFAULT_NODE_KEY;
    public static final String DEFAULT_SOURCE_KEY;
    public static final String DEFAULT_TARGET_KEY;
    public static final String NODES;
    public static final String EDGES;
    protected Table m_links;
    protected TupleManager m_nodeTuples;
    protected TupleManager m_edgeTuples;
    protected boolean m_directed = false;
    protected SpanningTree m_spanning = null;
    protected String m_nkey;
    protected String m_skey;
    protected String m_tkey;
    protected Index m_nidx;
    protected boolean m_longKey = false;
    private Listener j;
    private CopyOnWriteArrayList k = new CopyOnWriteArrayList();
    protected static final String INDEGREE;
    protected static final String OUTDEGREE;
    protected static final String INLINKS;
    protected static final String OUTLINKS;
    protected static final Schema LINKS_SCHEMA;
    private static final String[] z;

    public Graph() {
        this(false);
    }

    public Graph(boolean bl) {
        this(new Table(), bl);
    }

    public Graph(Table table, boolean bl) {
        this(table, bl, DEFAULT_NODE_KEY, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Graph(Table table, boolean bl, String string, String string2, String string3) {
        Table table2 = new Table();
        table2.addColumn(string2, Integer.TYPE, new Integer(-1));
        table2.addColumn(string3, Integer.TYPE, new Integer(-1));
        this.init(table, table2, bl, string, string2, string3);
    }

    public Graph(Table table, Table table2, boolean bl) {
        this(table, table2, bl, DEFAULT_NODE_KEY, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Graph(Table table, Table table2, boolean bl, String string, String string2) {
        this.init(table, table2, bl, DEFAULT_NODE_KEY, string, string2);
    }

    public Graph(Table table, Table table2, boolean bl, String string, String string2, String string3) {
        this.init(table, table2, bl, string, string2, string3);
    }

    protected void init(Table table, Table table2, boolean bl, String string, String string2, String string3) {
        int n2 = Table.e;
        if (string != null && !TypeLib.isIntegerType(table.getColumnType(string)) || !TypeLib.isIntegerType(table2.getColumnType(string2)) || !TypeLib.isIntegerType(table2.getColumnType(string3))) {
            throw new IllegalArgumentException(z[4]);
        }
        this.removeAllSets();
        super.addSet(EDGES, table2);
        super.addSet(NODES, table);
        this.m_directed = bl;
        this.m_nkey = string;
        this.m_skey = string2;
        this.m_tkey = string3;
        if (string != null) {
            if (table.getColumnType(string) == Long.TYPE) {
                this.m_longKey = true;
            }
            table.index(string);
            this.m_nidx = table.getIndex(string);
        }
        if (this.m_nodeTuples == null) {
            this.m_nodeTuples = new TupleManager(table, this, TableNode.class);
        }
        this.m_edgeTuples = new TupleManager(table2, this, TableEdge.class);
        this.initLinkTable();
        if (this.j == null) {
            this.j = new Listener();
        }
        table.addTableListener(this.j);
        table2.addTableListener(this.j);
        this.j.setEdgeTable(table2);
        if (n2 != 0) {
            AbstractExpression.b = !AbstractExpression.b;
        }
    }

    public void setTupleManagers(TupleManager tupleManager, TupleManager tupleManager2) {
        if (!Node.class.isAssignableFrom(tupleManager.getTupleType())) {
            throw new IllegalArgumentException(z[6]);
        }
        if (!Edge.class.isAssignableFrom(tupleManager2.getTupleType())) {
            throw new IllegalArgumentException(z[5]);
        }
        this.m_nodeTuples = tupleManager;
        this.m_edgeTuples = tupleManager2;
    }

    public void dispose() {
        this.getNodeTable().removeTableListener(this.j);
        this.getEdgeTable().removeTableListener(this.j);
    }

    public void setEdgeTable(Table table) {
        Table table2 = this.getEdgeTable();
        table2.removeTableListener(this.j);
        this.m_edgeTuples.invalidateAll();
        this.m_links.clear();
        this.init(this.getNodeTable(), table, this.m_directed, this.m_nkey, this.m_skey, this.m_tkey);
    }

    protected void initLinkTable() {
        int n2 = Table.e;
        this.m_links = this.createLinkTable();
        IntIterator intIterator = this.getEdgeTable().rows();
        while (intIterator.hasNext()) {
            this.updateDegrees(intIterator.nextInt(), 1);
            if (n2 == 0) continue;
        }
    }

    protected Table createLinkTable() {
        return LINKS_SCHEMA.instantiate(this.getNodeTable().getMaximumRow() + 1);
    }

    protected void updateDegrees(int n2, int n3) {
        if (!this.getEdgeTable().isValidRow(n2)) {
            return;
        }
        int n4 = this.getSourceNode(n2);
        int n5 = this.getTargetNode(n2);
        if (n4 < 0 || n5 < 0) {
            return;
        }
        this.updateDegrees(n2, n4, n5, n3);
        if (n3 < 0) {
            this.m_edgeTuples.invalidate(n2);
        }
    }

    protected void updateDegrees(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        block5: {
            block4: {
                n7 = this.m_links.getInt(n3, OUTDEGREE);
                n6 = this.m_links.getInt(n4, INDEGREE);
                if (n5 <= 0) break block4;
                this.addLink(OUTLINKS, n7, n3, n2);
                this.addLink(INLINKS, n6, n4, n2);
                if (Table.e == 0) break block5;
            }
            if (n5 < 0) {
                this.remLink(OUTLINKS, n7, n3, n2);
                this.remLink(INLINKS, n6, n4, n2);
            }
        }
        this.m_links.setInt(n3, OUTDEGREE, n7 + n5);
        this.m_links.setInt(n4, INDEGREE, n6 + n5);
        this.m_spanning = null;
    }

    protected void addLink(String string, int n2, int n3, int n4) {
        int[] nArray = (int[])this.m_links.get(n3, string);
        if (nArray == null) {
            nArray = new int[]{n4};
            this.m_links.set(n3, string, (Object)nArray);
            return;
        }
        if (n2 == nArray.length) {
            int[] nArray2 = new int[Math.max(3 * nArray.length / 2, n2 + 1)];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
            this.m_links.set(n3, string, (Object)nArray);
        }
        nArray[n2] = n4;
    }

    protected boolean remLink(String string, int n2, int n3, int n4) {
        int n5 = Table.e;
        int[] nArray = (int[])this.m_links.get(n3, string);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] != n4) continue;
            System.arraycopy(nArray, i2 + 1, nArray, i2, n2 - i2 - 1);
            return true;
        }
        return false;
    }

    protected void updateNodeData(int n2, boolean bl) {
        block3: {
            block2: {
                if (!bl) break block2;
                this.m_links.addRow();
                if (Table.e == 0) break block3;
            }
            this.m_nodeTuples.invalidate(n2);
            this.m_links.removeRow(n2);
        }
    }

    public String getNodeKeyField() {
        return this.m_nkey;
    }

    public String getEdgeSourceField() {
        return this.m_skey;
    }

    public String getEdgeTargetField() {
        return this.m_tkey;
    }

    public long getKey(int n2) {
        return this.m_nkey == null ? (long)n2 : this.getNodeTable().getLong(n2, this.m_nkey);
    }

    public int getNodeIndex(long l2) {
        if (this.m_nidx == null) {
            return (int)l2;
        }
        int n2 = this.m_longKey ? this.m_nidx.get(l2) : this.m_nidx.get((int)l2);
        return n2 < 0 ? -1 : n2;
    }

    public int addNodeRow() {
        return this.getNodeTable().addRow();
    }

    public Node addNode() {
        int n2 = this.addNodeRow();
        return (Node)this.m_nodeTuples.getTuple(n2);
    }

    public int addEdge(int n2, int n3) {
        int n4;
        block3: {
            Table table;
            long l2;
            long l3;
            block2: {
                l3 = this.getKey(n2);
                l2 = this.getKey(n3);
                table = this.getEdgeTable();
                n4 = table.addRow();
                if (!this.m_longKey) break block2;
                table.setLong(n4, this.m_skey, l3);
                table.setLong(n4, this.m_tkey, l2);
                if (Table.e == 0) break block3;
            }
            table.setInt(n4, this.m_skey, (int)l3);
            table.setInt(n4, this.m_tkey, (int)l2);
        }
        return n4;
    }

    public Edge addEdge(Node node, Node node2) {
        this.nodeCheck(node, true);
        this.nodeCheck(node2, true);
        int n2 = this.addEdge(node.getRow(), node2.getRow());
        return this.getEdge(n2);
    }

    public boolean removeNode(int n2) {
        int n3 = Table.e;
        Table table = this.getNodeTable();
        if (table.isValidRow(n2)) {
            int n4;
            int n5 = this.getInDegree(n2);
            if (n5 > 0) {
                int[] nArray = (int[])this.m_links.get(n2, INLINKS);
                int n6 = n5;
                while (--n6 >= 0) {
                    this.removeEdge(nArray[n6]);
                    if (n3 == 0) continue;
                }
            }
            if ((n4 = this.getOutDegree(n2)) > 0) {
                int[] nArray = (int[])this.m_links.get(n2, OUTLINKS);
                int n7 = n4;
                while (--n7 >= 0) {
                    this.removeEdge(nArray[n7]);
                    if (n3 == 0) continue;
                }
            }
        }
        return table.removeRow(n2);
    }

    public boolean removeNode(Node node) {
        this.nodeCheck(node, true);
        return this.removeNode(node.getRow());
    }

    public boolean removeEdge(int n2) {
        return this.getEdgeTable().removeRow(n2);
    }

    public boolean removeEdge(Edge edge) {
        this.edgeCheck(edge, true);
        return this.removeEdge(edge.getRow());
    }

    protected void clearEdges() {
        this.getEdgeTable().clear();
    }

    protected boolean nodeCheck(Node node, boolean bl) {
        if (!node.isValid()) {
            if (bl) {
                throw new IllegalArgumentException(z[8]);
            }
            return false;
        }
        Graph graph = node.getGraph();
        if (graph != this && graph.m_spanning != this) {
            if (bl) {
                throw new IllegalArgumentException(z[7]);
            }
            return false;
        }
        return true;
    }

    public TupleSet getNodes() {
        return this.getSet(NODES);
    }

    public Table getNodeTable() {
        return (Table)this.getSet(NODES);
    }

    public int getNodeCount() {
        return this.getNodeTable().getRowCount();
    }

    public Node getNode(int n2) {
        return (Node)this.m_nodeTuples.getTuple(n2);
    }

    public Node getNodeFromKey(long l2) {
        int n2 = this.getNodeIndex(l2);
        return n2 < 0 ? null : this.getNode(n2);
    }

    public int getInDegree(int n2) {
        return this.m_links.getInt(n2, INDEGREE);
    }

    public int getInDegree(Node node) {
        this.nodeCheck(node, true);
        return this.getInDegree(node.getRow());
    }

    public int getOutDegree(int n2) {
        return this.m_links.getInt(n2, OUTDEGREE);
    }

    public int getOutDegree(Node node) {
        this.nodeCheck(node, true);
        return this.getOutDegree(node.getRow());
    }

    public int getDegree(int n2) {
        return this.getInDegree(n2) + this.getOutDegree(n2);
    }

    public int getDegree(Node node) {
        this.nodeCheck(node, true);
        return this.getDegree(node.getRow());
    }

    public boolean isDirected() {
        return this.m_directed;
    }

    protected boolean edgeCheck(Edge edge, boolean bl) {
        if (!edge.isValid()) {
            if (bl) {
                throw new IllegalArgumentException(z[10]);
            }
            return false;
        }
        if (edge.getGraph() != this) {
            if (bl) {
                throw new IllegalArgumentException(z[9]);
            }
            return false;
        }
        return true;
    }

    public TupleSet getEdges() {
        return this.getSet(EDGES);
    }

    public Table getEdgeTable() {
        return (Table)this.getSet(EDGES);
    }

    public int getEdgeCount() {
        return this.getEdgeTable().getRowCount();
    }

    public Edge getEdge(int n2) {
        return n2 < 0 ? null : (Edge)this.m_edgeTuples.getTuple(n2);
    }

    public int getEdge(int n2, int n3) {
        int n4 = Table.e;
        int n5 = this.getOutDegree(n2);
        if (n5 > 0) {
            int[] nArray = (int[])this.m_links.get(n2, OUTLINKS);
            for (int i2 = 0; i2 < n5; ++i2) {
                if (this.getTargetNode(nArray[i2]) != n3) continue;
                return nArray[i2];
            }
        }
        return -1;
    }

    public Edge getEdge(Node node, Node node2) {
        this.nodeCheck(node, true);
        this.nodeCheck(node2, true);
        return this.getEdge(this.getEdge(node.getRow(), node2.getRow()));
    }

    public int getSourceNode(int n2) {
        return this.getNodeIndex(this.getEdgeTable().getLong(n2, this.m_skey));
    }

    public Node getSourceNode(Edge edge) {
        this.edgeCheck(edge, true);
        return this.getNode(this.getSourceNode(edge.getRow()));
    }

    public int getTargetNode(int n2) {
        return this.getNodeIndex(this.getEdgeTable().getLong(n2, this.m_tkey));
    }

    public Node getTargetNode(Edge edge) {
        this.edgeCheck(edge, true);
        return this.getNode(this.getTargetNode(edge.getRow()));
    }

    public int getAdjacentNode(int n2, int n3) {
        int n4 = this.getSourceNode(n2);
        int n5 = this.getTargetNode(n2);
        if (n4 == n3) {
            return n5;
        }
        if (n5 == n3) {
            return n4;
        }
        throw new IllegalArgumentException(z[11]);
    }

    public Node getAdjacentNode(Edge edge, Node node) {
        this.edgeCheck(edge, true);
        this.nodeCheck(node, true);
        return this.getNode(this.getAdjacentNode(edge.getRow(), node.getRow()));
    }

    public IntIterator nodeRows() {
        return this.getNodeTable().rows();
    }

    public IntIterator edgeRows() {
        return this.getEdgeTable().rows();
    }

    public IntIterator edgeRows(int n2) {
        return this.edgeRows(n2, 2);
    }

    public IntIterator edgeRows(int n2, int n3) {
        if (n3 == 1) {
            int[] nArray = (int[])this.m_links.get(n2, OUTLINKS);
            return new IntArrayIterator(nArray, 0, this.getOutDegree(n2));
        }
        if (n3 == 0) {
            int[] nArray = (int[])this.m_links.get(n2, INLINKS);
            return new IntArrayIterator(nArray, 0, this.getInDegree(n2));
        }
        if (n3 == 2) {
            return new CompositeIntIterator(this.edgeRows(n2, 1), this.edgeRows(n2, 0));
        }
        throw new IllegalArgumentException(z[0] + n3 + z[2] + z[1]);
    }

    public IntIterator inEdgeRows(int n2) {
        return this.edgeRows(n2, 0);
    }

    public IntIterator outEdgeRows(int n2) {
        return this.edgeRows(n2, 1);
    }

    public Iterator nodes() {
        return this.m_nodeTuples.iterator(this.nodeRows());
    }

    public Iterator neighbors(Node node) {
        return new NeighborIterator(node, this.edges(node));
    }

    public Iterator inNeighbors(Node node) {
        return new NeighborIterator(node, this.inEdges(node));
    }

    public Iterator outNeighbors(Node node) {
        return new NeighborIterator(node, this.outEdges(node));
    }

    public Iterator edges() {
        return this.m_edgeTuples.iterator(this.edgeRows());
    }

    public Iterator edges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.edgeRows(node.getRow(), 2));
    }

    public Iterator inEdges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.inEdgeRows(node.getRow()));
    }

    public Iterator outEdges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.outEdgeRows(node.getRow()));
    }

    @Override
    public void clear() {
        this.m_nodeTuples.invalidateAll();
        this.m_edgeTuples.invalidateAll();
        super.clear();
        this.m_links.clear();
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        if (tuple instanceof Node) {
            return this.removeNode((Node)tuple);
        }
        if (tuple instanceof Edge) {
            return this.removeEdge((Edge)tuple);
        }
        throw new IllegalArgumentException(z[3]);
    }

    @Override
    public Iterator tuples(Predicate predicate) {
        if (predicate == null) {
            return this.tuples();
        }
        return new CompositeIterator(this.m_edgeTuples.iterator(this.getEdgeTable().rows(predicate)), this.m_nodeTuples.iterator(this.getNodeTable().rows(predicate)));
    }

    @Override
    public Iterator tuples() {
        return new CompositeIterator(this.edges(), this.nodes());
    }

    public Tree getSpanningTree() {
        if (this.m_spanning == null) {
            return this.getSpanningTree((Node)this.nodes().next());
        }
        return this.m_spanning;
    }

    public Tree getSpanningTree(Node node) {
        block5: {
            block4: {
                this.nodeCheck(node, true);
                if (this.m_spanning != null) break block4;
                this.m_spanning = new SpanningTree(this, node);
                if (Table.e == 0) break block5;
            }
            if (this.m_spanning.getRoot() != node) {
                this.m_spanning.buildSpanningTree(node);
            }
        }
        return this.m_spanning;
    }

    public void clearSpanningTree() {
        this.m_spanning = null;
    }

    public void addGraphModelListener(GraphListener graphListener) {
        if (!this.k.contains(graphListener)) {
            this.k.add(graphListener);
        }
    }

    public void removeGraphModelListener(GraphListener graphListener) {
        this.k.remove(graphListener);
    }

    public void removeAllGraphModelListeners() {
        this.k.clear();
    }

    protected void fireGraphEvent(Table table, int n2, int n3, int n4, int n5) {
        String string;
        int n6 = Table.e;
        String string2 = string = table == this.getNodeTable() ? NODES : EDGES;
        if (n5 != 0) {
            this.fireTupleEvent(table, n2, n3, n5);
        }
        if (!this.k.isEmpty()) {
            Object[] objectArray = this.k.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ((GraphListener)objectArray[i2]).graphChanged(this, string, n2, n3, n4, n5);
                if (n6 == 0) continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0019\u0007#&C!\u001c('";
        int n3 = 11;
        block23: while (true) {
            switch (n3) {
                case 11: {
                    INDEGREE = Graph.z(Graph.z(string2));
                    string2 = "\u0019\u0007#.O(\u0005>";
                    n3 = 12;
                    continue block23;
                }
                case 12: {
                    INLINKS = Graph.z(Graph.z(string2));
                    string2 = "\u0019\u000186J/\u0000&1";
                    n3 = 13;
                    continue block23;
                }
                case 13: {
                    OUTLINKS = Graph.z(Graph.z(string2));
                    string2 = "\u0019\u000186B#\t?'C";
                    n3 = 14;
                    continue block23;
                }
                case 14: {
                    OUTDEGREE = Graph.z(Graph.z(string2));
                    string2 = "\u0013\u0000?'E)\t#+\\#\nm'B!\u000bm6_6\u000bwb";
                    n3 = -1;
                    continue block23;
                }
                default: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0001\u001c,-Nh'\u0003\u0007b\u0001+\u001en\u0006)\u001cm\u0005T'\u001e%lg\n\"";
                    n3 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "hN\u0019;V#N>*I3\u0002)bD#N\",Cf\u0001+ba4\u000f=*\b\t;\u0019\u0007b\u0001+\u001en\u0006";
                    n3 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u000f\u0000=7Rf\u001a82J#N 7U2N/'\u00066\u000f?6\u0006)\bm6N/\u001dm%T'\u001e%";
                    n3 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u000f\u0000.-K6\u000f9+D*\u000bm!I*\u001b ,\u00062\u0017='Uf\b\"0\u0006!\u001c,2Nf\u0005(;U";
                    n3 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0012\u0006(bV4\u0001;+B#\nm'B!\u000bm\u0016S6\u0002(\u000fG(\u000f*'Tf\u000381Rf\t(,C4\u000f9'\u00062\u001b=.C5N9*G2N$/V*\u000b 'H2N9*Cf+)%Cf\u0007#6C4\b,!Ch";
                    n3 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0012\u0006(bV4\u0001;+B#\nm,I\"\u000bm\u0016S6\u0002(\u000fG(\u000f*'Tf\u000381Rf\t(,C4\u000f9'\u00062\u001b=.C5N9*G2N$/V*\u000b 'H2N9*Cf \"&Cf\u0007#6C4\b,!Ch";
                    n3 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\b\u0001)'\u0006+\u001b>6\u0006$\u000bm2G4\u001am-@f\u001a%+Uf)?#V.@";
                    n3 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\b\u0001)'\u0006+\u001b>6\u0006$\u000bm4G*\u0007)l";
                    n3 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0003\n*'\u0006+\u001b>6\u0006$\u000bm2G4\u001am-@f\u001a%+Uf)?#V.@";
                    n3 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0003\n*'\u0006+\u001b>6\u0006$\u000bm4G*\u0007)l";
                    n3 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n2] = Graph.z(Graph.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0003\n*'\u0006/\u001dm,I2N$,E/\n(,Rf\u0001#bR.\u000bm+H6\u001b9bH)\n(l";
                    n3 = 10;
                    continue block23;
                }
                case 10: 
            }
            break;
        }
        stringArray2[n2] = Graph.z(Graph.z(string2));
        z = stringArray3;
        String string3 = "\"\u000f9#\b!\u001c,2Nh\u0000\"&C\r\u000b4";
        int n4 = -1;
        block24: while (true) {
            string = Graph.z(Graph.z(string3));
            switch (n4) {
                default: {
                    DEFAULT_NODE_KEY = PrefuseConfig.get(string);
                    string3 = "\"\u000f9#\b!\u001c,2Nh\u001d\"7T%\u000b\u0006'_";
                    n4 = 0;
                    continue block24;
                }
                case 0: {
                    DEFAULT_SOURCE_KEY = PrefuseConfig.get(string);
                    string3 = "\"\u000f9#\b!\u001c,2Nh\u001a,0A#\u001a\u0006'_";
                    n4 = 1;
                    continue block24;
                }
                case 1: {
                    DEFAULT_TARGET_KEY = PrefuseConfig.get(string);
                    string3 = "\"\u000f9#\b!\u001c,2Nh\u0000\"&C\u0001\u001c\"7V";
                    n4 = 2;
                    continue block24;
                }
                case 2: {
                    NODES = PrefuseConfig.get(string);
                    string3 = "\"\u000f9#\b!\u001c,2Nh\u000b)%C\u0001\u001c\"7V";
                    n4 = 3;
                    continue block24;
                }
                case 3: 
            }
            break;
        }
        EDGES = PrefuseConfig.get(string);
        LINKS_SCHEMA = new Schema();
        Integer n5 = new Integer(0);
        LINKS_SCHEMA.addColumn(INDEGREE, Integer.TYPE, n5);
        LINKS_SCHEMA.addColumn(OUTDEGREE, Integer.TYPE, n5);
        LINKS_SCHEMA.addColumn(INLINKS, int[].class);
        LINKS_SCHEMA.addColumn(OUTLINKS, int[].class);
        LINKS_SCHEMA.lockSchema();
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x26);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 70;
                            break;
                        }
                        case 1: {
                            n7 = 110;
                            break;
                        }
                        case 2: {
                            n7 = 77;
                            break;
                        }
                        case 3: {
                            n7 = 66;
                            break;
                        }
                        default: {
                            n7 = 38;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }

    protected class Listener
    implements TableListener,
    ColumnListener {
        private Table a;
        private Column b;
        private Column c;
        private int d;
        private int e;
        private static final String z;

        protected Listener() {
        }

        public void setEdgeTable(Table table) {
            if (this.b != null) {
                this.b.removeColumnListener(this);
            }
            if (this.c != null) {
                this.c.removeColumnListener(this);
            }
            this.c = null;
            this.b = null;
            this.e = -1;
            this.d = -1;
            this.a = table;
            if (this.a != null) {
                this.d = table.getColumnNumber(Graph.this.m_skey);
                this.e = table.getColumnNumber(Graph.this.m_tkey);
                this.b = table.getColumn(this.d);
                this.c = table.getColumn(this.e);
                this.b.addColumnListener(this);
                this.c.addColumnListener(this);
            }
        }

        @Override
        public void tableChanged(Table table, int n2, int n3, int n4, int n5) {
            block7: {
                block9: {
                    int n6;
                    boolean bl;
                    int n7;
                    block8: {
                        n7 = Table.e;
                        if (!Graph.this.containsSet(table)) {
                            throw new IllegalStateException(z);
                        }
                        if (n5 == 0) break block7;
                        if (table != Graph.this.getNodeTable()) break block8;
                        if (n4 != -1) break block9;
                        bl = n5 == 1;
                        for (n6 = n2; n6 <= n3; ++n6) {
                            Graph.this.updateNodeData(n6, bl);
                            if (n7 == 0) continue;
                        }
                        if (n7 == 0) break block9;
                    }
                    if (n4 == -1) {
                        bl = n5 == 1;
                        for (n6 = n2; n6 <= n3; ++n6) {
                            Graph.this.updateDegrees(n2, bl ? 1 : -1);
                            if (n7 == 0) continue;
                        }
                    }
                }
                Graph.this.m_spanning = null;
            }
            Graph.this.fireGraphEvent(table, n2, n3, n4, n5);
        }

        @Override
        public void columnChanged(Column column, int n2, int n3) {
            this.columnChanged(column, n2, (long)n3);
        }

        @Override
        public void columnChanged(Column column, int n2, long l2) {
            block7: {
                block6: {
                    if (column != this.b && column != this.c) break block6;
                    boolean bl = column == this.b;
                    int n3 = this.a.getTableRow(n2, bl ? this.d : this.e);
                    if (n3 == -1) {
                        return;
                    }
                    int n4 = Graph.this.getSourceNode(n3);
                    int n5 = Graph.this.getTargetNode(n3);
                    int n6 = Graph.this.getNodeIndex(l2);
                    if (n6 > -1 && (bl && n5 > -1 || !bl && n4 > -1)) {
                        Graph.this.updateDegrees(n3, bl ? n6 : n4, bl ? n5 : n6, -1);
                    }
                    if (n4 > -1 && n5 > -1) {
                        Graph.this.updateDegrees(n3, n4, n5, 1);
                    }
                    if (Table.e == 0) break block7;
                }
                throw new IllegalStateException();
            }
        }

        @Override
        public void columnChanged(Column column, int n2, int n3, int n4) {
            throw new IllegalStateException();
        }

        @Override
        public void columnChanged(Column column, int n2, float f2) {
            throw new IllegalStateException();
        }

        @Override
        public void columnChanged(Column column, int n2, double d2) {
            throw new IllegalStateException();
        }

        @Override
        public void columnChanged(Column column, int n2, boolean bl) {
            throw new IllegalStateException();
        }

        @Override
        public void columnChanged(Column column, int n2, Object object) {
            throw new IllegalStateException();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "wo;GD\u0010n2XY\\y4\u0010X\u0010\u007f?\u0017@Yn.RBYs=\u0017X_=;Y\fEs(R@Qi?S\fD|8[I".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 48;
                                break;
                            }
                            case 1: {
                                n7 = 29;
                                break;
                            }
                            case 2: {
                                n7 = 90;
                                break;
                            }
                            case 3: {
                                n7 = 55;
                                break;
                            }
                            default: {
                                n7 = 44;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

