/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.data.column.ColumnFactory;
import prefuse.data.column.ColumnMetadata;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.TableListener;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.AbstractTupleSet;
import prefuse.data.tuple.TableTuple;
import prefuse.data.tuple.TupleManager;
import prefuse.data.util.FilterIteratorFactory;
import prefuse.data.util.Index;
import prefuse.data.util.RowManager;
import prefuse.data.util.Sort;
import prefuse.data.util.TableIterator;
import prefuse.data.util.TreeIndex;
import prefuse.util.TypeLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IncompatibleComparatorException;
import prefuse.util.collections.IntIterator;

public class Table
extends AbstractTupleSet
implements ColumnListener {
    protected CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
    protected ArrayList m_columns;
    protected ArrayList m_names;
    protected HashMap m_entries;
    protected RowManager m_rows;
    protected TupleManager m_tuples;
    protected int m_modCount = 0;
    protected int m_lastCol = -1;
    protected Schema m_schema;
    public static int e;
    private static final String[] z;

    public Table() {
        this(0, 0);
    }

    public Table(int n2, int n3) {
        this(n2, n3, TableTuple.class);
    }

    protected Table(int n2, int n3, Class clazz) {
        this.m_columns = new ArrayList(n3);
        this.m_names = new ArrayList(n3);
        this.m_rows = new RowManager(this);
        this.m_entries = new HashMap(n3 + 5);
        this.m_tuples = new TupleManager(this, null, clazz);
        if (n2 > 0) {
            this.addRows(n2);
        }
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public Class getColumnType(int n2) {
        return this.getColumn(n2).getColumnType();
    }

    public Class getColumnType(String string) {
        Column column = this.getColumn(string);
        return column == null ? null : column.getColumnType();
    }

    public int getRowCount() {
        return this.m_rows.getRowCount();
    }

    public int getMinimumRow() {
        return this.m_rows.getMinimumRow();
    }

    public int getMaximumRow() {
        return this.m_rows.getMaximumRow();
    }

    public boolean isCellEditable(int n2, int n3) {
        if (!this.m_rows.isValidRow(n2)) {
            return false;
        }
        return this.getColumn(n3).isCellEditable(n2);
    }

    public int getModificationCount() {
        return this.m_modCount;
    }

    public void setTupleManager(TupleManager tupleManager) {
        this.m_tuples.invalidateAll();
        this.m_tuples = tupleManager;
    }

    public Schema getSchema() {
        int n2 = e;
        if (this.m_schema == null) {
            Schema schema = new Schema();
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                schema.addColumn(this.getColumnName(i2), this.getColumnType(i2), this.getColumn(i2).getDefaultValue());
                if (n2 == 0) continue;
            }
            schema.lockSchema();
            this.m_schema = schema;
        }
        return this.m_schema;
    }

    protected void invalidateSchema() {
        this.m_schema = null;
    }

    public int getColumnRow(int n2, int n3) {
        return this.m_rows.getColumnRow(n2, n3);
    }

    public int getTableRow(int n2, int n3) {
        return this.m_rows.getTableRow(n2, n3);
    }

    public int addRow() {
        int n2 = this.m_rows.addRow();
        this.updateRowCount();
        this.fireTableEvent(n2, n2, -1, 1);
        return n2;
    }

    public void addRows(int n2) {
        int n3 = e;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addRow();
            if (n3 == 0) continue;
        }
    }

    protected void updateRowCount() {
        int n2 = e;
        int n3 = this.m_rows.getMaximumRow() + 1;
        Iterator iterator = this.getColumns();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            column.setMaximumRow(n3);
            if (n2 == 0) continue;
        }
    }

    public boolean removeRow(int n2) {
        int n3 = e;
        if (this.m_rows.isValidRow(n2)) {
            this.fireTableEvent(n2, n2, -1, -1);
            this.m_tuples.invalidate(n2);
            this.m_rows.releaseRow(n2);
            Iterator iterator = this.getColumns();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                column.revertToDefault(n2);
                if (n3 == 0) continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        int n2 = e;
        IntIterator intIterator = this.rows(true);
        while (intIterator.hasNext()) {
            this.removeRow(intIterator.nextInt());
            if (n2 == 0) continue;
        }
    }

    public boolean isValidRow(int n2) {
        return this.m_rows.isValidRow(n2);
    }

    protected boolean hasColumn(String string) {
        return this.getColumnNumber(string) != -1;
    }

    public String getColumnName(int n2) {
        return (String)this.m_names.get(n2);
    }

    public int getColumnNumber(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        return columnEntry == null ? -1 : columnEntry.colnum;
    }

    public int getColumnNumber(Column column) {
        return this.m_columns.indexOf(column);
    }

    public Column getColumn(int n2) {
        this.m_lastCol = n2;
        return (Column)this.m_columns.get(n2);
    }

    public Column getColumn(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        return columnEntry != null ? columnEntry.column : null;
    }

    @Override
    public void addColumn(String string, Class clazz) {
        this.addColumn(string, clazz, null);
    }

    @Override
    public void addColumn(String string, Class clazz, Object object) {
        Column column = ColumnFactory.getColumn(clazz, this.m_rows.getMaximumRow() + 1, object);
        this.addColumn(string, column);
    }

    @Override
    public void addColumn(String string, String string2) {
        Expression expression = ExpressionParser.parse(string2);
        Throwable throwable = ExpressionParser.getError();
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
        this.addColumn(string, expression);
    }

    @Override
    public void addColumn(String string, Expression expression) {
        this.addColumn(string, ColumnFactory.getColumn(this, expression));
    }

    public void addConstantColumn(String string, Class clazz, Object object) {
        this.addColumn(string, ColumnFactory.getConstantColumn(clazz, object));
    }

    protected void addColumn(String string, Column column) {
        int n2 = e;
        int n3 = this.getColumnNumber(string);
        if (n3 >= 0 && n3 < this.m_columns.size()) {
            throw new IllegalArgumentException(z[3] + string + "\"");
        }
        this.m_columns.add(column);
        this.m_names.add(string);
        this.m_lastCol = this.m_columns.size() - 1;
        ColumnEntry columnEntry = new ColumnEntry(this.m_lastCol, column, new ColumnMetadata(this, string));
        ColumnEntry columnEntry2 = this.m_entries.put(string, columnEntry);
        if (columnEntry2 != null) {
            columnEntry2.dispose();
        }
        this.invalidateSchema();
        column.addColumnListener(this);
        this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), this.m_lastCol, 1);
        if (AbstractExpression.b) {
            e = ++n2;
        }
    }

    protected Column removeColumn(int n2) {
        if (n2 < 0 || n2 >= this.m_columns.size()) {
            throw new IllegalArgumentException(z[0]);
        }
        String string = (String)this.m_names.get(n2);
        ((ColumnEntry)this.m_entries.get(string)).dispose();
        Column column = (Column)this.m_columns.remove(n2);
        this.m_entries.remove(string);
        this.m_names.remove(n2);
        this.renumberColumns();
        this.m_lastCol = -1;
        this.invalidateSchema();
        column.removeColumnListener(this);
        this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), n2, -1);
        return column;
    }

    public Column removeColumn(String string) {
        int n2 = this.m_names.indexOf(string);
        if (n2 < 0) {
            throw new IllegalArgumentException(z[2]);
        }
        return this.removeColumn(n2);
    }

    public void removeColumn(Column column) {
        int n2 = this.m_columns.indexOf(column);
        if (n2 < 0) {
            throw new IllegalArgumentException(z[2]);
        }
        this.removeColumn(n2);
    }

    protected void renumberColumns() {
        int n2 = e;
        Iterator iterator = this.m_names.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
            columnEntry.colnum = n3++;
            if (n2 == 0) continue;
        }
    }

    protected Iterator getColumns() {
        return this.m_columns.iterator();
    }

    protected Iterator getColumnNames() {
        return this.m_names.iterator();
    }

    public ColumnMetadata getMetadata(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException(z[1] + string);
        }
        return columnEntry.metadata;
    }

    public Index index(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException(z[1] + string);
        }
        if (columnEntry.index != null) {
            return columnEntry.index;
        }
        Column column = columnEntry.column;
        try {
            columnEntry.index = new TreeIndex(this, this.m_rows, column, null);
        }
        catch (IncompatibleComparatorException incompatibleComparatorException) {
            // empty catch block
        }
        return columnEntry.index;
    }

    public Index getIndex(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException(z[1] + string);
        }
        return columnEntry.index;
    }

    protected Index getIndex(String string, Class clazz, boolean bl) {
        if (!clazz.equals(this.getColumnType(string))) {
            throw new IllegalArgumentException(z[4]);
        }
        if (this.getIndex(string) == null && bl) {
            this.index(string);
        }
        return this.getIndex(string);
    }

    public boolean removeIndex(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException(z[1] + string);
        }
        if (columnEntry.index == null) {
            return false;
        }
        columnEntry.index.dispose();
        columnEntry.index = null;
        return true;
    }

    public Tuple getTuple(int n2) {
        return this.m_tuples.getTuple(n2);
    }

    @Override
    public Tuple addTuple(Tuple tuple) {
        int n2 = e;
        if (tuple.getTable() == this) {
            return null;
        }
        Schema schema = tuple.getSchema();
        if (this.getSchema().isAssignableFrom(schema)) {
            int n3 = this.addRow();
            for (int i2 = 0; i2 < schema.getColumnCount(); ++i2) {
                String string = schema.getColumnName(i2);
                this.set(n3, string, tuple.get(i2));
                if (n2 == 0) continue;
            }
            return this.getTuple(n3);
        }
        return null;
    }

    @Override
    public Tuple setTuple(Tuple tuple) {
        this.clear();
        return this.addTuple(tuple);
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        if (this.containsTuple(tuple)) {
            this.removeRow(tuple.getRow());
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTuple(Tuple tuple) {
        return tuple.getTable() == this && this.isValidRow(tuple.getRow());
    }

    @Override
    public int getTupleCount() {
        return this.getRowCount();
    }

    @Override
    public boolean isAddColumnSupported() {
        return true;
    }

    public boolean canGet(String string, Class clazz) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGet(clazz);
    }

    public boolean canSet(String string, Class clazz) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSet(clazz);
    }

    public Object get(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).get(n2);
    }

    public void set(int n2, String string, Object object) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).set(object, n2);
    }

    public Object get(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).get(n2);
    }

    public void set(int n2, int n3, Object object) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).set(object, n2);
    }

    public Object getDefault(String string) {
        int n2 = this.getColumnNumber(string);
        return this.getColumn(n2).getDefaultValue();
    }

    public void revertToDefault(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).revertToDefault(n2);
    }

    public final boolean canGetInt(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetInt();
    }

    public final boolean canSetInt(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetInt();
    }

    public final int getInt(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getInt(n2);
    }

    public final void setInt(int n2, String string, int n3) {
        int n4 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n4);
        this.getColumn(n4).setInt(n3, n2);
    }

    public final int getInt(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getInt(n2);
    }

    public final void setInt(int n2, int n3, int n4) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setInt(n4, n2);
    }

    public final boolean canGetLong(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetLong();
    }

    public final boolean canSetLong(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetLong();
    }

    public final long getLong(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getLong(n2);
    }

    public final void setLong(int n2, String string, long l2) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setLong(l2, n2);
    }

    public final long getLong(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getLong(n2);
    }

    public final void setLong(int n2, int n3, long l2) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setLong(l2, n2);
    }

    public final boolean canGetFloat(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetFloat();
    }

    public final boolean canSetFloat(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetFloat();
    }

    public final float getFloat(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getFloat(n2);
    }

    public final void setFloat(int n2, String string, float f2) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setFloat(f2, n2);
    }

    public final float getFloat(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getFloat(n2);
    }

    public final void setFloat(int n2, int n3, float f2) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setFloat(f2, n2);
    }

    public final boolean canGetDouble(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetDouble();
    }

    public final boolean canSetDouble(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetDouble();
    }

    public final double getDouble(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getDouble(n2);
    }

    public final void setDouble(int n2, String string, double d2) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setDouble(d2, n2);
    }

    public final double getDouble(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getDouble(n2);
    }

    public final void setDouble(int n2, int n3, double d2) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setDouble(d2, n2);
    }

    public final boolean canGetBoolean(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetBoolean();
    }

    public final boolean canSetBoolean(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetBoolean();
    }

    public final boolean getBoolean(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getBoolean(n2);
    }

    public final void setBoolean(int n2, String string, boolean bl) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setBoolean(bl, n2);
    }

    public final boolean getBoolean(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getBoolean(n2);
    }

    public final void setBoolean(int n2, int n3, boolean bl) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setBoolean(bl, n2);
    }

    public final boolean canGetString(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetString();
    }

    public final boolean canSetString(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetString();
    }

    public final String getString(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getString(n2);
    }

    public final void setString(int n2, String string, String string2) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setString(string2, n2);
    }

    public final String getString(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getString(n2);
    }

    public final void setString(int n2, int n3, String string) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setString(string, n2);
    }

    public final boolean canGetDate(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetDate();
    }

    public final boolean canSetDate(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetDate();
    }

    public final Date getDate(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getDate(n2);
    }

    public final void setDate(int n2, String string, Date date) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setDate(date, n2);
    }

    public final Date getDate(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getDate(n2);
    }

    public final void setDate(int n2, int n3, Date date) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setDate(date, n2);
    }

    public Table select(Predicate predicate, Sort sort) {
        int n2 = e;
        Table table = this.getSchema().instantiate();
        Iterator iterator = this.tuples(predicate, sort);
        while (iterator.hasNext()) {
            table.addTuple((Tuple)iterator.next());
            if (n2 == 0) continue;
        }
        return table;
    }

    public void remove(Predicate predicate) {
        int n2 = e;
        IntIterator intIterator = this.rows(predicate);
        while (intIterator.hasNext()) {
            this.removeRow(intIterator.nextInt());
            if (n2 == 0) continue;
        }
    }

    public TableIterator iterator() {
        return this.iterator(this.rows());
    }

    public TableIterator iterator(IntIterator intIterator) {
        return new TableIterator(this, intIterator);
    }

    @Override
    public Iterator tuples() {
        return this.m_tuples.iterator(this.rows());
    }

    public Iterator tuplesReversed() {
        return this.m_tuples.iterator(this.rows(true));
    }

    public Iterator tuples(IntIterator intIterator) {
        return this.m_tuples.iterator(intIterator);
    }

    public IntIterator rows() {
        return this.m_rows.rows();
    }

    public IntIterator rows(Predicate predicate) {
        return FilterIteratorFactory.rows(this, predicate);
    }

    public IntIterator rows(boolean bl) {
        return this.m_rows.rows(bl);
    }

    public IntIterator rowsSortedBy(String string, boolean bl) {
        Class clazz = this.getColumnType(string);
        Index index = this.getIndex(string, clazz, true);
        int n2 = bl ? 32 : 16;
        return index.allRows(n2);
    }

    public IntIterator rangeSortedBy(String string, int n2, int n3, int n4) {
        Index index = this.getIndex(string, Integer.TYPE, true);
        return index.rows(n2, n3, n4);
    }

    public IntIterator rangeSortedBy(String string, long l2, long l3, int n2) {
        Index index = this.getIndex(string, Long.TYPE, true);
        return index.rows(l2, l3, n2);
    }

    public IntIterator rangeSortedBy(String string, float f2, float f3, int n2) {
        Index index = this.getIndex(string, Float.TYPE, true);
        return index.rows(f2, f3, n2);
    }

    public IntIterator rangeSortedBy(String string, double d2, double d3, int n2) {
        Index index = this.getIndex(string, Double.TYPE, true);
        return index.rows(d2, d3, n2);
    }

    public IntIterator rangeSortedBy(String string, Object object, Object object2, int n2) {
        Class clazz = TypeLib.getSharedType(object, object2);
        if (clazz == null) {
            throw new IllegalArgumentException(z[9]);
        }
        Index index = this.getIndex(string, clazz, true);
        return index.rows(object, object2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, boolean bl) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, double d2) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, float f2) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, int n3) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, long l2) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, Object object) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, int n3, int n4) {
        this.handleColumnChanged(column, n3, n4);
    }

    protected void handleColumnChanged(Column column, int n2, int n3) {
        int n4;
        block7: {
            block6: {
                int n5 = e;
                while (!this.isValidRow(n2) && n2 <= n3) {
                    ++n2;
                    if (n5 == 0) continue;
                }
                if (n2 > n3) {
                    return;
                }
                if (this.m_lastCol == -1 || column != this.getColumn(this.m_lastCol)) break block6;
                n4 = this.m_lastCol;
                if (n5 == 0) break block7;
            }
            n4 = this.getColumnNumber(column);
        }
        if (n4 >= 0) {
            this.fireTableEvent(n2, n3, n4, 0);
        }
    }

    public void addTableListener(TableListener tableListener) {
        if (!this.m_listeners.contains(tableListener)) {
            this.m_listeners.add(tableListener);
        }
    }

    public void removeTableListener(TableListener tableListener) {
        this.m_listeners.remove(tableListener);
    }

    public void removeAllTableListeners() {
        this.m_listeners.clear();
    }

    protected void fireTableEvent(int n2, int n3, int n4, int n5) {
        int n6 = e;
        ++this.m_modCount;
        if (n5 != 0 && n4 == -1) {
            this.fireTupleEvent(this, n2, n3, n5);
        }
        if (!this.m_listeners.isEmpty()) {
            Object[] objectArray = this.m_listeners.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ((TableListener)objectArray[i2]).tableChanged(this, n2, n3, n4, n5);
                if (n6 == 0) continue;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[5]);
        stringBuffer.append(z[7]).append(this.getRowCount());
        stringBuffer.append(z[6]).append(this.getColumnCount());
        stringBuffer.append(z[8]).append(this.m_rows.getMaximumRow());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0006hi:W+'l!^ \u007f%&Ieij;\u001a)bb.Vk";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block21: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block21;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block22;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 69;
                                break;
                            }
                            case 1: {
                                n9 = 7;
                                break;
                            }
                            case 2: {
                                n9 = 5;
                                break;
                            }
                            case 3: {
                                n9 = 79;
                                break;
                            }
                            default: {
                                n9 = 58;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0010in!U2i%,U)rh!\u001a+fh*\u0000e";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000bh%<O&o%,U)rh!\u0014";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0011fg#_efi=_$c|oR$t%,U)rh!\u001a2nq'\u001a+fh*\u001ag";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0006hi:W+'q6J 'a _6'k Nejd;Y-)";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0011fg#_\u001e";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "i'f V6:";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "7hr<\u0007";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "i'h.B7hrr";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\fif W5fq&X)b%.H\"rh*T1t";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    protected static class ColumnEntry {
        public int colnum;
        public Column column;
        public ColumnMetadata metadata;
        public Index index;

        public ColumnEntry(int n2, Column column, ColumnMetadata columnMetadata) {
            this.colnum = n2;
            this.column = column;
            this.metadata = columnMetadata;
            this.index = null;
        }

        public void dispose() {
            if (this.metadata != null) {
                this.metadata.dispose();
            }
            if (this.index != null) {
                this.index.dispose();
            }
        }
    }
}

