/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.Iterator;
import java.util.logging.Logger;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.SpanningTree;
import prefuse.data.Table;
import prefuse.util.PrefuseConfig;
import prefuse.util.collections.IntIterator;

public class Tree
extends Graph {
    private static final Logger l;
    public static final String DEFAULT_SOURCE_KEY;
    public static final String DEFAULT_TARGET_KEY;
    protected int m_root;
    protected static final String CHILDINDEX;
    protected static final Schema TREE_LINKS_SCHEMA;
    private static final String[] z;

    public Tree() {
        super(new Table(), false);
        this.m_root = -1;
    }

    public Tree(Table table, Table table2) {
        this(table, table2, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Tree(Table table, Table table2, String string, String string2) {
        this(table, table2, DEFAULT_NODE_KEY, string, string2);
    }

    public Tree(Table table, Table table2, String string, String string2, String string3) {
        int n2 = Table.e;
        super(table, table2, false, string, string2, string3);
        this.m_root = -1;
        IntIterator intIterator = table.rows();
        while (intIterator.hasNext()) {
            int n3 = intIterator.nextInt();
            if (this.getParent(n3) < 0) {
                this.m_root = n3;
                if (n2 == 0) break;
            }
            if (n2 == 0) continue;
        }
    }

    void a(Node node) {
        this.m_root = node.getRow();
    }

    @Override
    protected Table createLinkTable() {
        Table table = super.createLinkTable();
        table.addColumns(TREE_LINKS_SCHEMA);
        return table;
    }

    @Override
    protected void updateDegrees(int n2, int n3, int n4, int n5) {
        block6: {
            int n6;
            int n7;
            block5: {
                n7 = Table.e;
                super.updateDegrees(n2, n3, n4, n5);
                n6 = this.getOutDegree(n3);
                if (n5 <= 0) break block5;
                this.m_links.setInt(n4, CHILDINDEX, n6 - 1);
                if (n7 == 0) break block6;
            }
            if (n5 < 0) {
                int[] nArray = (int[])this.m_links.get(n3, z[0]);
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = this.getTargetNode(nArray[i2]);
                    this.m_links.setInt(n8, CHILDINDEX, i2);
                    if (n7 == 0) continue;
                }
                this.m_links.setInt(n4, CHILDINDEX, -1);
            }
        }
    }

    public int addRootRow() {
        if (this.getNodeCount() != 0) {
            throw new IllegalStateException(z[2]);
        }
        this.m_root = this.addNodeRow();
        return this.m_root;
    }

    public Node addRoot() {
        return this.getNode(this.addRootRow());
    }

    public int addChild(int n2) {
        int n3 = super.addNodeRow();
        this.addChildEdge(n2, n3);
        return n3;
    }

    public Node addChild(Node node) {
        this.nodeCheck(node, true);
        return this.getNode(this.addChild(node.getRow()));
    }

    public int addChildEdge(int n2, int n3) {
        return super.addEdge(n2, n3);
    }

    public Edge addChildEdge(Node node, Node node2) {
        this.nodeCheck(node, true);
        this.nodeCheck(node2, true);
        return this.getEdge(this.addChildEdge(node.getRow(), node2.getRow()));
    }

    public boolean removeChildEdge(int n2) {
        return this.removeChild(this.getTargetNode(n2));
    }

    public boolean removeChildEdge(Edge edge) {
        this.edgeCheck(edge, true);
        return this.removeChild(this.getTargetNode(edge.getRow()));
    }

    public boolean removeChild(int n2) {
        int n3 = Table.e;
        while (this.getChildCount(n2) > 0) {
            this.removeChild(this.getLastChildRow(n2));
            if (n3 == 0) continue;
        }
        return this.removeNode(n2);
    }

    public boolean removeChild(Node node) {
        this.nodeCheck(node, true);
        return this.removeChild(node.getRow());
    }

    public int getRootRow() {
        return this.m_root;
    }

    public Node getRoot() {
        return (Node)this.m_nodeTuples.getTuple(this.m_root);
    }

    public int getChildRow(int n2, int n3) {
        int n4 = this.getChildCount(n2);
        if (n3 < 0 || n3 >= n4) {
            return -1;
        }
        int[] nArray = (int[])this.m_links.get(n2, z[0]);
        return this.getTargetNode(nArray[n3]);
    }

    public Node getChild(Node node, int n2) {
        int n3 = this.getChildRow(node.getRow(), n2);
        return n3 < 0 ? null : this.getNode(n3);
    }

    public int getChildIndex(int n2, int n3) {
        if (this.getParent(n3) != n2) {
            return -1;
        }
        return this.m_links.getInt(n3, CHILDINDEX);
    }

    public int getChildIndex(Node node, Node node2) {
        return this.getChildIndex(node.getRow(), node2.getRow());
    }

    public int getFirstChildRow(int n2) {
        return this.getChildRow(n2, 0);
    }

    public Node getFirstChild(Node node) {
        return this.getChild(node, 0);
    }

    public int getLastChildRow(int n2) {
        return this.getChildRow(n2, this.getChildCount(n2) - 1);
    }

    public Node getLastChild(Node node) {
        return this.getChild(node, node.getChildCount() - 1);
    }

    public int getPreviousSiblingRow(int n2) {
        int n3 = this.getParent(n2);
        if (n3 < 0) {
            return -1;
        }
        int[] nArray = (int[])this.m_links.get(n3, z[0]);
        int n4 = this.m_links.getInt(n2, CHILDINDEX);
        return n4 <= 0 ? -1 : this.getTargetNode(nArray[n4 - 1]);
    }

    public Node getPreviousSibling(Node node) {
        int n2 = this.getPreviousSiblingRow(node.getRow());
        return n2 < 0 ? null : this.getNode(n2);
    }

    public int getNextSiblingRow(int n2) {
        int n3 = this.getParent(n2);
        if (n3 < 0) {
            return -1;
        }
        int[] nArray = (int[])this.m_links.get(n3, z[0]);
        int n4 = this.m_links.getInt(n2, CHILDINDEX);
        int n5 = this.getChildCount(n3) - 1;
        return n4 < 0 || n4 >= n5 ? -1 : this.getTargetNode(nArray[n4 + 1]);
    }

    public Node getNextSibling(Node node) {
        int n2 = this.getNextSiblingRow(node.getRow());
        return n2 < 0 ? null : this.getNode(n2);
    }

    public int getDepth(int n2) {
        int n3 = Table.e;
        if (!this.getNodeTable().isValidRow(n2)) {
            return -1;
        }
        int n4 = 0;
        if (n2 != this.m_root && this.getParent(n2) < 0) {
            return -1;
        }
        int n5 = n2;
        while (n5 != this.m_root && n5 >= 0) {
            ++n4;
            n5 = this.getParent(n5);
            if (n3 == 0) continue;
        }
        return n4;
    }

    public int getChildCount(int n2) {
        return this.getOutDegree(n2);
    }

    public int getParentEdge(int n2) {
        if (this.getInDegree(n2) > 0) {
            int[] nArray = (int[])this.m_links.get(n2, z[1]);
            return nArray[0];
        }
        return -1;
    }

    public Edge getParentEdge(Node node) {
        this.nodeCheck(node, true);
        int n2 = this.getParentEdge(node.getRow());
        return n2 < 0 ? null : this.getEdge(n2);
    }

    public int getParent(int n2) {
        int n3 = this.getParentEdge(n2);
        return n3 < 0 ? -1 : this.getSourceNode(n3);
    }

    public Node getParent(Node node) {
        int n2 = this.getParent(node.getRow());
        return n2 < 0 ? null : this.getNode(n2);
    }

    public IntIterator childEdgeRows(int n2) {
        return super.outEdgeRows(n2);
    }

    public Iterator childEdges(Node node) {
        return super.outEdges(node);
    }

    public Iterator children(Node node) {
        return super.outNeighbors(node);
    }

    public boolean isValidTree() {
        int n2;
        int n3 = Table.e;
        int n4 = this.getNodeCount();
        if (n4 != (n2 = this.getEdgeCount()) + 1) {
            l.warning(z[8]);
            return false;
        }
        int n5 = this.getRootRow();
        IntIterator intIterator = this.getNodeTable().rows();
        while (intIterator.hasNext()) {
            int n6 = intIterator.nextInt();
            int n7 = this.getInDegree(n6);
            if (n6 == n5 && n7 > 0) {
                l.warning(z[9]);
                return false;
            }
            if (n7 > 1) {
                l.warning(z[3] + n6 + z[5]);
                return false;
            }
            if (n3 == 0) continue;
        }
        int[] nArray = new int[]{0, n2};
        this.a(this.getRootRow(), nArray);
        if (nArray[0] > n2) {
            l.warning(z[7]);
            return false;
        }
        if (nArray[0] < n2) {
            l.warning(z[4] + nArray[0] + "/" + n2 + z[6]);
            return false;
        }
        return true;
    }

    private void a(int n2, int[] nArray) {
        int n3 = Table.e;
        IntIterator intIterator = this.childEdgeRows(n2);
        int n4 = 0;
        while (intIterator.hasNext()) {
            int n5 = intIterator.nextInt();
            ++n4;
            nArray[0] = nArray[0] + 1;
            int n6 = this.getAdjacentNode(n5, n2);
            this.a(n6, nArray);
            if (nArray[0] > nArray[1]) {
                return;
            }
            if (n3 == 0) continue;
        }
    }

    @Override
    public Tree getSpanningTree() {
        return this.m_spanning == null ? this : this.m_spanning;
    }

    @Override
    public Tree getSpanningTree(Node node) {
        block6: {
            block5: {
                this.nodeCheck(node, true);
                if (this.m_spanning != null) break block5;
                if (this.m_root == node.getRow()) {
                    return this;
                }
                this.m_spanning = new SpanningTree(this, node);
                if (Table.e == 0) break block6;
            }
            if (this.m_spanning.getRoot() != node) {
                this.m_spanning.buildSpanningTree(node);
            }
        }
        return this.m_spanning;
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "YPQ\u0004$bzW\t-~";
        int n3 = 9;
        block15: while (true) {
            switch (n3) {
                case 9: {
                    CHILDINDEX = Tree.z(Tree.z(string2));
                    string2 = "Y\\L\u0019$o]R\u001e";
                    n3 = -1;
                    continue block15;
                }
                default: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "YZW\u0001!hXJ";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "ERWM'h_@M)bW\u0019\fht\\V\u0019hh\\]\bhr\\\u0019\f&&VT\u001d<\u007f\u0013M\u001f-c";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "H\\]\bh";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "H\\MM)j_\u0019\u0002.&GQ\bhrA\\\bhqRJM>o@P\u0019-b\u001d\u0019\"&jJ\u0019";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "&[X\u001ehkFU\u0019!v_\\M8gA\\\u0003<u\u001d";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "&V]\n-u\u0013\\\u0003+iFW\u0019-tV]";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "R[\\M<tV\\M g@\u0019\u0003'h\u001eM\u001f-c\u0013\\\t/c@\u0019\u0004&&ZMC";
                    n3 = 6;
                    continue block15;
                }
                case 6: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "H\\]\bgcW^\bhe\\L\u0003<u\u0013P\u0003+iAK\b+r\u001d";
                    n3 = 7;
                    continue block15;
                }
                case 7: {
                    stringArray2[n2] = Tree.z(Tree.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "T\\V\u0019hh\\]\bhnRJM)&CX\u001f-hG\u0017";
                    n3 = 8;
                    continue block15;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = Tree.z(Tree.z(string2));
        z = stringArray3;
        l = Logger.getLogger(Tree.class.getName());
        String string3 = "bRM\ffrA\\\bfu\\L\u001f+cx\\\u0014";
        int n4 = -1;
        block16: while (true) {
            string = Tree.z(Tree.z(string3));
            switch (n4) {
                default: {
                    DEFAULT_SOURCE_KEY = PrefuseConfig.get(string);
                    string3 = "bRM\ffrA\\\bfrRK\n-rx\\\u0014";
                    n4 = 0;
                    continue block16;
                }
                case 0: 
            }
            break;
        }
        DEFAULT_TARGET_KEY = PrefuseConfig.get(string);
        TREE_LINKS_SCHEMA = new Schema();
        TREE_LINKS_SCHEMA.addColumn(CHILDINDEX, Integer.TYPE, new Integer(-1));
        TREE_LINKS_SCHEMA.lockSchema();
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x48);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 6;
                            break;
                        }
                        case 1: {
                            n7 = 51;
                            break;
                        }
                        case 2: {
                            n7 = 57;
                            break;
                        }
                        case 3: {
                            n7 = 109;
                            break;
                        }
                        default: {
                            n7 = 72;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

