/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ObjectParser;
import prefuse.data.parser.ParserFactory;
import prefuse.util.TypeLib;
import prefuse.util.collections.CopyOnWriteArrayList;

public abstract class AbstractColumn
implements Column {
    protected final Class m_columnType;
    protected DataParser m_parser;
    protected Object m_defaultValue;
    protected boolean m_readOnly;
    protected CopyOnWriteArrayList m_listeners;
    public static boolean a;
    private static final String[] z;

    public AbstractColumn() {
        this(Object.class, null);
    }

    public AbstractColumn(Class clazz) {
        this(clazz, null);
    }

    public AbstractColumn(Class clazz, Object object) {
        this.m_columnType = clazz;
        DataParser dataParser = ParserFactory.getDefaultFactory().getParser(clazz);
        this.m_parser = dataParser == null ? new ObjectParser() : dataParser;
        this.setDefaultValue(object);
        this.m_readOnly = false;
        this.m_listeners = new CopyOnWriteArrayList();
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.m_readOnly = bl;
    }

    @Override
    public boolean isCellEditable(int n2) {
        return !this.m_readOnly;
    }

    @Override
    public Class getColumnType() {
        return this.m_columnType;
    }

    @Override
    public DataParser getParser() {
        return this.m_parser;
    }

    @Override
    public void setParser(DataParser dataParser) {
        if (!this.m_columnType.isAssignableFrom(dataParser.getType())) {
            throw new IllegalArgumentException(z[1] + dataParser.getType().getName() + z[0] + z[2] + this.m_columnType.getName() + ")");
        }
        this.m_parser = dataParser;
    }

    @Override
    public void addColumnListener(ColumnListener columnListener) {
        this.m_listeners.add(columnListener);
    }

    @Override
    public void removeColumnListener(ColumnListener columnListener) {
        this.m_listeners.remove(columnListener);
    }

    protected final void fireColumnEvent(int n2, int n3, int n4) {
        boolean bl = a;
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged(this, n2, n3, n4);
            if (!bl) continue;
        }
    }

    protected final void fireColumnEvent(int n2, int n3) {
        boolean bl = a;
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, n3);
            if (!bl) continue;
        }
    }

    protected final void fireColumnEvent(int n2, long l2) {
        boolean bl = a;
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, l2);
            if (!bl) continue;
        }
    }

    protected final void fireColumnEvent(int n2, float f2) {
        boolean bl = a;
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, f2);
            if (!bl) continue;
        }
    }

    protected final void fireColumnEvent(int n2, double d2) {
        boolean bl = a;
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, d2);
            if (!bl) continue;
        }
    }

    protected final void fireColumnEvent(int n2, boolean bl) {
        boolean bl2 = a;
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, bl);
            if (!bl2) continue;
        }
    }

    protected final void fireColumnEvent(int n2, Object object) {
        boolean bl = a;
        Object[] objectArray = this.m_listeners.getArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ColumnListener)objectArray[i2]).columnChanged((Column)this, n2, object);
            if (!bl) continue;
        }
    }

    @Override
    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setDefaultValue(Object object) {
        boolean bl = this.m_columnType.isPrimitive();
        if (object != null && (!bl && !this.m_columnType.isInstance(object) || bl && !TypeLib.isWrapperInstance(this.m_columnType, object))) {
            throw new IllegalArgumentException(z[3] + this.m_columnType.getName());
        }
        this.m_defaultValue = object;
    }

    @Override
    public void revertToDefault(int n2) {
        this.set(this.m_defaultValue, n2);
    }

    @Override
    public boolean canGet(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            boolean bl = clazz.isAssignableFrom(this.m_columnType) || TypeLib.isNumericType(this.m_columnType) && TypeLib.isNumericType(clazz);
            return bl || clazz.isAssignableFrom(TypeLib.getWrapperType(this.m_columnType)) || clazz.isAssignableFrom(String.class);
        }
        return clazz.isAssignableFrom(this.m_columnType);
    }

    @Override
    public boolean canSet(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            return this.m_columnType.isAssignableFrom(clazz) || TypeLib.getWrapperType(this.m_columnType).isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
        }
        return this.m_columnType.isAssignableFrom(clazz);
    }

    @Override
    public boolean canGetInt() {
        return this.canGet(Integer.TYPE);
    }

    @Override
    public boolean canSetInt() {
        return this.canSet(Integer.TYPE);
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        if (this.canGetInt()) {
            return (Integer)this.get(n2);
        }
        throw new DataTypeException(Integer.TYPE);
    }

    @Override
    public void setInt(int n2, int n3) throws DataTypeException {
        block3: {
            block2: {
                if (!this.canSetInt()) break block2;
                this.set(new Integer(n2), n3);
                if (!a) break block3;
            }
            throw new DataTypeException(Integer.TYPE);
        }
    }

    @Override
    public boolean canGetLong() {
        return this.canGet(Long.TYPE);
    }

    @Override
    public boolean canSetLong() {
        return this.canSet(Long.TYPE);
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        if (this.canGetLong()) {
            return (Long)this.get(n2);
        }
        throw new DataTypeException(Long.TYPE);
    }

    @Override
    public void setLong(long l2, int n2) throws DataTypeException {
        block3: {
            block2: {
                if (!this.canSetLong()) break block2;
                this.set(new Long(l2), n2);
                if (!a) break block3;
            }
            throw new DataTypeException(Long.TYPE);
        }
    }

    @Override
    public boolean canGetFloat() {
        return this.canGet(Float.TYPE);
    }

    @Override
    public boolean canSetFloat() {
        return this.canSet(Float.TYPE);
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        if (this.canGetFloat()) {
            return ((Float)this.get(n2)).floatValue();
        }
        throw new DataTypeException(Float.TYPE);
    }

    @Override
    public void setFloat(float f2, int n2) throws DataTypeException {
        block3: {
            block2: {
                if (!this.canSetFloat()) break block2;
                this.set(new Float(f2), n2);
                if (!a) break block3;
            }
            throw new DataTypeException(Float.TYPE);
        }
    }

    @Override
    public boolean canGetDouble() {
        return this.canGet(Double.TYPE);
    }

    @Override
    public boolean canSetDouble() {
        return this.canSet(Double.TYPE);
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        if (this.canGetDouble()) {
            return (Double)this.get(n2);
        }
        throw new DataTypeException(Double.TYPE);
    }

    @Override
    public void setDouble(double d2, int n2) throws DataTypeException {
        block3: {
            block2: {
                if (!this.canSetDouble()) break block2;
                this.set(new Double(d2), n2);
                if (!a) break block3;
            }
            throw new DataTypeException(Double.TYPE);
        }
    }

    @Override
    public boolean canGetBoolean() {
        return this.canGet(Boolean.TYPE);
    }

    @Override
    public boolean canSetBoolean() {
        return this.canSet(Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(int n2) throws DataTypeException {
        if (this.canGetBoolean()) {
            return (Boolean)this.get(n2);
        }
        throw new DataTypeException(Boolean.TYPE);
    }

    @Override
    public void setBoolean(boolean bl, int n2) throws DataTypeException {
        block3: {
            block2: {
                if (!this.canSetBoolean()) break block2;
                this.set(new Boolean(bl), n2);
                if (!a) break block3;
            }
            throw new DataTypeException(Boolean.TYPE);
        }
    }

    @Override
    public boolean canGetString() {
        return true;
    }

    @Override
    public boolean canSetString() {
        return this.m_parser != null && !(this.m_parser instanceof ObjectParser);
    }

    @Override
    public String getString(int n2) throws DataTypeException {
        if (this.canGetString()) {
            return this.m_parser.format(this.get(n2));
        }
        throw new DataTypeException(String.class);
    }

    @Override
    public void setString(String string, int n2) throws DataTypeException {
        try {
            this.set(this.m_parser.parse(string), n2);
        }
        catch (DataParseException dataParseException) {
            throw new DataTypeException(dataParseException);
        }
    }

    @Override
    public boolean canGetDate() {
        return this.canGet(Date.class);
    }

    @Override
    public boolean canSetDate() {
        return this.canSet(Date.class);
    }

    @Override
    public Date getDate(int n2) throws DataTypeException {
        if (this.canGetDate()) {
            return (Date)this.get(n2);
        }
        throw new DataTypeException(Date.class);
    }

    @Override
    public void setDate(Date date, int n2) throws DataTypeException {
        this.set(date, n2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0019DzDF_\tcKQY\u0006\u007fO\u0005G\rgB";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 48;
                                break;
                            }
                            case 1: {
                                n9 = 100;
                                break;
                            }
                            case 2: {
                                n9 = 19;
                                break;
                            }
                            case 3: {
                                n9 = 42;
                                break;
                            }
                            default: {
                                n9 = 37;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "`\u0005aY@BDgSUUD;";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0010\u0010{CV\u0010\u0007|FP]\n4Y\u0005T\u0005gK\u0005D\u001dcO\u0005\u0018";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "t\u0001uKP\\\u00103\\D\\\u0011v\nLCD}EQ\u0010\u000bu\nQI\u0014v\n";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

