/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.data.Table;
import prefuse.data.column.BooleanColumn;
import prefuse.data.column.ByteColumn;
import prefuse.data.column.Column;
import prefuse.data.column.ConstantColumn;
import prefuse.data.column.DateColumn;
import prefuse.data.column.DoubleColumn;
import prefuse.data.column.ExpressionColumn;
import prefuse.data.column.FloatColumn;
import prefuse.data.column.IntColumn;
import prefuse.data.column.LongColumn;
import prefuse.data.column.ObjectColumn;
import prefuse.data.expression.Expression;

public class ColumnFactory {
    public static final Column getColumn(Class clazz) {
        return ColumnFactory.getColumn(clazz, 0, 0, null);
    }

    public static final Column getColumn(Class clazz, int n2) {
        return ColumnFactory.getColumn(clazz, n2, n2, null);
    }

    public static final Column getColumn(Class clazz, int n2, Object object) {
        return ColumnFactory.getColumn(clazz, n2, n2, object);
    }

    public static final Column getColumn(Class clazz, int n2, int n3, Object object) {
        if (clazz == Byte.TYPE) {
            if (object == null) {
                return new ByteColumn(n2);
            }
            byte by = ((Number)object).byteValue();
            return new ByteColumn(n2, n2, by);
        }
        if (clazz == Integer.TYPE) {
            if (object == null) {
                return new IntColumn(n2);
            }
            int n4 = ((Number)object).intValue();
            return new IntColumn(n2, n2, n4);
        }
        if (clazz == Long.TYPE) {
            if (object == null) {
                return new LongColumn(n2);
            }
            long l2 = ((Number)object).longValue();
            return new LongColumn(n2, n2, l2);
        }
        if (clazz == Float.TYPE) {
            if (object == null) {
                return new FloatColumn(n2);
            }
            float f2 = ((Number)object).floatValue();
            return new FloatColumn(n2, n2, f2);
        }
        if (clazz == Double.TYPE) {
            if (object == null) {
                return new DoubleColumn(n2);
            }
            double d2 = ((Number)object).doubleValue();
            return new DoubleColumn(n2, n2, d2);
        }
        if (clazz == Boolean.TYPE) {
            if (object == null) {
                return new BooleanColumn(n2);
            }
            boolean bl = (Boolean)object;
            return new BooleanColumn(n2, n2, bl);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            if (object == null) {
                return new DateColumn(clazz, n2);
            }
            Date date = (Date)object;
            return new DateColumn(clazz, n2, n2, date.getTime());
        }
        if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Void.TYPE) {
            throw new DataTypeException(clazz);
        }
        return new ObjectColumn(clazz, n2, n2, object);
    }

    public static final Column getColumn(Table table, Expression expression) {
        return new ExpressionColumn(table, expression);
    }

    public static final Column getConstantColumn(Class clazz, Object object) {
        return new ConstantColumn(clazz, object);
    }
}

