/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class FloatColumn
extends AbstractColumn {
    private float[] b;
    private int c;
    private static final String[] z;

    public FloatColumn() {
        this(0, 10, 0.0f);
    }

    public FloatColumn(int n2) {
        this(n2, n2, 0.0f);
    }

    public FloatColumn(int n2, int n3, float f2) {
        super(Float.TYPE, new Float(f2));
        if (n3 < n2) {
            throw new IllegalArgumentException(z[0]);
        }
        this.b = new float[n3];
        Arrays.fill(this.b, f2);
        this.c = n2;
    }

    @Override
    public int getRowCount() {
        return this.c;
    }

    @Override
    public void setMaximumRow(int n2) {
        if (n2 > this.b.length) {
            int n3 = Math.max(3 * this.b.length / 2 + 1, n2);
            float[] fArray = new float[n3];
            System.arraycopy(this.b, 0, fArray, 0, this.c);
            Arrays.fill(fArray, this.c, n3, ((Float)this.m_defaultValue).floatValue());
            this.b = fArray;
        }
        this.c = n2;
    }

    @Override
    public Object get(int n2) {
        return new Float(this.getFloat(n2));
    }

    @Override
    public void set(Object object, int n2) throws DataTypeException {
        block5: {
            block3: {
                block6: {
                    boolean bl;
                    block4: {
                        bl = AbstractColumn.a;
                        if (this.m_readOnly) {
                            throw new DataReadOnlyException();
                        }
                        if (object == null) break block3;
                        if (!(object instanceof Number)) break block4;
                        this.setFloat(((Number)object).floatValue(), n2);
                        if (!bl) break block5;
                    }
                    if (!(object instanceof String)) break block6;
                    this.setString((String)object, n2);
                    if (!bl) break block5;
                }
                throw new DataTypeException(object.getClass());
            }
            throw new DataTypeException(z[2]);
        }
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        if (n2 < 0 || n2 > this.c) {
            throw new IllegalArgumentException(z[1] + n2);
        }
        return this.b[n2];
    }

    @Override
    public void setFloat(float f2, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.c) {
            throw new IllegalArgumentException(z[1] + n2);
        }
        float f3 = this.b[n2];
        if (f3 == f2) {
            return;
        }
        this.b[n2] = f2;
        this.fireColumnEvent(n2, f3);
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        return (int)this.getFloat(n2);
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        return (long)this.getFloat(n2);
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        return this.getFloat(n2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "0)\u001c@d\u001a<\u0015\u0001q\u0012$\u0019D'\u0010)\u0002\u0001i\u001c<LCbS$\tRtS<\u0004@iS<\u0004D'\u0001'\u001b\u0001d\u001c=\u0002U)";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 115;
                                break;
                            }
                            case 1: {
                                n9 = 72;
                                break;
                            }
                            case 2: {
                                n9 = 108;
                                break;
                            }
                            case 3: {
                                n9 = 33;
                                break;
                            }
                            default: {
                                n9 = 7;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "!'\u001b\u0001n\u001d,\tY'\u001c=\u0018\u0001h\u0015h\u000eNr\u001d,\u001f\u001b'";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "0'\u0000Tj\u001dh\bNb\u0000h\u0002NsS)\u000fBb\u0003<LOr\u001f$LWf\u001f=\tR";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

