/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.BinaryExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.FunctionExpression;
import prefuse.util.TypeLib;

public class ArithmeticExpression
extends BinaryExpression {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int POW = 4;
    public static final int MOD = 5;
    private Class c = null;
    private static final String z;

    public ArithmeticExpression(int n2, Expression expression, Expression expression2) {
        super(n2, 0, 5, expression, expression2);
    }

    @Override
    public Class getType(Schema schema) {
        if (this.c == null) {
            Class clazz = this.m_left.getType(schema);
            Class clazz2 = this.m_right.getType(schema);
            this.c = TypeLib.getNumericType(clazz, clazz2);
        }
        return this.c;
    }

    @Override
    public Object get(Tuple tuple) {
        Class clazz = this.getType(tuple.getSchema());
        if (Integer.TYPE == clazz || Byte.TYPE == clazz) {
            return new Integer(this.getInt(tuple));
        }
        if (Long.TYPE == clazz) {
            return new Long(this.getInt(tuple));
        }
        if (Float.TYPE == clazz) {
            return new Float(this.getFloat(tuple));
        }
        if (Double.TYPE == clazz) {
            return new Double(this.getDouble(tuple));
        }
        throw new IllegalStateException();
    }

    @Override
    public int getInt(Tuple tuple) {
        int n2 = this.m_left.getInt(tuple);
        int n3 = this.m_right.getInt(tuple);
        switch (this.m_op) {
            case 0: {
                return n2 + n3;
            }
            case 1: {
                return n2 - n3;
            }
            case 2: {
                return n2 * n3;
            }
            case 3: {
                return n2 / n3;
            }
            case 4: {
                return (int)Math.pow(n2, n3);
            }
            case 5: {
                return n2 % n3;
            }
        }
        throw new IllegalStateException(z);
    }

    @Override
    public long getLong(Tuple tuple) {
        long l2 = this.m_left.getLong(tuple);
        long l3 = this.m_right.getLong(tuple);
        switch (this.m_op) {
            case 0: {
                return l2 + l3;
            }
            case 1: {
                return l2 - l3;
            }
            case 2: {
                return l2 * l3;
            }
            case 3: {
                return l2 / l3;
            }
            case 4: {
                return (long)Math.pow(l2, l3);
            }
            case 5: {
                return l2 % l3;
            }
        }
        throw new IllegalStateException(z);
    }

    @Override
    public float getFloat(Tuple tuple) {
        float f2 = this.m_left.getFloat(tuple);
        float f3 = this.m_right.getFloat(tuple);
        switch (this.m_op) {
            case 0: {
                return f2 + f3;
            }
            case 1: {
                return f2 - f3;
            }
            case 2: {
                return f2 * f3;
            }
            case 3: {
                return f2 / f3;
            }
            case 4: {
                return (float)Math.pow(f2, f3);
            }
            case 5: {
                return (float)Math.IEEEremainder(f2, f3);
            }
        }
        throw new IllegalStateException(z);
    }

    @Override
    public double getDouble(Tuple tuple) {
        double d2 = this.m_left.getDouble(tuple);
        double d3 = this.m_right.getDouble(tuple);
        switch (this.m_op) {
            case 0: {
                return d2 + d3;
            }
            case 1: {
                return d2 - d3;
            }
            case 2: {
                return d2 * d3;
            }
            case 3: {
                return d2 / d3;
            }
            case 4: {
                return Math.pow(d2, d3);
            }
            case 5: {
                return Math.IEEEremainder(d2, d3);
            }
        }
        throw new IllegalStateException(z);
    }

    public String toString() {
        int n2 = FunctionExpression.c;
        char c2 = '?';
        switch (this.m_op) {
            case 0: {
                c2 = '+';
                if (n2 == 0) break;
            }
            case 1: {
                c2 = '-';
                if (n2 == 0) break;
            }
            case 2: {
                c2 = '*';
                if (n2 == 0) break;
            }
            case 3: {
                c2 = '/';
                if (n2 == 0) break;
            }
            case 4: {
                c2 = '^';
                if (n2 == 0) break;
            }
            case 5: {
                c2 = '%';
            }
        }
        return '(' + this.m_left.toString() + ' ' + c2 + ' ' + this.m_right.toString() + ')';
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "y5nk%[5%j:I)dq#C5%q3\\>+".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 44;
                            break;
                        }
                        case 1: {
                            n7 = 91;
                            break;
                        }
                        case 2: {
                            n7 = 5;
                            break;
                        }
                        case 3: {
                            n7 = 5;
                            break;
                        }
                        default: {
                            n7 = 74;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }
}

