/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.Literal;
import prefuse.data.expression.Predicate;

public class BooleanLiteral
extends Literal
implements Predicate {
    public static final BooleanLiteral TRUE = new BooleanLiteral(true);
    public static final BooleanLiteral FALSE = new BooleanLiteral(false);
    private final boolean c;

    public BooleanLiteral(boolean bl) {
        this.c = bl;
    }

    @Override
    public boolean getBoolean(Tuple tuple) {
        return this.c;
    }

    @Override
    public Class getType(Schema schema) {
        return Boolean.TYPE;
    }

    @Override
    public Object get(Tuple tuple) {
        return this.getBoolean(tuple) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        return String.valueOf(this.c).toUpperCase();
    }
}

