/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableWriter;
import prefuse.data.io.DataIOException;
import prefuse.util.collections.IntIterator;

public class DelimitedTextTableWriter
extends AbstractTableWriter {
    private String a;
    private boolean b;

    public DelimitedTextTableWriter() {
        this("\t");
    }

    public DelimitedTextTableWriter(String string) {
        this(string, true);
    }

    public DelimitedTextTableWriter(String string, boolean bl) {
        this.a = string;
        this.b = bl;
    }

    public String getDelimiter() {
        return this.a;
    }

    public void setDelimeter(String string) {
        this.a = string;
    }

    public boolean isPrintHeader() {
        return this.b;
    }

    public void setPrintHeader(boolean bl) {
        this.b = bl;
    }

    @Override
    public void writeTable(Table table, OutputStream outputStream) throws DataIOException {
        int n2 = DataIOException.a;
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(outputStream));
            if (this.b) {
                for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                    if (i2 > 0) {
                        printStream.print(this.a);
                    }
                    printStream.print(table.getColumnName(i2));
                    if (n2 == 0) continue;
                }
                printStream.println();
            }
            IntIterator intIterator = table.rows();
            while (intIterator.hasNext()) {
                int n3 = intIterator.nextInt();
                for (int i3 = 0; i3 < table.getColumnCount(); ++i3) {
                    if (i3 > 0) {
                        printStream.print(this.a);
                    }
                    printStream.print(table.getString(n3, table.getColumnName(i3)));
                    if (n2 == 0) continue;
                }
                printStream.println();
                if (n2 == 0) continue;
            }
            printStream.flush();
        }
        catch (Exception exception) {
            throw new DataIOException(exception);
        }
    }
}

