/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.io.AbstractGraphReader;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphReader;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ParserFactory;
import prefuse.util.collections.IntIterator;

public class GraphMLReader
extends AbstractGraphReader
implements GraphReader {
    @Override
    public Graph readGraph(InputStream inputStream) throws DataIOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            GraphMLHandler graphMLHandler = new GraphMLHandler();
            sAXParser.parse(inputStream, (DefaultHandler)graphMLHandler);
            return graphMLHandler.getGraph();
        }
        catch (Exception exception) {
            if (exception instanceof DataIOException) {
                throw (DataIOException)exception;
            }
            throw new DataIOException(exception);
        }
    }

    public static class GraphMLHandler
    extends DefaultHandler
    implements Tokens {
        protected ParserFactory m_pf = ParserFactory.getDefaultFactory();
        protected static final String SRC;
        protected static final String TRG;
        protected static final String SRCID;
        protected static final String TRGID;
        protected Schema m_nsch = new Schema();
        protected Schema m_esch = new Schema();
        protected String m_graphid;
        protected Graph m_graph = null;
        protected Table m_nodes;
        protected Table m_edges;
        protected String m_id;
        protected String m_for;
        protected String m_name;
        protected String m_type;
        protected String m_dflt;
        protected StringBuffer m_sbuf = new StringBuffer();
        private String a;
        private int b = -1;
        private Table c = null;
        protected HashMap m_nodeMap = new HashMap();
        protected HashMap m_idMap = new HashMap();
        private boolean d = false;
        private boolean e;
        private static final String[] z;

        @Override
        public void startDocument() {
            this.m_nodeMap.clear();
            this.e = true;
            this.m_esch.addColumn(SRC, Integer.TYPE);
            this.m_esch.addColumn(TRG, Integer.TYPE);
            this.m_esch.addColumn(SRCID, String.class);
            this.m_esch.addColumn(TRGID, String.class);
        }

        @Override
        public void endDocument() throws SAXException {
            int n2 = DataIOException.a;
            IntIterator intIterator = this.m_edges.rows();
            while (intIterator.hasNext()) {
                int n3 = intIterator.nextInt();
                String string = this.m_edges.getString(n3, SRCID);
                if (!this.m_nodeMap.containsKey(string)) {
                    throw new SAXException(z[21] + string + z[19]);
                }
                int n4 = (Integer)this.m_nodeMap.get(string);
                this.m_edges.setInt(n3, SRC, n4);
                String string2 = this.m_edges.getString(n3, TRGID);
                if (!this.m_nodeMap.containsKey(string2)) {
                    throw new SAXException(z[22] + string2 + z[19]);
                }
                int n5 = (Integer)this.m_nodeMap.get(string2);
                this.m_edges.setInt(n3, TRG, n5);
                if (n2 == 0) continue;
            }
            this.m_edges.removeColumn(SRCID);
            this.m_edges.removeColumn(TRGID);
            this.m_graph = new Graph(this.m_nodes, this.m_edges, this.d);
            if (this.m_graphid != null) {
                this.m_graph.putClientProperty(z[20], this.m_graphid);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            block6: {
                block9: {
                    int n2;
                    block8: {
                        String string4;
                        block7: {
                            block5: {
                                n2 = DataIOException.a;
                                this.m_sbuf.delete(0, this.m_sbuf.length());
                                if (!string3.equals(z[24])) break block5;
                                string4 = attributes.getValue(z[25]);
                                this.d = z[29].equalsIgnoreCase(string4);
                                this.m_graphid = attributes.getValue(z[20]);
                                if (n2 == 0) break block6;
                            }
                            if (!string3.equals(z[1])) break block7;
                            if (!this.e) {
                                this.error(z[28]);
                            }
                            this.m_for = attributes.getValue(z[26]);
                            this.m_id = attributes.getValue(z[20]);
                            this.m_name = attributes.getValue(z[27]);
                            this.m_type = attributes.getValue(z[23]);
                            if (n2 == 0) break block6;
                        }
                        if (!string3.equals(z[2])) break block8;
                        this.schemaCheck();
                        this.b = this.m_nodes.addRow();
                        string4 = attributes.getValue(z[20]);
                        this.m_nodeMap.put(string4, new Integer(this.b));
                        this.c = this.m_nodes;
                        if (n2 == 0) break block6;
                    }
                    if (!string3.equals(z[4])) break block9;
                    this.schemaCheck();
                    this.b = this.m_edges.addRow();
                    this.m_edges.setString(this.b, SRCID, attributes.getValue(SRC));
                    this.m_edges.setString(this.b, TRGID, attributes.getValue(TRG));
                    this.c = this.m_edges;
                    if (n2 == 0) break block6;
                }
                if (string3.equals(z[0])) {
                    this.a = attributes.getValue(z[1]);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            block7: {
                block9: {
                    int n2;
                    block8: {
                        block6: {
                            n2 = DataIOException.a;
                            if (!string3.equals(z[3])) break block6;
                            this.m_dflt = this.m_sbuf.toString();
                            if (n2 == 0) break block7;
                        }
                        if (!string3.equals(z[1])) break block8;
                        this.addToSchema();
                        if (n2 == 0) break block7;
                    }
                    if (!string3.equals(z[0])) break block9;
                    String string4 = this.m_sbuf.toString();
                    String string5 = (String)this.m_idMap.get(this.a);
                    Class clazz = this.c.getColumnType(string5);
                    try {
                        Object object = this.parse(string4, clazz);
                        this.c.set(this.b, string5, object);
                    }
                    catch (DataParseException dataParseException) {
                        this.error(dataParseException);
                    }
                    if (n2 == 0) break block7;
                }
                if (string3.equals(z[2]) || string3.equals(z[4])) {
                    this.b = -1;
                    this.c = null;
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            this.m_sbuf.append(cArray, n2, n3);
        }

        protected void schemaCheck() {
            if (this.e) {
                this.m_nsch.lockSchema();
                this.m_esch.lockSchema();
                this.m_nodes = this.m_nsch.instantiate();
                this.m_edges = this.m_esch.instantiate();
                this.e = false;
            }
        }

        protected void addToSchema() {
            int n2 = DataIOException.a;
            if (this.m_name == null || this.m_name.length() == 0) {
                this.error(z[15]);
            }
            if (this.m_type == null || this.m_type.length() == 0) {
                this.error(z[18]);
            }
            try {
                block8: {
                    block10: {
                        Object object;
                        Class clazz;
                        block9: {
                            block7: {
                                clazz = this.parseType(this.m_type);
                                Object object2 = object = this.m_dflt == null ? null : this.parse(this.m_dflt, clazz);
                                if (this.m_for != null && !this.m_for.equals(z[17])) break block7;
                                this.m_nsch.addColumn(this.m_name, clazz, object);
                                this.m_esch.addColumn(this.m_name, clazz, object);
                                if (n2 == 0) break block8;
                            }
                            if (!this.m_for.equals(z[2])) break block9;
                            this.m_nsch.addColumn(this.m_name, clazz, object);
                            if (n2 == 0) break block8;
                        }
                        if (!this.m_for.equals(z[4])) break block10;
                        this.m_esch.addColumn(this.m_name, clazz, object);
                        if (n2 == 0) break block8;
                    }
                    this.error(z[16] + this.m_for);
                }
                this.m_idMap.put(this.m_id, this.m_name);
                this.m_dflt = null;
            }
            catch (DataParseException dataParseException) {
                this.error(dataParseException);
            }
        }

        protected Class parseType(String string) {
            if ((string = string.toLowerCase()).equals(z[11]) || string.equals(z[6])) {
                return Integer.TYPE;
            }
            if (string.equals(z[5])) {
                return Long.TYPE;
            }
            if (string.equals(z[9])) {
                return Float.TYPE;
            }
            if (string.equals(z[7]) || string.equals(z[12])) {
                return Double.TYPE;
            }
            if (string.equals(z[13])) {
                return Boolean.TYPE;
            }
            if (string.equals(z[14])) {
                return String.class;
            }
            if (string.equals(z[8])) {
                return Date.class;
            }
            this.error(z[10] + string);
            return null;
        }

        protected Object parse(String string, Class clazz) throws DataParseException {
            DataParser dataParser = this.m_pf.getParser(clazz);
            return dataParser.parse(string);
        }

        public Graph getGraph() {
            return this.m_graph;
        }

        protected void error(String string) {
            throw new RuntimeException(string);
        }

        protected void error(Exception exception) {
            throw new RuntimeException(exception);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[30];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "et\u0003q";
            int n3 = -1;
            block37: while (true) {
                char[] cArray;
                block42: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block41: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block41;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block42;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 1;
                                    break;
                                }
                                case 1: {
                                    n9 = 21;
                                    break;
                                }
                                case 2: {
                                    n9 = 119;
                                    break;
                                }
                                case 3: {
                                    n9 = 16;
                                    break;
                                }
                                default: {
                                    n9 = 49;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "jp\u000e";
                        n3 = 0;
                        continue block37;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "oz\u0013u";
                        n3 = 1;
                        continue block37;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "ep\u0011qDma";
                        n3 = 2;
                        continue block37;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "dq\u0010u";
                        n3 = 3;
                        continue block37;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "mz\u0019w";
                        n3 = 4;
                        continue block37;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "h{\u0003uVdg";
                        n3 = 5;
                        continue block37;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "ez\u0002r]d";
                        n3 = 6;
                        continue block37;
                    }
                    case 6: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = "et\u0003u";
                        n3 = 7;
                        continue block37;
                    }
                    case 7: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 9;
                        string2 = "gy\u0018qE";
                        n3 = 8;
                        continue block37;
                    }
                    case 8: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 10;
                        string2 = "T{\u0005uRnr\u0019yKdqWtPutWdHqpM0";
                        n3 = 9;
                        continue block37;
                    }
                    case 9: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 11;
                        string2 = "h{\u0003";
                        n3 = 10;
                        continue block37;
                    }
                    case 10: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 12;
                        string2 = "sp\u0016|";
                        n3 = 11;
                        continue block37;
                    }
                    case 11: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 13;
                        string2 = "cz\u0018|T`{";
                        n3 = 12;
                        continue block37;
                    }
                    case 12: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 14;
                        string2 = "ra\u0005y_f";
                        n3 = 13;
                        continue block37;
                    }
                    case 13: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 15;
                        string2 = "Dx\u0007dH!~\u0012i\u0011ot\u001au\u001f";
                        n3 = 14;
                        continue block37;
                    }
                    case 14: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 16;
                        string2 = "T{\u0005uRnr\u0019yKdqW2WngU0G`y\u0002u\u000b!";
                        n3 = 15;
                        continue block37;
                    }
                    case 15: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 17;
                        string2 = "`y\u001b";
                        n3 = 16;
                        continue block37;
                    }
                    case 16: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 18;
                        string2 = "Dx\u0007dH!~\u0012i\u0011ul\u0007u\u001f";
                        n3 = 17;
                        continue block37;
                    }
                    case 17: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 19;
                        string2 = "!b\u001fyRi5\u0013\u007fTr5\u0019\u007fE!p\u000fyBu;";
                        n3 = 18;
                        continue block37;
                    }
                    case 18: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 20;
                        string2 = "hq";
                        n3 = 19;
                        continue block37;
                    }
                    case 19: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 21;
                        string2 = "Ug\u001euU!a\u00180Rsp\u0016dT!p\u0013wT!b\u001edY!f\u0018eCbpW~^epWyU<";
                        n3 = 20;
                        continue block37;
                    }
                    case 20: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 22;
                        string2 = "Ug\u001euU!a\u00180Rsp\u0016dT!p\u0013wT!b\u001edY!a\u0016bVdaW~^epWyU<";
                        n3 = 21;
                        continue block37;
                    }
                    case 21: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 23;
                        string2 = "`a\u0003b\u001ful\u0007u";
                        n3 = 22;
                        continue block37;
                    }
                    case 22: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 24;
                        string2 = "fg\u0016`Y";
                        n3 = 23;
                        continue block37;
                    }
                    case 23: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 25;
                        string2 = "dq\u0010uUds\u0016e]u";
                        n3 = 24;
                        continue block37;
                    }
                    case 24: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 26;
                        string2 = "gz\u0005";
                        n3 = 25;
                        continue block37;
                    }
                    case 25: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 27;
                        string2 = "`a\u0003b\u001fot\u001au";
                        n3 = 26;
                        continue block37;
                    }
                    case 26: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 28;
                        string2 = "#~\u0012i\u0013!p\u001bu\\d{\u0003c\u0011bt\u00190_naW\u007fRb`\u00050Pga\u0012b\u0011u}\u00120Whg\u0004d\u0011oz\u0013u\u0011ngWuUfpWtTby\u0016bPu|\u0018~\u001f";
                        n3 = 27;
                        continue block37;
                    }
                    case 27: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 29;
                        string2 = "e|\u0005uRup\u0013";
                        n3 = 28;
                        continue block37;
                    }
                    case 28: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
            SRC = Graph.DEFAULT_SOURCE_KEY;
            TRG = Graph.DEFAULT_TARGET_KEY;
            SRCID = SRC + '_' + z[20];
            TRGID = TRG + '_' + z[20];
        }
    }

    public static interface Tokens {
        public static final String ID;
        public static final String GRAPH;
        public static final String EDGEDEF;
        public static final String DIRECTED;
        public static final String UNDIRECTED;
        public static final String KEY;
        public static final String FOR;
        public static final String ALL;
        public static final String ATTRNAME;
        public static final String ATTRTYPE;
        public static final String DEFAULT;
        public static final String NODE;
        public static final String EDGE;
        public static final String SOURCE;
        public static final String TARGET;
        public static final String DATA;
        public static final String TYPE;
        public static final String INT;
        public static final String INTEGER;
        public static final String LONG;
        public static final String FLOAT;
        public static final String DOUBLE;
        public static final String REAL;
        public static final String BOOLEAN;
        public static final String STRING;
        public static final String DATE;

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String string2 = "`\u000e&j5o\u001b?}";
            int n2 = -1;
            block33: while (true) {
                char[] cArray;
                block38: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block37: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block37;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block38;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 1;
                                    break;
                                }
                                case 1: {
                                    n8 = 122;
                                    break;
                                }
                                case 2: {
                                    n8 = 82;
                                    break;
                                }
                                case 3: {
                                    n8 = 24;
                                    break;
                                }
                                default: {
                                    n8 = 27;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        ATTRNAME = string.intern();
                        string2 = "r\u0015'jxd";
                        n2 = 0;
                        continue block33;
                    }
                    case 0: {
                        SOURCE = string.intern();
                        string2 = "s\u001f3t";
                        n2 = 1;
                        continue block33;
                    }
                    case 1: {
                        REAL = string.intern();
                        string2 = "e\u001f4ynm\u000e";
                        n2 = 2;
                        continue block33;
                    }
                    case 2: {
                        DEFAULT = string.intern();
                        string2 = "u\u0003\"}";
                        n2 = 3;
                        continue block33;
                    }
                    case 3: {
                        TYPE = string.intern();
                        string2 = "r\u000e quf";
                        n2 = 4;
                        continue block33;
                    }
                    case 4: {
                        STRING = string.intern();
                        string2 = "e\u0013 }xu\u001f6";
                        n2 = 5;
                        continue block33;
                    }
                    case 5: {
                        DIRECTED = string.intern();
                        string2 = "u\u001b \u007f~u";
                        n2 = 6;
                        continue block33;
                    }
                    case 6: {
                        TARGET = string.intern();
                        string2 = "c\u0015=t~`\u0014";
                        n2 = 7;
                        continue block33;
                    }
                    case 7: {
                        BOOLEAN = string.intern();
                        string2 = "d\u001e5}";
                        n2 = 8;
                        continue block33;
                    }
                    case 8: {
                        EDGE = string.intern();
                        string2 = "h\u0014&}|d\b";
                        n2 = 9;
                        continue block33;
                    }
                    case 9: {
                        INTEGER = string.intern();
                        string2 = "h\u0014&";
                        n2 = 10;
                        continue block33;
                    }
                    case 10: {
                        INT = string.intern();
                        string2 = "d\u001e5}\u007fd\u001c3mwu";
                        n2 = 11;
                        continue block33;
                    }
                    case 11: {
                        EDGEDEF = string.intern();
                        string2 = "f\b3hs";
                        n2 = 12;
                        continue block33;
                    }
                    case 12: {
                        GRAPH = string.intern();
                        string2 = "o\u00156}";
                        n2 = 13;
                        continue block33;
                    }
                    case 13: {
                        NODE = string.intern();
                        string2 = "e\u001b&}";
                        n2 = 14;
                        continue block33;
                    }
                    case 14: {
                        DATE = string.intern();
                        string2 = "m\u0015<\u007f";
                        n2 = 15;
                        continue block33;
                    }
                    case 15: {
                        LONG = string.intern();
                        string2 = "j\u001f+";
                        n2 = 16;
                        continue block33;
                    }
                    case 16: {
                        KEY = string.intern();
                        string2 = "h\u001e";
                        n2 = 17;
                        continue block33;
                    }
                    case 17: {
                        ID = string.intern();
                        string2 = "g\u0015 ";
                        n2 = 18;
                        continue block33;
                    }
                    case 18: {
                        FOR = string.intern();
                        string2 = "`\u0016>";
                        n2 = 19;
                        continue block33;
                    }
                    case 19: {
                        ALL = string.intern();
                        string2 = "e\u0015'zwd";
                        n2 = 20;
                        continue block33;
                    }
                    case 20: {
                        DOUBLE = string.intern();
                        string2 = "t\u00146qid\u0019&}\u007f";
                        n2 = 21;
                        continue block33;
                    }
                    case 21: {
                        UNDIRECTED = string.intern();
                        string2 = "g\u0016=yo";
                        n2 = 22;
                        continue block33;
                    }
                    case 22: {
                        FLOAT = string.intern();
                        string2 = "e\u001b&y";
                        n2 = 23;
                        continue block33;
                    }
                    case 23: {
                        DATA = string.intern();
                        string2 = "`\u000e&j5u\u0003\"}";
                        n2 = 24;
                        continue block33;
                    }
                    case 24: 
                }
                break;
            }
            ATTRTYPE = string.intern();
        }
    }
}

