/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.io.DataIOException;
import prefuse.data.io.sql.DataSourceWorker;
import prefuse.data.io.sql.SQLDataHandler;
import prefuse.data.util.Index;

public class DatabaseDataSource {
    private static final Logger a;
    protected Connection m_conn;
    protected Statement m_stmt;
    protected SQLDataHandler m_handler;
    private static final String[] z;

    DatabaseDataSource(Connection connection, SQLDataHandler sQLDataHandler) {
        this.m_conn = connection;
        this.m_handler = sQLDataHandler;
    }

    public synchronized Table getData(String string) throws DataIOException {
        return this.getData(null, string, null);
    }

    public synchronized Table getData(String string, String string2) throws DataIOException {
        return this.getData(null, string, string2);
    }

    public synchronized Table getData(Table table, String string) throws DataIOException {
        return this.getData(table, string, null);
    }

    public synchronized Table getData(Table table, String string, String string2) throws DataIOException {
        return this.getData(table, string, string2, null);
    }

    public synchronized Table getData(Table table, String string, String string2, Object object) throws DataIOException {
        ResultSet resultSet;
        try {
            resultSet = this.a(string);
        }
        catch (SQLException sQLException) {
            throw new DataIOException(sQLException);
        }
        return this.process(table, resultSet, string2, object);
    }

    public void loadData(Table table, String string) {
        this.loadData(table, string, null, null, null);
    }

    public void loadData(Table table, String string, String string2) {
        this.loadData(table, string, string2, null, null);
    }

    public void loadData(Table table, String string, Object object) {
        this.loadData(table, string, null, object, null);
    }

    public void loadData(Table table, String string, String string2, Object object) {
        this.loadData(table, string, string2, object, null);
    }

    public void loadData(Table table, String string, String string2, Object object, DataSourceWorker.Listener listener) {
        DataSourceWorker.Entry entry = new DataSourceWorker.Entry(this, table, string, string2, object, listener);
        DataSourceWorker.submit(entry);
    }

    private ResultSet a(String string) throws SQLException {
        if (this.m_stmt == null) {
            this.m_stmt = this.m_conn.createStatement();
        }
        long l2 = System.currentTimeMillis();
        a.info(z[0] + string);
        ResultSet resultSet = this.m_stmt.executeQuery(string);
        long l3 = System.currentTimeMillis() - l2;
        a.info(z[1] + l3 / 1000L + "." + l3 % 1000L + z[2]);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Table process(Table table, ResultSet resultSet, String string, Object object) throws DataIOException {
        int n2 = DataSourceWorker.Entry.g;
        int n3 = 0;
        long l2 = System.currentTimeMillis();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n4 = resultSetMetaData.getColumnCount();
            if (table == null) {
                table = this.getSchema(resultSetMetaData, this.m_handler).instantiate();
                if (string != null) {
                    try {
                        table.index(string);
                        a.info(z[3] + string);
                    }
                    catch (Exception exception) {
                        a.warning(z[6] + string);
                    }
                }
            }
            Object object2 = object = object == null ? table : object;
            while (resultSet.next()) {
                Object object3 = object;
                synchronized (object3) {
                    int n5 = this.getExistingRow(table, resultSet, string);
                    if (n5 < 0) {
                        n5 = table.addRow();
                    }
                    for (int i2 = 1; i2 <= n4; ++i2) {
                        this.m_handler.process(table, n5, resultSet, i2);
                        if (n2 == 0) continue;
                        AbstractExpression.b = !AbstractExpression.b;
                        break;
                    }
                }
                ++n3;
                if (n2 == 0) continue;
                break;
            }
        }
        catch (SQLException sQLException) {
            throw new DataIOException(sQLException);
        }
        long l3 = System.currentTimeMillis() - l2;
        a.info(z[4] + n3 + z[5] + l3 / 1000L + "." + l3 % 1000L + z[2]);
        return table;
    }

    protected int getExistingRow(Table table, ResultSet resultSet, String string) throws SQLException {
        if (string == null) {
            return -1;
        }
        Class clazz = table.getColumnType(string);
        if (clazz == null) {
            return -1;
        }
        Index index = table.index(string);
        if (clazz == Integer.TYPE) {
            return index.get(resultSet.getInt(string));
        }
        if (clazz == Long.TYPE) {
            return index.get(resultSet.getLong(string));
        }
        if (clazz == Float.TYPE) {
            return index.get(resultSet.getFloat(string));
        }
        if (clazz == Double.TYPE) {
            return index.get(resultSet.getDouble(string));
        }
        if (!clazz.isPrimitive()) {
            return index.get(resultSet.getObject(string));
        }
        return -1;
    }

    public Schema getSchema(ResultSetMetaData resultSetMetaData, SQLDataHandler sQLDataHandler) throws SQLException {
        int n2 = DataSourceWorker.Entry.g;
        int n3 = resultSetMetaData.getColumnCount();
        Schema schema = new Schema(n3);
        for (int i2 = 1; i2 <= n3; ++i2) {
            int n4;
            String string = resultSetMetaData.getColumnName(i2);
            Class clazz = sQLDataHandler.getDataType(string, n4 = resultSetMetaData.getColumnType(i2));
            if (clazz == null) continue;
            schema.addColumn(string, clazz);
            if (n2 == 0) continue;
        }
        return schema;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\r\u001fJ+t*\u000b\u0019/h!\u001e@d=";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block18;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 68;
                                break;
                            }
                            case 1: {
                                n9 = 108;
                                break;
                            }
                            case 2: {
                                n9 = 57;
                                break;
                            }
                            case 3: {
                                n9 = 94;
                                break;
                            }
                            default: {
                                n9 = 29;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0001\u0014M;o*\rU~l1\tK'=4\u001eV=x7\u001fP0zd\u000fV3m(\tM;y~L";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "d\u001f\\=r*\bJp";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\r\u0002];e!\b\u00198t!\u0000]d=";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\r\u0002M;o*\rU~l1\tK'=4\u001eV=x7\u001fP0zd\u000fV3m(\tM;y~L";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "d\u001eV)nhL";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0001\u001eK1od\u0005W:x<\u0005W9=\"\u0005\\2y~L";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        a = Logger.getLogger(DatabaseDataSource.class.getName());
    }
}

