/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import prefuse.data.Table;
import prefuse.data.io.sql.DataSourceWorker;
import prefuse.data.io.sql.SQLDataHandler;

public class DefaultSQLDataHandler
implements SQLDataHandler {
    private boolean a;

    public DefaultSQLDataHandler() {
        this(true);
    }

    public DefaultSQLDataHandler(boolean bl) {
        this.a = bl;
    }

    public void setIgnoreUnknownTypes(boolean bl) {
        this.a = bl;
    }

    public boolean isIgnoreUnknownTypes() {
        return this.a;
    }

    @Override
    public void process(Table table, int n2, ResultSet resultSet, int n3) throws SQLException {
        int n4 = DataSourceWorker.Entry.g;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        String string = resultSetMetaData.getColumnName(n3);
        int n5 = resultSetMetaData.getColumnType(n3);
        switch (n5) {
            case 2003: {
                table.set(n2, string, (Object)resultSet.getArray(n3));
                if (n4 == 0) break;
            }
            case -5: {
                table.setLong(n2, string, resultSet.getLong(n3));
                if (n4 == 0) break;
            }
            case -4: 
            case -3: 
            case -2: {
                table.set(n2, string, (Object)resultSet.getBytes(n3));
                if (n4 == 0) break;
            }
            case -7: 
            case 16: {
                table.setBoolean(n2, string, resultSet.getBoolean(n3));
                if (n4 == 0) break;
            }
            case 2004: {
                table.set(n2, string, (Object)resultSet.getBlob(n3));
                if (n4 == 0) break;
            }
            case -1: 
            case 1: 
            case 12: {
                table.setString(n2, string, resultSet.getString(n3));
                if (n4 == 0) break;
            }
            case 2005: {
                table.set(n2, string, (Object)resultSet.getClob(n3));
                if (n4 == 0) break;
            }
            case 91: {
                table.setDate(n2, string, (java.util.Date)resultSet.getDate(n3));
                if (n4 == 0) break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                table.setDouble(n2, string, resultSet.getDouble(n3));
                if (n4 == 0) break;
            }
            case -6: 
            case 4: 
            case 5: {
                table.setInt(n2, string, resultSet.getInt(n3));
                if (n4 == 0) break;
            }
            case 2000: {
                table.set(n2, string, resultSet.getObject(n3));
                if (n4 == 0) break;
            }
            case 7: {
                table.setFloat(n2, string, resultSet.getFloat(n3));
                if (n4 == 0) break;
            }
            case 2006: {
                table.set(n2, string, (Object)resultSet.getRef(n3));
                if (n4 == 0) break;
            }
            case 92: {
                table.setDate(n2, string, (java.util.Date)resultSet.getTime(n3));
                if (n4 == 0) break;
            }
            case 93: {
                table.setDate(n2, string, (java.util.Date)resultSet.getTimestamp(n3));
                if (n4 == 0) break;
            }
            default: {
                if (this.a) break;
                table.set(n2, string, resultSet.getObject(n3));
            }
        }
    }

    @Override
    public Class getDataType(String string, int n2) {
        switch (n2) {
            case 2003: {
                return Array.class;
            }
            case -5: {
                return Long.TYPE;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case -7: 
            case 16: {
                return Boolean.TYPE;
            }
            case 2004: {
                return Blob.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 91: {
                return Date.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 6: 
            case 8: {
                return Double.TYPE;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.TYPE;
            }
            case 2000: {
                return Object.class;
            }
            case 7: {
                return Float.TYPE;
            }
            case 2006: {
                return Ref.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        if (!this.a) {
            return Object.class;
        }
        return null;
    }
}

