/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.search.LuceneSearcher;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.search.Trie;
import prefuse.util.StringLib;
import prefuse.util.collections.IntObjectHashMap;

public class KeywordSearchTupleSet
extends SearchTupleSet {
    private static final Logger e;
    protected IntObjectHashMap m_map;
    protected String m_query;
    protected LuceneSearcher m_lucene;
    protected boolean m_storeTermVectors;
    protected int m_id;
    private static final String[] z;

    public KeywordSearchTupleSet() {
        boolean bl = Trie.TrieNode.b;
        this.m_map = new IntObjectHashMap();
        this.m_query = "";
        this.m_lucene = null;
        this.m_storeTermVectors = false;
        this.m_id = 1;
        this.m_lucene = new LuceneSearcher();
        if (bl) {
            AbstractExpression.b = !AbstractExpression.b;
        }
    }

    public KeywordSearchTupleSet(LuceneSearcher luceneSearcher) {
        boolean bl = Trie.TrieNode.b;
        this.m_map = new IntObjectHashMap();
        this.m_query = "";
        this.m_lucene = null;
        this.m_storeTermVectors = false;
        this.m_id = 1;
        this.m_lucene = luceneSearcher;
        if (AbstractExpression.b) {
            Trie.TrieNode.b = !bl;
        }
    }

    @Override
    public String getQuery() {
        return this.m_query;
    }

    @Override
    public void search(String string) {
        boolean bl = Trie.TrieNode.b;
        if (string == null) {
            string = "";
        }
        if (string.equals(this.m_query)) {
            return;
        }
        Tuple[] tupleArray = this.clearInternal();
        this.m_query = string;
        string.trim();
        if (string.length() == 0) {
            this.fireTupleEvent(null, -1);
            return;
        }
        this.m_lucene.setReadMode(true);
        try {
            Hits hits = this.m_lucene.search(string);
            for (int i2 = 0; i2 < hits.length(); ++i2) {
                Tuple tuple = this.getMatchingTuple(hits.doc(i2));
                this.addInternal(tuple);
                if (!bl) continue;
            }
            Tuple[] tupleArray2 = this.getTupleCount() > 0 ? this.toArray() : null;
            this.fireTupleEvent(tupleArray2, tupleArray);
        }
        catch (ParseException parseException) {
            e.warning(z[1] + StringLib.getStackTrace(parseException));
        }
        catch (IOException iOException) {
            e.warning(z[2] + StringLib.getStackTrace(iOException));
        }
    }

    protected Tuple getMatchingTuple(Document document) {
        int n2 = Integer.parseInt(document.get(z[0]));
        return (Tuple)this.m_map.get(n2);
    }

    @Override
    public void index(Tuple tuple, String string) {
        this.m_lucene.setReadMode(false);
        String string2 = tuple.getString(string);
        if (string2 == null) {
            return;
        }
        int n2 = this.m_id++;
        this.m_lucene.addDocument(this.getDocument(n2, string2));
        this.m_map.put(n2, tuple);
    }

    @Override
    public boolean isUnindexSupported() {
        return false;
    }

    @Override
    public void unindex(Tuple tuple, String string) {
        throw new UnsupportedOperationException();
    }

    protected Document getDocument(int n2, String string) {
        Document document = new Document();
        document.add(Field.Text((String)z[3], (String)string, (boolean)this.m_storeTermVectors));
        document.add(Field.Keyword((String)z[0], (String)String.valueOf(n2)));
        return document;
    }

    public LuceneSearcher getLuceneSearcher() {
        return this.m_lucene;
    }

    public IntObjectHashMap getTupleMap() {
        return (IntObjectHashMap)this.m_map.clone();
    }

    @Override
    public void clear() {
        this.m_lucene = new LuceneSearcher();
        super.clear();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0013\u0005\b\u0006=\u0010\u0012@\t,";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 99;
                                break;
                            }
                            case 1: {
                                n9 = 119;
                                break;
                            }
                            case 2: {
                                n9 = 109;
                                break;
                            }
                            case 3: {
                                n9 = 96;
                                break;
                            }
                            default: {
                                n9 = 72;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "/\u0002\u000e\u0005&\u0006W\u001c\u0015-\u0011\u000eM\u0010)\u0011\u0004\b@-\u001b\u0014\b\u0010<\n\u0018\u0003NB";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "/\u0002\u000e\u0005&\u0006W$/h\u0006\u000f\u000e\u00058\u0017\u001e\u0002\u000efi";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0013\u0005\b\u0006=\u0010\u0012@\u0014-\u001b\u0003";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        e = Logger.getLogger(KeywordSearchTupleSet.class.getName());
    }
}

