/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Comparator;
import java.util.Iterator;
import prefuse.data.Table;
import prefuse.data.expression.AndPredicate;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.ComparisonPredicate;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionAnalyzer;
import prefuse.data.expression.NotPredicate;
import prefuse.data.expression.OrPredicate;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.RangePredicate;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.FilterIterator;
import prefuse.data.util.FilterRowIterator;
import prefuse.data.util.Index;
import prefuse.data.util.RowManager;
import prefuse.data.util.UniqueRowIterator;
import prefuse.util.PrefuseConfig;
import prefuse.util.collections.CompositeIntIterator;
import prefuse.util.collections.IntIterator;

public class FilterIteratorFactory {
    private static final int a;

    public static Iterator tuples(TupleSet tupleSet, Predicate predicate) {
        Table table;
        IntIterator intIterator;
        if (predicate == null) {
            return tupleSet.tuples();
        }
        Iterator iterator = null;
        if (tupleSet instanceof Table && (intIterator = FilterIteratorFactory.getOptimizedIterator(table = (Table)tupleSet, predicate)) != null) {
            iterator = table.tuples(intIterator);
        }
        if (iterator == null) {
            iterator = new FilterIterator(tupleSet.tuples(), predicate);
        }
        return iterator;
    }

    public static IntIterator rows(Table table, Predicate predicate) {
        IntIterator intIterator = null;
        intIterator = FilterIteratorFactory.getOptimizedIterator(table, predicate);
        if (intIterator == null) {
            intIterator = new FilterRowIterator(table.rows(), table, predicate);
        }
        return intIterator;
    }

    protected static IntIterator getOptimizedIterator(Table table, Predicate predicate) {
        block11: {
            block10: {
                if (table.getRowCount() < a) {
                    return null;
                }
                if (predicate instanceof ColumnExpression) {
                    return FilterIteratorFactory.getColumnIterator(table, ((ColumnExpression)predicate).getColumnName(), true);
                }
                if (!(predicate instanceof NotPredicate)) break block10;
                Predicate predicate2 = ((NotPredicate)predicate).getPredicate();
                if (predicate2 instanceof ColumnExpression) {
                    return FilterIteratorFactory.getColumnIterator(table, ((ColumnExpression)predicate2).getColumnName(), false);
                }
                if (!RowManager.d) break block11;
            }
            if (predicate instanceof AndPredicate) {
                return FilterIteratorFactory.getAndIterator(table, (AndPredicate)predicate);
            }
            if (predicate instanceof OrPredicate) {
                return FilterIteratorFactory.getOrIterator(table, (OrPredicate)predicate);
            }
            if (predicate instanceof ComparisonPredicate) {
                return FilterIteratorFactory.getComparisonIterator(table, (ComparisonPredicate)predicate);
            }
            if (predicate instanceof RangePredicate) {
                return FilterIteratorFactory.getRangeIterator(table, (RangePredicate)predicate);
            }
        }
        return null;
    }

    protected static IntIterator getColumnIterator(Table table, String string, boolean bl) {
        if (table.getColumnType(string) != Boolean.TYPE) {
            return null;
        }
        Index index = table.getIndex(string);
        if (index == null) {
            return null;
        }
        return index.rows(bl);
    }

    protected static IntIterator getOrIterator(Table table, OrPredicate orPredicate) {
        boolean bl = RowManager.d;
        int n2 = orPredicate.size();
        if (n2 > 1) {
            IntIterator[] intIteratorArray = new IntIterator[n2];
            for (int i2 = 0; i2 < intIteratorArray.length; ++i2) {
                intIteratorArray[i2] = FilterIteratorFactory.getOptimizedIterator(table, orPredicate.get(i2));
                if (intIteratorArray[i2] != null) continue;
                return null;
            }
            return new UniqueRowIterator(new CompositeIntIterator(intIteratorArray));
        }
        if (n2 == 1) {
            return FilterIteratorFactory.getOptimizedIterator(table, orPredicate.get(0));
        }
        return null;
    }

    protected static IntIterator getAndIterator(Table table, AndPredicate andPredicate) {
        IntIterator intIterator = null;
        Predicate predicate = null;
        int n2 = andPredicate.size();
        while (--n2 >= 0 && (intIterator = FilterIteratorFactory.getOptimizedIterator(table, predicate = andPredicate.get(n2))) == null) {
        }
        if (intIterator == null) {
            return null;
        }
        if (andPredicate.size() == 1) {
            return intIterator;
        }
        return new FilterRowIterator(intIterator, table, andPredicate.getSubPredicate(predicate));
    }

    protected static IntIterator getComparisonIterator(Table table, ComparisonPredicate comparisonPredicate) {
        Expression expression;
        ColumnExpression columnExpression;
        int n2;
        block45: {
            block46: {
                Expression expression2;
                Expression expression3;
                boolean bl;
                block44: {
                    bl = RowManager.d;
                    expression3 = comparisonPredicate.getLeftExpression();
                    expression2 = comparisonPredicate.getRightExpression();
                    n2 = comparisonPredicate.getOperation();
                    if (n2 == 3) {
                        return null;
                    }
                    if (!(expression3 instanceof ColumnExpression) || ExpressionAnalyzer.hasDependency(expression2)) break block44;
                    columnExpression = (ColumnExpression)expression3;
                    expression = expression2;
                    if (!bl) break block45;
                }
                if (!(expression2 instanceof ColumnExpression) || ExpressionAnalyzer.hasDependency(expression3)) break block46;
                columnExpression = (ColumnExpression)expression2;
                expression = expression3;
                if (!bl) break block45;
            }
            return null;
        }
        Comparator comparator = comparisonPredicate.getComparator();
        Index index = table.getIndex(columnExpression.getColumnName());
        if (index == null || !comparator.equals(index.getComparator())) {
            return null;
        }
        Class<?> clazz = expression.getClass();
        if (clazz == Integer.TYPE) {
            int n3 = expression.getInt(null);
            switch (n2) {
                case 0: {
                    return index.rows(Integer.MIN_VALUE, n3, 41);
                }
                case 1: {
                    return index.rows(n3, Integer.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(n3, n3, 42);
                }
                case 4: {
                    return index.rows(Integer.MIN_VALUE, n3, 42);
                }
                case 5: {
                    return index.rows(n3, Integer.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (clazz == Long.TYPE) {
            long l2 = expression.getLong(null);
            switch (n2) {
                case 0: {
                    return index.rows(Long.MIN_VALUE, l2, 41);
                }
                case 1: {
                    return index.rows(l2, Long.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(l2, l2, 42);
                }
                case 4: {
                    return index.rows(Long.MIN_VALUE, l2, 42);
                }
                case 5: {
                    return index.rows(l2, Long.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (clazz == Float.TYPE) {
            float f2 = expression.getFloat(null);
            switch (n2) {
                case 0: {
                    return index.rows(Float.MIN_VALUE, f2, 41);
                }
                case 1: {
                    return index.rows(f2, Float.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(f2, f2, 42);
                }
                case 4: {
                    return index.rows(Float.MIN_VALUE, f2, 42);
                }
                case 5: {
                    return index.rows(f2, Float.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (clazz == Double.TYPE) {
            double d2 = expression.getDouble(null);
            switch (n2) {
                case 0: {
                    return index.rows((double)Double.MIN_VALUE, d2, 41);
                }
                case 1: {
                    return index.rows(d2, (double)Double.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(d2, d2, 42);
                }
                case 4: {
                    return index.rows((double)Double.MIN_VALUE, d2, 42);
                }
                case 5: {
                    return index.rows(d2, (double)Double.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        Object object = expression.get(null);
        switch (n2) {
            case 0: {
                return index.rows(null, object, 41);
            }
            case 1: {
                return index.rows(object, null, 38);
            }
            case 2: {
                return index.rows(object, object, 42);
            }
            case 4: {
                return index.rows(null, object, 42);
            }
            case 5: {
                return index.rows(object, null, 42);
            }
        }
        throw new IllegalStateException();
    }

    protected static IntIterator getRangeIterator(Table table, RangePredicate rangePredicate) {
        int n2;
        boolean bl = RowManager.d;
        if (!(rangePredicate.getMiddleExpression() instanceof ColumnExpression) || ExpressionAnalyzer.hasDependency(rangePredicate.getLeftExpression()) || ExpressionAnalyzer.hasDependency(rangePredicate.getRightExpression())) {
            return null;
        }
        ColumnExpression columnExpression = (ColumnExpression)rangePredicate.getMiddleExpression();
        Expression expression = rangePredicate.getLeftExpression();
        Expression expression2 = rangePredicate.getRightExpression();
        Comparator comparator = rangePredicate.getComparator();
        Index index = table.getIndex(columnExpression.getColumnName());
        if (index == null || !comparator.equals(index.getComparator())) {
            return null;
        }
        int n3 = rangePredicate.getOperation();
        Class clazz = table.getColumnType(columnExpression.getColumnName());
        switch (n3) {
            case 0: {
                n2 = 42;
                if (!bl) break;
            }
            case 1: {
                n2 = 41;
                if (!bl) break;
            }
            case 2: {
                n2 = 38;
                if (!bl) break;
            }
            case 3: {
                n2 = 37;
                if (!bl) break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (clazz == Integer.TYPE) {
            return index.rows(expression.getInt(null), expression2.getInt(null), n2);
        }
        if (clazz == Long.TYPE) {
            return index.rows(expression.getLong(null), expression2.getLong(null), n2);
        }
        if (clazz == Float.TYPE) {
            return index.rows(expression.getFloat(null), expression2.getFloat(null), n2);
        }
        if (clazz == Double.TYPE) {
            return index.rows(expression.getDouble(null), expression2.getDouble(null), n2);
        }
        return index.rows(expression.get(null), expression2.get(null), n2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "]BDy8_J\\lsK\r_hbPNYbsmKB}eQL\\|".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 57;
                            break;
                        }
                        case 1: {
                            n7 = 35;
                            break;
                        }
                        case 2: {
                            n7 = 48;
                            break;
                        }
                        case 3: {
                            n7 = 24;
                            break;
                        }
                        default: {
                            n7 = 22;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = PrefuseConfig.getInt(new String(cArray).intern());
    }
}

