/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import prefuse.render.Renderer;
import prefuse.util.GraphicsLib;
import prefuse.visual.VisualItem;

public abstract class AbstractShapeRenderer
implements Renderer {
    public static final int RENDER_TYPE_NONE = 0;
    public static final int RENDER_TYPE_DRAW = 1;
    public static final int RENDER_TYPE_FILL = 2;
    public static final int RENDER_TYPE_DRAW_AND_FILL = 3;
    private int a = 3;
    protected AffineTransform m_transform = new AffineTransform();
    protected boolean m_manageBounds = true;
    public static boolean b;
    private static final String z;

    public void setManageBounds(boolean bl) {
        this.m_manageBounds = bl;
    }

    @Override
    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape != null) {
            this.drawShape(graphics2D, visualItem, shape);
        }
    }

    protected void drawShape(Graphics2D graphics2D, VisualItem visualItem, Shape shape) {
        GraphicsLib.paint(graphics2D, visualItem, shape, this.getStroke(visualItem), this.getRenderType(visualItem));
    }

    public Shape getShape(VisualItem visualItem) {
        AffineTransform affineTransform = this.getTransform(visualItem);
        Shape shape = this.getRawShape(visualItem);
        return affineTransform == null || shape == null ? shape : affineTransform.createTransformedShape(shape);
    }

    protected BasicStroke getStroke(VisualItem visualItem) {
        return visualItem.getStroke();
    }

    protected abstract Shape getRawShape(VisualItem var1);

    protected AffineTransform getTransform(VisualItem visualItem) {
        return null;
    }

    public int getRenderType(VisualItem visualItem) {
        return this.a;
    }

    public void setRenderType(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException(z);
        }
        this.a = n2;
    }

    @Override
    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        if (visualItem.getBounds().contains(point2D)) {
            Shape shape = this.getShape(visualItem);
            return shape != null ? shape.contains(point2D) : false;
        }
        return false;
    }

    @Override
    public void setBounds(VisualItem visualItem) {
        block5: {
            Shape shape;
            block4: {
                if (!this.m_manageBounds) {
                    return;
                }
                shape = this.getShape(visualItem);
                if (shape != null) break block4;
                visualItem.setBounds(visualItem.getX(), visualItem.getY(), 0.0, 0.0);
                if (!b) break block5;
            }
            GraphicsLib.setBounds(visualItem, shape, this.getStroke(visualItem));
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "~p@i9Dy\\e Nz\u0012~?EzW~z_gBit".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 43;
                            break;
                        }
                        case 1: {
                            n7 = 30;
                            break;
                        }
                        case 2: {
                            n7 = 50;
                            break;
                        }
                        case 3: {
                            n7 = 12;
                            break;
                        }
                        default: {
                            n7 = 90;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }
}

