/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.visual.VisualItem;

public class AxisRenderer
extends AbstractShapeRenderer {
    private Line2D c = new Line2D.Double();
    private Rectangle2D d = new Rectangle2D.Double();
    private int e;
    private int f;
    private int g;

    public AxisRenderer() {
        this(0, 3);
    }

    public AxisRenderer(int n2, int n3) {
        this.e = n2;
        this.f = n3;
    }

    public void setHorizontalAlignment(int n2) {
        this.e = n2;
    }

    public void setVerticalAlignment(int n2) {
        this.f = n2;
    }

    @Override
    protected Shape getRawShape(VisualItem visualItem) {
        double d2;
        double d3;
        boolean bl = AbstractShapeRenderer.b;
        double d4 = visualItem.getDouble(VisualItem.X);
        double d5 = visualItem.getDouble(VisualItem.Y);
        double d6 = visualItem.getDouble(VisualItem.X2);
        double d7 = visualItem.getDouble(VisualItem.Y2);
        this.c.setLine(d4, d5, d6, d7);
        if (!visualItem.canGetString(VisualItem.LABEL)) {
            return this.c;
        }
        String string = visualItem.getString(VisualItem.LABEL);
        if (string == null) {
            return this.c;
        }
        FontMetrics fontMetrics = DEFAULT_GRAPHICS.getFontMetrics(visualItem.getFont());
        this.g = fontMetrics.getAscent();
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.stringWidth(string);
        switch (this.e) {
            case 6: {
                d3 = d6 + 2.0;
                if (!bl) break;
            }
            case 5: {
                d3 = d4 - (double)n3 - 2.0;
                if (!bl) break;
            }
            case 2: {
                d3 = d4 + (d6 - d4) / 2.0 - (double)(n3 / 2);
                if (!bl) break;
            }
            case 1: {
                d3 = d6 - (double)n3;
                if (!bl) break;
            }
            default: {
                d3 = d4;
            }
        }
        switch (this.f) {
            case 8: {
                d2 = d5 - (double)n2;
                if (!bl) break;
            }
            case 7: {
                d2 = d7;
                if (!bl) break;
            }
            case 2: {
                d2 = d5 + (d7 - d5) / 2.0 - (double)(n2 / 2);
                if (!bl) break;
            }
            case 4: {
                d2 = d5;
                if (!bl) break;
            }
            default: {
                d2 = d7 - (double)n2;
            }
        }
        this.d.setFrame(d3, d2, n3, n2);
        return this.d;
    }

    @Override
    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        GraphicsLib.paint(graphics2D, visualItem, this.c, this.getStroke(visualItem), this.getRenderType(visualItem));
        if (visualItem.canGetString(VisualItem.LABEL)) {
            float f2 = (float)this.d.getMinX();
            float f3 = (float)this.d.getMinY() + (float)this.g;
            GraphicsLib.paint(graphics2D, visualItem, shape, null, 2);
            String string = visualItem.getString(VisualItem.LABEL);
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = this.getTransform(visualItem);
            if (affineTransform2 != null) {
                graphics2D.setTransform(affineTransform2);
            }
            graphics2D.setFont(visualItem.getFont());
            graphics2D.setColor(ColorLib.getColor(visualItem.getTextColor()));
            graphics2D.drawString(string, f2, f3);
            if (affineTransform2 != null) {
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    @Override
    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            return false;
        }
        if (shape == this.d && this.d.contains(point2D)) {
            return true;
        }
        double d2 = Math.max(2.0, visualItem.getSize());
        double d3 = d2 / 2.0;
        return shape.intersects(point2D.getX() - d3, point2D.getY() - d3, d2, d2);
    }

    @Override
    public void setBounds(VisualItem visualItem) {
        block5: {
            block6: {
                Shape shape;
                boolean bl;
                block4: {
                    bl = AbstractShapeRenderer.b;
                    if (!this.m_manageBounds) {
                        return;
                    }
                    shape = this.getShape(visualItem);
                    if (shape != null) break block4;
                    visualItem.setBounds(visualItem.getX(), visualItem.getY(), 0.0, 0.0);
                    if (!bl) break block5;
                }
                if (shape != this.c) break block6;
                GraphicsLib.setBounds(visualItem, shape, this.getStroke(visualItem));
                if (!bl) break block5;
            }
            this.d.add(this.c.getX1(), this.c.getY1());
            this.d.add(this.c.getX2(), this.c.getY2());
            visualItem.setBounds(this.d.getMinX(), this.d.getMinY(), this.d.getWidth(), this.d.getHeight());
        }
    }
}

