/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.util.StrokeLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class EdgeRenderer
extends AbstractShapeRenderer {
    public static final String EDGE_TYPE;
    protected static final double HALF_PI = 1.5707963267948966;
    protected Line2D m_line = new Line2D.Float();
    protected CubicCurve2D m_cubic = new CubicCurve2D.Float();
    protected int m_edgeType = 0;
    protected int m_xAlign1 = 2;
    protected int m_yAlign1 = 2;
    protected int m_xAlign2 = 2;
    protected int m_yAlign2 = 2;
    protected double m_width = 1.0;
    protected float m_curWidth = 1.0f;
    protected Point2D[] m_tmpPoints = new Point2D[2];
    protected Point2D[] m_ctrlPoints = new Point2D[2];
    protected Point2D[] m_isctPoints = new Point2D[2];
    protected int m_edgeArrow = 1;
    protected int m_arrowWidth = 8;
    protected int m_arrowHeight = 12;
    protected Polygon m_arrowHead = this.updateArrowHead(this.m_arrowWidth, this.m_arrowHeight);
    protected AffineTransform m_arrowTrans = new AffineTransform();
    protected Shape m_curArrow;
    private static final String[] z;

    public EdgeRenderer() {
        this.m_tmpPoints[0] = new Point2D.Float();
        this.m_tmpPoints[1] = new Point2D.Float();
        this.m_ctrlPoints[0] = new Point2D.Float();
        this.m_ctrlPoints[1] = new Point2D.Float();
        this.m_isctPoints[0] = new Point2D.Float();
        this.m_isctPoints[1] = new Point2D.Float();
    }

    public EdgeRenderer(int n2) {
        this(n2, 1);
    }

    public EdgeRenderer(int n2, int n3) {
        this();
        this.setEdgeType(n2);
        this.setArrowType(n3);
    }

    @Override
    public int getRenderType(VisualItem visualItem) {
        return 1;
    }

    @Override
    protected Shape getRawShape(VisualItem visualItem) {
        int n2;
        EdgeItem edgeItem;
        block9: {
            block8: {
                NodeItem nodeItem;
                edgeItem = (EdgeItem)visualItem;
                NodeItem nodeItem2 = edgeItem.getSourceItem();
                NodeItem nodeItem3 = edgeItem.getTargetItem();
                n2 = this.m_edgeType;
                EdgeRenderer.getAlignedPoint(this.m_tmpPoints[0], nodeItem2.getBounds(), this.m_xAlign1, this.m_yAlign1);
                EdgeRenderer.getAlignedPoint(this.m_tmpPoints[1], nodeItem3.getBounds(), this.m_xAlign2, this.m_yAlign2);
                this.m_curWidth = (float)(this.m_width * this.getLineWidth(visualItem));
                EdgeItem edgeItem2 = (EdgeItem)visualItem;
                if (!edgeItem2.isDirected() || this.m_edgeArrow == 0) break block8;
                boolean bl = this.m_edgeArrow == 1;
                Point2D point2D = null;
                Point2D point2D2 = null;
                point2D = this.m_tmpPoints[bl ? 0 : 1];
                int n3 = GraphicsLib.intersectLineRectangle(point2D, point2D2 = this.m_tmpPoints[bl ? 1 : 0], (nodeItem = bl ? edgeItem2.getTargetItem() : edgeItem2.getSourceItem()).getBounds(), this.m_isctPoints);
                if (n3 > 0) {
                    point2D2 = this.m_isctPoints[0];
                }
                AffineTransform affineTransform = this.getArrowTrans(point2D, point2D2, this.m_curWidth);
                this.m_curArrow = affineTransform.createTransformedShape(this.m_arrowHead);
                Point2D point2D3 = this.m_tmpPoints[bl ? 1 : 0];
                point2D3.setLocation(0.0, -this.m_arrowHeight);
                affineTransform.transform(point2D3, point2D3);
                if (!AbstractShapeRenderer.b) break block9;
            }
            this.m_curArrow = null;
        }
        Shape shape = null;
        double d2 = this.m_tmpPoints[0].getX();
        double d3 = this.m_tmpPoints[0].getY();
        double d4 = this.m_tmpPoints[1].getX();
        double d5 = this.m_tmpPoints[1].getY();
        switch (n2) {
            case 0: {
                this.m_line.setLine(d2, d3, d4, d5);
                shape = this.m_line;
                break;
            }
            case 1: {
                this.getCurveControlPoints(edgeItem, this.m_ctrlPoints, d2, d3, d4, d5);
                this.m_cubic.setCurve(d2, d3, this.m_ctrlPoints[0].getX(), this.m_ctrlPoints[0].getY(), this.m_ctrlPoints[1].getX(), this.m_ctrlPoints[1].getY(), d4, d5);
                shape = this.m_cubic;
                break;
            }
            default: {
                throw new IllegalStateException(z[1]);
            }
        }
        return shape;
    }

    @Override
    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        super.render(graphics2D, visualItem);
        if (this.m_curArrow != null) {
            graphics2D.setPaint(ColorLib.getColor(visualItem.getFillColor()));
            graphics2D.fill(this.m_curArrow);
        }
    }

    protected AffineTransform getArrowTrans(Point2D point2D, Point2D point2D2, double d2) {
        this.m_arrowTrans.setToTranslation(point2D2.getX(), point2D2.getY());
        this.m_arrowTrans.rotate(-1.5707963267948966 + Math.atan2(point2D2.getY() - point2D.getY(), point2D2.getX() - point2D.getX()));
        if (d2 > 1.0) {
            double d3 = d2 / 4.0;
            this.m_arrowTrans.scale(d3, d3);
        }
        return this.m_arrowTrans;
    }

    protected Polygon updateArrowHead(int n2, int n3) {
        block3: {
            block2: {
                if (this.m_arrowHead != null) break block2;
                this.m_arrowHead = new Polygon();
                if (!AbstractShapeRenderer.b) break block3;
            }
            this.m_arrowHead.reset();
        }
        this.m_arrowHead.addPoint(0, 0);
        this.m_arrowHead.addPoint(-n2 / 2, -n3);
        this.m_arrowHead.addPoint(n2 / 2, -n3);
        this.m_arrowHead.addPoint(0, 0);
        return this.m_arrowHead;
    }

    @Override
    protected AffineTransform getTransform(VisualItem visualItem) {
        return null;
    }

    @Override
    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            return false;
        }
        double d2 = Math.max(2.0, this.getLineWidth(visualItem));
        double d3 = d2 / 2.0;
        return shape.intersects(point2D.getX() - d3, point2D.getY() - d3, d2, d2);
    }

    @Override
    public void setBounds(VisualItem visualItem) {
        if (!this.m_manageBounds) {
            return;
        }
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            visualItem.setBounds(visualItem.getX(), visualItem.getY(), 0.0, 0.0);
            return;
        }
        GraphicsLib.setBounds(visualItem, shape, this.getStroke(visualItem));
        if (this.m_curArrow != null) {
            Rectangle2D rectangle2D = (Rectangle2D)visualItem.get(VisualItem.BOUNDS);
            Rectangle2D.union(rectangle2D, this.m_curArrow.getBounds2D(), rectangle2D);
        }
    }

    protected double getLineWidth(VisualItem visualItem) {
        return visualItem.getSize();
    }

    @Override
    protected BasicStroke getStroke(VisualItem visualItem) {
        return StrokeLib.getDerivedStroke(visualItem.getStroke(), this.m_curWidth);
    }

    protected void getCurveControlPoints(EdgeItem edgeItem, Point2D[] point2DArray, double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        point2DArray[0].setLocation(d2 + 2.0 * d6 / 3.0, d3);
        point2DArray[1].setLocation(d4 - d6 / 8.0, d5 - d7 / 8.0);
    }

    protected static void getAlignedPoint(Point2D point2D, Rectangle2D rectangle2D, int n2, int n3) {
        double d2;
        double d3;
        block11: {
            double d4;
            block10: {
                boolean bl;
                block9: {
                    double d5;
                    block8: {
                        bl = AbstractShapeRenderer.b;
                        d3 = rectangle2D.getX();
                        d2 = rectangle2D.getY();
                        d5 = rectangle2D.getWidth();
                        d4 = rectangle2D.getHeight();
                        if (n2 != 2) break block8;
                        d3 += d5 / 2.0;
                        if (!bl) break block9;
                    }
                    if (n2 == 1) {
                        d3 += d5;
                    }
                }
                if (n3 != 2) break block10;
                d2 += d4 / 2.0;
                if (!bl) break block11;
            }
            if (n3 == 3) {
                d2 += d4;
            }
        }
        point2D.setLocation(d3, d2);
    }

    public int getEdgeType() {
        return this.m_edgeType;
    }

    public void setEdgeType(int n2) {
        if (n2 < 0 || n2 >= 2) {
            throw new IllegalArgumentException(z[2] + n2);
        }
        this.m_edgeType = n2;
    }

    public int getArrowType() {
        return this.m_edgeArrow;
    }

    public void setArrowType(int n2) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException(z[0] + n2);
        }
        this.m_edgeArrow = n2;
    }

    public void setArrowHeadSize(int n2, int n3) {
        this.m_arrowWidth = n2;
        this.m_arrowHeight = n3;
        this.m_arrowHead = this.updateArrowHead(n2, n3);
    }

    public int getArrowHeadHeight() {
        return this.m_arrowHeight;
    }

    public int getArrowHeadWidth() {
        return this.m_arrowWidth;
    }

    public int getHorizontalAlignment1() {
        return this.m_xAlign1;
    }

    public int getVerticalAlignment1() {
        return this.m_yAlign1;
    }

    public int getHorizontalAlignment2() {
        return this.m_xAlign2;
    }

    public int getVerticalAlignment2() {
        return this.m_yAlign2;
    }

    public void setHorizontalAlignment1(int n2) {
        this.m_xAlign1 = n2;
    }

    public void setVerticalAlignment1(int n2) {
        this.m_yAlign1 = n2;
    }

    public void setHorizontalAlignment2(int n2) {
        this.m_xAlign2 = n2;
    }

    public void setVerticalAlignment2(int n2) {
        this.m_yAlign2 = n2;
    }

    public void setDefaultLineWidth(double d2) {
        this.m_width = d2;
    }

    public double getDefaultLineWidth() {
        return this.m_width;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "0^K\u0014',JI";
        int n3 = 2;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 85;
                                break;
                            }
                            case 1: {
                                n9 = 58;
                                break;
                            }
                            case 2: {
                                n9 = 44;
                                break;
                            }
                            case 3: {
                                n9 = 113;
                                break;
                            }
                            default: {
                                n9 = 115;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 2: {
                    EDGE_TYPE = string.intern();
                    string2 = "\u0000T^\u0014\u0010:]B\u0018\t0^\f\u0014\u00172_\f\u0010\u0001'U[Q\u0007,JIKS";
                    n3 = -1;
                    continue block11;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0000TG\u001f\u001c\"T\f\u0014\u00172_\f\u0005\n%_";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0000T^\u0014\u0010:]B\u0018\t0^\f\u0014\u00172_\f\u0012\u0006'LIQ\u0007,JIKS";
                    n3 = 1;
                    continue block11;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

