/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.ImageFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphicsLib;
import prefuse.util.StringLib;
import prefuse.visual.VisualItem;

public class LabelRenderer
extends AbstractShapeRenderer {
    protected ImageFactory m_images = null;
    protected String m_delim = "\n";
    protected String m_labelName = z[0];
    protected String m_imageName = null;
    protected int m_xAlign = 2;
    protected int m_yAlign = 2;
    protected int m_hTextAlign = 2;
    protected int m_vTextAlign = 2;
    protected int m_hImageAlign = 2;
    protected int m_vImageAlign = 2;
    protected int m_imagePos = 0;
    protected int m_horizBorder = 2;
    protected int m_vertBorder = 0;
    protected int m_imageMargin = 2;
    protected int m_arcWidth = 0;
    protected int m_arcHeight = 0;
    protected int m_maxTextWidth = -1;
    AffineTransform c = new AffineTransform();
    protected RectangularShape m_bbox = new Rectangle2D.Double();
    protected Point2D m_pt = new Point2D.Double();
    protected Font m_font;
    protected String m_text;
    protected Dimension m_textDim = new Dimension();
    private static final String[] z;

    public LabelRenderer() {
    }

    public LabelRenderer(String string) {
        this.setTextField(string);
    }

    public LabelRenderer(String string, String string2) {
        this.setTextField(string);
        this.setImageField(string2);
    }

    public void setRoundedCorner(int n2, int n3) {
        block5: {
            block4: {
                if (n2 != 0 && n3 != 0 || this.m_bbox instanceof Rectangle2D) break block4;
                this.m_bbox = new Rectangle2D.Double();
                if (!AbstractShapeRenderer.b) break block5;
            }
            if (!(this.m_bbox instanceof RoundRectangle2D)) {
                this.m_bbox = new RoundRectangle2D.Double();
            }
            ((RoundRectangle2D)this.m_bbox).setRoundRect(0.0, 0.0, 10.0, 10.0, n2, n3);
            this.m_arcWidth = n2;
            this.m_arcHeight = n3;
        }
    }

    public String getTextField() {
        return this.m_labelName;
    }

    public void setTextField(String string) {
        this.m_labelName = string;
    }

    public void setMaxTextWidth(int n2) {
        this.m_maxTextWidth = n2;
    }

    protected String getText(VisualItem visualItem) {
        String string = null;
        if (visualItem.canGetString(this.m_labelName)) {
            return visualItem.getString(this.m_labelName);
        }
        return string;
    }

    public String getImageField() {
        return this.m_imageName;
    }

    public void setImageField(String string) {
        if (string != null) {
            this.m_images = new ImageFactory();
        }
        this.m_imageName = string;
    }

    public void setMaxImageDimensions(int n2, int n3) {
        if (this.m_images == null) {
            this.m_images = new ImageFactory();
        }
        this.m_images.setMaxImageDimensions(n2, n3);
    }

    protected String getImageLocation(VisualItem visualItem) {
        return visualItem.canGetString(this.m_imageName) ? visualItem.getString(this.m_imageName) : null;
    }

    protected Image getImage(VisualItem visualItem) {
        String string = this.getImageLocation(visualItem);
        return string == null ? null : this.m_images.getImage(string);
    }

    private String a(VisualItem visualItem, String string, double d2) {
        int n2;
        int n3;
        StringBuffer stringBuffer;
        FontMetrics fontMetrics;
        block15: {
            String string2;
            block14: {
                boolean bl = AbstractShapeRenderer.b;
                this.m_font = visualItem.getFont();
                if (d2 != 1.0) {
                    this.m_font = FontLib.getFont(this.m_font.getName(), this.m_font.getStyle(), d2 * (double)this.m_font.getSize());
                }
                fontMetrics = DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
                stringBuffer = null;
                n3 = 1;
                n2 = 0;
                int n4 = 0;
                int n5 = string.indexOf(this.m_delim);
                this.m_textDim.width = 0;
                while (n5 >= 0) {
                    block13: {
                        block12: {
                            string2 = string.substring(n4, n5);
                            n2 = fontMetrics.stringWidth(string2);
                            if (this.m_maxTextWidth <= -1 || n2 <= this.m_maxTextWidth) break block12;
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer(string.substring(0, n4));
                            }
                            stringBuffer.append(StringLib.abbreviate(string2, fontMetrics, this.m_maxTextWidth));
                            stringBuffer.append(this.m_delim);
                            n2 = this.m_maxTextWidth;
                            if (!bl) break block13;
                        }
                        if (stringBuffer != null) {
                            stringBuffer.append(string2).append(this.m_delim);
                        }
                    }
                    this.m_textDim.width = Math.max(this.m_textDim.width, n2);
                    n4 = n5 + 1;
                    n5 = string.indexOf(this.m_delim, n4);
                    ++n3;
                    if (!bl) continue;
                }
                string2 = string.substring(n4);
                n2 = fontMetrics.stringWidth(string2);
                if (this.m_maxTextWidth <= -1 || n2 <= this.m_maxTextWidth) break block14;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, n4));
                }
                stringBuffer.append(StringLib.abbreviate(string2, fontMetrics, this.m_maxTextWidth));
                n2 = this.m_maxTextWidth;
                if (!bl) break block15;
            }
            if (stringBuffer != null) {
                stringBuffer.append(string2);
            }
        }
        this.m_textDim.width = Math.max(this.m_textDim.width, n2);
        this.m_textDim.height = fontMetrics.getHeight() * n3;
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    @Override
    protected Shape getRawShape(VisualItem visualItem) {
        block10: {
            double d2;
            double d3;
            block9: {
                boolean bl = AbstractShapeRenderer.b;
                this.m_text = this.getText(visualItem);
                Image image = this.getImage(visualItem);
                double d4 = visualItem.getSize();
                double d5 = 0.0;
                double d6 = 0.0;
                if (image != null) {
                    d6 = image.getHeight(null);
                    d5 = image.getWidth(null);
                }
                int n2 = 0;
                int n3 = 0;
                if (this.m_text != null) {
                    this.m_text = this.a(visualItem, this.m_text, d4);
                    n3 = this.m_textDim.height;
                    n2 = this.m_textDim.width;
                }
                d3 = 0.0;
                d2 = 0.0;
                switch (this.m_imagePos) {
                    case 0: 
                    case 1: {
                        d3 = (double)n2 + d4 * (d5 + (double)(2 * this.m_horizBorder) + (double)(n2 > 0 && d5 > 0.0 ? this.m_imageMargin : 0));
                        d2 = Math.max((double)n3, d4 * d6) + d4 * 2.0 * (double)this.m_vertBorder;
                        if (!bl) break;
                    }
                    case 3: 
                    case 4: {
                        d3 = Math.max((double)n2, d4 * d5) + d4 * 2.0 * (double)this.m_horizBorder;
                        d2 = (double)n3 + d4 * (d6 + (double)(2 * this.m_vertBorder) + (double)(n3 > 0 && d6 > 0.0 ? this.m_imageMargin : 0));
                        if (!bl) break;
                    }
                    default: {
                        throw new IllegalStateException(z[4]);
                    }
                }
                LabelRenderer.getAlignedPoint(this.m_pt, visualItem, d3, d2, this.m_xAlign, this.m_yAlign);
                if (!(this.m_bbox instanceof RoundRectangle2D)) break block9;
                RoundRectangle2D roundRectangle2D = (RoundRectangle2D)this.m_bbox;
                roundRectangle2D.setRoundRect(this.m_pt.getX(), this.m_pt.getY(), d3, d2, d4 * (double)this.m_arcWidth, d4 * (double)this.m_arcHeight);
                if (!bl) break block10;
            }
            this.m_bbox.setFrame(this.m_pt.getX(), this.m_pt.getY(), d3, d2);
        }
        return this.m_bbox;
    }

    protected static void getAlignedPoint(Point2D point2D, VisualItem visualItem, double d2, double d3, int n2, int n3) {
        double d4;
        double d5;
        block13: {
            block12: {
                boolean bl;
                block11: {
                    block10: {
                        bl = AbstractShapeRenderer.b;
                        d5 = visualItem.getX();
                        d4 = visualItem.getY();
                        if (Double.isNaN(d5) || Double.isInfinite(d5)) {
                            d5 = 0.0;
                        }
                        if (Double.isNaN(d4) || Double.isInfinite(d4)) {
                            d4 = 0.0;
                        }
                        if (n2 != 2) break block10;
                        d5 -= d2 / 2.0;
                        if (!bl) break block11;
                    }
                    if (n2 == 1) {
                        d5 -= d2;
                    }
                }
                if (n3 != 2) break block12;
                d4 -= d3 / 2.0;
                if (!bl) break block13;
            }
            if (n3 == 3) {
                d4 -= d3;
            }
        }
        point2D.setLocation(d5, d4);
    }

    @Override
    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl;
        double d6;
        String string;
        int n2;
        RectangularShape rectangularShape;
        boolean bl2;
        block40: {
            double d7;
            Image image;
            block42: {
                block41: {
                    bl2 = AbstractShapeRenderer.b;
                    rectangularShape = (RectangularShape)this.getShape(visualItem);
                    if (rectangularShape == null) {
                        return;
                    }
                    n2 = this.getRenderType(visualItem);
                    if (n2 == 2 || n2 == 3) {
                        GraphicsLib.paint(graphics2D, visualItem, rectangularShape, this.getStroke(visualItem), 2);
                    }
                    string = this.m_text;
                    image = this.getImage(visualItem);
                    if (string == null && image == null) {
                        return;
                    }
                    d6 = visualItem.getSize();
                    bl = 1.5 > Math.max(graphics2D.getTransform().getScaleX(), graphics2D.getTransform().getScaleY());
                    d5 = rectangularShape.getMinX() + d6 * (double)this.m_horizBorder;
                    d4 = rectangularShape.getMinY() + d6 * (double)this.m_vertBorder;
                    if (image == null) break block40;
                    double d8 = d6 * (double)image.getWidth(null);
                    d3 = d6 * (double)image.getHeight(null);
                    d2 = d5;
                    d7 = d4;
                    switch (this.m_imagePos) {
                        case 0: {
                            d5 += d8 + d6 * (double)this.m_imageMargin;
                            if (!bl2) break;
                        }
                        case 1: {
                            d2 = rectangularShape.getMaxX() - d6 * (double)this.m_horizBorder - d8;
                            if (!bl2) break;
                        }
                        case 4: {
                            d4 += d3 + d6 * (double)this.m_imageMargin;
                            if (!bl2) break;
                        }
                        case 3: {
                            d7 = rectangularShape.getMaxY() - d6 * (double)this.m_vertBorder - d3;
                            if (!bl2) break;
                        }
                        default: {
                            throw new IllegalStateException(z[4]);
                        }
                    }
                    switch (this.m_imagePos) {
                        case 0: 
                        case 1: {
                            switch (this.m_vImageAlign) {
                                case 4: {
                                    if (!bl2) break;
                                }
                                case 3: {
                                    d7 = rectangularShape.getMaxY() - d6 * (double)this.m_vertBorder - d3;
                                    if (!bl2) break;
                                }
                                case 2: {
                                    d7 = rectangularShape.getCenterY() - d3 / 2.0;
                                }
                            }
                            if (!bl2) break;
                        }
                        case 3: 
                        case 4: {
                            switch (this.m_hImageAlign) {
                                case 0: {
                                    if (!bl2) break block41;
                                }
                                case 1: {
                                    d2 = rectangularShape.getMaxX() - d6 * (double)this.m_horizBorder - d8;
                                    if (!bl2) break block41;
                                }
                                case 2: {
                                    d2 = rectangularShape.getCenterX() - d8 / 2.0;
                                }
                            }
                        }
                    }
                }
                if (!bl || d6 != 1.0) break block42;
                graphics2D.drawImage(image, (int)d2, (int)d7, null);
                if (!bl2) break block40;
            }
            this.c.setTransform(d6, 0.0, 0.0, d6, d2, d7);
            graphics2D.drawImage(image, this.c, null);
        }
        int n3 = visualItem.getTextColor();
        if (string != null && ColorLib.alpha(n3) > 0) {
            graphics2D.setPaint(ColorLib.getColor(n3));
            graphics2D.setFont(this.m_font);
            FontMetrics fontMetrics = DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
            switch (this.m_imagePos) {
                case 3: 
                case 4: {
                    d3 = rectangularShape.getWidth() - 2.0 * d6 * (double)this.m_horizBorder;
                    if (!bl2) break;
                }
                default: {
                    d3 = this.m_textDim.width;
                }
            }
            switch (this.m_imagePos) {
                case 0: 
                case 1: {
                    d2 = rectangularShape.getHeight() - 2.0 * d6 * (double)this.m_vertBorder;
                    if (!bl2) break;
                }
                default: {
                    d2 = this.m_textDim.height;
                }
            }
            d4 += (double)fontMetrics.getAscent();
            switch (this.m_vTextAlign) {
                case 4: {
                    if (!bl2) break;
                }
                case 3: {
                    d4 += d2 - (double)this.m_textDim.height;
                    if (!bl2) break;
                }
                case 2: {
                    d4 += (d2 - (double)this.m_textDim.height) / 2.0;
                }
            }
            int n4 = fontMetrics.getHeight();
            int n5 = 0;
            int n6 = string.indexOf(this.m_delim);
            while (n6 >= 0) {
                this.a(graphics2D, fontMetrics, string.substring(n5, n6), bl, d5, d4, d3);
                n5 = n6 + 1;
                n6 = string.indexOf(this.m_delim, n5);
                d4 += (double)n4;
                if (!bl2) continue;
            }
            this.a(graphics2D, fontMetrics, string.substring(n5), bl, d5, d4, d3);
        }
        if (n2 == 1 || n2 == 3) {
            GraphicsLib.paint(graphics2D, visualItem, rectangularShape, this.getStroke(visualItem), 1);
        }
    }

    private final void a(Graphics2D graphics2D, FontMetrics fontMetrics, String string, boolean bl, double d2, double d3, double d4) {
        block8: {
            double d5;
            block7: {
                boolean bl2 = AbstractShapeRenderer.b;
                switch (this.m_hTextAlign) {
                    case 0: {
                        d5 = d2;
                        if (!bl2) break;
                    }
                    case 1: {
                        d5 = d2 + d4 - (double)fontMetrics.stringWidth(string);
                        if (!bl2) break;
                    }
                    case 2: {
                        d5 = d2 + (d4 - (double)fontMetrics.stringWidth(string)) / 2.0;
                        if (!bl2) break;
                    }
                    default: {
                        throw new IllegalStateException(z[5]);
                    }
                }
                if (!bl) break block7;
                graphics2D.drawString(string, (int)d5, (int)d3);
                if (!bl2) break block8;
            }
            graphics2D.drawString(string, (float)d5, (float)d3);
        }
    }

    public ImageFactory getImageFactory() {
        if (this.m_images == null) {
            this.m_images = new ImageFactory();
        }
        return this.m_images;
    }

    public void setImageFactory(ImageFactory imageFactory) {
        this.m_images = imageFactory;
    }

    public int getHorizontalTextAlignment() {
        return this.m_hTextAlign;
    }

    public void setHorizontalTextAlignment(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException(z[1]);
        }
        this.m_hTextAlign = n2;
    }

    public int getVerticalTextAlignment() {
        return this.m_vTextAlign;
    }

    public void setVerticalTextAlignment(int n2) {
        if (n2 != 4 && n2 != 3 && n2 != 2) {
            throw new IllegalArgumentException(z[2]);
        }
        this.m_vTextAlign = n2;
    }

    public int getHorizontalImageAlignment() {
        return this.m_hImageAlign;
    }

    public void setHorizontalImageAlignment(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException(z[1]);
        }
        this.m_hImageAlign = n2;
    }

    public int getVerticalImageAlignment() {
        return this.m_vImageAlign;
    }

    public void setVerticalImageAlignment(int n2) {
        if (n2 != 4 && n2 != 3 && n2 != 2) {
            throw new IllegalArgumentException(z[2]);
        }
        this.m_vImageAlign = n2;
    }

    public int getImagePosition() {
        return this.m_imagePos;
    }

    public void setImagePosition(int n2) {
        if (n2 != 4 && n2 != 3 && n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException(z[3]);
        }
        this.m_imagePos = n2;
    }

    public int getHorizontalAlignment() {
        return this.m_xAlign;
    }

    public int getVerticalAlignment() {
        return this.m_yAlign;
    }

    public void setHorizontalAlignment(int n2) {
        this.m_xAlign = n2;
    }

    public void setVerticalAlignment(int n2) {
        this.m_yAlign = n2;
    }

    public int getHorizontalPadding() {
        return this.m_horizBorder;
    }

    public void setHorizontalPadding(int n2) {
        this.m_horizBorder = n2;
    }

    public int getVerticalPadding() {
        return this.m_vertBorder;
    }

    public void setVerticalPadding(int n2) {
        this.m_vertBorder = n2;
    }

    public int getImageTextPadding() {
        return this.m_imageMargin;
    }

    public void setImageTextPadding(int n2) {
        this.m_imageMargin = n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "2\u0017mWQ";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 94;
                                break;
                            }
                            case 1: {
                                n9 = 118;
                                break;
                            }
                            case 2: {
                                n9 = 15;
                                break;
                            }
                            case 3: {
                                n9 = 50;
                                break;
                            }
                            default: {
                                n9 = 61;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0017\u001acWZ?\u001a/ZR,\u001fu]S*\u0017c\u0012I;\u000e{\u0012\\2\u001fh\\P;\u0018{\u0012K?\u001azW\u0013";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0017\u001acWZ?\u001a/DX,\u0002fQ\\2V{WE*Vn^T9\u0018bWS*VySQ+\u0013!";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0017\u001acWZ?\u001a/[P?\u0011j\u0012M1\u0005fFT1\u0018/D\\2\u0003j\u001c";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u000b\u0018}W^1\u0011a[G;\u0012/[P?\u0011j\u0012\\2\u001fh\\P;\u0018{\u0012N;\u0002{[S9X";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u000b\u0018}W^1\u0011a[G;\u0012/FX&\u0002/SQ7\u0011a_X0\u0002/AX*\u0002f\\Zp";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

