/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import prefuse.data.expression.AbstractExpression;
import prefuse.render.AbstractShapeRenderer;
import prefuse.visual.VisualItem;

public class ShapeRenderer
extends AbstractShapeRenderer {
    private int c = 10;
    private Ellipse2D d = new Ellipse2D.Double();
    private Rectangle2D e = new Rectangle2D.Double();
    private GeneralPath f = new GeneralPath();
    private static final String z;

    public ShapeRenderer() {
    }

    public ShapeRenderer(int n2) {
        this.setBaseSize(n2);
    }

    public void setBaseSize(int n2) {
        this.c = n2;
    }

    public int getBaseSize() {
        return this.c;
    }

    @Override
    protected Shape getRawShape(VisualItem visualItem) {
        double d2;
        double d3;
        int n2 = visualItem.getShape();
        double d4 = visualItem.getX();
        if (Double.isNaN(d4) || Double.isInfinite(d4)) {
            d4 = 0.0;
        }
        if (Double.isNaN(d3 = visualItem.getY()) || Double.isInfinite(d3)) {
            d3 = 0.0;
        }
        if ((d2 = (double)this.c * visualItem.getSize()) > 1.0) {
            d4 -= d2 / 2.0;
            d3 -= d2 / 2.0;
        }
        switch (n2) {
            case -1: {
                return null;
            }
            case 0: {
                return this.rectangle(d4, d3, d2, d2);
            }
            case 1: {
                return this.ellipse(d4, d3, d2, d2);
            }
            case 5: {
                return this.triangle_up((float)d4, (float)d3, (float)d2);
            }
            case 6: {
                return this.triangle_down((float)d4, (float)d3, (float)d2);
            }
            case 7: {
                return this.triangle_left((float)d4, (float)d3, (float)d2);
            }
            case 8: {
                return this.triangle_right((float)d4, (float)d3, (float)d2);
            }
            case 3: {
                return this.cross((float)d4, (float)d3, (float)d2);
            }
            case 4: {
                return this.star((float)d4, (float)d3, (float)d2);
            }
            case 9: {
                return this.hexagon((float)d4, (float)d3, (float)d2);
            }
            case 2: {
                return this.diamond((float)d4, (float)d3, (float)d2);
            }
        }
        throw new IllegalStateException(z + n2);
    }

    public Shape rectangle(double d2, double d3, double d4, double d5) {
        this.e.setFrame(d2, d3, d4, d5);
        return this.e;
    }

    public Shape ellipse(double d2, double d3, double d4, double d5) {
        this.d.setFrame(d2, d3, d4, d5);
        return this.d;
    }

    public Shape triangle_up(float f2, float f3, float f4) {
        this.f.reset();
        this.f.moveTo(f2, f3 + f4);
        this.f.lineTo(f2 + f4 / 2.0f, f3);
        this.f.lineTo(f2 + f4, f3 + f4);
        this.f.closePath();
        return this.f;
    }

    public Shape triangle_down(float f2, float f3, float f4) {
        this.f.reset();
        this.f.moveTo(f2, f3);
        this.f.lineTo(f2 + f4, f3);
        this.f.lineTo(f2 + f4 / 2.0f, f3 + f4);
        this.f.closePath();
        return this.f;
    }

    public Shape triangle_left(float f2, float f3, float f4) {
        this.f.reset();
        this.f.moveTo(f2 + f4, f3);
        this.f.lineTo(f2 + f4, f3 + f4);
        this.f.lineTo(f2, f3 + f4 / 2.0f);
        this.f.closePath();
        return this.f;
    }

    public Shape triangle_right(float f2, float f3, float f4) {
        this.f.reset();
        this.f.moveTo(f2, f3 + f4);
        this.f.lineTo(f2 + f4, f3 + f4 / 2.0f);
        this.f.lineTo(f2, f3);
        this.f.closePath();
        return this.f;
    }

    public Shape cross(float f2, float f3, float f4) {
        boolean bl = AbstractShapeRenderer.b;
        float f5 = 3.0f * f4 / 8.0f;
        float f6 = 5.0f * f4 / 8.0f;
        this.f.reset();
        this.f.moveTo(f2 + f5, f3);
        this.f.lineTo(f2 + f6, f3);
        this.f.lineTo(f2 + f6, f3 + f5);
        this.f.lineTo(f2 + f4, f3 + f5);
        this.f.lineTo(f2 + f4, f3 + f6);
        this.f.lineTo(f2 + f6, f3 + f6);
        this.f.lineTo(f2 + f6, f3 + f4);
        this.f.lineTo(f2 + f5, f3 + f4);
        this.f.lineTo(f2 + f5, f3 + f6);
        this.f.lineTo(f2, f3 + f6);
        this.f.lineTo(f2, f3 + f5);
        this.f.lineTo(f2 + f5, f3 + f5);
        this.f.closePath();
        if (AbstractExpression.b) {
            AbstractShapeRenderer.b = !bl;
        }
        return this.f;
    }

    public Shape star(float f2, float f3, float f4) {
        boolean bl = AbstractShapeRenderer.b;
        float f5 = (float)((double)f4 / (2.0 * Math.sin(Math.toRadians(54.0))));
        float f6 = (float)((double)f4 / (2.0 * Math.tan(Math.toRadians(54.0))));
        float f7 = (float)((double)f5 * Math.sin(Math.toRadians(18.0)));
        float f8 = (float)((double)f5 * Math.cos(Math.toRadians(18.0)));
        float f9 = (float)((double)f5 / (2.0 * Math.cos(Math.toRadians(36.0))));
        float f10 = f9 * (float)Math.sin(Math.toRadians(36.0));
        float f11 = f9 * (float)Math.cos(Math.toRadians(36.0));
        this.f.reset();
        this.f.moveTo(f2, f3 + f6);
        this.f.lineTo(f2 + f9, f3 + f6);
        this.f.lineTo(f2 + f4 / 2.0f, f3);
        this.f.lineTo(f2 + f4 - f9, f3 + f6);
        this.f.lineTo(f2 + f4, f3 + f6);
        this.f.lineTo(f2 + f4 - f11, f3 + f6 + f10);
        this.f.lineTo(f2 + f4 - f7, f3 + f4);
        this.f.lineTo(f2 + f4 / 2.0f, f3 + f6 + f8 - f10);
        this.f.lineTo(f2 + f7, f3 + f4);
        this.f.lineTo(f2 + f11, f3 + f6 + f10);
        this.f.closePath();
        if (bl) {
            AbstractExpression.b = !AbstractExpression.b;
        }
        return this.f;
    }

    public Shape hexagon(float f2, float f3, float f4) {
        float f5 = f4 / 2.0f;
        this.f.reset();
        this.f.moveTo(f2, f3 + 0.5f * f4);
        this.f.lineTo(f2 + 0.5f * f5, f3);
        this.f.lineTo(f2 + 1.5f * f5, f3);
        this.f.lineTo(f2 + 2.0f * f5, f3 + 0.5f * f4);
        this.f.lineTo(f2 + 1.5f * f5, f3 + f4);
        this.f.lineTo(f2 + 0.5f * f5, f3 + f4);
        this.f.closePath();
        return this.f;
    }

    public Shape diamond(float f2, float f3, float f4) {
        this.f.reset();
        this.f.moveTo(f2, f3 + 0.5f * f4);
        this.f.lineTo(f2 + 0.5f * f4, f3);
        this.f.lineTo(f2 + f4, f3 + 0.5f * f4);
        this.f.lineTo(f2 + 0.5f * f4, f3 + f4);
        this.f.closePath();
        return this.f;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\u001d\u001c'\u000fI?\u001cl\u0012N)\u0002)AR1\u0002)[\u0006".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 72;
                            break;
                        }
                        case 1: {
                            n7 = 114;
                            break;
                        }
                        case 2: {
                            n7 = 76;
                            break;
                        }
                        case 3: {
                            n7 = 97;
                            break;
                        }
                        default: {
                            n7 = 38;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }
}

