/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Comparator;
import java.util.Random;
import java.util.StringTokenizer;
import prefuse.util.ColorLib;

public abstract class ArrayLib {
    public static final int SORT_THRESHOLD = 30;

    public static final void shuffle(int[] nArray, Random random) {
        ArrayLib.shuffle(nArray, 0, nArray.length, random);
    }

    public static final void shuffle(int[] nArray, int n2, int n3, Random random) {
        int n4 = ColorLib.d;
        int n5 = n2 + n3;
        while (--n5 > 0) {
            int n6 = nArray[n5];
            int n7 = random.nextInt(n5);
            nArray[n5] = nArray[n7];
            nArray[n7] = n6;
            if (n4 == 0) continue;
        }
    }

    public static final void shuffle(long[] lArray, Random random) {
        ArrayLib.shuffle(lArray, 0, lArray.length, random);
    }

    public static final void shuffle(long[] lArray, int n2, int n3, Random random) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + n3; i2 > 1; --i2) {
            long l2 = lArray[i2];
            int n5 = random.nextInt(i2);
            lArray[i2] = lArray[n5];
            lArray[n5] = l2;
            if (n4 == 0) continue;
        }
    }

    public static final void shuffle(float[] fArray, Random random) {
        ArrayLib.shuffle(fArray, 0, fArray.length, random);
    }

    public static final void shuffle(float[] fArray, int n2, int n3, Random random) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + n3; i2 > 1; --i2) {
            float f2 = fArray[i2];
            int n5 = random.nextInt(i2);
            fArray[i2] = fArray[n5];
            fArray[n5] = f2;
            if (n4 == 0) continue;
        }
    }

    public static final void shuffle(double[] dArray, Random random) {
        ArrayLib.shuffle(dArray, 0, dArray.length, random);
    }

    public static final void shuffle(double[] dArray, int n2, int n3, Random random) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + n3; i2 > 1; --i2) {
            double d2 = dArray[i2];
            int n5 = random.nextInt(i2);
            dArray[i2] = dArray[n5];
            dArray[n5] = d2;
            if (n4 == 0) continue;
        }
    }

    public static final void shuffle(Object[] objectArray, Random random) {
        ArrayLib.shuffle(objectArray, 0, objectArray.length, random);
    }

    public static final void shuffle(Object[] objectArray, int n2, int n3, Random random) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + n3; i2 > 1; --i2) {
            Object object = objectArray[i2];
            int n5 = random.nextInt(i2);
            objectArray[i2] = objectArray[n5];
            objectArray[n5] = object;
            if (n4 == 0) continue;
        }
    }

    public static final double max(double[] dArray) {
        int n2 = ColorLib.d;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] > d2)) continue;
            d2 = dArray[i2];
            if (n2 == 0) continue;
        }
        return d2;
    }

    public static final double min(double[] dArray) {
        int n2 = ColorLib.d;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] < d2)) continue;
            d2 = dArray[i2];
            if (n2 == 0) continue;
        }
        return d2;
    }

    public static final double sum(double[] dArray) {
        int n2 = ColorLib.d;
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += dArray[i2];
            if (n2 == 0) continue;
        }
        return d2;
    }

    public static final int binarySearch(int[] nArray, int n2) {
        int n3 = ColorLib.d;
        int n4 = 0;
        int n5 = nArray.length;
        int n6 = n5 / 2;
        while (n4 < n5) {
            block6: {
                block5: {
                    if (nArray[n6] == n2) {
                        return n6;
                    }
                    if (nArray[n6] >= n2) break block5;
                    n4 = n6 + 1;
                    if (n3 == 0) break block6;
                }
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
            if (n3 == 0) continue;
        }
        return -1 * (n6 + 1);
    }

    public static final int binarySearch(int[] nArray, int n2, int n3) {
        int n4 = ColorLib.d;
        int n5 = 0;
        int n6 = n3;
        int n7 = n6 / 2;
        while (n5 < n6) {
            block6: {
                block5: {
                    if (nArray[n7] == n2) {
                        return n7;
                    }
                    if (nArray[n7] >= n2) break block5;
                    n5 = n7 + 1;
                    if (n4 == 0) break block6;
                }
                n6 = n7;
            }
            n7 = n5 + (n6 - n5) / 2;
            if (n4 == 0) continue;
        }
        return -1 * (n7 + 1);
    }

    public static final int binarySearch(int[] nArray, int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        int n6 = n3;
        int n7 = n4;
        int n8 = n6 + (n7 - n6) / 2;
        while (n6 < n7) {
            block6: {
                block5: {
                    if (nArray[n8] == n2) {
                        return n8;
                    }
                    if (nArray[n8] >= n2) break block5;
                    n6 = n8 + 1;
                    if (n5 == 0) break block6;
                }
                n7 = n8;
            }
            n8 = n6 + (n7 - n6) / 2;
            if (n5 == 0) continue;
        }
        return -1 * (n8 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object) {
        int n2 = ColorLib.d;
        int n3 = 0;
        int n4 = objectArray.length;
        int n5 = n4 / 2;
        while (n3 < n4) {
            block6: {
                block5: {
                    int n6 = ((Comparable)objectArray[n5]).compareTo(object);
                    if (n6 == 0) {
                        return n5;
                    }
                    if (n6 >= 0) break block5;
                    n3 = n5 + 1;
                    if (n2 == 0) break block6;
                }
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
            if (n2 == 0) continue;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, int n2) {
        int n3 = ColorLib.d;
        int n4 = 0;
        int n5 = n2;
        int n6 = n5 / 2;
        while (n4 < n5) {
            block6: {
                block5: {
                    int n7 = ((Comparable)objectArray[n6]).compareTo(object);
                    if (n7 == 0) {
                        return n6;
                    }
                    if (n7 >= 0) break block5;
                    n4 = n6 + 1;
                    if (n3 == 0) break block6;
                }
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
            if (n3 == 0) continue;
        }
        return -1 * (n6 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, int n2, int n3) {
        int n4 = ColorLib.d;
        int n5 = n2;
        int n6 = n3;
        int n7 = n5 + (n6 - n5) / 2;
        while (n5 < n6) {
            block6: {
                block5: {
                    int n8 = ((Comparable)objectArray[n7]).compareTo(object);
                    if (n8 == 0) {
                        return n7;
                    }
                    if (n8 >= 0) break block5;
                    n5 = n7 + 1;
                    if (n4 == 0) break block6;
                }
                n6 = n7;
            }
            n7 = n5 + (n6 - n5) / 2;
            if (n4 == 0) continue;
        }
        return -1 * (n7 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator) {
        int n2 = ColorLib.d;
        int n3 = 0;
        int n4 = objectArray.length;
        int n5 = n4 / 2;
        while (n3 < n4) {
            block6: {
                block5: {
                    int n6 = comparator.compare(objectArray[n5], object);
                    if (n6 == 0) {
                        return n5;
                    }
                    if (n6 >= 0) break block5;
                    n3 = n5 + 1;
                    if (n2 == 0) break block6;
                }
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
            if (n2 == 0) continue;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator, int n2) {
        int n3 = ColorLib.d;
        int n4 = 0;
        int n5 = n2;
        int n6 = n5 / 2;
        while (n4 < n5) {
            block6: {
                block5: {
                    int n7 = comparator.compare(objectArray[n6], object);
                    if (n7 == 0) {
                        return n6;
                    }
                    if (n7 >= 0) break block5;
                    n4 = n6 + 1;
                    if (n3 == 0) break block6;
                }
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
            if (n3 == 0) continue;
        }
        return -1 * (n6 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator, int n2, int n3) {
        int n4 = ColorLib.d;
        int n5 = n2;
        int n6 = n3;
        int n7 = n5 + (n6 - n5) / 2;
        while (n5 < n6) {
            block6: {
                block5: {
                    int n8 = comparator.compare(objectArray[n7], object);
                    if (n8 == 0) {
                        return n7;
                    }
                    if (n8 >= 0) break block5;
                    n5 = n7 + 1;
                    if (n4 == 0) break block6;
                }
                n6 = n7;
            }
            n7 = n5 + (n6 - n5) / 2;
            if (n4 == 0) continue;
        }
        return -1 * (n7 + 1);
    }

    public static final int find(int[] nArray, int n2) {
        int n3 = ColorLib.d;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static final int find(int[] nArray, int n2, int n3) {
        int n4 = ColorLib.d;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static final int find(int[] nArray, int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        for (int i2 = n3; i2 < n4; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static final int[] resize(int[] nArray, int n2) {
        if (nArray.length >= n2) {
            return nArray;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final float[] resize(float[] fArray, int n2) {
        if (fArray.length >= n2) {
            return fArray;
        }
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public static final double[] resize(double[] dArray, int n2) {
        if (dArray.length >= n2) {
            return dArray;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static final Object[] resize(Object[] objectArray, int n2) {
        if (objectArray.length >= n2) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static final int[] trim(int[] nArray, int n2) {
        if (nArray.length == n2) {
            return nArray;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static final float[] trim(float[] fArray, int n2) {
        if (fArray.length == n2) {
            return fArray;
        }
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        return fArray2;
    }

    public static final double[] trim(double[] dArray, int n2) {
        if (dArray.length == n2) {
            return dArray;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        return dArray2;
    }

    public static final Object[] trim(Object[] objectArray, int n2) {
        if (objectArray.length == n2) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    public static final void sort(int[] nArray, double[] dArray) {
        ArrayLib.mergesort(nArray, dArray, 0, nArray.length - 1);
    }

    public static final void sort(int[] nArray, double[] dArray, int n2) {
        ArrayLib.mergesort(nArray, dArray, 0, n2 - 1);
    }

    public static final void sort(int[] nArray, double[] dArray, int n2, int n3) {
        ArrayLib.mergesort(nArray, dArray, n2, n3 - 1);
    }

    protected static final void insertionsort(int[] nArray, double[] dArray, int n2, int n3) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n5 = nArray[i2];
            double d2 = dArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && nArray[i3] > n5; --i3) {
                nArray[i3 + 1] = nArray[i3];
                dArray[i3 + 1] = dArray[i3];
                if (n4 == 0) continue;
            }
            nArray[i3 + 1] = n5;
            dArray[i3 + 1] = d2;
            if (n4 == 0) continue;
        }
    }

    protected static final void mergesort(int[] nArray, double[] dArray, int n2, int n3) {
        block5: {
            block4: {
                if (n2 >= n3) {
                    return;
                }
                if (n3 - n2 + 1 >= 30) break block4;
                ArrayLib.insertionsort(nArray, dArray, n2, n3);
                if (ColorLib.d == 0) break block5;
            }
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(nArray, dArray, n2, n4);
            ArrayLib.mergesort(nArray, dArray, n4 + 1, n3);
            ArrayLib.merge(nArray, dArray, n2, n4, n3);
        }
    }

    protected static final void merge(int[] nArray, double[] dArray, int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        int[] nArray2 = new int[n4 - n2 + 1];
        double[] dArray2 = new double[n4 - n2 + 1];
        int n6 = n2;
        int n7 = n3 + 1;
        int n8 = 0;
        while (n6 <= n3 && n7 <= n4) {
            block7: {
                block6: {
                    if (nArray[n6] >= nArray[n7]) break block6;
                    dArray2[n8] = dArray[n6];
                    nArray2[n8] = nArray[n6++];
                    if (n5 == 0) break block7;
                }
                dArray2[n8] = dArray[n7];
                nArray2[n8] = nArray[n7++];
            }
            ++n8;
            if (n5 == 0) continue;
        }
        while (n6 <= n3) {
            dArray2[n8] = dArray[n6];
            nArray2[n8] = nArray[n6];
            ++n6;
            ++n8;
            if (n5 == 0) continue;
        }
        while (n7 <= n4) {
            dArray2[n8] = dArray[n7];
            nArray2[n8] = nArray[n7];
            ++n7;
            ++n8;
            if (n5 == 0) continue;
        }
        n8 = 0;
        n6 = n2;
        while (n8 < nArray2.length) {
            dArray[n6] = dArray2[n8];
            nArray[n6] = nArray2[n8];
            ++n8;
            ++n6;
            if (n5 == 0) continue;
        }
    }

    public static final void sort(int[] nArray, int[] nArray2) {
        ArrayLib.mergesort(nArray, nArray2, 0, nArray.length - 1);
    }

    public static final void sort(int[] nArray, int[] nArray2, int n2) {
        ArrayLib.mergesort(nArray, nArray2, 0, n2 - 1);
    }

    public static final void sort(int[] nArray, int[] nArray2, int n2, int n3) {
        ArrayLib.mergesort(nArray, nArray2, n2, n3 - 1);
    }

    protected static final void insertionsort(int[] nArray, int[] nArray2, int n2, int n3) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n5 = nArray[i2];
            int n6 = nArray2[i2];
            for (int i3 = i2 - 1; i3 >= n2 && nArray[i3] > n5; --i3) {
                nArray[i3 + 1] = nArray[i3];
                nArray2[i3 + 1] = nArray2[i3];
                if (n4 == 0) continue;
            }
            nArray[i3 + 1] = n5;
            nArray2[i3 + 1] = n6;
            if (n4 == 0) continue;
        }
    }

    protected static final void mergesort(int[] nArray, int[] nArray2, int n2, int n3) {
        block5: {
            block4: {
                if (n2 >= n3) {
                    return;
                }
                if (n3 - n2 + 1 >= 30) break block4;
                ArrayLib.insertionsort(nArray, nArray2, n2, n3);
                if (ColorLib.d == 0) break block5;
            }
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(nArray, nArray2, n2, n4);
            ArrayLib.mergesort(nArray, nArray2, n4 + 1, n3);
            ArrayLib.merge(nArray, nArray2, n2, n4, n3);
        }
    }

    protected static final void merge(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        int[] nArray3 = new int[n4 - n2 + 1];
        int[] nArray4 = new int[n4 - n2 + 1];
        int n6 = n2;
        int n7 = n3 + 1;
        int n8 = 0;
        while (n6 <= n3 && n7 <= n4) {
            block7: {
                block6: {
                    if (nArray[n6] >= nArray[n7]) break block6;
                    nArray4[n8] = nArray2[n6];
                    nArray3[n8] = nArray[n6++];
                    if (n5 == 0) break block7;
                }
                nArray4[n8] = nArray2[n7];
                nArray3[n8] = nArray[n7++];
            }
            ++n8;
            if (n5 == 0) continue;
        }
        while (n6 <= n3) {
            nArray4[n8] = nArray2[n6];
            nArray3[n8] = nArray[n6];
            ++n6;
            ++n8;
            if (n5 == 0) continue;
        }
        while (n7 <= n4) {
            nArray4[n8] = nArray2[n7];
            nArray3[n8] = nArray[n7];
            ++n7;
            ++n8;
            if (n5 == 0) continue;
        }
        n8 = 0;
        n6 = n2;
        while (n8 < nArray3.length) {
            nArray2[n6] = nArray4[n8];
            nArray[n6] = nArray3[n8];
            ++n8;
            ++n6;
            if (n5 == 0) continue;
        }
    }

    public static final void sort(int[] nArray, Object[] objectArray, int n2, int n3) {
        int n4 = ColorLib.d;
        int n5 = n3 - n2;
        if (n5 < 30) {
            ArrayLib.insertionsort(nArray, objectArray, n2, n3 - 1);
            return;
        }
        int[] nArray2 = new int[n5];
        Object[] objectArray2 = new Object[n5];
        int n6 = 0;
        int n7 = n2;
        while (n6 < n5) {
            nArray2[n6] = nArray[n7];
            objectArray2[n6] = objectArray[n7];
            ++n6;
            ++n7;
            if (n4 == 0) continue;
        }
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n2, n3, -n2);
    }

    public static final void sort(int[] nArray, Object[] objectArray, int[] nArray2, Object[] objectArray2, int n2, int n3) {
        int n4 = ColorLib.d;
        int n5 = n3 - n2;
        if (n5 < 30) {
            ArrayLib.insertionsort(nArray, objectArray, n2, n3 - 1);
            return;
        }
        int n6 = 0;
        int n7 = n2;
        while (n6 < n5) {
            nArray2[n6] = nArray[n7];
            objectArray2[n6] = objectArray[n7];
            ++n6;
            ++n7;
            if (n4 == 0) continue;
        }
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n2, n3, -n2);
    }

    protected static final void insertionsort(int[] nArray, Object[] objectArray, int n2, int n3) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n5 = nArray[i2];
            Object object = objectArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && nArray[i3] > n5; --i3) {
                nArray[i3 + 1] = nArray[i3];
                objectArray[i3 + 1] = objectArray[i3];
                if (n4 == 0) continue;
            }
            nArray[i3 + 1] = n5;
            objectArray[i3 + 1] = object;
            if (n4 == 0) continue;
        }
    }

    protected static void mergesort(int[] nArray, int[] nArray2, Object[] objectArray, Object[] objectArray2, int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        int n6 = n3 - n2;
        if (n6 < 30) {
            ArrayLib.insertionsort(nArray2, objectArray2, n2, n3 - 1);
            return;
        }
        int n7 = n2;
        int n8 = n3;
        int n9 = (n2 += n4) + (n3 += n4) >> 1;
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n2, n9, -n4);
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n9, n3, -n4);
        if (nArray[n9 - 1] <= nArray[n9]) {
            System.arraycopy(nArray, n2, nArray2, n7, n6);
            System.arraycopy(objectArray, n2, objectArray2, n7, n6);
            return;
        }
        int n10 = n2;
        int n11 = n9;
        for (int i2 = n7; i2 < n8; ++i2) {
            if (n11 >= n3 || n10 < n9 && nArray[n10] <= nArray[n11]) {
                objectArray2[i2] = objectArray[n10];
                nArray2[i2] = nArray[n10++];
                if (n5 == 0) continue;
            }
            objectArray2[i2] = objectArray[n11];
            nArray2[i2] = nArray[n11++];
            if (n5 == 0) continue;
        }
    }

    protected static final void merge(int[] nArray, Object[] objectArray, int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        int[] nArray2 = new int[n4 - n2 + 1];
        Object[] objectArray2 = new Object[n4 - n2 + 1];
        int n6 = n2;
        int n7 = n3 + 1;
        int n8 = 0;
        while (n6 <= n3 && n7 <= n4) {
            block7: {
                block6: {
                    if (nArray[n6] >= nArray[n7]) break block6;
                    objectArray2[n8] = objectArray[n6];
                    nArray2[n8] = nArray[n6++];
                    if (n5 == 0) break block7;
                }
                objectArray2[n8] = objectArray[n7];
                nArray2[n8] = nArray[n7++];
            }
            ++n8;
            if (n5 == 0) continue;
        }
        while (n6 <= n3) {
            objectArray2[n8] = objectArray[n6];
            nArray2[n8] = nArray[n6];
            ++n6;
            ++n8;
            if (n5 == 0) continue;
        }
        while (n7 <= n4) {
            objectArray2[n8] = objectArray[n7];
            nArray2[n8] = nArray[n7];
            ++n7;
            ++n8;
            if (n5 == 0) continue;
        }
        n8 = 0;
        n6 = n2;
        while (n8 < nArray2.length) {
            objectArray[n6] = objectArray2[n8];
            nArray[n6] = nArray2[n8];
            ++n8;
            ++n6;
            if (n5 == 0) continue;
        }
    }

    public static final void sort(double[] dArray, int[] nArray) {
        ArrayLib.mergesort(dArray, nArray, 0, dArray.length - 1);
    }

    public static final void sort(double[] dArray, int[] nArray, int n2) {
        ArrayLib.mergesort(dArray, nArray, 0, n2 - 1);
    }

    public static final void sort(double[] dArray, int[] nArray, int n2, int n3) {
        ArrayLib.mergesort(dArray, nArray, n2, n3 - 1);
    }

    protected static final void insertionsort(double[] dArray, int[] nArray, int n2, int n3) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            double d2 = dArray[i2];
            int n5 = nArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && dArray[i3] > d2; --i3) {
                dArray[i3 + 1] = dArray[i3];
                nArray[i3 + 1] = nArray[i3];
                if (n4 == 0) continue;
            }
            dArray[i3 + 1] = d2;
            nArray[i3 + 1] = n5;
            if (n4 == 0) continue;
        }
    }

    protected static final void mergesort(double[] dArray, int[] nArray, int n2, int n3) {
        block5: {
            block4: {
                if (n2 >= n3) {
                    return;
                }
                if (n3 - n2 + 1 >= 30) break block4;
                ArrayLib.insertionsort(dArray, nArray, n2, n3);
                if (ColorLib.d == 0) break block5;
            }
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(dArray, nArray, n2, n4);
            ArrayLib.mergesort(dArray, nArray, n4 + 1, n3);
            ArrayLib.merge(dArray, nArray, n2, n4, n3);
        }
    }

    protected static final void merge(double[] dArray, int[] nArray, int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        double[] dArray2 = new double[n4 - n2 + 1];
        int[] nArray2 = new int[n4 - n2 + 1];
        int n6 = n2;
        int n7 = n3 + 1;
        int n8 = 0;
        while (n6 <= n3 && n7 <= n4) {
            block7: {
                block6: {
                    if (!(dArray[n6] < dArray[n7])) break block6;
                    nArray2[n8] = nArray[n6];
                    dArray2[n8] = dArray[n6++];
                    if (n5 == 0) break block7;
                }
                nArray2[n8] = nArray[n7];
                dArray2[n8] = dArray[n7++];
            }
            ++n8;
            if (n5 == 0) continue;
        }
        while (n6 <= n3) {
            nArray2[n8] = nArray[n6];
            dArray2[n8] = dArray[n6];
            ++n6;
            ++n8;
            if (n5 == 0) continue;
        }
        while (n7 <= n4) {
            nArray2[n8] = nArray[n7];
            dArray2[n8] = dArray[n7];
            ++n7;
            ++n8;
            if (n5 == 0) continue;
        }
        n8 = 0;
        n6 = n2;
        while (n8 < dArray2.length) {
            nArray[n6] = nArray2[n8];
            dArray[n6] = dArray2[n8];
            ++n8;
            ++n6;
            if (n5 == 0) continue;
        }
    }

    public static final void sort(float[] fArray, int[] nArray) {
        ArrayLib.mergesort(fArray, nArray, 0, fArray.length - 1);
    }

    public static final void sort(float[] fArray, int[] nArray, int n2) {
        ArrayLib.mergesort(fArray, nArray, 0, n2 - 1);
    }

    public static final void sort(float[] fArray, int[] nArray, int n2, int n3) {
        ArrayLib.mergesort(fArray, nArray, n2, n3 - 1);
    }

    protected static final void insertionsort(float[] fArray, int[] nArray, int n2, int n3) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            float f2 = fArray[i2];
            int n5 = nArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && fArray[i3] > f2; --i3) {
                fArray[i3 + 1] = fArray[i3];
                nArray[i3 + 1] = nArray[i3];
                if (n4 == 0) continue;
            }
            fArray[i3 + 1] = f2;
            nArray[i3 + 1] = n5;
            if (n4 == 0) continue;
        }
    }

    protected static final void mergesort(float[] fArray, int[] nArray, int n2, int n3) {
        block5: {
            block4: {
                if (n2 >= n3) {
                    return;
                }
                if (n3 - n2 + 1 >= 30) break block4;
                ArrayLib.insertionsort(fArray, nArray, n2, n3);
                if (ColorLib.d == 0) break block5;
            }
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(fArray, nArray, n2, n4);
            ArrayLib.mergesort(fArray, nArray, n4 + 1, n3);
            ArrayLib.merge(fArray, nArray, n2, n4, n3);
        }
    }

    protected static final void merge(float[] fArray, int[] nArray, int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        float[] fArray2 = new float[n4 - n2 + 1];
        int[] nArray2 = new int[n4 - n2 + 1];
        int n6 = n2;
        int n7 = n3 + 1;
        int n8 = 0;
        while (n6 <= n3 && n7 <= n4) {
            block7: {
                block6: {
                    if (!(fArray[n6] < fArray[n7])) break block6;
                    nArray2[n8] = nArray[n6];
                    fArray2[n8] = fArray[n6++];
                    if (n5 == 0) break block7;
                }
                nArray2[n8] = nArray[n7];
                fArray2[n8] = fArray[n7++];
            }
            ++n8;
            if (n5 == 0) continue;
        }
        while (n6 <= n3) {
            nArray2[n8] = nArray[n6];
            fArray2[n8] = fArray[n6];
            ++n6;
            ++n8;
            if (n5 == 0) continue;
        }
        while (n7 <= n4) {
            nArray2[n8] = nArray[n7];
            fArray2[n8] = fArray[n7];
            ++n7;
            ++n8;
            if (n5 == 0) continue;
        }
        n8 = 0;
        n6 = n2;
        while (n8 < fArray2.length) {
            nArray[n6] = nArray2[n8];
            fArray[n6] = fArray2[n8];
            ++n8;
            ++n6;
            if (n5 == 0) continue;
        }
    }

    public static final void sort(Object[] objectArray, int[] nArray, Comparator comparator) {
        ArrayLib.mergesort(objectArray, nArray, 0, objectArray.length - 1, comparator);
    }

    public static final void sort(Object[] objectArray, int[] nArray, int n2, Comparator comparator) {
        ArrayLib.mergesort(objectArray, nArray, 0, n2 - 1, comparator);
    }

    public static final void sort(Object[] objectArray, int[] nArray, int n2, int n3, Comparator comparator) {
        ArrayLib.mergesort(objectArray, nArray, n2, n3 - 1, comparator);
    }

    protected static final void insertionsort(Object[] objectArray, int[] nArray, int n2, int n3, Comparator comparator) {
        int n4 = ColorLib.d;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            Object object = objectArray[i2];
            int n5 = nArray[i2];
            for (int i3 = i2 - 1; i3 >= n2 && comparator.compare(objectArray[i3], object) > 0; --i3) {
                objectArray[i3 + 1] = objectArray[i3];
                nArray[i3 + 1] = nArray[i3];
                if (n4 == 0) continue;
            }
            objectArray[i3 + 1] = object;
            nArray[i3 + 1] = n5;
            if (n4 == 0) continue;
        }
    }

    protected static final void mergesort(Object[] objectArray, int[] nArray, int n2, int n3, Comparator comparator) {
        block5: {
            block4: {
                if (n2 >= n3) {
                    return;
                }
                if (n3 - n2 + 1 >= 30) break block4;
                ArrayLib.insertionsort(objectArray, nArray, n2, n3, comparator);
                if (ColorLib.d == 0) break block5;
            }
            int n4 = (n2 + n3) / 2;
            ArrayLib.mergesort(objectArray, nArray, n2, n4, comparator);
            ArrayLib.mergesort(objectArray, nArray, n4 + 1, n3, comparator);
            ArrayLib.merge(objectArray, nArray, n2, n4, n3, comparator);
        }
    }

    protected static final void merge(Object[] objectArray, int[] nArray, int n2, int n3, int n4, Comparator comparator) {
        int n5 = ColorLib.d;
        Object[] objectArray2 = new Object[n4 - n2 + 1];
        int[] nArray2 = new int[n4 - n2 + 1];
        int n6 = n2;
        int n7 = n3 + 1;
        int n8 = 0;
        while (n6 <= n3 && n7 <= n4) {
            block7: {
                block6: {
                    if (comparator.compare(objectArray[n6], objectArray[n7]) >= 0) break block6;
                    nArray2[n8] = nArray[n6];
                    objectArray2[n8] = objectArray[n6++];
                    if (n5 == 0) break block7;
                }
                nArray2[n8] = nArray[n7];
                objectArray2[n8] = objectArray[n7++];
            }
            ++n8;
            if (n5 == 0) continue;
        }
        while (n6 <= n3) {
            nArray2[n8] = nArray[n6];
            objectArray2[n8] = objectArray[n6];
            ++n6;
            ++n8;
            if (n5 == 0) continue;
        }
        while (n7 <= n4) {
            nArray2[n8] = nArray[n7];
            objectArray2[n8] = objectArray[n7];
            ++n7;
            ++n8;
            if (n5 == 0) continue;
        }
        n8 = 0;
        n6 = n2;
        while (n8 < objectArray2.length) {
            nArray[n6] = nArray2[n8];
            objectArray[n6] = objectArray2[n8];
            ++n8;
            ++n6;
            if (n5 == 0) continue;
        }
    }

    public static int[] getIntArray(String string) {
        int n2 = ColorLib.d;
        int[] nArray = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n3 = stringTokenizer.countTokens();
            int n4 = 0;
            nArray = new int[n3];
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("#") && n2 == 0) continue;
                nArray[n4++] = Integer.parseInt(string3);
                if (n2 == 0) continue;
            }
            if (n4 != n3) {
                nArray = ArrayLib.trim(nArray, n4);
            }
            return nArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

