/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.Color;
import prefuse.util.collections.IntObjectHashMap;

public class ColorLib {
    public static final char HEX_PREFIX = '#';
    private static final IntObjectHashMap a = new IntObjectHashMap();
    private static int b = 0;
    private static int c = 0;
    public static final float[] CATEGORY_HUES = new float[]{0.0f, 0.083333336f, 0.16666667f, 0.33333334f, 0.5f, 0.5833333f, 0.6666667f, 0.8333333f, 0.9166667f};
    public static final int DEFAULT_MAP_SIZE = 64;
    public static int d;

    public static int rgb(int n2, int n3, int n4) {
        return ColorLib.rgba(n2, n3, n4, 255);
    }

    public static int gray(int n2) {
        return ColorLib.rgba(n2, n2, n2, 255);
    }

    public static int gray(int n2, int n3) {
        return ColorLib.rgba(n2, n2, n2, n3);
    }

    public static int hex(String string) {
        if (string.charAt(0) == '#') {
            string = string.substring(1);
        }
        if (string.length() > 6) {
            int n2 = Integer.parseInt(string.substring(2), 16);
            int n3 = Integer.parseInt(string.substring(0, 2), 16);
            return ColorLib.setAlpha(n2, n3);
        }
        return ColorLib.setAlpha(Integer.parseInt(string, 16), 255);
    }

    public static int hsb(float f2, float f3, float f4) {
        return Color.HSBtoRGB(f2, f3, f4);
    }

    public static int hsba(float f2, float f3, float f4, float f5) {
        return ColorLib.setAlpha(Color.HSBtoRGB(f2, f3, f4), (int)((double)(f5 * 255.0f) + 0.5) & 0xFF);
    }

    public static int rgba(int n2, int n3, int n4, int n5) {
        return (n5 & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 0;
    }

    public static int rgba(float f2, float f3, float f4, float f5) {
        return ((int)((double)(f5 * 255.0f) + 0.5) & 0xFF) << 24 | ((int)((double)(f2 * 255.0f) + 0.5) & 0xFF) << 16 | ((int)((double)(f3 * 255.0f) + 0.5) & 0xFF) << 8 | (int)((double)(f4 * 255.0f) + 0.5) & 0xFF;
    }

    public static int color(Color color) {
        return color.getRGB();
    }

    public static int red(int n2) {
        return n2 >> 16 & 0xFF;
    }

    public static int green(int n2) {
        return n2 >> 8 & 0xFF;
    }

    public static int blue(int n2) {
        return n2 & 0xFF;
    }

    public static int alpha(int n2) {
        return n2 >> 24 & 0xFF;
    }

    public static int setAlpha(int n2, int n3) {
        return ColorLib.rgba(ColorLib.red(n2), ColorLib.green(n2), ColorLib.blue(n2), n3);
    }

    public static Color getColor(float f2, float f3, float f4, float f5) {
        return ColorLib.getColor(ColorLib.rgba(f2, f3, f4, f5));
    }

    public static Color getColor(float f2, float f3, float f4) {
        return ColorLib.getColor(f2, f3, f4, 1.0f);
    }

    public static Color getColor(int n2, int n3, int n4, int n5) {
        return ColorLib.getColor(ColorLib.rgba(n2, n3, n4, n5));
    }

    public static Color getColor(int n2, int n3, int n4) {
        return ColorLib.getColor(n2, n3, n4, 255);
    }

    public static Color getGrayscale(int n2) {
        return ColorLib.getColor(n2, n2, n2, 255);
    }

    public static Color getColor(int n2) {
        Color color = null;
        color = (Color)a.get(n2);
        if (color == null) {
            color = new Color(n2, true);
            a.put(n2, color);
            ++b;
        }
        ++c;
        return color;
    }

    public static int getCacheMissCount() {
        return b;
    }

    public static int getCacheLookupCount() {
        return c;
    }

    public static void clearCache() {
        a.clear();
    }

    public static int interp(int n2, int n3, double d2) {
        double d3 = 1.0 - d2;
        return ColorLib.rgba((int)Math.round(d2 * (double)ColorLib.red(n3) + d3 * (double)ColorLib.red(n2)), (int)Math.round(d2 * (double)ColorLib.green(n3) + d3 * (double)ColorLib.green(n2)), (int)Math.round(d2 * (double)ColorLib.blue(n3) + d3 * (double)ColorLib.blue(n2)), (int)Math.round(d2 * (double)ColorLib.alpha(n3) + d3 * (double)ColorLib.alpha(n2)));
    }

    public static int darker(int n2) {
        return ColorLib.rgba(Math.max(0, (int)(0.7f * (float)ColorLib.red(n2))), Math.max(0, (int)(0.7f * (float)ColorLib.green(n2))), Math.max(0, (int)(0.7f * (float)ColorLib.blue(n2))), ColorLib.alpha(n2));
    }

    public static int brighter(int n2) {
        int n3 = ColorLib.red(n2);
        int n4 = ColorLib.green(n2);
        int n5 = ColorLib.blue(n2);
        int n6 = 3;
        if (n3 == 0 && n4 == 0 && n5 == 0) {
            return ColorLib.rgba(n6, n6, n6, ColorLib.alpha(n2));
        }
        if (n3 > 0 && n3 < n6) {
            n3 = n6;
        }
        if (n4 > 0 && n4 < n6) {
            n4 = n6;
        }
        if (n5 > 0 && n5 < n6) {
            n5 = n6;
        }
        return ColorLib.rgba(Math.min(255, (int)((float)n3 / 0.7f)), Math.min(255, (int)((float)n4 / 0.7f)), Math.min(255, (int)((float)n5 / 0.7f)), ColorLib.alpha(n2));
    }

    public static int desaturate(int n2) {
        int n3 = n2 & 0xFF000000;
        float f2 = (n2 & 0xFF0000) >> 16;
        float f3 = (n2 & 0xFF00) >> 8;
        float f4 = n2 & 0xFF;
        int n4 = Math.min((int)((f2 *= 0.2125f) + (f3 *= 0.7154f) + (f4 *= 0.0721f)), 255) & 0xFF;
        return n3 | n4 << 16 | n4 << 8 | n4;
    }

    public static int saturate(int n2, float f2) {
        float[] fArray = Color.RGBtoHSB(ColorLib.red(n2), ColorLib.green(n2), ColorLib.blue(n2), null);
        return ColorLib.hsb(fArray[0], f2, fArray[2]);
    }

    public static int[] getCoolPalette(int n2) {
        int n3 = d;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2 = (float)i2 / Math.max((float)(n2 - 1), 1.0f);
            nArray[i2] = ColorLib.rgba(f2, 1.0f - f2, 1.0f, 1.0f);
            if (n3 == 0) continue;
        }
        return nArray;
    }

    public static int[] getCoolPalette() {
        return ColorLib.getCoolPalette(64);
    }

    public static int[] getHotPalette(int n2) {
        int n3 = d;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2;
            int n4 = 3 * n2 / 8;
            float f3 = f2 = i2 < n4 ? (float)(i2 + 1) / (float)n4 : 1.0f;
            float f4 = i2 < n4 ? 0.0f : (i2 < 2 * n4 ? (float)(i2 - n4) / (float)n4 : 1.0f);
            float f5 = i2 < 2 * n4 ? 0.0f : (float)(i2 - 2 * n4) / (float)(n2 - 2 * n4);
            nArray[i2] = ColorLib.rgba(f2, f4, f5, 1.0f);
            if (n3 == 0) continue;
        }
        return nArray;
    }

    public static int[] getHotPalette() {
        return ColorLib.getHotPalette(64);
    }

    public static int[] getCategoryPalette(int n2, float f2, float f3, float f4, float f5) {
        int n3 = d;
        int[] nArray = new int[n2];
        float f6 = f2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2 % CATEGORY_HUES.length;
            if (n4 == 0) {
                f6 = f2 + (float)i2 / (float)n2 * (f3 - f2);
            }
            nArray[i2] = ColorLib.hsba(CATEGORY_HUES[n4], f6, f4, f5);
            if (n3 == 0) continue;
        }
        return nArray;
    }

    public static int[] getCategoryPalette(int n2) {
        return ColorLib.getCategoryPalette(n2, 1.0f, 0.4f, 1.0f, 1.0f);
    }

    public static int[] getHSBPalette(int n2, float f2, float f3) {
        int n3 = d;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            float f4 = (float)i2 / (float)(n2 - 1);
            nArray[i2] = ColorLib.hsb(f4, f2, f3);
            if (n3 == 0) continue;
        }
        return nArray;
    }

    public static int[] getHSBPalette() {
        return ColorLib.getHSBPalette(64, 1.0f, 1.0f);
    }

    public static int[] getInterpolatedPalette(int n2, int n3, int n4) {
        int n5 = d;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2 = (float)i2 / (float)(n2 - 1);
            nArray[i2] = ColorLib.interp(n3, n4, f2);
            if (n5 == 0) continue;
        }
        return nArray;
    }

    public static int[] getInterpolatedPalette(int n2, int n3) {
        return ColorLib.getInterpolatedPalette(64, n2, n3);
    }

    public static int[] getGrayscalePalette(int n2) {
        int n3 = d;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = Math.round(255.0f * (0.2f + 0.6f * (float)i2 / (float)(n2 - 1)));
            nArray[n2 - i2 - 1] = ColorLib.gray(n4);
            if (n3 == 0) continue;
        }
        return nArray;
    }

    public static int[] getGrayscalePalette() {
        return ColorLib.getGrayscalePalette(64);
    }
}

