/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.ArrayList;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tree;
import prefuse.util.ColorLib;

public class GraphLib {
    public static final String LABEL;
    public static final Schema LABEL_SCHEMA;
    private static final String[] z;

    private GraphLib() {
    }

    public static Graph getNodes(int n2) {
        int n3 = ColorLib.d;
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = graph.addNode();
            node.setString(LABEL, String.valueOf(i2));
            if (n3 == 0) continue;
        }
        return graph;
    }

    public static Graph getStar(int n2) {
        int n3 = ColorLib.d;
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = graph.addNode();
        node.setString(LABEL, "0");
        for (int i2 = 1; i2 <= n2; ++i2) {
            Node node2 = graph.addNode();
            node2.setString(LABEL, String.valueOf(i2));
            graph.addEdge(node, node2);
            if (n3 == 0) continue;
        }
        return graph;
    }

    public static Graph getClique(int n2) {
        int n3;
        int n4 = ColorLib.d;
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        Node[] nodeArray = new Node[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            nodeArray[n3] = graph.addNode();
            nodeArray[n3].setString(LABEL, String.valueOf(n3));
            if (n4 == 0) continue;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            for (int i2 = n3; i2 < n2; ++i2) {
                if (n3 == i2) continue;
                graph.addEdge(nodeArray[n3], nodeArray[i2]);
                if (n4 == 0) continue;
            }
            if (n4 == 0) continue;
        }
        return graph;
    }

    public static Graph getGrid(int n2, int n3) {
        int n4 = ColorLib.d;
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        Node[] nodeArray = new Node[n2 * n3];
        for (int i2 = 0; i2 < n2 * n3; ++i2) {
            nodeArray[i2] = graph.addNode();
            nodeArray[i2].setString(LABEL, String.valueOf(i2));
            if (i2 >= n3) {
                graph.addEdge(nodeArray[i2 - n3], nodeArray[i2]);
            }
            if (i2 % n3 == 0) continue;
            graph.addEdge(nodeArray[i2 - 1], nodeArray[i2]);
            if (n4 == 0) continue;
        }
        return graph;
    }

    public static Graph getHoneycomb(int n2) {
        int n3 = ColorLib.d;
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        ArrayList arrayList = GraphLib.a(graph, n2);
        ArrayList arrayList2 = GraphLib.a(graph, n2);
        for (int i2 = 0; i2 < n2 << 1; ++i2) {
            Node node = (Node)arrayList.get(i2);
            Node node2 = (Node)arrayList2.get(i2);
            graph.addEdge(node, node2);
            if (n3 == 0) continue;
        }
        return graph;
    }

    private static ArrayList a(Graph graph, int n2) {
        Node node;
        int n3;
        int n4 = ColorLib.d;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        int n5 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            node = graph.addNode();
            node.setString(LABEL, String.valueOf(n5++));
            arrayList.add(node);
            if (n4 == 0) continue;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            Node node2;
            int n6;
            node = null;
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                node2 = (Node)arrayList.get(n6);
                if (node == null) {
                    node = graph.addNode();
                    node.setString(LABEL, String.valueOf(n5++));
                    arrayList2.add(node);
                }
                graph.addEdge(node2, node);
                node = graph.addNode();
                node.setString(LABEL, String.valueOf(n5++));
                arrayList2.add(node);
                graph.addEdge(node2, node);
                if (n4 == 0) continue;
            }
            if (n3 == n2 - 1) {
                return arrayList2;
            }
            arrayList.clear();
            for (n6 = 0; n6 < arrayList2.size(); ++n6) {
                node2 = (Node)arrayList2.get(n6);
                node = graph.addNode();
                node.setString(LABEL, String.valueOf(n5++));
                arrayList.add(node);
                graph.addEdge(node2, node);
                if (n4 == 0) continue;
            }
            arrayList2.clear();
            if (n4 == 0) continue;
        }
        return arrayList;
    }

    public static Tree getBalancedTree(int n2, int n3) {
        Tree tree = new Tree();
        tree.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = tree.addRoot();
        node.setString(LABEL, z[0]);
        if (n3 > 0) {
            GraphLib.a(tree, node, n2, n3 - 1);
        }
        return tree;
    }

    private static void a(Tree tree, Node node, int n2, int n3) {
        int n4 = ColorLib.d;
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = tree.addChild(node);
            node2.setString(LABEL, i2 + "," + node2.getDepth());
            if (n3 <= 0) continue;
            GraphLib.a(tree, node2, n2, n3 - 1);
            if (n4 == 0) continue;
        }
    }

    public static Tree getLeftDeepTree(int n2) {
        Tree tree = new Tree();
        tree.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = tree.addRoot();
        node.setString(LABEL, z[0]);
        GraphLib.a(tree, node, 2, n2, true);
        return tree;
    }

    public static Tree getRightDeepTree(int n2) {
        Tree tree = new Tree();
        tree.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = tree.addRoot();
        node.setString(LABEL, z[0]);
        GraphLib.a(tree, node, 2, n2, false);
        return tree;
    }

    public static Tree getDiamondTree(int n2, int n3, int n4) {
        int n5 = ColorLib.d;
        Tree tree = new Tree();
        tree.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = tree.addRoot();
        node.setString(LABEL, z[0]);
        Node node2 = tree.addChild(node);
        node2.setString(LABEL, z[2]);
        Node node3 = tree.addChild(node);
        node3.setString(LABEL, z[1]);
        GraphLib.a(tree, node2, n2, n3 - 2, true);
        GraphLib.a(tree, node3, n2, n3 - 2, false);
        while (node2.getFirstChild() != null) {
            node2 = node2.getFirstChild();
            if (n5 == 0) continue;
        }
        while (node3.getLastChild() != null) {
            node3 = node3.getLastChild();
            if (n5 == 0) continue;
        }
        GraphLib.a(tree, node2, n2, n4 - 1, false);
        GraphLib.a(tree, node3, n2, n4 - 1, true);
        return tree;
    }

    private static void a(Tree tree, Node node, int n2, int n3, boolean bl) {
        int n4 = ColorLib.d;
        Node node2 = tree.addChild(node);
        node2.setString(LABEL, z[3] + node2.getDepth());
        if (bl && n3 > 0) {
            GraphLib.a(tree, node2, n2, n3 - 1, bl);
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            node2 = tree.addChild(node);
            node2.setString(LABEL, i2 + "," + node2.getDepth());
            if (n4 == 0) continue;
        }
        if (!bl && n3 > 0) {
            GraphLib.a(tree, node2, n2, n3 - 1, bl);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = " \u001dK>o";
        int n3 = 3;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 76;
                                break;
                            }
                            case 1: {
                                n9 = 124;
                                break;
                            }
                            case 2: {
                                n9 = 41;
                                break;
                            }
                            case 3: {
                                n9 = 91;
                                break;
                            }
                            default: {
                                n9 = 3;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 3: {
                    LABEL = string.intern();
                    string2 = "|P\u0019";
                    n3 = -1;
                    continue block12;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "}P\u0018";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "}P\u0019";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "|P";
                    n3 = 2;
                    continue block12;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        LABEL_SCHEMA = new Schema();
        LABEL_SCHEMA.addColumn(LABEL, String.class, "");
    }
}

