/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import prefuse.data.expression.AbstractExpression;
import prefuse.util.ArrayLib;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;

public class GraphicsLib {
    public static final int NO_INTERSECTION = 0;
    public static final int COINCIDENT = -1;
    public static final int PARALLEL = -2;
    private static final String[] z;

    public static int intersectLineLine(Line2D line2D, Line2D line2D2, Point2D point2D) {
        double d2 = line2D.getX1();
        double d3 = line2D.getY1();
        double d4 = line2D.getX2();
        double d5 = line2D.getY2();
        double d6 = line2D2.getX1();
        double d7 = line2D2.getY1();
        double d8 = line2D2.getX2();
        double d9 = line2D2.getY2();
        return GraphicsLib.intersectLineLine(d2, d3, d4, d5, d6, d7, d8, d9, point2D);
    }

    public static int intersectLineLine(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Point2D point2D) {
        double d10 = (d8 - d6) * (d3 - d7) - (d9 - d7) * (d2 - d6);
        double d11 = (d4 - d2) * (d3 - d7) - (d5 - d3) * (d2 - d6);
        double d12 = (d9 - d7) * (d4 - d2) - (d8 - d6) * (d5 - d3);
        if (d12 != 0.0) {
            double d13 = d10 / d12;
            double d14 = d11 / d12;
            if (0.0 <= d13 && d13 <= 1.0 && 0.0 <= d14 && d14 <= 1.0) {
                point2D.setLocation(d2 + d13 * (d4 - d2), d3 + d13 * (d5 - d3));
                return 1;
            }
            return 0;
        }
        return d10 == 0.0 || d11 == 0.0 ? -1 : -2;
    }

    public static int intersectLineRectangle(Point2D point2D, Point2D point2D2, Rectangle2D rectangle2D, Point2D[] point2DArray) {
        int n2;
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = point2D2.getX();
        double d5 = point2D2.getY();
        double d6 = rectangle2D.getMaxX();
        double d7 = rectangle2D.getMaxY();
        double d8 = rectangle2D.getMinX();
        double d9 = rectangle2D.getMinY();
        if (point2DArray[0] == null) {
            point2DArray[0] = new Point2D.Double();
        }
        if (point2DArray[1] == null) {
            point2DArray[1] = new Point2D.Double();
        }
        if (GraphicsLib.intersectLineLine(d8, d9, d6, d9, d2, d3, d4, d5, point2DArray[n2 = 0]) > 0) {
            ++n2;
        }
        if (GraphicsLib.intersectLineLine(d6, d9, d6, d7, d2, d3, d4, d5, point2DArray[n2]) > 0) {
            ++n2;
        }
        if (n2 == 2) {
            return n2;
        }
        if (GraphicsLib.intersectLineLine(d6, d7, d8, d7, d2, d3, d4, d5, point2DArray[n2]) > 0) {
            ++n2;
        }
        if (n2 == 2) {
            return n2;
        }
        if (GraphicsLib.intersectLineLine(d8, d7, d8, d9, d2, d3, d4, d5, point2DArray[n2]) > 0) {
            ++n2;
        }
        return n2;
    }

    public static int intersectLineRectangle(Line2D line2D, Rectangle2D rectangle2D, Point2D[] point2DArray) {
        int n2;
        double d2 = line2D.getX1();
        double d3 = line2D.getY1();
        double d4 = line2D.getX2();
        double d5 = line2D.getY2();
        double d6 = rectangle2D.getMaxX();
        double d7 = rectangle2D.getMaxY();
        double d8 = rectangle2D.getMinX();
        double d9 = rectangle2D.getMinY();
        if (point2DArray[0] == null) {
            point2DArray[0] = new Point2D.Double();
        }
        if (point2DArray[1] == null) {
            point2DArray[1] = new Point2D.Double();
        }
        if (GraphicsLib.intersectLineLine(d8, d9, d6, d9, d2, d3, d4, d5, point2DArray[n2 = 0]) > 0) {
            ++n2;
        }
        if (GraphicsLib.intersectLineLine(d6, d9, d6, d7, d2, d3, d4, d5, point2DArray[n2]) > 0) {
            ++n2;
        }
        if (n2 == 2) {
            return n2;
        }
        if (GraphicsLib.intersectLineLine(d6, d7, d8, d7, d2, d3, d4, d5, point2DArray[n2]) > 0) {
            ++n2;
        }
        if (n2 == 2) {
            return n2;
        }
        if (GraphicsLib.intersectLineLine(d8, d7, d8, d9, d2, d3, d4, d5, point2DArray[n2]) > 0) {
            ++n2;
        }
        return n2;
    }

    public static double[] convexHull(double[] dArray, int n2) {
        if (n2 < 6) {
            throw new IllegalArgumentException(z[1]);
        }
        int n3 = n2 / 2 - 1;
        float[] fArray = new float[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n2 / 2];
        return GraphicsLib.convexHull(dArray, n2, fArray, nArray, nArray2);
    }

    public static double[] convexHull(double[] dArray, int n2, float[] fArray, int[] nArray, int[] nArray2) {
        int n3;
        int n4;
        int n5;
        int n6 = ColorLib.d;
        int n7 = n2 / 2 - 1;
        if (n2 < 6) {
            throw new IllegalArgumentException(z[1]);
        }
        if (fArray.length < n7 || nArray.length < n7 || nArray2.length < n2 / 2) {
            throw new IllegalArgumentException(z[2]);
        }
        int n8 = 0;
        for (n5 = 2; n5 < n2; n5 += 2) {
            if (dArray[n5 + 1] < dArray[n8 + 1]) {
                n8 = n5;
                if (n6 == 0) continue;
            }
            if (dArray[n5 + 1] != dArray[n8 + 1]) continue;
            n8 = dArray[n5] < dArray[n8] ? n5 : n8;
            if (n6 == 0) continue;
        }
        int n9 = 0;
        for (n5 = 0; n5 < n2; n5 += 2) {
            if (n5 == n8) continue;
            fArray[n9] = (float)Math.atan2(dArray[n5 + 1] - dArray[n8 + 1], dArray[n5] - dArray[n8]);
            nArray[n9++] = n5;
            if (n6 == 0) continue;
        }
        ArrayLib.sort(fArray, nArray, n7);
        float f2 = fArray[0];
        n9 = 0;
        int n10 = nArray[0];
        for (n4 = 1; n4 < n7; ++n4) {
            block15: {
                block17: {
                    block16: {
                        n3 = nArray[n4];
                        if (f2 != fArray[n4]) break block15;
                        double d2 = dArray[n10] - dArray[n8];
                        double d3 = dArray[n10 + 1] - dArray[n8 + 1];
                        double d4 = d2 * d2 + d3 * d3;
                        double d5 = dArray[n3] - dArray[n8];
                        double d6 = dArray[n3 + 1] - dArray[n8 + 1];
                        double d7 = d5 * d5 + d6 * d6;
                        if (!(d4 >= d7)) break block16;
                        nArray[n4] = -1;
                        if (n6 == 0) break block17;
                    }
                    nArray[n9] = -1;
                    f2 = fArray[n4];
                    n9 = n4;
                    n10 = n3;
                }
                if (n6 == 0) continue;
            }
            f2 = fArray[n4];
            n9 = n4;
            n10 = n3;
            if (n6 == 0) continue;
        }
        n4 = 0;
        nArray2[n4++] = n8;
        n3 = 0;
        int n11 = 0;
        while (n11 < 2) {
            if (nArray[n3] != -1) {
                nArray2[n4++] = nArray[n3];
                ++n11;
            }
            ++n3;
            if (n6 == 0) continue;
        }
        while (n3 < n7) {
            if (nArray[n3] != -1) {
                while (GraphicsLib.a(n8, nArray2[n4 - 2], nArray2[n4 - 1], nArray[n3], dArray)) {
                    --n4;
                    if (n6 == 0) continue;
                }
                nArray2[n4++] = nArray[n3];
            }
            ++n3;
            if (n6 == 0) continue;
        }
        double[] dArray2 = new double[2 * n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            dArray2[2 * i2] = dArray[nArray2[i2]];
            dArray2[2 * i2 + 1] = dArray[nArray2[i2] + 1];
            if (n6 == 0) continue;
        }
        return dArray2;
    }

    private static boolean a(int n2, int n3, int n4, int n5, double[] dArray) {
        double d2;
        double d3 = Math.sqrt(Math.pow(dArray[n4 + 1] - dArray[n3 + 1], 2.0) + Math.pow(dArray[n4] - dArray[n3], 2.0));
        double d4 = Math.sqrt(Math.pow(dArray[n5 + 1] - dArray[n4 + 1], 2.0) + Math.pow(dArray[n5] - dArray[n4], 2.0));
        double d5 = Math.sqrt(Math.pow(dArray[n5 + 1] - dArray[n2 + 1], 2.0) + Math.pow(dArray[n5] - dArray[n2], 2.0));
        double d6 = Math.sqrt(Math.pow(dArray[n3 + 1] - dArray[n2 + 1], 2.0) + Math.pow(dArray[n3] - dArray[n2], 2.0));
        double d7 = Math.sqrt(Math.pow(dArray[n4 + 1] - dArray[n2 + 1], 2.0) + Math.pow(dArray[n4] - dArray[n2], 2.0));
        double d8 = Math.acos((d4 * d4 + d7 * d7 - d5 * d5) / (2.0 * d4 * d7));
        double d9 = Math.PI - d8 - (d2 = Math.acos((d7 * d7 + d3 * d3 - d6 * d6) / (2.0 * d7 * d3)));
        return d9 <= 0.0;
    }

    public static float[] centroid(float[] fArray, int n2) {
        int n3 = ColorLib.d;
        float[] fArray2 = new float[]{0.0f, 0.0f};
        for (int i2 = 0; i2 < n2; i2 += 2) {
            fArray2[0] = fArray2[0] + fArray[i2];
            fArray2[1] = fArray2[1] + fArray[i2 + 1];
            if (n3 == 0) continue;
        }
        fArray2[0] = fArray2[0] / (float)(n2 / 2);
        fArray2[1] = fArray2[1] / (float)(n2 / 2);
        return fArray2;
    }

    public static void growPolygon(float[] fArray, int n2, float f2) {
        int n3 = ColorLib.d;
        float[] fArray2 = GraphicsLib.centroid(fArray, n2);
        for (int i2 = 0; i2 < n2; i2 += 2) {
            float f3 = fArray[i2] - fArray2[0];
            float f4 = fArray[i2 + 1] - fArray2[1];
            float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
            int n4 = i2;
            fArray[n4] = fArray[n4] + f2 * f3 / f5;
            int n5 = i2 + 1;
            fArray[n5] = fArray[n5] + f2 * f4 / f5;
            if (n3 == 0) continue;
        }
    }

    public static GeneralPath cardinalSpline(float[] fArray, float f2, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0], fArray[1]);
        return GraphicsLib.cardinalSpline(generalPath, fArray, f2, bl, 0.0f, 0.0f);
    }

    public static GeneralPath cardinalSpline(float[] fArray, int n2, int n3, float f2, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[n2], fArray[n2 + 1]);
        return GraphicsLib.cardinalSpline(generalPath, fArray, n2, n3, f2, bl, 0.0f, 0.0f);
    }

    public static GeneralPath cardinalSpline(GeneralPath generalPath, float[] fArray, float f2, boolean bl, float f3, float f4) {
        int n2;
        int n3 = ColorLib.d;
        for (n2 = 0; n2 < fArray.length && !Float.isNaN(fArray[n2]); ++n2) {
            if (n3 == 0) continue;
        }
        return GraphicsLib.cardinalSpline(generalPath, fArray, 0, n2 / 2, f2, bl, f3, f4);
    }

    public static GeneralPath cardinalSpline(GeneralPath generalPath, float[] fArray, int n2, int n3, float f2, boolean bl, float f3, float f4) {
        block11: {
            int n4;
            float f5;
            float f6;
            block10: {
                float f7;
                float f8;
                int n5;
                int n6;
                block9: {
                    block8: {
                        n6 = ColorLib.d;
                        int n7 = 2 * n3;
                        n5 = n2 + n7;
                        if (n7 < 6) {
                            throw new IllegalArgumentException(z[0]);
                        }
                        if (!bl) break block8;
                        f6 = fArray[n2 + 2] - fArray[n5 - 2];
                        f5 = fArray[n2 + 3] - fArray[n5 - 1];
                        if (n6 == 0) break block9;
                    }
                    f6 = fArray[n2 + 4] - fArray[n2];
                    f5 = fArray[n2 + 5] - fArray[n2 + 1];
                }
                for (n4 = n2 + 2; n4 < n5 - 2; n4 += 2) {
                    f8 = f6;
                    f7 = f5;
                    f6 = fArray[n4 + 2] - fArray[n4 - 2];
                    f5 = fArray[n4 + 3] - fArray[n4 - 1];
                    generalPath.curveTo(f3 + fArray[n4 - 2] + f2 * f8, f4 + fArray[n4 - 1] + f2 * f7, f3 + fArray[n4] - f2 * f6, f4 + fArray[n4 + 1] - f2 * f5, f3 + fArray[n4], f4 + fArray[n4 + 1]);
                    if (n6 == 0) continue;
                }
                if (!bl) break block10;
                f8 = f6;
                f7 = f5;
                f6 = fArray[n2] - fArray[n4 - 2];
                f5 = fArray[n2 + 1] - fArray[n4 - 1];
                generalPath.curveTo(f3 + fArray[n4 - 2] + f2 * f8, f4 + fArray[n4 - 1] + f2 * f7, f3 + fArray[n4] - f2 * f6, f4 + fArray[n4 + 1] - f2 * f5, f3 + fArray[n4], f4 + fArray[n4 + 1]);
                f8 = f6;
                f7 = f5;
                f6 = fArray[n2 + 2] - fArray[n5 - 2];
                f5 = fArray[n2 + 3] - fArray[n5 - 1];
                generalPath.curveTo(f3 + fArray[n5 - 2] + f2 * f8, f4 + fArray[n5 - 1] + f2 * f7, f3 + fArray[0] - f2 * f6, f4 + fArray[1] - f2 * f5, f3 + fArray[0], f4 + fArray[1]);
                generalPath.closePath();
                if (n6 == 0) break block11;
            }
            generalPath.curveTo(f3 + fArray[n4 - 2] + f2 * f6, f4 + fArray[n4 - 1] + f2 * f5, f3 + fArray[n4] - f2 * f6, f4 + fArray[n4 + 1] - f2 * f5, f3 + fArray[n4], f4 + fArray[n4 + 1]);
        }
        return generalPath;
    }

    public static GeneralPath stackSpline(GeneralPath generalPath, float[] fArray, float f2, float f3, boolean bl, float f4, float f5) {
        int n2;
        int n3 = ColorLib.d;
        for (n2 = 0; n2 < fArray.length && !Float.isNaN(fArray[n2]); ++n2) {
            if (n3 == 0) continue;
        }
        return GraphicsLib.stackSpline(generalPath, fArray, 0, n2 / 2, f2, f3, bl, f4, f5);
    }

    public static GeneralPath stackSpline(GeneralPath generalPath, float[] fArray, int n2, int n3, float f2, float f3, boolean bl, float f4, float f5) {
        int n4;
        block17: {
            block19: {
                float f6;
                float f7;
                float f8;
                float f9;
                int n5;
                block18: {
                    block16: {
                        int n6;
                        block15: {
                            block14: {
                                block13: {
                                    n4 = ColorLib.d;
                                    int n7 = 2 * n3;
                                    n5 = n2 + n7;
                                    if (n7 < 6) {
                                        throw new IllegalArgumentException(z[0]);
                                    }
                                    if (!bl) break block13;
                                    f9 = fArray[n2 + 2] - fArray[n5 - 2];
                                    f8 = fArray[n2 + 3] - fArray[n5 - 1];
                                    if (n4 == 0) break block14;
                                }
                                f9 = fArray[n2 + 4] - fArray[n2];
                                f8 = fArray[n2 + 5] - fArray[n2 + 1];
                            }
                            for (n6 = n2 + 2; n6 < n5 - 2; n6 += 2) {
                                f7 = f9;
                                f6 = f8;
                                f9 = fArray[n6 + 2] - fArray[n6 - 2];
                                f8 = fArray[n6 + 3] - fArray[n6 - 1];
                                if (Math.abs(fArray[n6] - fArray[n6 - 2]) < f2 || Math.abs(fArray[n6 + 1] - fArray[n6 - 1]) < f2) {
                                    generalPath.lineTo(f4 + fArray[n6], f5 + fArray[n6 + 1]);
                                    if (n4 == 0) continue;
                                }
                                generalPath.curveTo(f4 + fArray[n6 - 2] + f3 * f7, f5 + fArray[n6 - 1] + f3 * f6, f4 + fArray[n6] - f3 * f9, f5 + fArray[n6 + 1] - f3 * f8, f4 + fArray[n6], f5 + fArray[n6 + 1]);
                                if (n4 == 0) continue;
                            }
                            f7 = f9;
                            f6 = f8;
                            f9 = fArray[n2] - fArray[n6 - 2];
                            f8 = fArray[n2 + 1] - fArray[n6 - 1];
                            if (!(Math.abs(fArray[n6] - fArray[n6 - 2]) < f2) && !(Math.abs(fArray[n6 + 1] - fArray[n6 - 1]) < f2)) break block15;
                            generalPath.lineTo(f4 + fArray[n6], f5 + fArray[n6 + 1]);
                            if (n4 == 0) break block16;
                        }
                        generalPath.curveTo(f4 + fArray[n6 - 2] + f3 * f7, f5 + fArray[n6 - 1] + f3 * f6, f4 + fArray[n6] - f3 * f9, f5 + fArray[n6 + 1] - f3 * f8, f4 + fArray[n6], f5 + fArray[n6 + 1]);
                    }
                    if (!bl) break block17;
                    if (!(Math.abs(fArray[n5 - 2] - fArray[0]) < f2) && !(Math.abs(fArray[n5 - 1] - fArray[1]) < f2)) break block18;
                    generalPath.lineTo(f4 + fArray[0], f5 + fArray[1]);
                    if (n4 == 0) break block19;
                }
                f7 = f9;
                f6 = f8;
                f9 = fArray[n2 + 2] - fArray[n5 - 2];
                f8 = fArray[n2 + 3] - fArray[n5 - 1];
                generalPath.curveTo(f4 + fArray[n5 - 2] + f3 * f7, f5 + fArray[n5 - 1] + f3 * f6, f4 + fArray[0] - f3 * f9, f5 + fArray[1] - f3 * f8, f4 + fArray[0], f5 + fArray[1]);
            }
            generalPath.closePath();
        }
        if (AbstractExpression.b) {
            ColorLib.d = ++n4;
        }
        return generalPath;
    }

    public static void expand(Rectangle2D rectangle2D, double d2) {
        rectangle2D.setRect(rectangle2D.getX() - d2, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d2, rectangle2D.getHeight() + 2.0 * d2);
    }

    public static void setBounds(VisualItem visualItem, Shape shape, BasicStroke basicStroke) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        block12: {
            Shape shape2;
            block13: {
                int n2;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block11: {
                                    n2 = ColorLib.d;
                                    if (!(shape instanceof RectangularShape)) break block11;
                                    shape2 = (RectangularShape)shape;
                                    d6 = ((RectangularShape)shape2).getX();
                                    d5 = ((RectangularShape)shape2).getY();
                                    d4 = ((RectangularShape)shape2).getWidth();
                                    d3 = ((RectangularShape)shape2).getHeight();
                                    if (n2 == 0) break block12;
                                }
                                if (!(shape instanceof Line2D)) break block13;
                                shape2 = (Line2D)shape;
                                d6 = ((Line2D)shape2).getX1();
                                d5 = ((Line2D)shape2).getY1();
                                d4 = ((Line2D)shape2).getX2();
                                d3 = ((Line2D)shape2).getY2();
                                if (!(d4 < d6)) break block14;
                                d2 = d6;
                                d6 = d4;
                                d4 = d2 - d6;
                                if (n2 == 0) break block15;
                            }
                            d4 -= d6;
                        }
                        if (!(d3 < d5)) break block16;
                        d2 = d5;
                        d5 = d3;
                        d3 = d2 - d5;
                        if (n2 == 0) break block17;
                    }
                    d3 -= d5;
                }
                if (n2 == 0) break block12;
            }
            shape2 = shape.getBounds2D();
            d6 = ((RectangularShape)shape2).getX();
            d5 = ((RectangularShape)shape2).getY();
            d4 = ((RectangularShape)shape2).getWidth();
            d3 = ((RectangularShape)shape2).getHeight();
        }
        if (basicStroke != null) {
            double d7;
            d2 = basicStroke.getLineWidth();
            if (d7 > 1.0) {
                double d8 = d2 / 2.0;
                d6 -= d8;
                d5 -= d8;
                d4 += d2;
                d3 += d2;
            }
        }
        visualItem.setBounds(d6, d5, d4, d3);
    }

    public static void paint(Graphics2D graphics2D, VisualItem visualItem, Shape shape, BasicStroke basicStroke, int n2) {
        Stroke stroke;
        boolean bl;
        block20: {
            boolean bl2;
            Color color;
            Color color2;
            block26: {
                int n3;
                int n4;
                int n5;
                int n6;
                Shape shape2;
                int n7;
                block21: {
                    block23: {
                        block25: {
                            block24: {
                                block22: {
                                    block19: {
                                        AffineTransform affineTransform;
                                        double d2;
                                        n7 = ColorLib.d;
                                        if (n2 == 0) {
                                            return;
                                        }
                                        color2 = ColorLib.getColor(visualItem.getStrokeColor());
                                        color = ColorLib.getColor(visualItem.getFillColor());
                                        bl = (n2 == 1 || n2 == 3) && color2.getAlpha() != 0;
                                        boolean bl3 = bl2 = (n2 == 2 || n2 == 3) && color.getAlpha() != 0;
                                        if (!bl && !bl2) {
                                            return;
                                        }
                                        stroke = null;
                                        if (bl) {
                                            stroke = graphics2D.getStroke();
                                            graphics2D.setStroke(basicStroke);
                                        }
                                        if (!((d2 = Math.max((affineTransform = graphics2D.getTransform()).getScaleX(), affineTransform.getScaleY())) > 1.5)) break block19;
                                        if (bl2) {
                                            graphics2D.setPaint(color);
                                            graphics2D.fill(shape);
                                        }
                                        if (!bl) break block20;
                                        graphics2D.setPaint(color2);
                                        graphics2D.draw(shape);
                                        if (n7 == 0) break block20;
                                    }
                                    if (!(shape instanceof RectangularShape)) break block21;
                                    shape2 = (RectangularShape)shape;
                                    double d3 = ((RectangularShape)shape2).getX();
                                    double d4 = ((RectangularShape)shape2).getWidth();
                                    double d5 = ((RectangularShape)shape2).getY();
                                    double d6 = ((RectangularShape)shape2).getHeight();
                                    n6 = (int)d3;
                                    n5 = (int)d5;
                                    n4 = (int)(d4 + d3 - (double)n6);
                                    n3 = (int)(d6 + d5 - (double)n5);
                                    if (!(shape instanceof Rectangle2D)) break block22;
                                    if (bl2) {
                                        graphics2D.setPaint(color);
                                        graphics2D.fillRect(n6, n5, n4, n3);
                                    }
                                    if (!bl) break block23;
                                    graphics2D.setPaint(color2);
                                    graphics2D.drawRect(n6, n5, n4, n3);
                                    if (n7 == 0) break block23;
                                }
                                if (!(shape instanceof RoundRectangle2D)) break block24;
                                RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
                                int n8 = (int)roundRectangle2D.getArcWidth();
                                int n9 = (int)roundRectangle2D.getArcHeight();
                                if (bl2) {
                                    graphics2D.setPaint(color);
                                    graphics2D.fillRoundRect(n6, n5, n4, n3, n8, n9);
                                }
                                if (bl) {
                                    graphics2D.setPaint(color2);
                                    graphics2D.drawRoundRect(n6, n5, n4, n3, n8, n9);
                                }
                                if (n7 == 0) break block23;
                            }
                            if (!(shape instanceof Ellipse2D)) break block25;
                            if (bl2) {
                                graphics2D.setPaint(color);
                                graphics2D.fillOval(n6, n5, n4, n3);
                            }
                            if (!bl) break block23;
                            graphics2D.setPaint(color2);
                            graphics2D.drawOval(n6, n5, n4, n3);
                            if (n7 == 0) break block23;
                        }
                        if (bl2) {
                            graphics2D.setPaint(color);
                            graphics2D.fill(shape);
                        }
                        if (bl) {
                            graphics2D.setPaint(color2);
                            graphics2D.draw(shape);
                        }
                    }
                    if (n7 == 0) break block20;
                }
                if (!(shape instanceof Line2D)) break block26;
                if (!bl) break block20;
                shape2 = (Line2D)shape;
                n6 = (int)(((Line2D)shape2).getX1() + 0.5);
                n5 = (int)(((Line2D)shape2).getY1() + 0.5);
                n4 = (int)(((Line2D)shape2).getX2() + 0.5);
                n3 = (int)(((Line2D)shape2).getY2() + 0.5);
                graphics2D.setPaint(color2);
                graphics2D.drawLine(n6, n5, n4, n3);
                if (n7 == 0) break block20;
            }
            if (bl2) {
                graphics2D.setPaint(color);
                graphics2D.fill(shape);
            }
            if (bl) {
                graphics2D.setPaint(color2);
                graphics2D.draw(shape);
            }
        }
        if (bl) {
            graphics2D.setStroke(stroke);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\r,5\u000e)<\"a\b{*3y\u00045<cg\b*,*g\b(y\"aM7<\"f\u0019{jce\u0002277f";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 89;
                                break;
                            }
                            case 1: {
                                n9 = 67;
                                break;
                            }
                            case 2: {
                                n9 = 21;
                                break;
                            }
                            case 3: {
                                n9 = 109;
                                break;
                            }
                            default: {
                                n9 = 91;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0010-e\u0018/y.`\u001e/y+t\u001b>y\"aM7<\"f\u0019{jce\u0002277f";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\t1p@:5/z\u000e:-&qM?87tM(-1`\u000e/,1pM/6,5\u001e68/y";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

