/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.Arrays;
import prefuse.util.ColorLib;

public class MathLib {
    public static final double TWO_PI = Math.PI * 2;
    public static final double LOG10;
    public static final double LOG2;
    private static final String z;

    private MathLib() {
    }

    public static double log2(double d2) {
        return Math.log(d2) / LOG2;
    }

    public static double log10(double d2) {
        return Math.log(d2) / LOG10;
    }

    public static double safeLog10(double d2) {
        boolean bl;
        boolean bl2 = bl = d2 < 0.0;
        if (bl) {
            d2 = -d2;
        }
        if (d2 < 10.0) {
            d2 += (10.0 - d2) / 10.0;
        }
        d2 = Math.log(d2) / LOG10;
        return bl ? -d2 : d2;
    }

    public static double safeSqrt(double d2) {
        return d2 < 0.0 ? -Math.sqrt(-d2) : Math.sqrt(d2);
    }

    public static double interp(int n2, double d2, double[] dArray) {
        switch (n2) {
            case 0: {
                return MathLib.linearInterp(d2, dArray[0], dArray[dArray.length - 1]);
            }
            case 1: {
                return MathLib.logInterp(d2, dArray[0], dArray[dArray.length - 1]);
            }
            case 2: {
                return MathLib.sqrtInterp(d2, dArray[0], dArray[dArray.length - 1]);
            }
            case 3: {
                return MathLib.quantile(d2, dArray);
            }
        }
        throw new IllegalArgumentException(z + n2);
    }

    public static double linearInterp(double d2, double d3, double d4) {
        double d5 = d4 - d3;
        if (d5 == 0.0) {
            return 0.0;
        }
        return (d2 - d3) / d5;
    }

    public static double logInterp(double d2, double d3, double d4) {
        double d5 = MathLib.safeLog10(d3);
        double d6 = MathLib.safeLog10(d4) - d5;
        if (d6 == 0.0) {
            return 0.0;
        }
        return (MathLib.safeLog10(d2) - d5) / d6;
    }

    public static double sqrtInterp(double d2, double d3, double d4) {
        double d5 = MathLib.safeSqrt(d3);
        double d6 = MathLib.safeSqrt(d4) - d5;
        if (d6 == 0.0) {
            return 0.0;
        }
        return (MathLib.safeSqrt(d2) - d5) / d6;
    }

    public static double[] quantiles(int n2, double[] dArray) {
        int n3 = ColorLib.d;
        dArray = (double[])dArray.clone();
        Arrays.sort(dArray);
        double[] dArray2 = new double[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            dArray2[i2] = dArray[(dArray.length - 1) * i2 / n2];
            if (n3 == 0) continue;
        }
        return dArray2;
    }

    public static double quantile(double d2, double[] dArray) {
        int n2 = ColorLib.d;
        int n3 = 1;
        int n4 = dArray.length;
        int n5 = n4 / 2;
        while (n3 < n4 && (dArray[n5] != d2 || n2 != 0)) {
            block4: {
                block3: {
                    if (!(dArray[n5] < d2)) break block3;
                    n3 = n5 + 1;
                    if (n2 == 0) break block4;
                }
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
            if (n2 == 0) continue;
        }
        return (double)n5 / (double)(dArray.length - 1);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "$Xq#\\\u001eQm/E\u0014R#5\\\u0010ZffI\u0010Zv#\u0005Q".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 113;
                            break;
                        }
                        case 1: {
                            n7 = 54;
                            break;
                        }
                        case 2: {
                            n7 = 3;
                            break;
                        }
                        case 3: {
                            n7 = 70;
                            break;
                        }
                        default: {
                            n7 = 63;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
        LOG10 = Math.log(10.0);
        LOG2 = Math.log(2.0);
    }
}

