/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.data.Schema;
import prefuse.data.expression.AbstractExpression;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.PrefuseConfig;
import prefuse.util.StringLib;
import prefuse.visual.VisualItem;

public class PrefuseLib {
    private static final String a;
    private static final double b;
    public static final String FIELD_PREFIX;
    private static final String[] z;

    private PrefuseLib() {
    }

    public static String getMemoryUsageInKB() {
        long l2 = Runtime.getRuntime().totalMemory() / 2048L;
        long l3 = Runtime.getRuntime().freeMemory() / 2048L;
        long l4 = Runtime.getRuntime().maxMemory() / 2048L;
        return z[12] + (l2 - l3) + z[13] + l2 + z[13] + l4 + "k";
    }

    public static String getMemoryUsageInMB() {
        long l2 = Runtime.getRuntime().totalMemory() / 0x200000L;
        long l3 = Runtime.getRuntime().freeMemory() / 0x200000L;
        long l4 = Runtime.getRuntime().maxMemory() / 0x200000L;
        return z[12] + (l2 - l3) + z[8] + l2 + z[8] + l4 + "M";
    }

    public static String getDisplayStats(Display display) {
        int n2 = ColorLib.d;
        float f2 = (float)Math.round(display.getFrameRate() * 100.0) / 100.0f;
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory() / 0x200000L;
        long l3 = runtime.freeMemory() / 0x200000L;
        long l4 = runtime.maxMemory() / 0x200000L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[6]).append(f2).append(z[2]);
        stringBuffer.append(display.getVisibleItemCount()).append(z[1]);
        stringBuffer.append(z[9]).append(FontLib.getCacheMissCount());
        stringBuffer.append(z[7]);
        stringBuffer.append(ColorLib.getCacheMissCount()).append(')');
        stringBuffer.append(z[4]);
        stringBuffer.append(l2 - l3).append(z[8]);
        stringBuffer.append(l4).append(z[3]);
        stringBuffer.append(z[10]);
        stringBuffer.append(StringLib.formatNumber(display.getDisplayX(), 2));
        stringBuffer.append(z[11]);
        stringBuffer.append(StringLib.formatNumber(display.getDisplayY(), 2));
        stringBuffer.append(z[5]);
        stringBuffer.append(StringLib.formatNumber(display.getScale(), 5)).append(")");
        String string = stringBuffer.toString();
        if (n2 != 0) {
            AbstractExpression.b = !AbstractExpression.b;
        }
        return string;
    }

    public static double getSize2D(double d2) {
        return Math.pow(d2, b);
    }

    public static double distance(VisualItem visualItem, VisualItem visualItem2) {
        double d2 = visualItem.getX() - visualItem2.getX();
        double d3 = visualItem.getY() - visualItem2.getY();
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public static void update(VisualItem visualItem, String string, Object object) {
        visualItem.set(PrefuseLib.getStartField(string), visualItem.get(string));
        visualItem.set(string, object);
        visualItem.set(PrefuseLib.getEndField(string), object);
    }

    public static void updateInt(VisualItem visualItem, String string, int n2) {
        visualItem.setInt(PrefuseLib.getStartField(string), visualItem.getInt(string));
        visualItem.setInt(string, n2);
        visualItem.setInt(PrefuseLib.getEndField(string), n2);
    }

    public static void updateLong(VisualItem visualItem, String string, long l2) {
        visualItem.setLong(PrefuseLib.getStartField(string), visualItem.getLong(string));
        visualItem.setLong(string, l2);
        visualItem.setLong(PrefuseLib.getEndField(string), l2);
    }

    public static void updateFloat(VisualItem visualItem, String string, float f2) {
        visualItem.setFloat(PrefuseLib.getStartField(string), visualItem.getFloat(string));
        visualItem.setFloat(string, f2);
        visualItem.setFloat(PrefuseLib.getEndField(string), f2);
    }

    public static void updateDouble(VisualItem visualItem, String string, double d2) {
        visualItem.setDouble(PrefuseLib.getStartField(string), visualItem.getDouble(string));
        visualItem.setDouble(string, d2);
        visualItem.setDouble(PrefuseLib.getEndField(string), d2);
    }

    public static void updateBoolean(VisualItem visualItem, String string, boolean bl) {
        visualItem.setBoolean(PrefuseLib.getStartField(string), visualItem.getBoolean(string));
        visualItem.setBoolean(string, bl);
        visualItem.setBoolean(PrefuseLib.getEndField(string), bl);
    }

    public static void updateVisible(VisualItem visualItem, boolean bl) {
        visualItem.setStartVisible(visualItem.isVisible());
        visualItem.setVisible(bl);
        visualItem.setEndVisible(bl);
    }

    public static void setX(VisualItem visualItem, VisualItem visualItem2, double d2) {
        double d3 = visualItem.getX();
        if (Double.isNaN(d3)) {
            d3 = visualItem2 != null ? visualItem2.getX() : d2;
        }
        visualItem.setStartX(d3);
        visualItem.setEndX(d2);
        visualItem.setX(d2);
    }

    public static void setY(VisualItem visualItem, VisualItem visualItem2, double d2) {
        double d3 = visualItem.getY();
        if (Double.isNaN(d3)) {
            d3 = visualItem2 != null ? visualItem2.getY() : d2;
        }
        visualItem.setStartY(d3);
        visualItem.setEndY(d2);
        visualItem.setY(d2);
    }

    public static boolean isChildGroup(String string) {
        return string.indexOf(a) != -1;
    }

    public static String getParentGroup(String string) {
        int n2 = string.lastIndexOf(a);
        return n2 < 0 ? null : string.substring(0, n2);
    }

    public static String getChildGroup(String string) {
        int n2 = string.lastIndexOf(a);
        return n2 < 0 ? null : string.substring(n2 + 1);
    }

    public static String getGroupName(String string, String string2) {
        return string + a + string2;
    }

    public static String getStartField(String string) {
        return string + z[15];
    }

    public static String getEndField(String string) {
        return string + z[0];
    }

    public static Schema getVisualItemSchema() {
        Schema schema = new Schema();
        schema.addColumn(VisualItem.VALIDATED, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.VISIBLE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.STARTVISIBLE, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.ENDVISIBLE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.INTERACTIVE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.EXPANDED, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.FIXED, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.HIGHLIGHT, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.HOVER, Boolean.TYPE, Boolean.FALSE);
        schema.addInterpolatedColumn(VisualItem.X, Double.TYPE);
        schema.addInterpolatedColumn(VisualItem.Y, Double.TYPE);
        schema.addColumn(VisualItem.BOUNDS, Rectangle2D.class, new Rectangle2D.Double());
        Integer n2 = new Integer(ColorLib.rgba(0, 0, 0, 0));
        schema.addInterpolatedColumn(VisualItem.STROKECOLOR, Integer.TYPE, n2);
        Integer n3 = new Integer(ColorLib.rgba(0, 0, 0, 0));
        schema.addInterpolatedColumn(VisualItem.FILLCOLOR, Integer.TYPE, n3);
        Integer n4 = new Integer(ColorLib.rgba(0, 0, 0, 0));
        schema.addInterpolatedColumn(VisualItem.TEXTCOLOR, Integer.TYPE, n4);
        schema.addInterpolatedColumn(VisualItem.SIZE, Double.TYPE, new Double(1.0));
        schema.addColumn(VisualItem.SHAPE, Integer.TYPE, new Integer(0));
        schema.addColumn(VisualItem.STROKE, Stroke.class, new BasicStroke());
        Font font = FontLib.getFont(z[14], 0, 10);
        schema.addInterpolatedColumn(VisualItem.FONT, Font.class, font);
        schema.addColumn(VisualItem.DOI, Double.TYPE, new Double(Double.MIN_VALUE));
        return schema;
    }

    public static Schema getMinimalVisualSchema() {
        Schema schema = new Schema();
        schema.addColumn(VisualItem.VALIDATED, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.VISIBLE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.STARTVISIBLE, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.ENDVISIBLE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.INTERACTIVE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.BOUNDS, Rectangle2D.class, new Rectangle2D.Double());
        return schema;
    }

    public static Schema getAxisLabelSchema() {
        Schema schema = PrefuseLib.getVisualItemSchema();
        schema.setDefault(VisualItem.STARTVISIBLE, (Object)Boolean.FALSE);
        Integer n2 = new Integer(ColorLib.gray(230));
        schema.setInterpolatedDefault(VisualItem.STROKECOLOR, n2);
        n2 = new Integer(ColorLib.gray(150));
        schema.setInterpolatedDefault(VisualItem.TEXTCOLOR, n2);
        Double d2 = new Double(Double.NaN);
        schema.addInterpolatedColumn(VisualItem.X2, Double.TYPE);
        schema.addInterpolatedColumn(VisualItem.Y2, Double.TYPE);
        schema.addColumn(VisualItem.LABEL, String.class);
        schema.addColumn(VisualItem.VALUE, Double.TYPE, d2);
        return schema;
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0014KP@";
        int n3 = -1;
        block21: while (true) {
            switch (n3) {
                default: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u000eGJA}]\u000e\u0013\u0004";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "H^M\u0004=\u000e";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "c\u0007";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u000eC[I8";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0002\u000eD\u001e";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "H\\_Iu\u000e\\_Pu\u0014\u000e";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0007\u000e]K|A\\M\f";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "c\u000e\u0011\u0004";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "HAPPc\u0006";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u000e\u0006F\u001e";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0002\u000eG\u001e";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "cKSKbW\u0014\u001e";
                    n3 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "E\u000e\u0011\u0004";
                    n3 = 12;
                    continue block21;
                }
                case 12: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "}OPWCK\\WB";
                    n3 = 13;
                    continue block21;
                }
                case 13: {
                    stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u0014]JEbZ";
                    n3 = 14;
                    continue block21;
                }
                case 14: 
            }
            break;
        }
        stringArray2[n2] = PrefuseLib.z(PrefuseLib.z(string2));
        z = stringArray3;
        String string3 = "JOJE>JKRM}GZ[V";
        int n4 = -1;
        block22: while (true) {
            string = PrefuseLib.z(PrefuseLib.z(string3));
            switch (n4) {
                default: {
                    a = PrefuseConfig.get(string);
                    string3 = "]GDA>]M_Hu\u001cj";
                    n4 = 0;
                    continue block22;
                }
                case 0: {
                    b = PrefuseConfig.getDouble(string);
                    string3 = "JOJE>XGMQqB\u0000XMuBJnVuHGF";
                    n4 = 1;
                    continue block22;
                }
                case 1: 
            }
            break;
        }
        FIELD_PREFIX = PrefuseConfig.get(string);
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x10);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 46;
                            break;
                        }
                        case 1: {
                            n7 = 46;
                            break;
                        }
                        case 2: {
                            n7 = 62;
                            break;
                        }
                        case 3: {
                            n7 = 36;
                            break;
                        }
                        default: {
                            n7 = 16;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

