/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import prefuse.data.expression.AbstractExpression;
import prefuse.util.collections.AbstractLiteralIterator;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.IntSortedMap;
import prefuse.util.collections.LiteralComparator;

public abstract class AbstractTreeMap
implements IntSortedMap {
    protected static final boolean RED = false;
    protected static final boolean BLACK = true;
    protected static final Entry NIL;
    protected LiteralComparator cmp = null;
    protected Entry root = NIL;
    protected boolean allowDuplicates;
    protected int size = 0;
    protected int unique = 0;
    protected int modCount = 0;
    protected int lastOrder = 0;

    public AbstractTreeMap(LiteralComparator literalComparator, boolean bl) {
        this.cmp = literalComparator == null ? DefaultLiteralComparator.getInstance() : literalComparator;
        this.allowDuplicates = bl;
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.root == NIL;
    }

    @Override
    public Comparator comparator() {
        return this.cmp;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public int getMinimum() {
        return this.minimum(this.root).getValue();
    }

    @Override
    public int getMaximum() {
        return this.maximum(this.root).getValue();
    }

    @Override
    public int getMedian() {
        boolean bl = AbstractLiteralIterator.a;
        Entry entry = this.minimum(this.root);
        for (int i2 = 0; i2 < this.size / 2; ++i2) {
            entry = this.successor(entry);
            if (!bl) continue;
        }
        return entry.getValue();
    }

    @Override
    public int getUniqueCount() {
        return this.unique;
    }

    @Override
    public boolean containsValue(int n2) {
        return this.root == NIL ? false : this.a(this.root, n2);
    }

    private boolean a(Entry entry, int n2) {
        if (entry.a == n2) {
            return true;
        }
        return entry.c != NIL && this.a(entry.c, n2) || entry.d != NIL && this.a(entry.d, n2);
    }

    @Override
    public IntIterator valueIterator(boolean bl) {
        return new ValueIterator(new EntryIterator(!bl));
    }

    protected void incrementSize(boolean bl) {
        ++this.size;
        ++this.modCount;
        if (bl) {
            ++this.unique;
        }
    }

    protected void decrementSize(boolean bl) {
        --this.size;
        ++this.modCount;
        if (bl) {
            --this.unique;
        }
    }

    protected abstract int compare(Entry var1, Entry var2);

    protected Entry find(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            block6: {
                block5: {
                    int n2 = this.compare(entry, entry2);
                    if (n2 == 0) {
                        return entry2;
                    }
                    if (n2 >= 0) break block5;
                    entry2 = entry2.c;
                    if (!bl) break block6;
                }
                entry2 = entry2.d;
            }
            if (!bl) continue;
        }
        return entry2;
    }

    protected Entry findPredecessor(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            block7: {
                block8: {
                    block6: {
                        int n2 = this.compare(entry, entry2);
                        if (n2 <= 0) break block6;
                        if (entry2.d == NIL) {
                            return entry2;
                        }
                        entry2 = entry2.d;
                        if (!bl) break block7;
                    }
                    if (entry2.c == NIL) break block8;
                    entry2 = entry2.c;
                    if (!bl) break block7;
                }
                Entry entry3 = entry2.e;
                Entry entry4 = entry2;
                while (entry3 != NIL && entry4 == entry3.c) {
                    entry4 = entry3;
                    entry3 = entry3.e;
                    if (!bl) continue;
                }
                return entry3;
            }
            if (!bl) continue;
        }
        return entry2;
    }

    protected Entry findCeiling(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            block11: {
                block12: {
                    block9: {
                        block10: {
                            int n2 = this.compare(entry, entry2);
                            if (n2 == 0) {
                                return entry2;
                            }
                            if (n2 >= 0) break block9;
                            if (entry2.c == NIL) break block10;
                            entry2 = entry2.c;
                            if (!bl) break block11;
                        }
                        return entry2;
                    }
                    if (entry2.d == NIL) break block12;
                    entry2 = entry2.d;
                    if (!bl) break block11;
                }
                Entry entry3 = entry2.e;
                Entry entry4 = entry2;
                while (entry3 != NIL && entry4 == entry3.d) {
                    entry4 = entry3;
                    entry3 = entry3.e;
                    if (!bl) continue;
                }
                return entry3;
            }
            if (!bl) continue;
        }
        return entry2;
    }

    protected Entry minimum(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        while (entry.c != NIL) {
            entry = entry.c;
            if (!bl) continue;
        }
        return entry;
    }

    protected Entry maximum(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        while (entry.d != NIL) {
            entry = entry.d;
            if (!bl) continue;
        }
        return entry;
    }

    protected Entry successor(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        if (entry.d != NIL) {
            return this.minimum(entry.d);
        }
        Entry entry2 = entry.e;
        while (entry2 != NIL && entry == entry2.d) {
            entry = entry2;
            entry2 = entry2.e;
            if (!bl) continue;
        }
        return entry2;
    }

    protected Entry predecessor(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        if (entry.c != NIL) {
            return this.maximum(entry.c);
        }
        Entry entry2 = entry.e;
        while (entry2 != NIL && entry == entry2.c) {
            entry = entry2;
            entry2 = entry2.e;
            if (!bl) continue;
        }
        return entry2;
    }

    protected void rotateLeft(Entry entry) {
        Entry entry2;
        block5: {
            block6: {
                boolean bl;
                block4: {
                    bl = AbstractLiteralIterator.a;
                    entry2 = entry.d;
                    entry.d = entry2.c;
                    if (entry2.c != NIL) {
                        entry2.c.e = entry;
                    }
                    entry2.e = entry.e;
                    if (entry.e != NIL) break block4;
                    this.root = entry2;
                    if (!bl) break block5;
                }
                if (entry.e.c != entry) break block6;
                entry.e.c = entry2;
                if (!bl) break block5;
            }
            entry.e.d = entry2;
        }
        entry2.c = entry;
        entry.e = entry2;
    }

    protected void rotateRight(Entry entry) {
        Entry entry2;
        block5: {
            block6: {
                boolean bl;
                block4: {
                    bl = AbstractLiteralIterator.a;
                    entry2 = entry.c;
                    entry.c = entry2.d;
                    if (entry2.d != NIL) {
                        entry2.d.e = entry;
                    }
                    entry2.e = entry.e;
                    if (entry.e != NIL) break block4;
                    this.root = entry2;
                    if (!bl) break block5;
                }
                if (entry.e.d != entry) break block6;
                entry.e.d = entry2;
                if (!bl) break block5;
            }
            entry.e.c = entry2;
        }
        entry2.d = entry;
        entry.e = entry2;
    }

    protected void fixUpInsert(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        entry.f = false;
        while (entry != NIL && entry != this.root && !entry.e.f) {
            block15: {
                block14: {
                    Entry entry2;
                    block11: {
                        block13: {
                            block12: {
                                if (entry.e != entry.e.e.c) break block11;
                                entry2 = entry.e.e.d;
                                if (entry2.f) break block12;
                                entry.e.f = true;
                                entry2.f = true;
                                entry.e.e.f = false;
                                entry = entry.e.e;
                                if (!bl) break block13;
                            }
                            if (entry == entry.e.d) {
                                entry = entry.e;
                                this.rotateLeft(entry);
                            }
                            entry.e.f = true;
                            entry.e.e.f = false;
                            if (entry.e.e != NIL) {
                                this.rotateRight(entry.e.e);
                            }
                        }
                        if (!bl) continue;
                    }
                    entry2 = entry.e.e.c;
                    if (entry2.f) break block14;
                    entry.e.f = true;
                    entry2.f = true;
                    entry.e.e.f = false;
                    entry = entry.e.e;
                    if (!bl) break block15;
                }
                if (entry == entry.e.c) {
                    entry = entry.e;
                    this.rotateRight(entry);
                }
                entry.e.f = true;
                entry.e.e.f = false;
                if (entry.e.e != NIL) {
                    this.rotateLeft(entry.e.e);
                }
            }
            if (!bl) continue;
        }
        this.root.f = true;
    }

    protected void fixUpRemove(Entry entry) {
        boolean bl = AbstractLiteralIterator.a;
        while (entry != this.root && entry.f) {
            block15: {
                Entry entry2;
                block14: {
                    block11: {
                        block13: {
                            block12: {
                                if (entry != entry.e.c) break block11;
                                entry2 = entry.e.d;
                                if (!entry2.f) {
                                    entry2.f = true;
                                    entry.e.f = false;
                                    this.rotateLeft(entry.e);
                                    entry2 = entry.e.d;
                                }
                                if (!entry2.c.f || !entry2.d.f) break block12;
                                entry2.f = false;
                                entry = entry.e;
                                if (!bl) break block13;
                            }
                            if (entry2.d.f) {
                                entry2.c.f = true;
                                entry2.f = false;
                                this.rotateRight(entry2);
                                entry2 = entry.e.d;
                            }
                            entry2.f = entry.e.f;
                            entry.e.f = true;
                            entry2.d.f = true;
                            this.rotateLeft(entry.e);
                            entry = this.root;
                        }
                        if (!bl) continue;
                    }
                    entry2 = entry.e.c;
                    if (!entry2.f) {
                        entry2.f = true;
                        entry.e.f = false;
                        this.rotateRight(entry.e);
                        entry2 = entry.e.c;
                    }
                    if (!entry2.d.f || !entry2.c.f) break block14;
                    entry2.f = false;
                    entry = entry.e;
                    if (!bl) break block15;
                }
                if (entry2.c.f) {
                    entry2.d.f = true;
                    entry2.f = false;
                    this.rotateLeft(entry2);
                    entry2 = entry.e.c;
                }
                entry2.f = entry.e.f;
                entry.e.f = true;
                entry2.c.f = true;
                this.rotateRight(entry.e);
                entry = this.root;
            }
            if (!bl) continue;
        }
        entry.f = true;
    }

    protected void remove(Entry entry) {
        Entry entry2;
        Entry entry3;
        boolean bl;
        block6: {
            block7: {
                boolean bl2;
                block5: {
                    bl2 = AbstractLiteralIterator.a;
                    bl = !entry.keyEquals(entry.c) && !entry.keyEquals(entry.d) && !entry.keyEquals(entry.e);
                    entry3 = entry.c != NIL && entry.d != NIL ? this.successor(entry) : entry;
                    entry2 = entry3.c != NIL ? entry3.c : entry3.d;
                    entry2.e = entry3.e;
                    if (entry3.e != NIL) break block5;
                    this.root = entry2;
                    if (!bl2) break block6;
                    boolean bl3 = AbstractExpression.b = !AbstractExpression.b;
                }
                if (entry3 != entry3.e.c) break block7;
                entry3.e.c = entry2;
                if (!bl2) break block6;
            }
            entry3.e.d = entry2;
        }
        if (entry3 != entry) {
            entry.copyFields(entry3);
        }
        if (entry3.f) {
            this.fixUpRemove(entry2);
        }
        this.decrementSize(bl);
    }

    static {
        AbstractTreeMap.NIL.d = AbstractTreeMap.NIL.e = (NIL = new Entry(Integer.MIN_VALUE));
        AbstractTreeMap.NIL.c = AbstractTreeMap.NIL.e;
    }

    protected class ValueIterator
    extends IntIterator {
        EntryIterator b;

        public ValueIterator(EntryIterator entryIterator) {
            this.b = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this.b.hasNext();
        }

        @Override
        public int nextInt() {
            return this.b.a().a;
        }

        @Override
        public void remove() {
            this.b.remove();
        }
    }

    protected class KeyIterator
    extends EntryIterator {
        public KeyIterator() {
            super(false);
        }

        public KeyIterator(Entry entry, Entry entry2) {
            super(entry, entry2);
        }

        @Override
        public Object next() {
            return this.a().getKey();
        }
    }

    protected class EntryIterator
    extends AbstractLiteralIterator {
        private int b;
        private Entry c;
        private boolean d;
        Entry e;
        Entry f;
        private static final String z;

        EntryIterator(boolean bl) {
            this.b = AbstractTreeMap.this.modCount;
            this.c = NIL;
            this.d = false;
            this.d = bl;
            this.e = bl ? AbstractTreeMap.this.maximum(AbstractTreeMap.this.root) : AbstractTreeMap.this.minimum(AbstractTreeMap.this.root);
            this.f = NIL;
        }

        EntryIterator(Entry entry, Entry entry2) {
            this.b = AbstractTreeMap.this.modCount;
            this.c = NIL;
            this.d = false;
            this.e = entry;
            this.f = entry2;
            this.d = entry == NIL ? true : (entry2 == NIL ? false : AbstractTreeMap.this.compare(entry, entry2) > 0);
        }

        @Override
        public boolean hasNext() {
            return this.e != this.f;
        }

        final Entry a() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (AbstractTreeMap.this.modCount != this.b) {
                throw new ConcurrentModificationException();
            }
            this.c = this.e;
            Entry entry = this.e = this.d ? AbstractTreeMap.this.predecessor(this.e) : AbstractTreeMap.this.successor(this.e);
            if (this.c == NIL) {
                System.err.println(z);
            }
            return this.c;
        }

        public Object next() {
            return this.a();
        }

        @Override
        public void remove() {
            if (this.c == NIL) {
                throw new IllegalStateException();
            }
            if (AbstractTreeMap.this.modCount != this.b) {
                throw new ConcurrentModificationException();
            }
            if (this.c.c != NIL && this.c.d != NIL) {
                this.e = this.c;
            }
            AbstractTreeMap.this.remove(this.c);
            ++this.b;
            this.c = NIL;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "\"jq\u0019S\tpw\u0004C\u0003$\\?jGm|VO\u0013a`\u0017R\u000ek|W".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 103;
                                break;
                            }
                            case 1: {
                                n7 = 4;
                                break;
                            }
                            case 2: {
                                n7 = 18;
                                break;
                            }
                            case 3: {
                                n7 = 118;
                                break;
                            }
                            default: {
                                n7 = 38;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }

    public static class Entry {
        int a;
        int b;
        Entry c = null;
        Entry d = null;
        Entry e;
        boolean f = true;
        private static final String z;

        public Entry(int n2) {
            this.a = n2;
        }

        public Entry(int n2, Entry entry, int n3) {
            this.a = n2;
            this.e = entry;
            this.b = n3;
            this.c = NIL;
            this.d = NIL;
        }

        public int getIntKey() {
            throw new UnsupportedOperationException(z);
        }

        public long getLongKey() {
            throw new UnsupportedOperationException(z);
        }

        public float getFloatKey() {
            throw new UnsupportedOperationException(z);
        }

        public double getDoubleKey() {
            throw new UnsupportedOperationException(z);
        }

        public Object getKey() {
            return null;
        }

        public int getValue() {
            return this.a;
        }

        public int getOrder() {
            return this.b;
        }

        public int setValue(int n2) {
            int n3 = this.a;
            this.a = n2;
            return n3;
        }

        public boolean keyEquals(Entry entry) {
            Object object = this.getKey();
            return object == null ? object == entry.getKey() : object.equals(entry.getKey());
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.a == entry.a && this.getKey() == entry.getKey();
        }

        public int hashCode() {
            int n2 = this.getKey().hashCode();
            int n3 = this.a;
            return n2 ^ n3;
        }

        public String toString() {
            return this.getKey() + "=" + this.a;
        }

        public void copyFields(Entry entry) {
            this.a = entry.a;
            this.b = entry.b;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "\u0013V*=m6W+<x\"".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 70;
                                break;
                            }
                            case 1: {
                                n7 = 56;
                                break;
                            }
                            case 2: {
                                n7 = 89;
                                break;
                            }
                            case 3: {
                                n7 = 72;
                                break;
                            }
                            default: {
                                n7 = 29;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

