/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.BitSet;
import java.util.Comparator;
import java.util.NoSuchElementException;
import prefuse.util.collections.AbstractLiteralIterator;
import prefuse.util.collections.BooleanIntSortedMap;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralIterator;

public class BooleanIntBitSetMap
implements BooleanIntSortedMap {
    private BitSet a = new BitSet();
    private BitSet b = new BitSet();

    @Override
    public boolean firstKey() {
        return false;
    }

    @Override
    public boolean lastKey() {
        return true;
    }

    @Override
    public boolean containsKey(boolean bl) {
        BitSet bitSet = bl ? this.a : this.b;
        return bitSet.cardinality() > 0;
    }

    @Override
    public IntIterator valueRangeIterator(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl2 && !bl4) {
            return new BitSetIterator(null);
        }
        if (bl == bl3 || !bl4) {
            return new BitSetIterator(bl ? this.a : this.b);
        }
        if (!bl2) {
            return new BitSetIterator(bl3 ? this.a : this.b);
        }
        return new BitSetIterator(bl ? this.a : this.b, bl3 ? this.a : this.b);
    }

    @Override
    public LiteralIterator keyIterator() {
        return new BitSetIterator(this.b, this.a);
    }

    @Override
    public LiteralIterator keyRangeIterator(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl2 && !bl4) {
            return new BitSetIterator(null);
        }
        if (bl == bl3 || !bl4) {
            return new BitSetIterator(bl ? this.a : this.b);
        }
        if (!bl2) {
            return new BitSetIterator(bl3 ? this.a : this.b);
        }
        return new BitSetIterator(bl ? this.a : this.b, bl3 ? this.a : this.b);
    }

    @Override
    public int get(boolean bl) {
        BitSet bitSet = bl ? this.a : this.b;
        return bitSet.nextSetBit(0);
    }

    @Override
    public int remove(boolean bl) {
        BitSet bitSet = bl ? this.a : this.b;
        int n2 = bitSet.length() - 1;
        bitSet.clear(n2);
        return n2;
    }

    @Override
    public int remove(boolean bl, int n2) {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = bl ? this.a : this.b;
        if (bitSet.get(n2)) {
            bitSet.clear(n2);
            return n2;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int put(boolean bl, int n2) {
        BitSet bitSet = bl ? this.a : this.b;
        boolean bl2 = bitSet.get(n2);
        bitSet.set(n2);
        return bl2 ? n2 : Integer.MIN_VALUE;
    }

    @Override
    public int getMinimum() {
        if (this.b.cardinality() > 0) {
            return this.b.nextSetBit(0);
        }
        if (this.a.cardinality() > 0) {
            return this.a.nextSetBit(0);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getMaximum() {
        int n2 = this.a.length() - 1;
        return n2 > 0 ? n2 : this.b.length() - 1;
    }

    @Override
    public int getMedian() {
        boolean bl = AbstractLiteralIterator.a;
        int n2 = this.b.cardinality();
        int n3 = this.a.cardinality();
        if (n2 == 0 && n3 == 0) {
            return Integer.MIN_VALUE;
        }
        int n4 = (n2 + n3) / 2;
        BitSet bitSet = n2 > n3 ? this.b : this.a;
        int n5 = bitSet.nextSetBit(0);
        int n6 = 0;
        while (n5 >= 0) {
            if (n6 == n4) {
                return n5;
            }
            n5 = bitSet.nextSetBit(n5 + 1);
            ++n6;
            if (!bl) continue;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getUniqueCount() {
        int n2 = 0;
        if (this.b.cardinality() > 0) {
            ++n2;
        }
        if (this.a.cardinality() > 0) {
            ++n2;
        }
        return n2;
    }

    @Override
    public boolean isAllowDuplicates() {
        return true;
    }

    @Override
    public int size() {
        return this.a.cardinality() + this.b.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.a.isEmpty() && this.b.isEmpty();
    }

    @Override
    public Comparator comparator() {
        return DefaultLiteralComparator.getInstance();
    }

    @Override
    public void clear() {
        this.a.clear();
        this.b.clear();
    }

    @Override
    public boolean containsValue(int n2) {
        return this.b.get(n2) || this.a.get(n2);
    }

    @Override
    public IntIterator valueIterator(boolean bl) {
        if (!bl) {
            return new BitSetIterator(this.a, this.b);
        }
        return new BitSetIterator(this.b, this.a);
    }

    public class BitSetIterator
    extends IntIterator {
        private BitSet b;
        private BitSet c;
        private int d;

        public BitSetIterator(BitSet bitSet) {
            this(bitSet, null);
        }

        public BitSetIterator(BitSet bitSet, BitSet bitSet2) {
            block3: {
                block2: {
                    this.d = -1;
                    this.b = bitSet;
                    this.c = bitSet2;
                    if (bitSet != null) break block2;
                    this.d = -2;
                    if (!AbstractLiteralIterator.a) break block3;
                }
                this.d = -1;
                this.a();
            }
        }

        private void a() {
            int n2;
            block2: {
                block4: {
                    block3: {
                        n2 = this.b.nextSetBit(this.d + 1);
                        if (n2 >= 0) break block2;
                        if (this.c == null) break block3;
                        this.b = this.c;
                        this.c = null;
                        this.d = -1;
                        this.a();
                        if (!AbstractLiteralIterator.a) break block4;
                    }
                    this.d = -2;
                }
                return;
            }
            this.d = n2;
        }

        @Override
        public int nextInt() {
            if (this.d < 0) {
                throw new NoSuchElementException();
            }
            int n2 = this.d;
            this.a();
            return n2;
        }

        @Override
        public boolean nextBoolean() {
            if (this.b == BooleanIntBitSetMap.this.a) {
                this.a();
                return true;
            }
            if (this.b == BooleanIntBitSetMap.this.b) {
                this.a();
                return false;
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return this.d >= 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

