/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Comparator;
import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.util.collections.BooleanIntBitSetMap;
import prefuse.util.collections.DoubleIntTreeMap;
import prefuse.util.collections.FloatIntTreeMap;
import prefuse.util.collections.IncompatibleComparatorException;
import prefuse.util.collections.IntIntTreeMap;
import prefuse.util.collections.IntSortedMap;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;
import prefuse.util.collections.LongIntTreeMap;
import prefuse.util.collections.ObjectIntTreeMap;

public class SortedMapFactory {
    private static final String[] z;

    public static IntSortedMap getMap(Class clazz, Comparator comparator, boolean bl) throws IncompatibleComparatorException {
        if (!SortedMapFactory.comparatorCheck(clazz, comparator)) {
            throw new IncompatibleComparatorException();
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Byte.TYPE)) {
            return new IntIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Long.TYPE) || clazz.isAssignableFrom(Date.class)) {
            return new LongIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Float.TYPE)) {
            return new FloatIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Double.TYPE)) {
            return new DoubleIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Boolean.TYPE)) {
            return new BooleanIntBitSetMap();
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return new ObjectIntTreeMap(comparator, !bl);
        }
        throw new DataTypeException(z[1]);
    }

    public static boolean comparatorCheck(Class clazz, Comparator comparator) {
        if (comparator == null) {
            return true;
        }
        if (clazz.equals(Integer.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0, 0);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Long.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0L, 0L);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Float.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0.0f, 0.0f);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Double.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0.0, 0.0);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Boolean.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(false, false);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return true;
        }
        throw new DataTypeException(z[0]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "i+\u0012#CJ4S2MS+@`MQ%[,ME(W`JH6\u00124DBdB2CQ-V%H\u00070K0I";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 39;
                                break;
                            }
                            case 1: {
                                n9 = 68;
                                break;
                            }
                            case 2: {
                                n9 = 50;
                                break;
                            }
                            case 3: {
                                n9 = 64;
                                break;
                            }
                            default: {
                                n9 = 44;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "i+\u0012-MWdS6MN(S\"@BdT/^\u00070Z%\fW6]6EC!V`X^4W";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

