/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import prefuse.data.expression.AbstractExpression;

public class Clip {
    private double[] a = new double[8];
    private byte b = (byte)2;
    public static boolean c;
    private static final String[] z;

    public void reset() {
        this.b = 0;
    }

    public void invalidate() {
        this.b = (byte)2;
    }

    public void setClip(Clip clip) {
        this.b = 1;
        System.arraycopy(clip.a, 0, this.a, 0, this.a.length);
    }

    public void setClip(Rectangle2D rectangle2D) {
        this.setClip(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setClip(double d2, double d3, double d4, double d5) {
        this.b = 1;
        this.a[0] = d2;
        this.a[1] = d3;
        this.a[6] = d2 + d4;
        this.a[7] = d3 + d5;
    }

    public void transform(AffineTransform affineTransform) {
        boolean bl = c;
        this.a[2] = this.a[0];
        this.a[3] = this.a[7];
        this.a[4] = this.a[6];
        this.a[5] = this.a[1];
        affineTransform.transform(this.a, 0, this.a, 0, 4);
        double d2 = this.a[0];
        double d3 = this.a[1];
        double d4 = this.a[6];
        double d5 = this.a[7];
        for (int i2 = 0; i2 < 7; i2 += 2) {
            if (this.a[i2] < d2) {
                d2 = this.a[i2];
            }
            if (this.a[i2] > d4) {
                d4 = this.a[i2];
            }
            if (this.a[i2 + 1] < d3) {
                d3 = this.a[i2 + 1];
            }
            if (!(this.a[i2 + 1] > d5)) continue;
            d5 = this.a[i2 + 1];
            if (!bl) continue;
        }
        this.a[0] = d2;
        this.a[1] = d3;
        this.a[6] = d4;
        this.a[7] = d5;
        if (AbstractExpression.b) {
            c = !bl;
        }
    }

    public void limit(double d2, double d3, double d4, double d5) {
        this.a[0] = Math.max(this.a[0], d2);
        this.a[1] = Math.max(this.a[1], d3);
        this.a[6] = Math.min(this.a[6], d4);
        this.a[7] = Math.min(this.a[7], d5);
    }

    public boolean intersects(Rectangle2D rectangle2D, double d2) {
        double d3 = this.a[6] - this.a[0];
        double d4 = this.a[7] - this.a[1];
        double d5 = rectangle2D.getWidth();
        double d6 = rectangle2D.getHeight();
        if (d5 < 0.0 || d6 < 0.0 || d3 < 0.0 || d4 < 0.0) {
            return false;
        }
        double d7 = this.a[0];
        double d8 = this.a[1];
        double d9 = rectangle2D.getX() - d2;
        double d10 = rectangle2D.getY() - d2;
        return ((d5 += d9 + 2.0 * d2) < d9 || d5 > d7) && ((d6 += d10 + 2.0 * d2) < d10 || d6 > d8) && ((d3 += d7) < d7 || d3 > d9) && ((d4 += d8) < d8 || d4 > d10);
    }

    public void union(Clip clip) {
        if (this.b == 2) {
            return;
        }
        if (this.b == 0) {
            this.setClip(clip);
            this.b = 1;
            return;
        }
        this.a[0] = Math.min(this.a[0], clip.a[0]);
        this.a[1] = Math.min(this.a[1], clip.a[1]);
        this.a[6] = Math.max(this.a[6], clip.a[6]);
        this.a[7] = Math.max(this.a[7], clip.a[7]);
    }

    public void union(Rectangle2D rectangle2D) {
        if (this.b == 2) {
            return;
        }
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxX();
        double d5 = rectangle2D.getMaxY();
        if (Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4) || Double.isNaN(d5)) {
            Logger.getLogger(this.getClass().getName()).warning(z[0] + rectangle2D);
            return;
        }
        if (this.b == 0) {
            this.setClip(rectangle2D);
            this.b = 1;
            return;
        }
        this.a[0] = Math.min(this.a[0], d2);
        this.a[1] = Math.min(this.a[1], d3);
        this.a[6] = Math.max(this.a[6], d4);
        this.a[7] = Math.max(this.a[7], d5);
    }

    public void union(double d2, double d3, double d4, double d5) {
        if (this.b == 2) {
            return;
        }
        if (this.b == 0) {
            this.setClip(d2, d3, d4, d5);
            this.b = 1;
            return;
        }
        this.a[0] = Math.min(this.a[0], d2);
        this.a[1] = Math.min(this.a[1], d3);
        this.a[6] = Math.max(this.a[6], d2 + d4);
        this.a[7] = Math.max(this.a[7], d3 + d5);
    }

    public void intersection(Clip clip) {
        if (this.b == 2) {
            return;
        }
        if (this.b == 0) {
            this.setClip(clip);
            this.b = 1;
            return;
        }
        this.a[0] = Math.max(this.a[0], clip.a[0]);
        this.a[1] = Math.max(this.a[1], clip.a[1]);
        this.a[6] = Math.min(this.a[6], clip.a[6]);
        this.a[7] = Math.min(this.a[7], clip.a[7]);
    }

    public void intersection(Rectangle2D rectangle2D) {
        if (this.b == 2) {
            return;
        }
        if (this.b == 0) {
            this.setClip(rectangle2D);
            this.b = 1;
            return;
        }
        this.a[0] = Math.max(this.a[0], rectangle2D.getMinX());
        this.a[1] = Math.max(this.a[1], rectangle2D.getMinY());
        this.a[6] = Math.min(this.a[6], rectangle2D.getMaxX());
        this.a[7] = Math.min(this.a[7], rectangle2D.getMaxY());
    }

    public void intersection(double d2, double d3, double d4, double d5) {
        if (this.b == 2) {
            return;
        }
        if (this.b == 0) {
            this.setClip(d2, d3, d4, d5);
            this.b = 1;
            return;
        }
        this.a[0] = Math.max(this.a[0], d2);
        this.a[1] = Math.max(this.a[1], d3);
        this.a[6] = Math.min(this.a[6], d2 + d4);
        this.a[7] = Math.min(this.a[7], d3 + d5);
    }

    public void expandToIntegerLimits() {
        this.a[0] = Math.floor(this.a[0]);
        this.a[1] = Math.floor(this.a[1]);
        this.a[6] = Math.ceil(this.a[6]);
        this.a[7] = Math.ceil(this.a[7]);
    }

    public void expand(double d2) {
        this.a[0] = this.a[0] - d2;
        this.a[1] = this.a[1] - d2;
        this.a[6] = this.a[6] + d2;
        this.a[7] = this.a[7] + d2;
    }

    public void grow(double d2) {
        this.a[6] = this.a[6] + d2;
        this.a[7] = this.a[7] + d2;
    }

    public double getMinX() {
        return this.a[0];
    }

    public double getMinY() {
        return this.a[1];
    }

    public double getMaxX() {
        return this.a[6];
    }

    public double getMaxY() {
        return this.a[7];
    }

    public double getWidth() {
        return this.a[6] - this.a[0];
    }

    public double getHeight() {
        return this.a[7] - this.a[1];
    }

    public boolean isEmpty() {
        return this.b == 0;
    }

    public boolean isInvalid() {
        return this.b == 2;
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)object;
            return rectangle2D.getMinX() == this.a[0] && rectangle2D.getMinY() == this.a[1] && rectangle2D.getMaxX() == this.a[6] && rectangle2D.getMaxY() == this.a[7];
        }
        if (object instanceof Clip) {
            Clip clip = (Clip)object;
            if (clip.b == this.b) {
                if (this.b == 1) {
                    return clip.a[0] == this.a[0] && clip.a[1] == this.a[1] && clip.a[6] == this.a[6] && clip.a[7] == this.a[7];
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        boolean bl = c;
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(z[3]);
        switch (this.b) {
            case 2: {
                stringBuffer.append(z[2]);
                if (!bl) break;
            }
            case 0: {
                stringBuffer.append(z[1]);
                if (!bl) break;
            }
            default: {
                stringBuffer.append(this.a[0]).append(",");
                stringBuffer.append(this.a[1]).append(",");
                stringBuffer.append(this.a[6]).append(",");
                stringBuffer.append(this.a[7]);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "T\u0004\u00169\u001a!\u001d\u0016\"\u001c!\u0003\u0011 \u0015m\u0003\u001bv\u0017m\u0003\u000fv\u0006d\r\u00169\u001a;J";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 1;
                                break;
                            }
                            case 1: {
                                n9 = 106;
                                break;
                            }
                            case 2: {
                                n9 = 127;
                                break;
                            }
                            case 3: {
                                n9 = 86;
                                break;
                            }
                            default: {
                                n9 = 116;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "d\u0007\u000f\"\r";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "h\u0004\t7\u0018h\u000e";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "B\u0006\u0016&/";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

