/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.Display;
import prefuse.util.display.Clip;
import prefuse.visual.VisualItem;

public class DisplayLib {
    private DisplayLib() {
    }

    public static Rectangle2D getBounds(Iterator iterator, double d2, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2;
        VisualItem visualItem;
        boolean bl = Clip.c;
        rectangle2D.setFrame(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        if (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            rectangle2D2 = visualItem.getBounds();
            rectangle2D.setFrame(rectangle2D2);
        }
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            rectangle2D2 = visualItem.getBounds();
            double d3 = rectangle2D2.getMinX() < rectangle2D.getMinX() ? rectangle2D2.getMinX() : rectangle2D.getMinX();
            double d4 = rectangle2D2.getMaxX() > rectangle2D.getMaxX() ? rectangle2D2.getMaxX() : rectangle2D.getMaxX();
            double d5 = rectangle2D2.getMinY() < rectangle2D.getMinY() ? rectangle2D2.getMinY() : rectangle2D.getMinY();
            double d6 = rectangle2D2.getMaxY() > rectangle2D.getMaxY() ? rectangle2D2.getMaxY() : rectangle2D.getMaxY();
            rectangle2D.setFrame(d3, d5, d4 - d3, d6 - d5);
            if (!bl) continue;
        }
        rectangle2D.setFrame(rectangle2D.getMinX() - d2, rectangle2D.getMinY() - d2, rectangle2D.getWidth() + 2.0 * d2, rectangle2D.getHeight() + 2.0 * d2);
        return rectangle2D;
    }

    public static Rectangle2D getBounds(Iterator iterator, double d2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        return DisplayLib.getBounds(iterator, d2, double_);
    }

    public static Point2D getCentroid(Iterator iterator, Point2D point2D) {
        boolean bl = Clip.c;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            double d4 = visualItem.getX();
            double d5 = visualItem.getY();
            if (!(Double.isInfinite(d4) || Double.isNaN(d4) || Double.isInfinite(d5) || Double.isNaN(d5))) {
                d2 += d4;
                d3 += d5;
                ++n2;
            }
            if (!bl) continue;
        }
        if (n2 > 0) {
            d2 /= (double)n2;
            d3 /= (double)n2;
        }
        point2D.setLocation(d2, d3);
        return point2D;
    }

    public static Point2D getCentroid(Iterator iterator) {
        return DisplayLib.getCentroid(iterator, new Point2D.Double());
    }

    public static void fitViewToBounds(Display display, Rectangle2D rectangle2D, long l2) {
        DisplayLib.fitViewToBounds(display, rectangle2D, null, l2);
    }

    public static void fitViewToBounds(Display display, Rectangle2D rectangle2D, Point2D point2D, long l2) {
        block5: {
            double d2;
            block4: {
                double d3 = display.getWidth();
                double d4 = display.getHeight();
                double d5 = point2D == null ? rectangle2D.getCenterX() : point2D.getX();
                double d6 = point2D == null ? rectangle2D.getCenterY() : point2D.getY();
                double d7 = Math.max(d5 - rectangle2D.getMinX(), rectangle2D.getMaxX() - d5);
                double d8 = Math.max(d6 - rectangle2D.getMinY(), rectangle2D.getMaxY() - d6);
                d2 = Math.min(d3 / (2.0 * d7), d4 / (2.0 * d8)) / display.getScale();
                if (point2D == null) {
                    point2D = new Point2D.Double(d5, d6);
                }
                if (l2 <= 0L) break block4;
                display.animatePanAndZoomToAbs(point2D, d2, l2);
                if (!Clip.c) break block5;
            }
            display.panToAbs(point2D);
            display.zoomAbs(point2D, d2);
        }
    }
}

